/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.checks.TargetMethodDataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u001c\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u00101\u001a\u00020,H\u0016J \u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/SliceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkHasContent", "", "qualifiedName", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lorg/jetbrains/uast/UMethod;", "checkListBuilder", "listBuilder", "checkManifest", "Lcom/android/tools/lint/detector/api/Context;", "sliceProvider", "onMapMethodLocation", "Lcom/android/tools/lint/detector/api/Location;", "declarationLocation", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "checkRowBuilder", "ensureSingleToggleType", "endActionItems", "", "Lorg/jetbrains/uast/UExpression;", "message", "findRows", "findSliceActionConstructor", "Lorg/jetbrains/uast/UElement;", "getApplicableConstructorTypes", "isAddRowMethod", "", "methodName", "isBuildConsumer", "call", "isContentMethod", "isCustomToggle", "Lcom/intellij/psi/PsiMethod;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "visitConstructor", "constructor", "warnMissingContent", "builder", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nSliceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliceDetector.kt\ncom/android/tools/lint/checks/SliceDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,698:1\n1282#2,2:699\n1#3:701\n*S KotlinDebug\n*F\n+ 1 SliceDetector.kt\ncom/android/tools/lint/checks/SliceDetector\n*L\n140#1:699,2\n*E\n"})
public final class SliceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SliceDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ICON_CLASS = "android.graphics.drawable.Icon";
    @NotNull
    private static final String ICON_COMPAT_CLASS_1 = "androidx.core.graphics.drawable.IconCompat";
    @NotNull
    private static final String ICON_COMPAT_CLASS_2 = "android.support.v4.graphics.drawable.IconCompat";
    @NotNull
    private static final String SLICE_PROVIDER_CLASS_1 = "androidx.slice.SliceProvider";
    @NotNull
    private static final String SLICE_PROVIDER_CLASS_2 = "android.app.slice.SliceProvider";
    @NotNull
    private static final String SLICE_ACTION_CLASS = "androidx.slice.builders.SliceAction";
    @NotNull
    private static final String LIST_BUILDER_CLASS = "androidx.slice.builders.ListBuilder";
    @NotNull
    private static final String LIST_INPUT_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.InputRangeBuilder";
    @NotNull
    private static final String LIST_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RangeBuilder";
    @NotNull
    private static final String LIST_HEADER_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.HeaderBuilder";
    @NotNull
    private static final String GRID_ROW_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder";
    @NotNull
    private static final String GRID_ROW_CELL_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder.CellBuilder";
    @NotNull
    private static final String ROW_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RowBuilder";
    @NotNull
    private static final String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static final boolean WARN_ABOUT_TOO_MANY_ROWS = false;
    @NotNull
    private static final String KEY_DECLARATION = "declaration";
    @NotNull
    private static final String KEY_MAP_METHOD = "onMapMethod";

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{SLICE_PROVIDER_CLASS_1, SLICE_PROVIDER_CLASS_2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Location location;
        UMethod onMapMethod;
        String sliceProvider;
        block9: {
            UMethod uMethod;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)KEY_DECLARATION);
            String string = declaration.getQualifiedName();
            if (string == null) {
                return;
            }
            sliceProvider = string;
            UMethod[] $this$firstOrNull$iv = declaration.getMethods();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                UMethod element$iv;
                UMethod it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"onMapIntentToUri") && it.getUastParameters().size() == 1)) continue;
                uMethod = element$iv;
                break block9;
            }
            uMethod = onMapMethod = null;
        }
        if (onMapMethod != null ? context.getDriver().isSuppressed(context, ISSUE, (UElement)((UAnnotated)onMapMethod)) : context.getDriver().isSuppressed(context, ISSUE, (UElement)((UAnnotated)declaration))) {
            return;
        }
        UMethod uMethod = onMapMethod;
        if (uMethod != null) {
            UMethod it = uMethod;
            boolean bl = false;
            location = context.getNameLocation(it);
        } else {
            location = null;
        }
        Location onMapMethodLocation = location;
        Location declarationLocation = context.getNameLocation(declaration);
        if (context.isGlobalAnalysis()) {
            this.checkManifest((Context)context, sliceProvider, onMapMethodLocation, declarationLocation);
        } else {
            PartialResult partial = context.getPartialResults(ISSUE);
            if (onMapMethodLocation != null) {
                LintMap map = new LintMap();
                map.put(KEY_DECLARATION, declarationLocation);
                map.put(KEY_MAP_METHOD, onMapMethodLocation);
                partial.map().put(sliceProvider, map);
            } else {
                partial.map().put(sliceProvider, declarationLocation);
            }
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        Iterator iterator = partialResults.iterator();
        while (iterator.hasNext()) {
            LintMap map = (LintMap)((Map.Entry)iterator.next()).getValue();
            for (String sliceProvider : map) {
                boolean bl = StringsKt.contains$default((CharSequence)sliceProvider, (char)'.', (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Location onMapMethodLocation = null;
                Location declarationLocation = map.getLocation(sliceProvider);
                if (declarationLocation != null) {
                    onMapMethodLocation = null;
                } else {
                    LintMap providerMap;
                    if (map.getMap(sliceProvider) == null) continue;
                    Location location = providerMap.getLocation(KEY_DECLARATION);
                    if (location == null) continue;
                    declarationLocation = location;
                    onMapMethodLocation = providerMap.getLocation(KEY_MAP_METHOD);
                }
                this.checkManifest(context, sliceProvider, onMapMethodLocation, declarationLocation);
            }
        }
    }

    private final void checkManifest(Context context, String sliceProvider, Location onMapMethodLocation, Location declarationLocation) {
        String manifestName;
        if (context.getMainProject().isLibrary()) {
            return;
        }
        Project mainProject = context.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element element2 = DomExtensions.subtag((Element)root, (String)"application");
        if (element2 == null) {
            return;
        }
        Element application = element2;
        Element provider = DomExtensions.subtag((Element)application, (String)"provider");
        while (provider != null && !Intrinsics.areEqual((Object)sliceProvider, (Object)(manifestName = Lint.resolveManifestName((Element)provider, (Project)mainProject)))) {
            provider = DomExtensions.next((Element)provider, (String)"provider");
        }
        if (provider == null) {
            return;
        }
        Element firstCategory = null;
        Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
        while (intentFilter != null) {
            boolean foundCategory = false;
            Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
            while (category != null) {
                String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)CATEGORY_SLICE, (Object)name)) {
                    foundCategory = true;
                    if (firstCategory != null) break;
                    firstCategory = category;
                    break;
                }
                category = XmlUtils.getNextTagByName((Node)category, (String)"category");
            }
            if (!foundCategory) {
                Location location;
                Location location2 = context.getClient().findManifestSourceLocation((Node)intentFilter);
                Location location3 = location = location2 != null ? Location.withSecondary$default((Location)location2, (Location)declarationLocation, (String)"SliceProvider declaration", (boolean)false, (int)4, null) : null;
                if (location != null) {
                    context.report(ISSUE, location, "All `SliceProvider` filters require category slice to be set:  <category android:name=\"android.app.slice.category.SLICE\" />", null);
                }
            }
            intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
        }
        if (onMapMethodLocation != null && firstCategory == null) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)onMapMethodLocation, (String)("Define intent filters in your manifest on your `<provider android:name=\"" + sliceProvider + "\">`; otherwise `onMapIntentToUri` will not be called"), null, (int)8, null);
        } else if (firstCategory != null && onMapMethodLocation == null) {
            Location location = context.getClient().findManifestSourceLocation((Node)firstCategory);
            if (location != null) {
                Location it = location;
                boolean bl = false;
                declarationLocation.setSecondary(it);
            }
            Context.report$default((Context)context, (Issue)ISSUE, (Location)declarationLocation, (String)"Implement `SliceProvider#onMapIntentToUri` to handle the intents defined on your slice `<provider>` in your manifest", null, (int)8, null);
        }
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{LIST_BUILDER_CLASS, ROW_BUILDER_CLASS, GRID_ROW_BUILDER_CLASS, GRID_ROW_CELL_BUILDER_CLASS, LIST_HEADER_BUILDER_CLASS, LIST_INPUT_RANGE_BUILDER_CLASS, LIST_RANGE_BUILDER_CLASS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Object name;
        UMethod method;
        block10: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
            if (uMethod == null) {
                return;
            }
            method = uMethod;
            Object object = constructor.getContainingClass();
            if (object == null || (object = object.getQualifiedName()) == null) {
                return;
            }
            Object object2 = name = object;
            switch (((String)object2).hashCode()) {
                case -631842329: {
                    if (((String)object2).equals(ROW_BUILDER_CLASS)) break;
                    return;
                }
                case 991555848: {
                    if (!((String)object2).equals(LIST_HEADER_BUILDER_CLASS)) {
                        return;
                    }
                    break block10;
                }
                case 1661209095: {
                    if (!((String)object2).equals(GRID_ROW_CELL_BUILDER_CLASS)) {
                        return;
                    }
                    break block10;
                }
                case 843941960: {
                    if (!((String)object2).equals(LIST_BUILDER_CLASS)) return;
                    this.checkListBuilder(context, node, method);
                    return;
                }
            }
            this.checkRowBuilder(context, node, method);
            return;
        }
        this.checkHasContent((String)name, context, node, method);
    }

    private final void checkListBuilder(JavaContext context, UCallExpression listBuilder, UMethod method) {
        List<UCallExpression> rows = this.findRows(listBuilder, method);
        if (rows.isEmpty()) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have at least one row added to it", null, (int)16, null);
            return;
        }
        List initialReferences = new ArrayList();
        for (UCallExpression call : rows) {
            PsiParameter parameter;
            List parameters;
            PsiElement psiElement;
            UExpression lambda;
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) || !this.isBuildConsumer(call) || !((lambda = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)call.getValueArguments().get(0)))) instanceof ULambdaExpression) || ((psiElement = ((UParameter)(parameters = ((ULambdaExpression)lambda).getValueParameters()).get(0)).getSourcePsi()) instanceof PsiParameter ? (PsiParameter)psiElement : null) == null) continue;
            parameter = parameter;
            initialReferences.add(parameter);
        }
        Ref.BooleanRef primaryAction = new Ref.BooleanRef();
        method.accept((UastVisitor)new DataFlowAnalyzer(rows, initialReferences, primaryAction){
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            {
                this.$primaryAction = $primaryAction;
                super((Collection<? extends UElement>)$rows, (Collection<? extends PsiVariable>)$initialReferences);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                if (Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) {
                    this.$primaryAction.element = true;
                }
            }
        });
        if (!primaryAction.element) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have a primary action set on one of its rows", null, (int)16, null);
            return;
        }
        Ref.IntRef rowCount = new Ref.IntRef();
        List endActionItems = new ArrayList();
        List list = CollectionsKt.listOf((Object)listBuilder);
        method.accept((UastVisitor)new DataFlowAnalyzer(primaryAction, endActionItems, this, rowCount, context, listBuilder, list){
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            final /* synthetic */ List<UExpression> $endActionItems;
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.IntRef $rowCount;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $listBuilder;
            {
                this.$primaryAction = $primaryAction;
                this.$endActionItems = $endActionItems;
                this.this$0 = $receiver;
                this.$rowCount = $rowCount;
                this.$context = $context;
                this.$listBuilder = $listBuilder;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                block3: {
                    String type;
                    String methodName;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        methodName = call.getMethodName();
                        if (!Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) break block2;
                        this.$primaryAction.element = true;
                        break block3;
                    }
                    if (!Intrinsics.areEqual((Object)methodName, (Object)"addAction")) break block3;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)));
                    UExpression uExpression = first;
                    String string = uExpression != null && (uExpression = uExpression.getExpressionType()) != null ? uExpression.getCanonicalText() : (type = null);
                    if (Intrinsics.areEqual((Object)type, (Object)"androidx.slice.builders.SliceAction")) {
                        this.$endActionItems.add(first);
                    }
                }
            }
        });
        this.ensureSingleToggleType(endActionItems, context, "A mixture of slice actions and icons are not supported on a list, add either actions or icons but not both");
    }

    private final boolean isAddRowMethod(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"addRow") || Intrinsics.areEqual((Object)methodName, (Object)"addInputRange") || Intrinsics.areEqual((Object)methodName, (Object)"addRange") || Intrinsics.areEqual((Object)methodName, (Object)"addGridRow");
    }

    private final void ensureSingleToggleType(List<UExpression> endActionItems, JavaContext context, String message2) {
        if (endActionItems.size() >= 2) {
            UExpression custom = null;
            UExpression uExpression = null;
            for (UExpression action : endActionItems) {
                PsiMethod constructorMethod;
                UCallExpression constructorCall;
                if (this.findSliceActionConstructor((UElement)action) == null || constructorCall.resolve() == null) continue;
                if (this.isCustomToggle(constructorMethod)) {
                    custom = action;
                } else {
                    uExpression = action;
                }
                if (custom == null || uExpression == null) continue;
                Location location = Location.withSecondary$default((Location)context.getLocation((UElement)custom), (Location)context.getLocation((UElement)uExpression), (String)"Conflicting action type here", (boolean)false, (int)4, null);
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)custom), (Location)location, (String)message2, null, (int)16, null);
                break;
            }
        }
    }

    private final List<UCallExpression> findRows(UCallExpression node, UMethod method) {
        List rows = new ArrayList();
        List list = CollectionsKt.listOf((Object)node);
        method.accept((UastVisitor)new DataFlowAnalyzer(rows, this, list){
            final /* synthetic */ List<UCallExpression> $rows;
            final /* synthetic */ SliceDetector this$0;
            {
                this.$rows = $rows;
                this.this$0 = $receiver;
                super($super_call_param$1, null, 2, null);
            }

            /*
             * Unable to fully structure code
             */
            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    if (!UastExpressionUtils.isConstructorCall((UElement)((UElement)call))) break block14;
                    v0 = call.resolve();
                    if (v0 == null || (v0 = v0.getContainingClass()) == null || (v0 = v0.getQualifiedName()) == null) {
                        return;
                    }
                    var4_4 = qualifiedName = v0;
                    switch (var4_4.hashCode()) {
                        case -715879516: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.RangeBuilder")) {
                                break;
                            }
                            ** GOTO lbl31
                        }
                        case 991555848: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.HeaderBuilder")) {
                                break;
                            }
                            ** GOTO lbl31
                        }
                        case -631842329: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.RowBuilder")) {
                                break;
                            }
                            ** GOTO lbl31
                        }
                        case 1661209095: {
                            if (!var4_4.equals("androidx.slice.builders.GridRowBuilder.CellBuilder")) {
                                break;
                            }
                            ** GOTO lbl31
                        }
                        case 1064244290: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.InputRangeBuilder")) {
                                break;
                            }
                            ** GOTO lbl31
                        }
                        case 324114748: {
                            if (!var4_4.equals("androidx.slice.builders.GridRowBuilder")) break;
lbl31:
                            // 6 sources

                            this.$rows.add(call);
                        }
                    }
                }
            }

            public void receiver(@NotNull UCallExpression call) {
                block7: {
                    UExpression arg;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        if (SliceDetector.access$isBuildConsumer(this.this$0, call)) {
                            this.$rows.add(call);
                        }
                        if (!SliceDetector.access$isAddRowMethod(this.this$0, Lint.getMethodName((UCallExpression)call))) break block7;
                        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)call.getValueArguments());
                        if (uExpression == null) break block7;
                        UExpression it = uExpression;
                        boolean bl = false;
                        arg = UastUtils.skipParenthesizedExprDown((UExpression)it);
                        if (!(arg instanceof UCallExpression)) break block8;
                        this.argument((UCallExpression)arg, (UElement)arg);
                        break block7;
                    }
                    if (!(arg instanceof UQualifiedReferenceExpression)) break block7;
                    UElement curr = (UElement)arg;
                    while (true) {
                        if (curr instanceof UQualifiedReferenceExpression) {
                            UExpression selector = ((UQualifiedReferenceExpression)curr).getSelector();
                            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)selector))) {
                                Intrinsics.checkNotNull((Object)selector, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                                this.argument((UCallExpression)selector, (UElement)selector);
                                break block7;
                            }
                            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)curr).getReceiver());
                            if (uExpression == null) {
                                break block7;
                            }
                            curr = (UElement)uExpression;
                            continue;
                        }
                        if (!(curr instanceof UPostfixExpression) || !Intrinsics.areEqual((Object)((UPostfixExpression)curr).getOperator().getText(), (Object)"!!")) break;
                        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UPostfixExpression)curr).getOperand());
                        if (uExpression == null) {
                            break block7;
                        }
                        curr = (UElement)uExpression;
                    }
                    if (curr instanceof UCallExpression) {
                        this.argument((UCallExpression)curr, curr);
                    }
                }
            }
        });
        return rows;
    }

    private final boolean isBuildConsumer(UCallExpression call) {
        if (call.getValueArgumentCount() != 1) {
            return false;
        }
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return false;
        }
        PsiMethod calledMethod = psiMethod;
        PsiParameter[] psiParameterArray = calledMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])psiParameterArray);
        if (psiParameter == null) {
            return false;
        }
        PsiParameter arg = psiParameter;
        String string = arg.getType().getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String type = string;
        return StringsKt.startsWith$default((String)type, (String)"androidx.core.util.Consumer<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)type, (String)"Builder>", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContentMethod(String methodName) {
        String string = methodName;
        switch (string.hashCode()) {
            case 1116025060: {
                if (string.equals("setSummary")) return true;
                return false;
            }
            case 300673709: {
                if (string.equals("addEndItem")) return true;
                return false;
            }
            case -596682935: {
                if (string.equals("setTitleItem")) return true;
                return false;
            }
            case 290558358: {
                if (string.equals("setPrimaryAction")) return true;
                return false;
            }
            case -1148585618: {
                if (string.equals("addText")) return true;
                return false;
            }
            case -1256358598: {
                if (string.equals("addImage")) return true;
                return false;
            }
            case 1405084438: {
                if (string.equals("setTitle")) return true;
                return false;
            }
            case -71177574: {
                if (string.equals("setSubtitle")) return true;
                return false;
            }
            case 1481751836: {
                if (string.equals("setSummarySubtitle")) return true;
                return false;
            }
            case 2021309444: {
                if (!string.equals("addTitleText")) return false;
                return true;
            }
        }
        return false;
    }

    private final void checkHasContent(String qualifiedName, JavaContext context, UCallExpression node, UMethod method) {
        List list = CollectionsKt.listOf((Object)node);
        TargetMethodDataFlowAnalyzer analyzer2 = new TargetMethodDataFlowAnalyzer(this, list){
            final /* synthetic */ SliceDetector this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, 2, null);
            }

            public boolean isTargetMethodName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return SliceDetector.access$isContentMethod(this.this$0, name);
            }

            public boolean isTargetMethod(@NotNull String name, @Nullable PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return true;
            }
        };
        if (DataFlowAnalyzerKt.isMissingTarget(method, analyzer2, true)) {
            String string = qualifiedName.substring(StringsKt.lastIndexOf$default((CharSequence)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String name = string;
            this.warnMissingContent(name, context, node);
        }
    }

    private final void checkRowBuilder(JavaContext context, UCallExpression node, UMethod method) {
        Ref.ObjectRef timestamp = new Ref.ObjectRef();
        Ref.ObjectRef endActionItem = new Ref.ObjectRef();
        List endActionItems = new ArrayList();
        Ref.ObjectRef endIconItem = new Ref.ObjectRef();
        Ref.BooleanRef hasContent = new Ref.BooleanRef();
        List list = CollectionsKt.listOf((Object)node);
        method.accept((UastVisitor)new DataFlowAnalyzer(hasContent, (Ref.ObjectRef<UCallExpression>)timestamp, context, (Ref.ObjectRef<UCallExpression>)endIconItem, (Ref.ObjectRef<UCallExpression>)endActionItem, endActionItems, this, list){
            final /* synthetic */ Ref.BooleanRef $hasContent;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $timestamp;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $endIconItem;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $endActionItem;
            final /* synthetic */ List<UExpression> $endActionItems;
            final /* synthetic */ SliceDetector this$0;
            {
                this.$hasContent = $hasContent;
                this.$timestamp = $timestamp;
                this.$context = $context;
                this.$endIconItem = $endIconItem;
                this.$endActionItem = $endActionItem;
                this.$endActionItems = $endActionItems;
                this.this$0 = $receiver;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                String string = call.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (Intrinsics.areEqual((Object)methodName, (Object)"addEndItem") || Intrinsics.areEqual((Object)methodName, (Object)"setTitleItem")) {
                    String type;
                    this.$hasContent.element = true;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)));
                    UExpression uExpression = first;
                    String string2 = uExpression != null && (uExpression = uExpression.getExpressionType()) != null ? uExpression.getCanonicalText() : (type = null);
                    if (arguments.size() == 1 && Intrinsics.areEqual((Object)type, (Object)"long")) {
                        if (this.$timestamp.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            Object object = this.$timestamp.element;
                            Intrinsics.checkNotNull((Object)object);
                            Location location2 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)object), (String)"Earlier timestamp here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location2, (String)"`RowBuilder` can only have one timestamp added to it, remove one of your timestamps", null, (int)16, null);
                        } else {
                            this.$timestamp.element = call;
                        }
                    } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.slice.builders.SliceAction")) {
                        if (this.$endIconItem.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            Object object = this.$endIconItem.element;
                            Intrinsics.checkNotNull((Object)object);
                            Location location3 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)object), (String)"Earlier icon here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location3, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endActionItem.element = call;
                        this.$endActionItems.add(first);
                    } else if (Intrinsics.areEqual((Object)type, (Object)"android.graphics.drawable.Icon") || Intrinsics.areEqual((Object)type, (Object)"androidx.core.graphics.drawable.IconCompat") || Intrinsics.areEqual((Object)type, (Object)"android.support.v4.graphics.drawable.IconCompat")) {
                        if (this.$endActionItem.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            Object object = this.$endActionItem.element;
                            Intrinsics.checkNotNull((Object)object);
                            Location location4 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)object), (String)"Earlier slice action here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location4, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endIconItem.element = call;
                    }
                } else if (SliceDetector.access$isContentMethod(this.this$0, methodName)) {
                    this.$hasContent.element = true;
                }
            }
        });
        String message2 = "`RowBuilder` should not have a mixture of default and custom toggles";
        this.ensureSingleToggleType(endActionItems, context, message2);
        if (!hasContent.element) {
            this.warnMissingContent("RowBuilder", context, node);
        }
    }

    private final void warnMissingContent(String builder, JavaContext context, UCallExpression node) {
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("`" + builder + "` should have a piece of content added to it"), null, (int)16, null);
    }

    private final boolean isCustomToggle(PsiMethod method) {
        return method.getParameterList().getParametersCount() == 3;
    }

    private final UCallExpression findSliceActionConstructor(UElement node) {
        if (node instanceof UReferenceExpression) {
            if (node instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)node).getSelector() instanceof UCallExpression) {
                return this.findSliceActionConstructor((UElement)((UQualifiedReferenceExpression)node).getSelector());
            }
            PsiElement psiElement = ((UReferenceExpression)node).resolve();
            if (psiElement == null) {
                return null;
            }
            PsiElement resolved = psiElement;
            if (resolved instanceof ULocalVariable) {
                UExpression uExpression = ((ULocalVariable)resolved).getUastInitializer();
                if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                    return null;
                }
                UExpression initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
            if (resolved instanceof PsiLocalVariable) {
                UExpression uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, node);
                if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                    return null;
                }
                UExpression initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
        } else if (node instanceof UCallExpression && UastExpressionUtils.isConstructorCall((UElement)node)) {
            String name;
            PsiMethod psiMethod = ((UCallExpression)node).resolve();
            String string = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : (name = null);
            if (Intrinsics.areEqual((Object)name, (Object)SLICE_ACTION_CLASS)) {
                return (UCallExpression)node;
            }
        } else {
            if (node instanceof UQualifiedReferenceExpression) {
                return this.findSliceActionConstructor((UElement)((UQualifiedReferenceExpression)node).getSelector());
            }
            if (node instanceof UParenthesizedExpression) {
                return this.findSliceActionConstructor((UElement)((UParenthesizedExpression)node).getExpression());
            }
        }
        return null;
    }

    public static final /* synthetic */ boolean access$isAddRowMethod(SliceDetector $this, String methodName) {
        return $this.isAddRowMethod(methodName);
    }

    public static final /* synthetic */ boolean access$isBuildConsumer(SliceDetector $this, UCallExpression call) {
        return $this.isBuildConsumer(call);
    }

    public static final /* synthetic */ boolean access$isContentMethod(SliceDetector $this, String methodName) {
        return $this.isContentMethod(methodName);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Slices", (String)"Slices", (String)"\n            This check analyzes usages of the Slices API and offers suggestions based \\\n            on best practices.\n            ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/SliceDetector$Companion;", "", "()V", "CATEGORY_SLICE", "", "GRID_ROW_BUILDER_CLASS", "GRID_ROW_CELL_BUILDER_CLASS", "ICON_CLASS", "ICON_COMPAT_CLASS_1", "ICON_COMPAT_CLASS_2", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_DECLARATION", "KEY_MAP_METHOD", "LIST_BUILDER_CLASS", "LIST_HEADER_BUILDER_CLASS", "LIST_INPUT_RANGE_BUILDER_CLASS", "LIST_RANGE_BUILDER_CLASS", "ROW_BUILDER_CLASS", "SLICE_ACTION_CLASS", "SLICE_PROVIDER_CLASS_1", "SLICE_PROVIDER_CLASS_2", "WARN_ABOUT_TOO_MANY_ROWS", "", "isSliceProvider", "provider", "Lorg/w3c/dom/Element;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSliceProvider(@NotNull Element provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
            while (intentFilter != null) {
                Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
                while (category != null) {
                    String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (Intrinsics.areEqual((Object)SliceDetector.CATEGORY_SLICE, (Object)name)) {
                        return true;
                    }
                    category = XmlUtils.getNextTagByName((Node)category, (String)"category");
                }
                intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

