/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/LabelForDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "editableTextFields", "", "Lorg/w3c/dom/Element;", "labels", "", "", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableAttributes", "", "getApplicableElements", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nLabelForDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelForDetector.kt\ncom/android/tools/lint/checks/LabelForDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class LabelForDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> labels;
    @Nullable
    private List<Element> editableTextFields;
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("LabelFor", "Missing accessibility label", "\n                 Editable text fields should provide an `android:hint` or, provided your `minSdkVersion` \\\n                 is at least 17, they may be referenced by a view with a `android:labelFor` attribute.\n\n                 When using `android:labelFor`, be sure to provide an `android:text` or an \\\n                 `android:contentDescription`.\n\n                 If your view is labeled but by a label in a different layout which includes this one, \\\n                 just suppress this warning from lint.\n                ", Category.A11Y, 2, Severity.WARNING, new Implementation(LabelForDetector.class, Scope.RESOURCE_FILE_SCOPE));
    @NotNull
    private static final String PREFIX = "Missing accessibility label";
    @NotNull
    private static final String PROVIDE_HINT = "where minSdk < 17, you should provide an `android:hint`";
    @NotNull
    private static final String PROVIDE_LABEL_FOR_OR_HINT = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`";
    @NotNull
    private static final String KEY_HINT = "hint";
    @NotNull
    private static final String KEY_LABEL = "label";

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"labelFor");
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"EditText", "AutoCompleteTextView", "MultiAutoCompleteTextView"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void afterCheckFile(@NotNull Context context) {
        List list;
        Set labels;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set set = this.labels;
        if (set == null) {
            set = labels = SetsKt.emptySet();
        }
        if ((list = this.editableTextFields) == null) {
            list = CollectionsKt.emptyList();
        }
        List editableTextFields = list;
        this.labels = null;
        this.editableTextFields = null;
        for (Element element : editableTextFields) {
            String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            boolean hintProvided = element.hasAttributeNS("http://schemas.android.com/apk/res/android", KEY_HINT);
            boolean labelForProvided = false;
            if (labels.contains(id)) {
                labelForProvided = true;
            } else {
                Intrinsics.checkNotNull((Object)id);
                if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
                    labelForProvided = labels.contains("@id/" + Lint.stripIdPrefix((String)id));
                } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
                    labelForProvided = labels.contains("@+id/" + Lint.stripIdPrefix((String)id));
                }
            }
            if (!(hintProvided && labelForProvided || !hintProvided && !labelForProvided || labelForProvided && context.getProject().getMinSdk() < 17)) {
                return;
            }
            Location location = Context.getLocation$default((Context)context, (Object)element, null, (int)2, null);
            Incident incident = new Incident(ISSUE, (Object)element, location, "");
            context.report(incident, this.map().put(KEY_HINT, hintProvided).put(KEY_LABEL, labelForProvided));
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Boolean bl = LintMap.getBoolean$default((LintMap)map, (String)KEY_HINT, null, (int)2, null);
        boolean hintProvided = bl != null ? bl : false;
        Boolean bl2 = LintMap.getBoolean$default((LintMap)map, (String)KEY_LABEL, null, (int)2, null);
        boolean labelForProvided = bl2 != null ? bl2 : false;
        String message2 = "";
        int minSdk = context.getMainProject().getMinSdk();
        if (hintProvided && labelForProvided) {
            if (minSdk >= 17) {
                message2 = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`, but not both";
            }
        } else if (!hintProvided && !labelForProvided) {
            message2 = minSdk < 17 ? PROVIDE_HINT : PROVIDE_LABEL_FOR_OR_HINT;
        } else if (labelForProvided && minSdk < 17) {
            message2 = PROVIDE_HINT;
        }
        if (((CharSequence)message2).length() == 0) {
            return false;
        }
        incident.setMessage(LabelForDetector.Companion.messageWithPrefix(message2));
        return true;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        block7: {
            Element element;
            block8: {
                Attr contentDescriptionNode;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                    boolean bl = Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"labelFor");
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    element = attribute.getOwnerElement();
                    Set set = this.labels;
                    if (set == null) {
                        Set set2;
                        Set it = set2 = (Set)new LinkedHashSet();
                        boolean bl2 = false;
                        this.labels = it;
                        set = set2;
                    }
                    Set labels = set;
                    String string = attribute.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    labels.add((String)string);
                    if (!Intrinsics.areEqual((Object)element.getLocalName(), (Object)"TextView")) {
                        return;
                    }
                    Attr textAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "text");
                    contentDescriptionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
                    if (textAttributeNode == null) break block6;
                    String string2 = textAttributeNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    if (!(((CharSequence)string2).length() == 0)) break block7;
                }
                if (contentDescriptionNode == null) break block8;
                String string = contentDescriptionNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!(((CharSequence)string).length() == 0)) break block7;
            }
            LintFix[] lintFixArray = new LintFix[]{LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"text", null, null, (int)12, null).build(), LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"contentDescription", null, null, (int)12, null).build()};
            LintFix fix = this.fix().alternatives(lintFixArray);
            Node node = element;
            Intrinsics.checkNotNull((Object)element);
            context.report(ISSUE, node, context.getElementLocation(element, null, "http://schemas.android.com/apk/res/android", "labelFor"), LabelForDetector.Companion.messageWithPrefix("when using `android:labelFor`, you must also define an `android:text` or an `android:contentDescription`"), fix);
        }
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", KEY_HINT)) {
            Attr hintAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", KEY_HINT);
            String string = hintAttributeNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                Node node = hintAttributeNode;
                Intrinsics.checkNotNull((Object)hintAttributeNode);
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getLocation((Node)hintAttributeNode), (String)"Empty `android:hint` attribute", null, (int)16, null);
            }
        }
        if ((list = this.editableTextFields) == null) {
            List list2;
            List it = list2 = (List)new ArrayList();
            boolean bl = false;
            this.editableTextFields = it;
            list = list2;
        }
        List fields = list;
        fields.add((Element)element);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/LabelForDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_HINT", "", "KEY_LABEL", "PREFIX", "PROVIDE_HINT", "PROVIDE_LABEL_FOR_OR_HINT", "messageWithPrefix", "message", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final String messageWithPrefix(String message2) {
            return "Missing accessibility label: " + message2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

