/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AppCompatResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"AppCompatResource", (String)"Menu namespace", (String)"When using the appcompat library, menu resources should refer to the `showAsAction` (or `actionViewClass`, or `actionProviderClass`) in the `app:` namespace, not the `android:` namespace.\n\nSimilarly, when **not** using the appcompat library, you should be using the `android:showAsAction` (or `actionViewClass`, or `actionProviderClass`) attribute.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(AppCompatResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final String ATTR_ACTION_VIEW_CLASS = "actionViewClass";
    public static final String ATTR_ACTION_PROVIDER_CLASS = "actionProviderClass";

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("showAsAction", ATTR_ACTION_PROVIDER_CLASS, ATTR_ACTION_VIEW_CLASS);
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Project project = context.getProject();
        Boolean appCompat = project.dependsOn("com.android.support:appcompat-v7");
        String localName = attribute.getLocalName();
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            if (context.getFolderVersion() >= 14) {
                return;
            }
            if (appCompat == Boolean.TRUE) {
                LintFix fix = this.fix().replaceAttribute(attribute, "http://schemas.android.com/apk/res-auto", attribute.getLocalName(), attribute.getValue()).build();
                String message2 = String.format("Should use `app:%1$s` with the appcompat library with `xmlns:app=\"http://schemas.android.com/apk/res-auto\"`", localName);
                context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), message2, fix);
            }
        } else if (appCompat == Boolean.FALSE) {
            LintFix fix = this.fix().replaceAttribute(attribute, "http://schemas.android.com/apk/res/android", attribute.getLocalName(), attribute.getValue()).build();
            String message3 = String.format("Should use `android:%1$s` when not using the appcompat library", localName);
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), message3, fix);
        }
    }
}

