/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KotlinLightMethodUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/SyntheticAccessorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "reportError", "", "node", "member", "Lcom/intellij/psi/PsiMember;", "target", "Lcom/intellij/psi/PsiClass;", "Companion", "lint-checks"})
public final class SyntheticAccessorDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SyntheticAccessorDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, USimpleNameReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ SyntheticAccessorDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (UastExpressionUtils.isNewArray((UElement)((UElement)node)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)node))) {
                    return;
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                if (uClass == null) {
                    return;
                }
                UClass containingClass = uClass;
                PsiMethod method = node.resolve();
                if (method == null) {
                    UReferenceExpression uReferenceExpression = node.getClassReference();
                    if (uReferenceExpression == null) {
                        return;
                    }
                    UReferenceExpression classRef = uReferenceExpression;
                    PsiElement psiElement = classRef.resolve();
                    PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass target2 = psiClass;
                    if (!this.$context.getEvaluator().isPrivate((PsiModifierListOwner)target2)) {
                        return;
                    }
                    if (target2.isEquivalentTo((PsiElement)containingClass)) {
                        return;
                    }
                    if (!this.isSameCompilationUnit(target2, (UElement)node)) {
                        return;
                    }
                    SyntheticAccessorDetector.access$reportError(this.this$0, this.$context, (UElement)node, (PsiMember)target2, target2);
                } else {
                    if (!this.$context.getEvaluator().isPrivate((PsiModifierListOwner)method)) {
                        return;
                    }
                    PsiClass psiClass = method.getContainingClass();
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass aClass = psiClass;
                    if (Intrinsics.areEqual((Object)aClass, (Object)containingClass.getPsi())) {
                        return;
                    }
                    if (!this.isSameCompilationUnit(aClass, (UElement)node)) {
                        return;
                    }
                    UClass from = UastUtils.getContainingUClass((UElement)((UElement)node));
                    if (from != null && Intrinsics.areEqual((Object)from.getName(), (Object)"Companion")) {
                        return;
                    }
                    SyntheticAccessorDetector.access$reportError(this.this$0, this.$context, (UElement)node, (PsiMember)method, aClass);
                }
            }

            private final boolean isSameCompilationUnit(PsiClass aClass, UElement node) {
                PsiFile file1 = UastLintUtils.Companion.getContainingFile((PsiElement)aClass);
                PsiFile file2 = UastLintUtils.Companion.getContainingFile(node.getSourcePsi());
                return Intrinsics.areEqual((Object)file1, (Object)file2);
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Object constant;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.resolve();
                if (psiElement == null) {
                    return;
                }
                PsiElement resolved = psiElement;
                if (!(resolved instanceof PsiMethod) && !(resolved instanceof PsiField)) {
                    return;
                }
                PsiMember member = (PsiMember)resolved;
                if (!this.$context.getEvaluator().isPrivate((PsiModifierListOwner)member)) {
                    return;
                }
                if (resolved instanceof PsiField) {
                    Language language = ((PsiField)resolved).getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                    if (Lint.isKotlin((Language)language)) {
                        return;
                    }
                }
                if ((constant = ConstantEvaluator.evaluate((JavaContext)this.$context, (UElement)((UElement)node))) != null) {
                    return;
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                if (uClass == null) {
                    return;
                }
                UClass containingClass = uClass;
                PsiClass memberClass = member.getContainingClass();
                if (memberClass == null || Intrinsics.areEqual((Object)memberClass, (Object)containingClass.getPsi())) {
                    return;
                }
                if (!this.isSameCompilationUnit(memberClass, (UElement)node)) {
                    return;
                }
                SyntheticAccessorDetector.access$reportError(this.this$0, this.$context, (UElement)node, member, memberClass);
            }
        };
    }

    private final void reportError(JavaContext context, UElement node, PsiMember member, PsiClass target2) {
        Object object;
        Location location;
        String name;
        Location location2 = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, true, false) : context.getLocation(node);
        Language language = member.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        boolean isKotlin = Lint.isKotlin((Language)language);
        String string = name = isKotlin ? "Make internal" : "Make package protected";
        if (member instanceof KtLightMethod && (KotlinLightMethodUtilsKt.isGetter((KtLightMethod)((KtLightMethod)member)) || KotlinLightMethodUtilsKt.isSetter((KtLightMethod)((KtLightMethod)member)))) {
            KtElement ktElement = ((KtLightMethod)member).getKotlinOrigin();
            KtProperty ktProperty = ktElement instanceof KtProperty ? (KtProperty)ktElement : null;
            if (ktProperty == null) {
                return;
            }
            KtProperty ktProperty2 = ktProperty;
            location = context.getLocation((PsiElement)ktProperty2);
        } else {
            location = context.getLocation((PsiElement)member);
        }
        Location fixRange = location;
        LintFix fix = this.fix().replace().name(name).sharedName(name).range(fixRange).text("private ").with(isKotlin ? "internal " : "").autoFix().build();
        if (member instanceof PsiField) {
            object = "field `" + ((PsiField)member).getName() + "`";
        } else if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                if (context.getEvaluator().isStatic((PsiModifierListOwner)member)) {
                    return;
                }
                if (isKotlin) {
                    if (context.getEvaluator().isSealed((PsiModifierListOwner)member)) {
                        return;
                    }
                    if (context.getEvaluator().isSealed((PsiModifierListOwner)target2)) {
                        return;
                    }
                }
                object = "constructor";
            } else {
                object = "method `" + ((PsiMethod)member).getName() + "`";
            }
        } else {
            object = "member";
        }
        Object memberType = object;
        String message2 = "Access to `private` " + (String)memberType + " of class `" + target2.getName() + "` requires synthetic accessor";
        context.report(ISSUE, node, location2, message2, fix);
    }

    public static final /* synthetic */ void access$reportError(SyntheticAccessorDetector $this, JavaContext context, UElement node, PsiMember member, PsiClass target2) {
        $this.reportError(context, node, member, target2);
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        Issue issue = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"SyntheticAccessor", (String)"Synthetic Accessor", (String)"\n                A private inner class which is accessed from the outer class will force \\\n                the compiler to insert a synthetic accessor; this means that you are \\\n                causing extra overhead. This is not important in small projects, but is \\\n                important for large apps running up against the 64K method handle limit, \\\n                and especially for **libraries** where you want to make sure your library \\\n                is as small as possible for the cases where your library is used in an \\\n                app running up against the 64K limit.\n                ", (Implementation)implementation, null, (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3072, null);
        objectArray = new String[]{"SyntheticAccessorCall", "PrivateMemberAccessBetweenOuterAndInnerClass"};
        ISSUE = issue.setAliases(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/SyntheticAccessorDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

