/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NfcTechListDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"NfcTechWhitespace", (String)"Whitespace in NFC tech lists", (String)"In a `<tech-list>`, there can be whitespace around the `<tech>` elements,but not inside them. This is because the code which reads in the tech list is currently very strict and will include the whitespace as part of the name.\n\nIn other words, use `<tech>name</tech>`, not `<tech> name </tech>`.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.FATAL, (Implementation)new Implementation(NfcTechListDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://issuetracker.google.com/36988969");

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("tech");
    }

    public void visitElement(XmlContext context, Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode == null || parentNode.getNodeType() != 1 || !"tech-list".equals(parentNode.getNodeName())) {
            return;
        }
        NodeList children = element.getChildNodes();
        if (children.getLength() != 1) {
            return;
        }
        Node child = children.item(0);
        if (child.getNodeType() != 3) {
            return;
        }
        String text = child.getNodeValue();
        if (!text.equals(text.trim())) {
            String message2 = "There should not be any whitespace inside `<tech>` elements";
            context.report(ISSUE, (Node)element, context.getLocation(child), message2);
        }
    }
}

