/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.TranslationDetectorKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/LocaleConfigDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "createFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "path", "Lcom/android/ide/common/util/PathString;", "language", "", "getApplicableAttributes", "", "getConfigLanguages", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "visitAttribute", "", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nLocaleConfigDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleConfigDetector.kt\ncom/android/tools/lint/checks/LocaleConfigDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class LocaleConfigDetector
extends Detector
implements XmlScanner,
ResourceFolderScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"localeConfig");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)attribute.getValue());
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        if (url.type != ResourceType.XML || url.isFramework() || url.isTheme()) {
            return;
        }
        LintClient client = context.getClient();
        ResourceRepository resources = context.isGlobalAnalysis() ? client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : client.getResources(context.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
        ResourceNamespace namespace = context.getProject().getResourceNamespace();
        List list = resources.getResources(namespace, url.type, url.name);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResources(...)");
        List configs = list;
        for (ResourceItem config : configs) {
            Set<String> configLanguages;
            PathString path;
            if (config.getSource() == null || this.getConfigLanguages(client, path) == null || configLanguages.isEmpty()) continue;
            SortedSet<LocaleQualifier> actualLocales = TranslationDetectorKt.getStringLocales(resources);
            for (LocaleQualifier actualLocale : actualLocales) {
                Object object;
                String language;
                block9: {
                    block8: {
                        if (actualLocale.getLanguage() == null || configLanguages.contains(language)) continue;
                        object = LocaleManager.getLanguageName((String)language);
                        if (object == null) break block8;
                        String it = object;
                        boolean bl = false;
                        String string = language + " (" + it + ")";
                        object = string;
                        if (string != null) break block9;
                    }
                    object = language;
                }
                String desc = object;
                String message2 = "The language `" + desc + "` is present in this project, but not declared in the `localeConfig` resource";
                context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), message2, this.createFix(context, path, language));
            }
        }
    }

    private final LintFix createFix(XmlContext context, PathString path, String language) {
        File file = path.toFile();
        if (file == null) {
            return null;
        }
        File file2 = file;
        XmlParser parser = context.getParser();
        CharSequence contents = context.getClient().readFile(file2);
        Document document = parser.parseXml(contents, file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        String string = document2.lookupPrefix("http://schemas.android.com/apk/res/android");
        if (string == null) {
            string = "android";
        }
        String prefix = string;
        Element element = document2.getDocumentElement();
        Node node = element != null ? element.getFirstChild() : null;
        if (node == null) {
            return null;
        }
        Node curr = node;
        Location location = null;
        while (true) {
            if (curr instanceof Element && ((Element)curr).getAttributeNS("http://schemas.android.com/apk/res/android", "name").compareTo(language) > 0) {
                location = parser.getLocation(file2, curr);
                break;
            }
            if (curr.getNextSibling() == null) break;
        }
        String replacement = "<locale " + prefix + ":name=\"" + language + "\"/>";
        LintFix.ReplaceStringBuilder fix = this.fix().name("Add " + language + " to " + file2.getName()).replace();
        if (location == null) {
            Iterable iterable = XmlUtils.getSubTags((Node)document2.getDocumentElement());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTags(...)");
            Object object = CollectionsKt.last((Iterable)iterable);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            fix.range(parser.getLocation(file2, (Node)object)).end().with("\n    " + replacement);
        } else {
            int offset;
            Position position = location.getStart();
            Intrinsics.checkNotNull((Object)position);
            int start = position.getOffset();
            for (offset = start - 1; offset > 0 && contents.charAt(offset) != '\n'; --offset) {
            }
            String indent2 = ((Object)contents.subSequence(offset, start)).toString();
            fix.beginning().with(replacement + indent2).range(location);
        }
        return fix.build();
    }

    private final Set<String> getConfigLanguages(LintClient client, PathString file) {
        if (file == null) {
            return null;
        }
        try {
            XmlPullParser xmlPullParser = client.createXmlPullParser(file);
            if (xmlPullParser == null) {
                return null;
            }
            XmlPullParser parser = xmlPullParser;
            Set languages = new LinkedHashSet();
            block7: while (true) {
                int event = parser.next();
                switch (event) {
                    case 2: {
                        String language = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                        CharSequence charSequence = language;
                        if (charSequence == null || charSequence.length() == 0) continue block7;
                        languages.add(StringsKt.substringBefore$default((String)language, (char)'-', null, (int)2, null));
                        continue block7;
                    }
                    case 1: {
                        return languages;
                    }
                }
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(LocaleConfigDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.MESSAGES;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"UnusedTranslation", (String)"Unused Translation", (String)"\n              If an application defines a translation for a language which is not included in \\\n              the app's `localeConfig` file (when declared in the manifest), that language will \\\n              be \"unused\"; it will not be presented to the user. Usually this means you have \\\n              forgotten to include it in the locale config file.\n              ", (Implementation)implementation, (String)"https://developer.android.com/about/versions/13/features/app-languages", (Category)category, (int)2, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/LocaleConfigDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

