/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/PluralExample;", "", "language", "", "keyword", "number", "example", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExample", "()Ljava/lang/String;", "getKeyword", "getLanguage", "getNumber", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "formattedWithNumber", "hashCode", "", "toString", "lint-checks"})
public final class PluralExample {
    @NotNull
    private final String language;
    @NotNull
    private final String keyword;
    @NotNull
    private final String number;
    @Nullable
    private final String example;

    public PluralExample(@NotNull String language, @NotNull String keyword, @NotNull String number, @Nullable String example) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.language = language;
        this.keyword = keyword;
        this.number = number;
        this.example = example;
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    @NotNull
    public final String getKeyword() {
        return this.keyword;
    }

    @NotNull
    public final String getNumber() {
        return this.number;
    }

    @Nullable
    public final String getExample() {
        return this.example;
    }

    @NotNull
    public final String formattedWithNumber() {
        String string = this.example;
        if (string == null || (string = StringsKt.replace$default((String)string, (String)"{0}", (String)this.number, (boolean)false, (int)4, null)) == null) {
            string = this.number;
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.language;
    }

    @NotNull
    public final String component2() {
        return this.keyword;
    }

    @NotNull
    public final String component3() {
        return this.number;
    }

    @Nullable
    public final String component4() {
        return this.example;
    }

    @NotNull
    public final PluralExample copy(@NotNull String language, @NotNull String keyword, @NotNull String number, @Nullable String example) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return new PluralExample(language, keyword, number, example);
    }

    public static /* synthetic */ PluralExample copy$default(PluralExample pluralExample, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = pluralExample.language;
        }
        if ((n & 2) != 0) {
            string2 = pluralExample.keyword;
        }
        if ((n & 4) != 0) {
            string3 = pluralExample.number;
        }
        if ((n & 8) != 0) {
            string4 = pluralExample.example;
        }
        return pluralExample.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "PluralExample(language=" + this.language + ", keyword=" + this.keyword + ", number=" + this.number + ", example=" + this.example + ")";
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = result * 31 + this.keyword.hashCode();
        result = result * 31 + this.number.hashCode();
        result = result * 31 + (this.example == null ? 0 : this.example.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluralExample)) {
            return false;
        }
        PluralExample pluralExample = (PluralExample)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)pluralExample.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keyword, (Object)pluralExample.keyword)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.number, (Object)pluralExample.number)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.example, (Object)pluralExample.example);
    }
}

