/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerDependencyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "checkAuthPlayServicesDependency", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkMergedProject", "Companion", "lint-checks"})
public final class CredentialManagerDependencyDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CredentialManagerDependencyDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CREDENTIAL_DEP;

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.checkAuthPlayServicesDependency(context);
    }

    private final void checkAuthPlayServicesDependency(Context context) {
        Project project = context.getProject();
        if (project.isLibrary()) {
            return;
        }
        if (project.getMinSdk() > 33) {
            return;
        }
        Document document = project.getMergedManifest();
        Element element = document != null ? document.getDocumentElement() : null;
        if (element == null) {
            return;
        }
        Element manifest = element;
        if (WearDetector.Companion.containsWearFeature(manifest)) {
            return;
        }
        Element element2 = DomExtensions.subtag((Element)manifest, (String)"application");
        if (element2 == null) {
            return;
        }
        Element application = element2;
        if (!Intrinsics.areEqual((Object)project.dependsOn("androidx.credentials:credentials"), (Object)true)) {
            return;
        }
        if (Intrinsics.areEqual((Object)project.dependsOn("androidx.credentials:credentials-play-services-auth"), (Object)true)) {
            return;
        }
        Context.report$default((Context)context, (Issue)CREDENTIAL_DEP, (Location)Context.getLocation$default((Context)context, (Object)application, null, (int)2, null), (String)"This app supports Android 13 and depends on `androidx.credentials:credentials`, and so should also depend on `androidx.credentials:credentials-play-services-auth`", null, (int)8, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CREDENTIAL_DEP = Issue.Companion.create$default((Issue.Companion)companion, (String)"CredentialDependency", (String)"`credentials-play-services-auth` is Required", (String)"\n          The dependency `androidx.credentials:credentials-play-services-auth` is required \\\n          for Android 13 and below \\\n          to get support from Play services for the Credential Manager API \\\n          (`androidx.credentials:credentials`) to work. \\\n          For Android 14 and above, this is optional. Please check release notes for the \\\n          latest version.\n          ", (Implementation)implementation, (String)"https://developer.android.com/jetpack/androidx/releases/credentials", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerDependencyDetector$Companion;", "", "()V", "CREDENTIAL_DEP", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

