/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/TraceSectionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "endName", "", "name", "getApplicableMethodNames", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class TraceSectionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final BooleanOption STRICT_MODE = new BooleanOption("strict", "Whether to assume any method call could throw an exception", false, "\n          In strict mode, this check assumes that any method call in between begin-section and \\\n          end-section pairs could potentially throw an exception. Strict mode is useful for \\\n          situations where unchecked Java exceptions are caught and do not necessarily result in \\\n          a crash.\n\n          If strict mode is off, this check will still consider the flow of exceptions in Kotlin, \\\n          but it will ignore unchecked exceptions (`RuntimeException` and its subclasses) in Java \\\n          unless the method declares explicitly that it `throws` them. If strict mode is enabled, \\\n          all Java method calls need to be guarded using a finally block so ensure the trace is \\\n          always ended.\n          ");
    @JvmField
    @NotNull
    public static final Issue UNCLOSED_TRACE;
    @NotNull
    private static final String PLATFORM_TRACE_FQN = "android.os.Trace";
    @NotNull
    private static final String ANDROIDX_TRACE_FQN = "androidx.tracing.Trace";
    @NotNull
    private static final String TRACE_IS_ENABLED = "isEnabled";
    @NotNull
    private static final String TRACE_IS_TAG_ENABLED = "isTagEnabled";
    @NotNull
    private static final String BEGIN_SECTION = "beginSection";
    @NotNull
    private static final String END_SECTION = "endSection";
    @NotNull
    private static final String TRACE_BEGIN = "traceBegin";
    @NotNull
    private static final String TRACE_END = "traceEnd";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{BEGIN_SECTION, TRACE_BEGIN};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Companion.SearchResult result = TraceSectionDetector.Companion.searchForMatchingTraceSection(context, node);
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                string = "The `" + node.getMethodName() + "()` call is not always closed with a matching `" + this.endName(node.getMethodName()) + "()` because the code in between may suspend";
                break;
            }
            case 3: {
                string = "The `" + node.getMethodName() + "()` call is not always closed with a matching `" + this.endName(node.getMethodName()) + "()` because the code in between may return early";
                break;
            }
            case 4: {
                string = "The `" + node.getMethodName() + "()` call is not always closed with a matching `" + this.endName(node.getMethodName()) + "()` because the code in between may throw an exception";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String message2 = string;
        JavaContext.report$default((JavaContext)context, (Issue)UNCLOSED_TRACE, (UElement)((UElement)node), (Location)context.getCallLocation(node, false, false), (String)message2, null, (int)16, null);
    }

    private final String endName(String name) {
        return Intrinsics.areEqual((Object)name, (Object)TRACE_BEGIN) ? TRACE_END : END_SECTION;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(TraceSectionDetector.class, Scope.JAVA_FILE_SCOPE);
        UNCLOSED_TRACE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnclosedTrace", (String)"Incorrect trace section usage", (String)"\n            Calls to begin trace sections must be followed by corresponding calls to end those \\\n            trace sections. Care must be taken to ensure that begin-section / end-section pairs \\\n            are properly nested, and that functions do not return when there are still unclosed \\\n            trace sections. The easiest way to ensure begin-section / end-section pairs are \\\n            properly closed is to use a try-finally block as follows:\n\n            ```kotlin\n            try {\n              Trace.beginSection(\"OK\")\n              return true\n            } finally {\n              Trace.endSection()\n            }\n            ```\n\n            This lint check may result in false-positives if trace sections are guarded by \\\n            conditionals. For example, it may erroneously say the following has unclosed trace \\\n            sections:\n\n            ```kotlin\n            try {\n              Trace.beginSection(\"Wrong\")\n              if (a == b) {\n                Trace.beginSection(\"OK\")\n                blockingCall()\n              }\n            } finally {\n              // Even though this is technically correct, the lint check isn't capable of detecting\n              // that the two conditionals are the same\n              if (a == b) Trace.endSection()\n              Trace.endSection()\n            }\n            ```\n\n            To fix the code snippet above, you could add a nested try-finally as follows:\n\n            ```kotlin\n            try {\n              Trace.beginSection(\"OK\")\n              if (a == b) {\n                try {\n                  Trace.beginSection(\"OK\")\n                  blockingCall()\n                } finally {\n                  Trace.endSection()\n                }\n              }\n            } finally {\n              Trace.endSection()\n            }\n            ```\n            ", (Implementation)implementation, null, (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null).setOptions(CollectionsKt.listOf((Object)STRICT_MODE));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002)*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/TraceSectionDetector$Companion;", "", "()V", "ANDROIDX_TRACE_FQN", "", "BEGIN_SECTION", "END_SECTION", "PLATFORM_TRACE_FQN", "STRICT_MODE", "Lcom/android/tools/lint/detector/api/BooleanOption;", "TRACE_BEGIN", "TRACE_END", "TRACE_IS_ENABLED", "TRACE_IS_TAG_ENABLED", "UNCLOSED_TRACE", "Lcom/android/tools/lint/detector/api/Issue;", "dfs", "Lcom/android/tools/lint/checks/TraceSectionDetector$Companion$SearchResult;", "searchContext", "Lcom/android/tools/lint/checks/TraceSectionDetector$Companion$AstSearchContext;", "node", "Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "Lorg/jetbrains/uast/UElement;", "traceSectionCount", "", "viaException", "", "isAndroidXBeginCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "isAndroidXEndCall", "isPlatformPublicBeginCall", "isPlatformPublicEndCall", "isPlatformSystemBeginCall", "isPlatformSystemEndCall", "isSuspendCall", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "searchForMatchingTraceSection", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "AstSearchContext", "SearchResult", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nTraceSectionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceSectionDetector.kt\ncom/android/tools/lint/checks/TraceSectionDetector$Companion\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,381:1\n18#2:382\n*S KotlinDebug\n*F\n+ 1 TraceSectionDetector.kt\ncom/android/tools/lint/checks/TraceSectionDetector$Companion\n*L\n211#1:382\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SearchResult searchForMatchingTraceSection(JavaContext context, UCallExpression node) {
            AstSearchContext astSearchContext;
            if (this.isPlatformPublicBeginCall(node)) {
                astSearchContext = new AstSearchContext(context, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isPlatformPublicBeginCall((Companion)this.receiver, p0);
                    }
                }), (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isPlatformPublicEndCall((Companion)this.receiver, p0);
                    }
                }));
            } else if (this.isPlatformSystemBeginCall(node)) {
                astSearchContext = new AstSearchContext(context, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isPlatformSystemBeginCall((Companion)this.receiver, p0);
                    }
                }), (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isPlatformSystemEndCall((Companion)this.receiver, p0);
                    }
                }));
            } else if (this.isAndroidXBeginCall(node)) {
                astSearchContext = new AstSearchContext(context, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isAndroidXBeginCall((Companion)this.receiver, p0);
                    }
                }), (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull UCallExpression p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.TraceSectionDetector$Companion.access$isAndroidXEndCall((Companion)this.receiver, p0);
                    }
                }));
            } else {
                return SearchResult.FOUND_NOTHING;
            }
            AstSearchContext searchContext2 = astSearchContext;
            UElement $this$getParentOfType_u24default$iv = (UElement)node;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
            if (uMethod == null) {
                return SearchResult.FOUND_NOTHING;
            }
            UMethod containingMethod = uMethod;
            boolean strictMode = STRICT_MODE.getValue((Context)context);
            ControlFlowGraph<UElement> graph2 = ControlFlowGraph.Companion.create(containingMethod, new ControlFlowGraph.Companion.Builder(strictMode){

                /*
                 * Unable to fully structure code
                 */
                public boolean canThrow(@NotNull UElement reference, @NotNull PsiMethod method) {
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    v0 = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"method.name");
                    name = v0;
                    switch (name.hashCode()) {
                        case 797015825: {
                            if (!name.equals("isTagEnabled")) {
                                break;
                            }
                            ** GOTO lbl29
                        }
                        case 1270275414: {
                            if (!name.equals("traceEnd")) {
                                break;
                            }
                            ** GOTO lbl29
                        }
                        case 960928356: {
                            if (!name.equals("traceBegin")) {
                                break;
                            }
                            ** GOTO lbl29
                        }
                        case -2097221238: {
                            if (!name.equals("endSection")) {
                                break;
                            }
                            ** GOTO lbl29
                        }
                        case 2105594551: {
                            if (!name.equals("isEnabled")) {
                                break;
                            }
                            ** GOTO lbl29
                        }
                        case 1162034684: {
                            if (!name.equals("beginSection")) break;
lbl29:
                            // 6 sources

                            v1 = method.getContainingClass();
                            v2 = containing = v1 != null ? v1.getQualifiedName() : null;
                            if (!Intrinsics.areEqual((Object)containing, (Object)"android.os.Trace") && !Intrinsics.areEqual((Object)containing, (Object)"androidx.tracing.Trace")) break;
                            return false;
                        }
                    }
                    return super.canThrow(reference, method);
                }

                @NotNull
                public ControlFlowGraph.FollowBranch checkBranchPaths(@NotNull UExpression conditional) {
                    Intrinsics.checkNotNullParameter((Object)conditional, (String)"conditional");
                    UElement selector = UastLintUtilsKt.findSelector((UElement)((UElement)conditional));
                    if (selector instanceof UCallExpression) {
                        PsiMethod resolved;
                        PsiMethod psiMethod = resolved = ((UCallExpression)selector).resolve();
                        String methodName = psiMethod != null ? psiMethod.getName() : null;
                        PsiMethod psiMethod2 = resolved;
                        String classFqn = psiMethod2 != null && (psiMethod2 = psiMethod2.getContainingClass()) != null ? psiMethod2.getQualifiedName() : null;
                        boolean isAndroidXCall = Intrinsics.areEqual((Object)classFqn, (Object)"androidx.tracing.Trace");
                        boolean isPlatformCall = Intrinsics.areEqual((Object)classFqn, (Object)"android.os.Trace");
                        if ((isAndroidXCall || isPlatformCall) && Intrinsics.areEqual((Object)methodName, (Object)"isEnabled") || isPlatformCall && Intrinsics.areEqual((Object)methodName, (Object)"isTagEnabled")) {
                            return ControlFlowGraph.FollowBranch.THEN;
                        }
                    }
                    return super.checkBranchPaths(conditional);
                }
            });
            ControlFlowGraph.Node<UElement> node2 = graph2.getNode((UElement)node);
            if (node2 == null) {
                return SearchResult.FOUND_NOTHING;
            }
            ControlFlowGraph.Node<UElement> graphNode = node2;
            return this.dfs(searchContext2, graphNode, 0, false);
        }

        private final boolean isPlatformPublicBeginCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.BEGIN_SECTION) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.PLATFORM_TRACE_FQN);
        }

        private final boolean isPlatformPublicEndCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.END_SECTION) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.PLATFORM_TRACE_FQN);
        }

        private final boolean isPlatformSystemBeginCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.TRACE_BEGIN) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.PLATFORM_TRACE_FQN);
        }

        private final boolean isPlatformSystemEndCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.TRACE_END) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.PLATFORM_TRACE_FQN);
        }

        private final boolean isAndroidXBeginCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.BEGIN_SECTION) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.ANDROIDX_TRACE_FQN);
        }

        private final boolean isAndroidXEndCall(UCallExpression call) {
            PsiMethod psiMethod;
            String name = call.getMethodName();
            return Intrinsics.areEqual((Object)name, (Object)TraceSectionDetector.END_SECTION) && Intrinsics.areEqual((Object)((psiMethod = call.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)TraceSectionDetector.ANDROIDX_TRACE_FQN);
        }

        private final boolean isSuspendCall(JavaEvaluator evaluator, UCallExpression call) {
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return false;
            }
            PsiMethod method = psiMethod;
            return evaluator.isSuspend((PsiModifierListOwner)method);
        }

        private final SearchResult dfs(AstSearchContext searchContext2, ControlFlowGraph.Node<UElement> node, int traceSectionCount, boolean viaException) {
            if (node.getVisit() > 0) {
                return SearchResult.FOUND_NOTHING;
            }
            int n = node.getVisit();
            node.setVisit(n + 1);
            int openTraceSectionCount = traceSectionCount;
            if (openTraceSectionCount > 0 && node.isExit()) {
                return viaException ? SearchResult.FOUND_EXCEPTION : SearchResult.FOUND_RETURN;
            }
            UElement instruction = node.getInstruction();
            if (instruction instanceof UCallExpression) {
                if (((Boolean)searchContext2.isEndCall().invoke((Object)instruction)).booleanValue()) {
                    if (--openTraceSectionCount <= 0) {
                        return SearchResult.FOUND_NOTHING;
                    }
                } else if (this.isPlatformPublicBeginCall((UCallExpression)instruction) || this.isPlatformSystemBeginCall((UCallExpression)instruction) || this.isAndroidXBeginCall((UCallExpression)instruction)) {
                    if (((Boolean)searchContext2.isBeginCall().invoke((Object)instruction)).booleanValue()) {
                        ++openTraceSectionCount;
                    }
                } else if (this.isSuspendCall(searchContext2.getContext().getEvaluator(), (UCallExpression)instruction)) {
                    return SearchResult.FOUND_SUSPEND;
                }
            }
            Iterator<ControlFlowGraph.Edge<UElement>> iterator = node.iterator();
            while (iterator.hasNext()) {
                ControlFlowGraph.Edge<UElement> edge = iterator.next();
                ControlFlowGraph.Node<UElement> next = edge.component2();
                boolean isException = edge.component4();
                SearchResult other = this.dfs(searchContext2, next, openTraceSectionCount, viaException || isException);
                if (other == SearchResult.FOUND_NOTHING) continue;
                return other;
            }
            return SearchResult.FOUND_NOTHING;
        }

        public static final /* synthetic */ boolean access$isPlatformPublicBeginCall(Companion $this, UCallExpression call) {
            return $this.isPlatformPublicBeginCall(call);
        }

        public static final /* synthetic */ boolean access$isPlatformPublicEndCall(Companion $this, UCallExpression call) {
            return $this.isPlatformPublicEndCall(call);
        }

        public static final /* synthetic */ boolean access$isPlatformSystemBeginCall(Companion $this, UCallExpression call) {
            return $this.isPlatformSystemBeginCall(call);
        }

        public static final /* synthetic */ boolean access$isPlatformSystemEndCall(Companion $this, UCallExpression call) {
            return $this.isPlatformSystemEndCall(call);
        }

        public static final /* synthetic */ boolean access$isAndroidXBeginCall(Companion $this, UCallExpression call) {
            return $this.isAndroidXBeginCall(call);
        }

        public static final /* synthetic */ boolean access$isAndroidXEndCall(Companion $this, UCallExpression call) {
            return $this.isAndroidXEndCall(call);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR,\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/TraceSectionDetector$Companion$AstSearchContext;", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "isBeginCall", "Lkotlin/Function1;", "Lorg/jetbrains/uast/UCallExpression;", "Lkotlin/ParameterName;", "name", "call", "", "isEndCall", "(Lcom/android/tools/lint/detector/api/JavaContext;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "()Lkotlin/jvm/functions/Function1;", "lint-checks"})
        private static final class AstSearchContext {
            @NotNull
            private final JavaContext context;
            @NotNull
            private final Function1<UCallExpression, Boolean> isBeginCall;
            @NotNull
            private final Function1<UCallExpression, Boolean> isEndCall;

            public AstSearchContext(@NotNull JavaContext context, @NotNull Function1<? super UCallExpression, Boolean> isBeginCall, @NotNull Function1<? super UCallExpression, Boolean> isEndCall) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(isBeginCall, (String)"isBeginCall");
                Intrinsics.checkNotNullParameter(isEndCall, (String)"isEndCall");
                this.context = context;
                this.isBeginCall = isBeginCall;
                this.isEndCall = isEndCall;
            }

            @NotNull
            public final JavaContext getContext() {
                return this.context;
            }

            @NotNull
            public final Function1<UCallExpression, Boolean> isBeginCall() {
                return this.isBeginCall;
            }

            @NotNull
            public final Function1<UCallExpression, Boolean> isEndCall() {
                return this.isEndCall;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/TraceSectionDetector$Companion$SearchResult;", "", "(Ljava/lang/String;I)V", "FOUND_NOTHING", "FOUND_RETURN", "FOUND_EXCEPTION", "FOUND_SUSPEND", "lint-checks"})
        public static final class SearchResult
        extends Enum<SearchResult> {
            public static final /* enum */ SearchResult FOUND_NOTHING = new SearchResult();
            public static final /* enum */ SearchResult FOUND_RETURN = new SearchResult();
            public static final /* enum */ SearchResult FOUND_EXCEPTION = new SearchResult();
            public static final /* enum */ SearchResult FOUND_SUSPEND = new SearchResult();
            private static final /* synthetic */ SearchResult[] $VALUES;

            public static SearchResult[] values() {
                return (SearchResult[])$VALUES.clone();
            }

            public static SearchResult valueOf(String value) {
                return Enum.valueOf(SearchResult.class, value);
            }

            static {
                $VALUES = searchResultArray = new SearchResult[]{SearchResult.FOUND_NOTHING, SearchResult.FOUND_RETURN, SearchResult.FOUND_EXCEPTION, SearchResult.FOUND_SUSPEND};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.SearchResult.values().length];
            try {
                nArray[Companion.SearchResult.FOUND_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SearchResult.FOUND_SUSPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SearchResult.FOUND_RETURN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SearchResult.FOUND_EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

