/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/SdkSuppressDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nSdkSuppressDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSuppressDetector.kt\ncom/android/tools/lint/checks/SdkSuppressDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class SdkSuppressDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SdkSuppressDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("UseSdkSuppress", "Using `@SdkSuppress` instead of `@RequiresApi`", "\n          In tests, you should be using `@SdkSuppress` instead of `@RequiresApi`. \\\n          The `@RequiresApi` annotation is used to propagate a version requirement \\\n          out to the caller of the API -- but the testing framework is only looking \\\n          for `@SdkSuppress`, which it uses to skip tests that are intended for \\\n          newer versions.\n          ", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[3];
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.oldName(), (String)"REQUIRES_API_ANNOTATION.oldName()");
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.newName(), (String)"REQUIRES_API_ANNOTATION.newName()");
        objectArray[2] = "androidx.annotation.RequiresExtension";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type == AnnotationUsageType.DEFINITION;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        String name;
        LintFix lintFix;
        String source;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (!context.isTestSource()) {
            return;
        }
        UAnnotation annotation = annotationInfo.getAnnotation();
        UElement annotated = annotation.getUastParent();
        if (!(annotated instanceof UClass) && !(annotated instanceof UMethod)) {
            return;
        }
        PsiElement psiElement = annotation.getSourcePsi();
        String string = source = psiElement != null ? psiElement.getText() : null;
        if (source != null) {
            int it = StringsKt.indexOf$default((CharSequence)source, (char)'=', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int index2 = it != -1 ? it : StringsKt.indexOf$default((CharSequence)source, (char)'(', (int)0, (boolean)false, (int)6, null);
            int valueStart = index2 + 1;
            String string2 = source.substring(valueStart);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            lintFix = this.fix().replace().text(source).with("@androidx.test.filters.SdkSuppress(minSdkVersion=" + value).range(context.getLocation(element)).reformat(true).shortenNames().build();
        } else {
            lintFix = null;
        }
        LintFix fix = lintFix;
        StringBuilder message2 = new StringBuilder("Don't use @RequiresApi from tests; use @SdkSuppress");
        UElement uElement = annotated;
        String string3 = uElement instanceof UMethod ? ((UMethod)annotated).getName() : (uElement instanceof UVariable ? ((UVariable)annotated).getName() : (name = uElement instanceof UClass ? ((UClass)annotated).getName() : null));
        if (name != null) {
            message2.append(" on `" + name + "`");
        }
        message2.append(" instead");
        Location location = context.getNameLocation(element);
        String string4 = message2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message.toString()");
        context.report(ISSUE, element, location, string4, fix);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/SdkSuppressDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

