/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/WearBackNavigationDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Issues", "lint-checks"})
public final class WearBackNavigationDetector
extends WearDetector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WearBackNavigationDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return this.isWearProject() && ResourceFolderType.VALUES == folderType;
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"item");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String nameAttribute = element.getAttribute("name");
        if (Intrinsics.areEqual((Object)nameAttribute, (Object)"android:windowSwipeToDismiss")) {
            String string = element.getTextContent();
            if (Intrinsics.areEqual((Object)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null), (Object)"false")) {
                LintFix fix = this.fix().name("Delete `android:windowSwipeToDismiss` from theme").replace().with("").autoFix().build();
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), "Disabling swipe-to-dismiss is generally not recommended for Wear applications", fix);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"WearBackNavigation", (String)"Wear: Disabling Back navigation", (String)"\n              Disabling swipe-to-dismiss is generally not recommended for Wear applications because \\\n              the user expects to dismiss any screen with a swipe. \\\n              If your activity does not require swipe-to-dismiss to be disabled, the recommendation is to \\\n              remove the `android:windowSwipeToDismiss` attribute from your theme declaration.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)true, (Boolean)true, null, null, (int)3152, null).addMoreInfo("https://developer.android.com/training/wearables/views/exit#disabling-swipe-to-dismiss");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WearBackNavigationDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

