/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/EmptySuperDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "lint-checks"})
public final class EmptySuperDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(EmptySuperDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("EmptySuperCall", "Calling an empty super method", "\n                For methods annotated with `@EmptySuper`, overriding methods should not also call the super implementation, either \\\n                because it is empty, or perhaps it contains code not intended to be run when the method is overridden.\n                ", Category.CORRECTNESS, 9, Severity.WARNING, IMPLEMENTATION);
    @NotNull
    public static final String EMPTY_SUPER_ANNOTATION = "androidx.annotation.EmptySuper";

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JavaEvaluator evaluator = this.$context.getEvaluator();
                PsiMethod psiMethod = com.android.tools.lint.checks.EmptySuperDetector$Companion.access$getEmptySuperMethod(EmptySuperDetector.Companion, evaluator, node);
                if (psiMethod == null) {
                    return;
                }
                PsiMethod superMethod = psiMethod;
                node.accept((UastVisitor)new AbstractUastVisitor(superMethod, this.$context){
                    final /* synthetic */ PsiMethod $superMethod;
                    final /* synthetic */ JavaContext $context;
                    {
                        this.$superMethod = $superMethod;
                        this.$context = $context;
                    }

                    public boolean visitCallExpression(@NotNull UCallExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.getReceiver() instanceof USuperExpression && this.$superMethod.isEquivalentTo((PsiElement)node.resolve())) {
                            String message2 = "No need to call `super." + this.$superMethod.getName() + "`; the super method is defined to be empty";
                            Location location = this.$context.getNameLocation((UElement)node);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)EmptySuperDetector.ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
                        }
                        return super.visitCallExpression(node);
                    }
                });
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/EmptySuperDetector$Companion;", "", "()V", "EMPTY_SUPER_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getEmptySuperMethod", "Lcom/intellij/psi/PsiMethod;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "method", "Lorg/jetbrains/uast/UMethod;", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nEmptySuperDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmptySuperDetector.kt\ncom/android/tools/lint/checks/EmptySuperDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1747#2,3:103\n*S KotlinDebug\n*F\n+ 1 EmptySuperDetector.kt\ncom/android/tools/lint/checks/EmptySuperDetector$Companion\n*L\n70#1:103,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiMethod getEmptySuperMethod(JavaEvaluator evaluator, UMethod method) {
            boolean bl;
            PsiMethod directSuper;
            block4: {
                PsiMethod psiMethod = evaluator.getSuperMethod((PsiMethod)method);
                if (psiMethod == null) {
                    return null;
                }
                directSuper = psiMethod;
                Iterable $this$any$iv = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)directSuper), (boolean)false, null, (int)4, null);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)EmptySuperDetector.EMPTY_SUPER_ANNOTATION)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl ? directSuper : null;
        }

        public static final /* synthetic */ PsiMethod access$getEmptySuperMethod(Companion $this, JavaEvaluator evaluator, UMethod method) {
            return $this.getEmptySuperMethod(evaluator, method);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

