/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.UtilKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.w3c.dom.Attr;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "iconSetCalls", "", "", "Lcom/android/tools/lint/checks/ActivityIconColorDetector$IconSetterInfo;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "getApplicableAttributes", "", "getApplicableMethodNames", "", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "IconSetterInfo", "lint-checks"})
public final class ActivityIconColorDetector
extends Detector
implements SourceCodeScanner,
BinaryResourceScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, IconSetterInfo> iconSetCalls = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final Regex COLOR_REGEX;
    @NotNull
    public static final String BLACK = "#000000";
    @NotNull
    public static final String WHITE = "#ffffff";
    @NotNull
    public static final String ONGOING_ACTIVITY_BUILDER_METHOD = "androidx.wear.ongoing.OngoingActivity.Builder";

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getPhase() == 1 && !this.iconSetCalls.isEmpty()) {
            context.requestRepeat((Detector)this, EnumSet.of((Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.ALL_RESOURCE_FILES));
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setAnimatedIcon", "setStaticIcon"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    public void checkBinaryResource(@NotNull ResourceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getPhase() != 2) {
            return;
        }
        String iconFileName = context.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iconFileName, (String)"iconFileName");
        String iconName = StringsKt.substringBeforeLast$default((String)iconFileName, (String)".", null, (int)2, null);
        IconSetterInfo iconSetterInfo = this.iconSetCalls.get(iconName);
        if (iconSetterInfo == null) {
            return;
        }
        IconSetterInfo iconInfo = iconSetterInfo;
        if (StringsKt.endsWith$default((String)iconFileName, (String)".xml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)iconFileName, (String)".json", (boolean)false, (int)2, null)) {
            return;
        }
        BufferedImage bufferedImage = ImageIO.read(context.file);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(context.file)");
        BufferedImage image = bufferedImage;
        if (!IconDetector.isWhite(image)) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)iconInfo.getLocation(), (String)iconInfo.getMessage(), null, (int)8, null);
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (context.getPhase() != 1) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)ONGOING_ACTIVITY_BUILDER_METHOD)) {
            return;
        }
        UExpression uExpression = node.getArgumentForParameter(0);
        if (uExpression == null) {
            return;
        }
        UExpression iconResource = uExpression;
        ResourceUrl resourceUrl = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)((UElement)iconResource));
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        String iconKind = Intrinsics.areEqual((Object)method.getName(), (Object)"setAnimatedIcon") ? "animated icon" : "static icon";
        Map<String, IconSetterInfo> map = this.iconSetCalls;
        String string = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.name");
        String string2 = string;
        IconSetterInfo iconSetterInfo = new IconSetterInfo(url, (UElement)node, context.getLocation((UElement)iconResource), "The " + iconKind + " for an ongoing activity should be white with a transparent background");
        map.put(string2, iconSetterInfo);
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"fillColor", "strokeColor", "color"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (context.getPhase() != 2) {
            return;
        }
        String string = context.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
        String iconName = UtilKt.removeSuffixIfPresent((String)string, (String)".xml");
        IconSetterInfo iconSetterInfo = this.iconSetCalls.get(iconName);
        if (iconSetterInfo == null) {
            return;
        }
        IconSetterInfo iconSetterInfo2 = iconSetterInfo;
        String string2 = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.value");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String fillColor = string3;
        if (COLOR_REGEX.matches((CharSequence)fillColor) && !Intrinsics.areEqual((Object)fillColor, (Object)BLACK) && !Intrinsics.areEqual((Object)fillColor, (Object)WHITE)) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getValueLocation(attribute), (String)iconSetterInfo2.getMessage(), null, (int)8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.ICONS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ActivityIconColorDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.RESOURCE_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ActivityIconColor", (String)"Ongoing activity icon is not white", (String)"\n            The resources passed to `setAnimatedIcon` and `setStaticIcon` should be white \\\n            with a transparent background, preferably a VectorDrawable or AnimatedVectorDrawable.\n            ", (Implementation)implementation, (String)"https://developer.android.com/training/wearables/ongoing-activity#best-practices", (Category)category, (int)4, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        COLOR_REGEX = new Regex("#[a-fA-F\\d]{6}");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector$Companion;", "", "()V", "BLACK", "", "COLOR_REGEX", "Lkotlin/text/Regex;", "getCOLOR_REGEX", "()Lkotlin/text/Regex;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ONGOING_ACTIVITY_BUILDER_METHOD", "WHITE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getCOLOR_REGEX() {
            return COLOR_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector$IconSetterInfo;", "", "url", "Lcom/android/resources/ResourceUrl;", "element", "Lorg/jetbrains/uast/UElement;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "(Lcom/android/resources/ResourceUrl;Lorg/jetbrains/uast/UElement;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "getElement", "()Lorg/jetbrains/uast/UElement;", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "getMessage", "()Ljava/lang/String;", "getUrl", "()Lcom/android/resources/ResourceUrl;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
    public static final class IconSetterInfo {
        @NotNull
        private final ResourceUrl url;
        @NotNull
        private final UElement element;
        @NotNull
        private final Location location;
        @NotNull
        private final String message;

        public IconSetterInfo(@NotNull ResourceUrl url, @NotNull UElement element, @NotNull Location location, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.url = url;
            this.element = element;
            this.location = location;
            this.message = message2;
        }

        @NotNull
        public final ResourceUrl getUrl() {
            return this.url;
        }

        @NotNull
        public final UElement getElement() {
            return this.element;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final ResourceUrl component1() {
            return this.url;
        }

        @NotNull
        public final UElement component2() {
            return this.element;
        }

        @NotNull
        public final Location component3() {
            return this.location;
        }

        @NotNull
        public final String component4() {
            return this.message;
        }

        @NotNull
        public final IconSetterInfo copy(@NotNull ResourceUrl url, @NotNull UElement element, @NotNull Location location, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new IconSetterInfo(url, element, location, message2);
        }

        public static /* synthetic */ IconSetterInfo copy$default(IconSetterInfo iconSetterInfo, ResourceUrl resourceUrl, UElement uElement, Location location, String string, int n, Object object) {
            if ((n & 1) != 0) {
                resourceUrl = iconSetterInfo.url;
            }
            if ((n & 2) != 0) {
                uElement = iconSetterInfo.element;
            }
            if ((n & 4) != 0) {
                location = iconSetterInfo.location;
            }
            if ((n & 8) != 0) {
                string = iconSetterInfo.message;
            }
            return iconSetterInfo.copy(resourceUrl, uElement, location, string);
        }

        @NotNull
        public String toString() {
            return "IconSetterInfo(url=" + this.url + ", element=" + this.element + ", location=" + this.location + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.element.hashCode();
            result = result * 31 + this.location.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconSetterInfo)) {
                return false;
            }
            IconSetterInfo iconSetterInfo = (IconSetterInfo)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)iconSetterInfo.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.element, (Object)iconSetterInfo.element)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)iconSetterInfo.location)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)iconSetterInfo.message);
        }
    }
}

