/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class InvalidImeActionIdDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"InvalidImeActionId", (String)"Invalid imeActionId declaration", (String)"`android:imeActionId` should not be a resource ID such as `@+id/resName`. It must be an integer constant, or an integer resource reference, as defined in `EditorInfo`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(InvalidImeActionIdDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/reference/android/view/inputmethod/EditorInfo.html");

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("imeActionId");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        String value = attribute.getValue();
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (url == null) {
            try {
                Integer.parseInt(value);
            }
            catch (Throwable ex) {
                context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("\"%1$s\" is not an integer", value));
            }
        } else if (url.type != ResourceType.INTEGER) {
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Invalid resource type, expected integer value");
        }
    }
}

