/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0006H\u0002J*\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0006H\u0002J\u001c\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060*H\u0016J\u001a\u0010+\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010#H\u0003J\u001a\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u00105\u001a\u000200H\u0002J0\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u0006H\u0002J\u0010\u0010=\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010>\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J>\u0010?\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010@\u001a\u00020A2\b\u0010\"\u001a\u0004\u0018\u00010B2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010F\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "activities", "", "", "checkedUniquePermissions", "", "seenApplication", "seenUsesSdk", "", "usesFeatures", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "beforeCheckFile", "checkApplication", "application", "Lorg/w3c/dom/Element;", "checkBackup", "checkDeviceAdmin", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "checkDocumentElement", "checkIcon", "checkLabel", "activity", "checkMergedProject", "checkMipmapIcon", "checkOverride", "attributeName", "checkXmlResourceExists", "node", "Lorg/w3c/dom/Attr;", "message", "createDataExtractionRulesFix", "Lcom/android/tools/lint/detector/api/LintFix;", "fullBackupNode", "ensureUniquePermission", "getApplicableElements", "", "getDataExtractionFileContent", "getExtraction", "client", "Lcom/android/tools/lint/client/api/LintClient;", "xmlFile", "Ljava/io/File;", "hasWearableGmsDependency", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "isDebugOrTestManifest", "manifestFile", "lookForNonUniqueNames", "mainProject", "Lcom/android/tools/lint/detector/api/Project;", "mergedManifest", "Lorg/w3c/dom/Document;", "humanReadableName", "tagName", "manifestMergerSkips", "onlyCheckSourceManifest", "reportFromManifest", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "Lorg/w3c/dom/Node;", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "fix", "visitElement", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nManifestDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestDetector.kt\ncom/android/tools/lint/checks/ManifestDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1571:1\n1#2:1572\n1747#3,3:1573\n*S KotlinDebug\n*F\n+ 1 ManifestDetector.kt\ncom/android/tools/lint/checks/ManifestDetector\n*L\n1518#1:1573,3\n*E\n"})
public final class ManifestDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean seenApplication;
    private int seenUsesSdk;
    @Nullable
    private Set<String> activities;
    @Nullable
    private Set<String> usesFeatures;
    private boolean checkedUniquePermissions;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ManifestDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ORDER = Issue.Companion.create("ManifestOrder", "Incorrect order of elements in manifest", "\n                The `<application>` tag should appear after the elements which declare which version you need, \\\n                which features you need, which libraries you need, and so on. In the past there have been subtle \\\n                bugs (such as themes not getting applied correctly) when the `<application>` tag appears before \\\n                some of these other elements, so it's best to order your manifest in the logical dependency \\\n                order.\n                ", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue TARGET_NEWER = Issue.Companion.create("OldTargetApi", "Target SDK attribute is not targeting latest version", "\n                When your application runs on a version of Android that is more recent than your \\\n                `targetSdkVersion` specifies that it has been tested with, various compatibility modes \\\n                kick in. This ensures that your application continues to work, but it may look out of \\\n                place. For example, if the `targetSdkVersion` is less than 14, your app may get an \\\n                option button in the UI.\n\n                To fix this issue, set the `targetSdkVersion` to the highest available value. Then test \\\n                your app to make sure everything works correctly. You may want to consult the \\\n                compatibility notes to see what changes apply to each version you are adding support \\\n                for: https://developer.android.com/reference/android/os/Build.VERSION_CODES.html as well \\\n                as follow this guide:\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html").addMoreInfo("https://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
    @JvmField
    @NotNull
    public static final Issue MULTIPLE_USES_SDK;
    @JvmField
    @NotNull
    public static final Issue WRONG_PARENT;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_ACTIVITY;
    @JvmField
    @NotNull
    public static final Issue DATA_EXTRACTION_RULES;
    @JvmField
    @NotNull
    public static final Issue UNIQUE_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue SET_VERSION;
    @JvmField
    @NotNull
    public static final Issue ILLEGAL_REFERENCE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_USES_FEATURE;
    @JvmField
    @NotNull
    public static final Issue APPLICATION_ICON;
    @JvmField
    @NotNull
    public static final Issue DEVICE_ADMIN;
    @JvmField
    @NotNull
    public static final Issue MOCK_LOCATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_OVERRIDES;
    @JvmField
    @NotNull
    public static final Issue MIPMAP;
    @JvmField
    @NotNull
    public static final Issue WEARABLE_BIND_LISTENER;
    @JvmField
    @NotNull
    public static final Issue APP_INDEXING_SERVICE;
    @JvmField
    @NotNull
    public static final Issue REDUNDANT_LABEL;
    @NotNull
    public static final String MOCK_LOCATION_PERMISSION = "android.permission.ACCESS_MOCK_LOCATION";
    @NotNull
    public static final String MISSING_FULL_BACKUP_CONTENT_RESOURCE = "Missing `<full-backup-content>` resource";
    @NotNull
    public static final String MISSING_EXTRACTION_RESOURCE = "Missing `data-extraction-rules` resource";
    private static final GradleCoordinate MIN_WEARABLE_GMS_VERSION;
    @NotNull
    private static final String PLAY_SERVICES_WEARABLE = "com.google.android.gms:play-services-wearable";
    @NotNull
    private static final String ATTR_DATA_EXTRACTION_RULES = "dataExtractionRules";

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.seenApplication = false;
        this.seenUsesSdk = 0;
        this.activities = null;
        this.usesFeatures = null;
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlContext xmlContext = (XmlContext)context;
        Element element = xmlContext.document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element element2 = element;
        this.checkDocumentElement(xmlContext, element2);
    }

    private final boolean onlyCheckSourceManifest(Context context) {
        return context.getDriver().isIsolated();
    }

    private final void checkApplication(Context context) {
        if (this.onlyCheckSourceManifest(context)) {
            return;
        }
        Project mainProject = context.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
        if (application == null || application.getFirstChild() == null && application.getAttributes().getLength() == 0) {
            return;
        }
        this.checkApplication(context, application);
    }

    private final void checkApplication(Context context, Element application) {
        if (context.getProject().isLibrary()) {
            return;
        }
        this.checkBackup(context, application);
        this.checkIcon(application, context);
    }

    private final void checkBackup(Context context, Element application) {
        if (!context.isEnabled(DATA_EXTRACTION_RULES)) {
            return;
        }
        Attr allowBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "allowBackup");
        Attr dataExtractionRules = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_DATA_EXTRACTION_RULES);
        Attr fullBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
        Project project = context.getMainProject();
        int min = project.getMinSdk();
        int target2 = project.getTargetSdk();
        if (min < 31 && target2 >= 31) {
            Attr attr = allowBackupNode;
            if (Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"false") && dataExtractionRules == null) {
                LintFix fix = this.createDataExtractionRulesFix(context, fullBackupNode);
                this.reportFromManifest(context, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures cloud backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix);
            } else if (fullBackupNode != null && dataExtractionRules == null) {
                LintFix fix = this.createDataExtractionRulesFix(context, fullBackupNode);
                this.reportFromManifest(context, DATA_EXTRACTION_RULES, fullBackupNode, "The attribute `android:fullBackupContent` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures cloud backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix);
            } else if (dataExtractionRules != null && fullBackupNode == null) {
                ManifestDetector.reportFromManifest$default(this, context, DATA_EXTRACTION_RULES, dataExtractionRules, "The attribute `android:dataExtractionRules` only applies for Android 12 and higher; since `minSdkVersion` is API " + min + " you should also set `android:fullBackupContent`", LocationType.VALUE, null, 32, null);
            }
        } else if (min >= 31 && dataExtractionRules == null) {
            LintFix fix;
            if (allowBackupNode != null && fullBackupNode == null && Intrinsics.areEqual((Object)allowBackupNode.getValue(), (Object)"true")) {
                this.reportFromManifest(context, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and the default allows backup", LocationType.VALUE, this.fix().unset("http://schemas.android.com/apk/res/android", "allowBackup").build());
            } else if (allowBackupNode != null) {
                fix = this.createDataExtractionRulesFix(context, fullBackupNode);
                this.reportFromManifest(context, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix);
            }
            if (fullBackupNode != null) {
                fix = this.createDataExtractionRulesFix(context, fullBackupNode);
                this.reportFromManifest(context, DATA_EXTRACTION_RULES, fullBackupNode, "The attribute `android:fullBackupContent` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix);
            }
        }
        this.checkXmlResourceExists(context, fullBackupNode, application, MISSING_FULL_BACKUP_CONTENT_RESOURCE);
        this.checkXmlResourceExists(context, dataExtractionRules, application, MISSING_EXTRACTION_RESOURCE);
    }

    private final String getExtraction(LintClient client, File xmlFile) {
        String descriptor;
        block7: {
            XmlParser parser = client.getXmlParser();
            String xml = FilesKt.readText$default((File)xmlFile, null, (int)1, null);
            Document document = parser.parseXml((CharSequence)xml, xmlFile);
            Element element = document != null ? document.getDocumentElement() : null;
            if (element == null) {
                return null;
            }
            Element root = element;
            Node node = root.getFirstChild();
            if (node == null) {
                return null;
            }
            Node first = node;
            Node node2 = root.getLastChild();
            if (node2 == null) {
                return null;
            }
            Node last = node2;
            int rootStart = parser.getNodeStartOffset(client, xmlFile, (Node)root);
            int firstStart = parser.getNodeStartOffset(client, xmlFile, first);
            int lastEnd = parser.getNodeEndOffset(client, xmlFile, last);
            if (rootStart == -1 || firstStart == -1 || lastEnd == -1) {
                return null;
            }
            List removeAttributes = new ArrayList();
            boolean clientSideEncryption2 = DomExtensions.visitAttributes((Element)root, (Function1)getExtraction.clientSideEncryption.1.INSTANCE);
            String string = xml.substring(0, rootStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string;
            String string2 = xml.substring(firstStart, lastEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object childContent = string2;
            if (clientSideEncryption2) {
                for (Attr attr : CollectionsKt.reversed((Iterable)removeAttributes)) {
                    int start = parser.getNodeStartOffset(client, xmlFile, (Node)attr);
                    int end = parser.getNodeEndOffset(client, xmlFile, (Node)attr);
                    if (start == -1 || end == -1) continue;
                    String string3 = ((String)childContent).substring(0, start - firstStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String string4 = ((String)childContent).substring(end - firstStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    childContent = string3 + string4;
                }
            }
            String indented2 = StringsKt.removePrefix((String)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)((CharSequence)childContent)), (CharSequence)"\n", null, null, (int)0, null, (Function1)getExtraction.indented.1.INSTANCE, (int)30, null), (CharSequence)"    ");
            descriptor = null;
            descriptor = prefix + "<data-extraction-rules>\n    <cloud-backup" + (clientSideEncryption2 ? " disableIfNoEncryptionCapabilities=\"true\"" : "") + ">\n" + StringsKt.removePrefix((String)((Object)StringsKt.trimEnd((CharSequence)indented2)).toString(), (CharSequence)"\n") + "\n    </cloud-backup>\n</data-extraction-rules>";
            Node node3 = parser.parseXml((CharSequence)descriptor, xmlFile);
            if (node3 == null || (node3 = node3.getDocumentElement()) == null) break block7;
            Node doc = node3;
            boolean bl = false;
            List commentOut = new ArrayList();
            DomExtensions.visitAttributes((Element)doc, (Function1)((Function1)new Function1<Attr, Boolean>((List<Element>)commentOut){
                final /* synthetic */ List<Element> $commentOut;
                {
                    this.$commentOut = $commentOut;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Attr it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)"requireFlags")) {
                        String string = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"deviceToDeviceTransfer", (boolean)false, (int)2, null)) {
                            Element element = it.getOwnerElement();
                            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"it.ownerElement");
                            this.$commentOut.add(element);
                        }
                    }
                    return false;
                }
            }));
            for (Element element2 : CollectionsKt.reversed((Iterable)commentOut)) {
                int start = parser.getNodeStartOffset(client, xmlFile, (Node)element2);
                int end = parser.getNodeEndOffset(client, xmlFile, (Node)element2);
                if (start == -1 || end == -1) continue;
                String string5 = descriptor.substring(0, start);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string6 = descriptor.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string7 = descriptor.substring(end);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                descriptor = string5 + "<!-- " + string6 + " -->" + string7;
            }
        }
        return descriptor;
    }

    @Language(value="XML")
    private final String getDataExtractionFileContent(Context context, Attr fullBackupNode) {
        String string;
        if (fullBackupNode != null && (string = fullBackupNode.getValue()) != null) {
            String it = string;
            boolean bl = false;
            ResourceUrl resourceUrl = ResourceUrl.parse((String)it);
            if (resourceUrl != null) {
                ResourceUrl url = resourceUrl;
                boolean bl2 = false;
                LintClient client = context.getClient();
                Project project = context.getProject();
                ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                List list = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resources.getResources(R\u2026DO(), url.type, url.name)");
                ResourceItem resourceItem = (ResourceItem)CollectionsKt.firstOrNull((List)list);
                Object item = resourceItem != null ? resourceItem.getSource() : null;
                Object object = item;
                if (object != null && (object = object.toFile()) != null) {
                    Object file = object;
                    boolean bl3 = false;
                    String string2 = this.getExtraction(client, (File)file);
                    if (string2 != null) {
                        String it2 = string2;
                        boolean bl4 = false;
                        return it2;
                    }
                }
            }
        }
        String descriptor = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n   Sample data extraction rules file; uncomment and customize as necessary.\n   See https://developer.android.com/about/versions/12/backup-restore#xml-changes\n   for details.\n-->\n<data-extraction-rules>\n    <cloud-backup>\n        <!--\n        TODO: Use <include> and <exclude> to control what is backed up.\n        The domain can be file, database, sharedpref, external or root.\n        Examples:\n\n        <include domain=\"file\" path=\"file_to_include\"/>\n        <exclude domain=\"file\" path=\"file_to_exclude\"/>\n        <include domain=\"file\" path=\"include_folder\"/>\n        <exclude domain=\"file\" path=\"include_folder/file_to_exclude\"/>\n        <exclude domain=\"file\" path=\"exclude_folder\"/>\n        <include domain=\"file\" path=\"exclude_folder/file_to_include\"/>\n\n        <include domain=\"sharedpref\" path=\"include_shared_pref1.xml\"/>\n        <include domain=\"database\" path=\"db_name/file_to_include\"/>\n        <exclude domain=\"database\" path=\"db_name/include_folder/file_to_exclude\"/>\n        <include domain=\"external\" path=\"file_to_include\"/>\n        <exclude domain=\"external\" path=\"file_to_exclude\"/>\n        <include domain=\"root\" path=\"file_to_include\"/>\n        <exclude domain=\"root\" path=\"file_to_exclude\"/>\n        -->\n    </cloud-backup>\n    <!--\n    <device-transfer>\n        <include .../>\n        <exclude .../>\n    </device-transfer>\n    -->\n</data-extraction-rules>";
        return descriptor;
    }

    private final LintFix createDataExtractionRulesFix(Context context, Attr fullBackupNode) {
        Project project = context.getProject();
        List list = project.getResourceFolders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.resourceFolders");
        File file = (File)CollectionsKt.firstOrNull((List)list);
        if (file == null) {
            return null;
        }
        File folder = file;
        String name = "data_extraction_rules";
        File file2 = new File(folder, "xml" + File.separator + name + ".xml");
        if (file2.exists()) {
            return null;
        }
        String descriptor = this.getDataExtractionFileContent(context, fullBackupNode);
        LintFix createFix = this.fix().newFile(file2, descriptor).build();
        LintFix setAttributeFix = this.fix().set("http://schemas.android.com/apk/res/android", ATTR_DATA_EXTRACTION_RULES, "@xml/" + name).build();
        LintFix[] lintFixArray = new LintFix[]{createFix, setAttributeFix};
        return this.fix().composite(lintFixArray);
    }

    private final void checkXmlResourceExists(Context context, Attr node, Element application, String message2) {
        block6: {
            block5: {
                if (node == null) break block5;
                String string = node.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.value");
                if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block6;
            }
            return;
        }
        boolean full = context.isGlobalAnalysis();
        Project project = full ? context.getMainProject() : context.getProject();
        ResourceRepository resources = context.getClient().getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        ResourceUrl url = ResourceUrl.parse((String)node.getValue());
        if (url != null && !url.isFramework() && !resources.hasResources(ResourceNamespace.TODO(), url.type, url.name)) {
            Attr attr = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", node.getName());
            if (attr == null) {
                attr = node;
            }
            Attr locationNode = attr;
            ManifestDetector.reportFromManifest$default(this, context, DATA_EXTRACTION_RULES, locationNode, message2, LocationType.VALUE, null, 32, null);
        }
    }

    private final void checkIcon(Element application, Context context) {
        if (!application.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon") && context.isEnabled(APPLICATION_ICON)) {
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "icon", "@mipmap/").caretEnd().build();
            this.reportFromManifest(context, APPLICATION_ICON, application, "Should explicitly set `android:icon`, there is no default", LocationType.NAME, fix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDocumentElement(XmlContext context, Element element) {
        codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionCode");
        if (codeNode == null) ** GOTO lbl-1000
        v0 = codeNode.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"codeNode.value");
        if (StringsKt.startsWith$default((String)v0, (String)"@", (boolean)false, (int)2, null) && context.isEnabled(ManifestDetector.ILLEGAL_REFERENCE)) {
            XmlContext.report$default((XmlContext)context, (Issue)ManifestDetector.ILLEGAL_REFERENCE, (Node)element, (Location)context.getLocation((Node)codeNode), (String)"The `android:versionCode` cannot be a resource url, it must be a literal integer", null, (int)16, null);
        } else if (codeNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"versionCode", null, null, (int)12, null).build();
            context.report(ManifestDetector.SET_VERSION, (Node)element, context.getNameLocation((Node)element), "Should set `android:versionCode` to specify the application version", fix);
        }
        nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionName");
        if (nameNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"versionName", null, null, (int)12, null).build();
            context.report(ManifestDetector.SET_VERSION, (Node)element, context.getNameLocation((Node)element), "Should set `android:versionName` to specify the application version", fix);
        }
        if ((pkgNode = element.getAttributeNode("package")) != null) {
            pkg = pkgNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)pkg, (String)"pkg");
            if (StringsKt.contains$default((CharSequence)pkg, (CharSequence)"${", (boolean)false, (int)2, null) && context.getProject().isGradleProject()) {
                XmlContext.report$default((XmlContext)context, (Issue)ManifestDetector.GRADLE_OVERRIDES, (Node)pkgNode, (Location)context.getLocation((Node)pkgNode), (String)"Cannot use placeholder for the package in the manifest; set `applicationId` in `build.gradle` instead", null, (int)16, null);
            }
        }
    }

    private final void reportFromManifest(Context context, Issue issue, Node node, String message2, LocationType type, LintFix fix) {
        Location location = context.getLocation((Object)node, type);
        if (location.getStart() == null) {
            return;
        }
        Incident incident = new Incident(issue, message2, location, fix);
        context.report(incident);
        if (context.isGlobalAnalysis()) {
            incident.project(context.getMainProject());
        }
    }

    static /* synthetic */ void reportFromManifest$default(ManifestDetector manifestDetector, Context context, Issue issue, Node node, String string, LocationType locationType, LintFix lintFix, int n, Object object) {
        if ((n & 0x20) != 0) {
            lintFix = null;
        }
        manifestDetector.reportFromManifest(context, issue, node, string, locationType, lintFix);
    }

    private final void checkOverride(XmlContext context, Element element, String attributeName) {
        LintModelVariant variant;
        Project project = context.getProject();
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (attribute != null && context.isEnabled(GRADLE_OVERRIDES) && (variant = project.getBuildVariant()) != null) {
            String string;
            if (Intrinsics.areEqual((Object)"minSdkVersion", (Object)attributeName)) {
                AndroidVersion minSdkVersion;
                if (element.hasAttributeNS("http://schemas.android.com/tools", "overrideLibrary")) {
                    return;
                }
                AndroidVersion androidVersion = minSdkVersion = variant.getMinSdkVersion();
                string = androidVersion != null ? androidVersion.getApiString() : null;
            } else if (Intrinsics.areEqual((Object)"targetSdkVersion", (Object)attributeName)) {
                AndroidVersion targetSdkVersion;
                AndroidVersion androidVersion = targetSdkVersion = variant.getTargetSdkVersion();
                string = androidVersion != null ? androidVersion.getApiString() : null;
            } else {
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-ManifestDetector$checkOverride$gradleValue$22 = false;
                    String $i$a$-assert-ManifestDetector$checkOverride$gradleValue$22 = attributeName;
                    throw new AssertionError((Object)$i$a$-assert-ManifestDetector$checkOverride$gradleValue$22);
                }
                return;
            }
            String gradleValue = string;
            if (gradleValue != null) {
                String manifestValue = attribute.getValue();
                String message2 = "This `" + attributeName + "` value (`" + manifestValue + "`) is not used; it is always overridden by the value specified in the Gradle build script (`" + gradleValue + "`)";
                XmlContext.report$default((XmlContext)context, (Issue)GRADLE_OVERRIDES, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message2, null, (int)16, null);
            }
        }
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture", "uses-library", "activity", "service", "provider", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Attr name;
        Attr nameNode;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        Node parentNode = element.getParentNode();
        boolean isReceiver = Intrinsics.areEqual((Object)tag, (Object)"receiver");
        if (isReceiver) {
            this.checkDeviceAdmin(context, element);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-library") || Intrinsics.areEqual((Object)tag, (Object)"activity") || Intrinsics.areEqual((Object)tag, (Object)"service") || isReceiver) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && context.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default((XmlContext)context, (Issue)WRONG_PARENT, (Node)element, (Location)context.getNameLocation((Node)element), (String)("The `<" + tag + ">` element must be a direct child of the <application> element"), null, (int)16, null);
            }
            if (Intrinsics.areEqual((Object)tag, (Object)"activity")) {
                Attr nameNode2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameNode2 != null) {
                    Object name2 = nameNode2.getValue();
                    String string = name2;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    if (((CharSequence)string).length() > 0) {
                        Set set;
                        Object pkg;
                        Object object = context.document.getDocumentElement().getAttributeNode("package");
                        if (object == null || (object = object.getValue()) == null) {
                            object = pkg = context.getProject().getPackage();
                        }
                        if (((String)name2).charAt(0) == '.') {
                            name2 = (String)pkg + (String)name2;
                        } else {
                            String string2 = name2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                            if (StringsKt.indexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                                name2 = (String)pkg + "." + (String)name2;
                            }
                        }
                        if ((set = this.activities) == null) {
                            Set set2;
                            Set it = set2 = (Set)new LinkedHashSet();
                            boolean bl = false;
                            this.activities = it;
                            set = set2;
                        }
                        Set activities = set;
                        Object object2 = name2;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"name");
                        if (!activities.add((String)object2)) {
                            String message2 = "Duplicate registration for activity `" + (String)name2 + "`";
                            XmlContext.report$default((XmlContext)context, (Issue)DUPLICATE_ACTIVITY, (Node)element, (Location)context.getLocation((Node)nameNode2), (String)message2, null, (int)16, null);
                        }
                    }
                }
                this.checkMipmapIcon(context, element);
                this.checkLabel(context, element);
            } else if (Intrinsics.areEqual((Object)tag, (Object)"service") && context.getProject().isGradleProject()) {
                if (context.getProject().getTargetSdk() >= 26) {
                    block2: for (Object child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                        for (Object innerChild : XmlUtils.getSubTagsByName((Node)((Node)child), (String)"action")) {
                            Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                            if (attr == null || !Intrinsics.areEqual((Object)"com.google.firebase.appindexing.UPDATE_INDEX", (Object)attr.getValue())) continue;
                            String message3 = "`UPDATE_INDEX` is configured as a service in your app, which is no longer supported for the API level you're targeting. Use a `BroadcastReceiver` instead.";
                            Incident incident = new Incident(APP_INDEXING_SERVICE, (Object)attr, context.getLocation((Node)attr), message3);
                            context.report(incident, Constraints.targetSdkAtLeast((int)26));
                            continue block2;
                        }
                    }
                }
                Attr bindListenerAttr = null;
                block4: for (Element child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                    for (Element innerChild : XmlUtils.getSubTagsByName((Node)child, (String)"action")) {
                        Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (attr == null || !Intrinsics.areEqual((Object)"com.google.android.gms.wearable.BIND_LISTENER", (Object)attr.getValue())) continue;
                        bindListenerAttr = attr;
                        continue block4;
                    }
                }
                if (bindListenerAttr == null) {
                    return;
                }
                LintModelVariant variant = context.getProject().getBuildVariant();
                if (variant != null && this.hasWearableGmsDependency(variant)) {
                    XmlContext.report$default((XmlContext)context, (Issue)WEARABLE_BIND_LISTENER, (Node)bindListenerAttr, (Location)context.getLocation((Node)bindListenerAttr), (String)"The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated", null, (int)16, null);
                    return;
                }
                File sdkHome = context.getClient().getSdkHome();
                if (context.getProject().getBuildSdk() >= 24 && sdkHome != null) {
                    GradleCoordinate max;
                    Path repository2 = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome.toPath(), true);
                    Object message4 = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest version of play-services-wearable 8.2.0 or later";
                    if (repository2 != null && (max = MavenRepositories.getHighestInstalledVersion((String)"com.google.android.gms", (String)"play-services-wearable", (Path)repository2, null, (boolean)false)) != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(max, MIN_WEARABLE_GMS_VERSION) > 0) {
                        message4 = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest available version of play-services-wearable: `" + max.getRevision() + "`";
                    }
                    Location location = context.getLocation((Node)bindListenerAttr);
                    XmlContext.report$default((XmlContext)context, (Issue)WEARABLE_BIND_LISTENER, (Node)bindListenerAttr, (Location)location, (String)message4, null, (int)16, null);
                }
            }
            return;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"provider")) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && !Intrinsics.areEqual((Object)"queries", (Object)parentNode.getNodeName()) && context.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default((XmlContext)context, (Issue)WRONG_PARENT, (Node)element, (Location)context.getNameLocation((Node)element), (String)("The `<" + tag + ">` element must be a direct child of the `<application>` element or the `<queries>` element"), null, (int)16, null);
            }
            return;
        }
        if (parentNode != element.getOwnerDocument().getDocumentElement()) {
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            if (StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null) == -1 && context.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default((XmlContext)context, (Issue)WRONG_PARENT, (Node)element, (Location)context.getNameLocation((Node)element), (String)("The `<" + tag + ">` element must be a direct child of the `<manifest>` root element"), null, (int)16, null);
            }
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-sdk")) {
            int bindListenerAttr = this.seenUsesSdk;
            this.seenUsesSdk = bindListenerAttr + 1;
            if (this.seenUsesSdk == 2) {
                Location location = context.getNameLocation((Node)element);
                NodeList elements = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location secondary = null;
                for (int i = elements.getLength() - 1; -1 < i; --i) {
                    Node node = elements.item(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    Element e = (Element)node;
                    if (e == element) continue;
                    Location l = context.getNameLocation((Node)e);
                    l.setSecondary(secondary);
                    l.setMessage("Also appears here");
                    secondary = l;
                }
                location.setSecondary(secondary);
                if (context.isEnabled(MULTIPLE_USES_SDK)) {
                    XmlContext.report$default((XmlContext)context, (Issue)MULTIPLE_USES_SDK, (Node)element, (Location)location, (String)"There should only be a single `<uses-sdk>` element in the manifest: merge these together", null, (int)16, null);
                }
                return;
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                if (codeNode != null) {
                    String string = codeNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeNode.value");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null) && context.isEnabled(ILLEGAL_REFERENCE)) {
                        XmlContext.report$default((XmlContext)context, (Issue)ILLEGAL_REFERENCE, (Node)element, (Location)context.getLocation((Node)codeNode), (String)"The `android:minSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, (int)16, null);
                    }
                }
                this.checkOverride(context, element, "minSdkVersion");
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                Attr targetSdkVersionNode;
                this.checkOverride(context, element, "targetSdkVersion");
                if (context.isEnabled(TARGET_NEWER) && (targetSdkVersionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                    String target2 = targetSdkVersionNode.getValue();
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"target");
                        int api2 = Integer.parseInt(target2);
                        int highest = context.getClient().getHighestKnownApiLevel();
                        if (api2 < highest) {
                            LintFix fix = this.fix().name("Update targetSdkVersion to " + highest).replace().pattern("targetSdkVersion\\s*=\\s*[\"'](.*)[\"']").with(String.valueOf(highest)).build();
                            Location location = context.getLocation((Node)targetSdkVersionNode);
                            context.report(TARGET_NEWER, (Node)element, location, "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the `android.os.Build.VERSION_CODES` javadoc for details.", fix);
                        }
                    }
                    catch (NumberFormatException api2) {
                        // empty catch block
                    }
                }
            }
            if ((nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                String string = nameNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameNode.value");
                if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null) && context.isEnabled(ILLEGAL_REFERENCE)) {
                    XmlContext.report$default((XmlContext)context, (Issue)ILLEGAL_REFERENCE, (Node)element, (Location)context.getLocation((Node)nameNode), (String)"The `android:targetSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, (int)16, null);
                }
            }
        }
        if ((Intrinsics.areEqual((Object)tag, (Object)"permission") || Intrinsics.areEqual((Object)tag, (Object)"permission-group")) && context.isGlobalAnalysis()) {
            this.ensureUniquePermission((Context)context);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-permission") && (name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && Intrinsics.areEqual((Object)name.getValue(), (Object)MOCK_LOCATION_PERMISSION) && context.getProject().getBuildModule() != null && !this.isDebugOrTestManifest(context, context.file) && context.isEnabled(MOCK_LOCATION)) {
            String message5 = "Mock locations should only be requested in a test or debug-specific manifest file (typically `src/debug/AndroidManifest.xml`)";
            Location location = context.getLocation((Node)name);
            XmlContext.report$default((XmlContext)context, (Issue)MOCK_LOCATION, (Node)element, (Location)location, (String)message5, null, (int)16, null);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"application")) {
            this.seenApplication = true;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon")) {
                this.checkMipmapIcon(context, element);
            }
            if (this.onlyCheckSourceManifest((Context)context)) {
                this.checkApplication((Context)context, element);
            }
        } else if (this.seenApplication) {
            if (context.isEnabled(ORDER)) {
                XmlContext.report$default((XmlContext)context, (Issue)ORDER, (Node)element, (Location)context.getNameLocation((Node)element), (String)("`<" + tag + ">` tag appears after `<application>` tag"), null, (int)16, null);
            }
            this.seenApplication = false;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-feature") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            String name3 = nameNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"name");
            if (((CharSequence)name3).length() > 0) {
                Set usesFeatures;
                Set set = this.usesFeatures;
                if (set == null) {
                    Set set3;
                    Set it = set3 = (Set)new LinkedHashSet();
                    boolean bl = false;
                    this.usesFeatures = it;
                    set = set3;
                }
                if (!(usesFeatures = set).add((String)name3)) {
                    String message6 = "Duplicate declaration of uses-feature `" + name3 + "`";
                    XmlContext.report$default((XmlContext)context, (Issue)DUPLICATE_USES_FEATURE, (Node)element, (Location)context.getLocation((Node)nameNode), (String)message6, null, (int)16, null);
                }
            }
        }
    }

    private final void ensureUniquePermission(Context context) {
        if (this.checkedUniquePermissions) {
            return;
        }
        this.checkedUniquePermissions = true;
        Project mainProject = context.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        this.lookForNonUniqueNames(context, mainProject, mergedManifest, "permission", "permission");
        this.lookForNonUniqueNames(context, mainProject, mergedManifest, "permission group", "permission-group");
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureUniquePermission(context);
        this.checkApplication(context);
    }

    private final void lookForNonUniqueNames(Context context, Project mainProject, Document mergedManifest, String humanReadableName, String tagName) {
        Map nameToFull = null;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Iterator iterator = DomExtensions.iterator((Element)root);
        while (iterator.hasNext()) {
            String string;
            Map map;
            Map map2;
            Map map3;
            String base;
            Object pkg;
            String string2;
            Attr nameNode;
            Element element2 = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)element2.getTagName(), (Object)tagName) || this.manifestMergerSkips(element2) || element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") == null) continue;
            String name = nameNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            String string3 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"this as java.lang.String).substring(startIndex)");
            Object object = mergedManifest.getDocumentElement().getAttributeNode("package");
            if (object == null || (object = object.getValue()) == null) {
                object = pkg = mainProject.getPackage();
            }
            if (!mainProject.isLibrary() && pkg != null) {
                String string4 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"${applicationId}", (boolean)false, (int)2, null)) {
                    String string5 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
                    name = StringsKt.replace$default((String)string5, (String)"${applicationId}", (String)pkg, (boolean)false, (int)4, null);
                }
            }
            String string6 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"name");
            if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"${", (boolean)false, (int)2, null)) continue;
            if (nameToFull != null) {
                if (nameToFull.containsKey(base) && !Intrinsics.areEqual((Object)name, nameToFull.get(base))) {
                    Node node;
                    String prevName = (String)nameToFull.get(base);
                    Location location = context.getLocation((Object)nameNode, LocationType.ALL);
                    NodeList siblings = element2.getParentNode().getChildNodes();
                    int n2 = siblings.getLength();
                    for (int i = 0; i < n2 && (node = siblings.item(i)) != element2; ++i) {
                        if (node.getNodeType() != 1) continue;
                        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                        Element sibling = (Element)node;
                        if (!Intrinsics.areEqual((Object)sibling.getTagName(), (Object)tagName) || !Intrinsics.areEqual((Object)prevName, (Object)sibling.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                        Attr no = sibling.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        Location prevLocation = context.getLocation((Object)no, LocationType.VALUE);
                        prevLocation.setMessage("Previous " + humanReadableName + " here");
                        location.setSecondary(prevLocation);
                        break;
                    }
                    String message2 = StringHelper.usLocaleCapitalize((String)humanReadableName) + " name `" + base + "` is not unique (appears in both `" + prevName + "` and `" + name + "`)";
                    Incident incident = new Incident(UNIQUE_PERMISSION, (Object)element2, location, message2);
                    context.report(incident);
                    if (context.isGlobalAnalysis()) {
                        incident.project(context.getMainProject());
                    }
                }
                map3 = nameToFull;
            } else {
                Map it = map2 = (Map)new LinkedHashMap();
                boolean bl = false;
                nameToFull = it;
                map3 = map2;
            }
            map2 = map = map3;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            map2.put(base, string);
        }
    }

    private final boolean manifestMergerSkips(Element element) {
        Attr operation = element.getAttributeNodeNS("http://schemas.android.com/tools", "node");
        if (operation != null) {
            String action = operation.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)action, (String)"action");
            if (StringsKt.startsWith$default((String)action, (String)"remove", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)action, (Object)"replace")) {
                return true;
            }
        }
        return false;
    }

    private final boolean hasWearableGmsDependency(LintModelVariant variant) {
        LintModelLibrary lintModelLibrary = variant.getMainArtifact().findCompileDependency(PLAY_SERVICES_WEARABLE);
        LintModelExternalLibrary lintModelExternalLibrary = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
        if (lintModelExternalLibrary == null) {
            return false;
        }
        LintModelExternalLibrary library = lintModelExternalLibrary;
        LintModelMavenName mc = library.getResolvedCoordinates();
        GradleCoordinate gc = GradleCoordinate.parseVersionOnly((String)mc.getVersion());
        return GradleCoordinate.COMPARE_PLUS_HIGHER.compare(gc, MIN_WEARABLE_GMS_VERSION) >= 0;
    }

    private final void checkMipmapIcon(XmlContext context, Element element) {
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "icon");
        if (attr == null) {
            return;
        }
        Attr attribute = attr;
        String icon = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"icon");
        if (StringsKt.startsWith$default((String)icon, (String)"@drawable/", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)"activity", (Object)element.getTagName()) && !Companion.isLaunchableActivity(element)) {
                return;
            }
            if (context.isEnabled(MIPMAP) && context.getProject().getApplicableDensities() != null) {
                XmlContext.report$default((XmlContext)context, (Issue)MIPMAP, (Node)element, (Location)context.getLocation((Node)attribute), (String)"Should use `@mipmap` instead of `@drawable` for launcher icons", null, (int)16, null);
            }
        }
    }

    private final void checkLabel(XmlContext context, Element activity) {
        Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "label");
        if (attr == null) {
            return;
        }
        Attr labelAttribute = attr;
        Node node = activity.getParentNode();
        Element element = node instanceof Element ? (Element)node : null;
        if (element == null) {
            return;
        }
        Element applicationElement = element;
        if (!Intrinsics.areEqual((Object)applicationElement.getNodeName(), (Object)"application")) {
            return;
        }
        String string = applicationElement.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
        if (string == null) {
            return;
        }
        String applicationLabel = string;
        if (Intrinsics.areEqual((Object)labelAttribute.getValue(), (Object)applicationLabel)) {
            LintFix fix = this.fix().unset("http://schemas.android.com/apk/res/android", "label").build();
            context.report(REDUNDANT_LABEL, context.getLocation((Node)labelAttribute), "Redundant label can be removed", fix);
        }
    }

    private final boolean isDebugOrTestManifest(XmlContext context, File manifestFile) {
        LintModelVariant variant = context.getProject().getBuildVariant();
        if (variant != null) {
            for (LintModelSourceProvider provider : variant.getSourceProviders()) {
                boolean bl;
                block5: {
                    if (!provider.isDebugOnly() && !provider.isTest()) continue;
                    Iterable $this$any$iv = provider.getManifestFiles();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            File it = (File)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)manifestFile)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private final void checkDeviceAdmin(XmlContext context, Element element) {
        boolean requiredIntentFilterFound = false;
        boolean deviceAdmin = false;
        Attr locationNode = null;
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr valueNode;
            String tagName = child.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"intent-filter") && !requiredIntentFilterFound) {
                boolean dataFound = false;
                boolean actionFound = false;
                for (Element filterChild : XmlUtils.getSubTags((Node)child)) {
                    String filterTag = filterChild.getTagName();
                    if (Intrinsics.areEqual((Object)filterTag, (Object)"action")) {
                        String name2 = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!Intrinsics.areEqual((Object)"android.app.action.DEVICE_ADMIN_ENABLED", (Object)name2)) continue;
                        actionFound = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)filterTag, (Object)"data")) continue;
                    dataFound = true;
                }
                if (!actionFound || dataFound) continue;
                requiredIntentFilterFound = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)tagName, (Object)"meta-data") || (valueNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)"android.app.device_admin", (Object)(name = valueNode.getValue()))) continue;
            deviceAdmin = true;
            locationNode = valueNode;
        }
        if (deviceAdmin && !requiredIntentFilterFound && context.isEnabled(DEVICE_ADMIN)) {
            XmlContext.report$default((XmlContext)context, (Issue)DEVICE_ADMIN, (Node)locationNode, (Location)Context.getLocation$default((Context)((Context)context), locationNode, null, (int)2, null), (String)"You must have an intent filter for action `android.app.action.DEVICE_ADMIN_ENABLED`", null, (int)16, null);
        }
    }

    @JvmStatic
    public static final boolean isLaunchableActivity(@NotNull Element activity) {
        return Companion.isLaunchableActivity(activity);
    }

    @JvmStatic
    @Nullable
    public static final Attr findLaunchableCategoryNode(@NotNull Element activity) {
        return Companion.findLaunchableCategoryNode(activity);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = IMPLEMENTATION;
        MULTIPLE_USES_SDK = Issue.Companion.create$default((Issue.Companion)companion, (String)"MultipleUsesSdk", (String)"Multiple `<uses-sdk>` elements in the manifest", (String)"\n                The `<uses-sdk>` element should appear just once; the tools will **not** merge the contents \\\n                of all the elements so if you split up the attributes across multiple elements, only one of \\\n                them will take effect. To fix this, just merge all the attributes from the various elements \\\n                into a single <uses-sdk> element.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/manifest/uses-sdk-element.html", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WRONG_PARENT = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongManifestParent", (String)"Wrong manifest parent", (String)"\n                The `<uses-library>` element should be defined as a direct child of the `<application>` \\\n                tag, not the `<manifest>` tag or an `<activity>` tag. Similarly, a `<uses-sdk>` tag must \\\n                be declared at the root level, and so on. This check looks for incorrect declaration \\\n                locations in the manifest, and complains if an element is found in the wrong place.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/manifest/manifest-intro.html", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        DUPLICATE_ACTIVITY = Issue.Companion.create("DuplicateActivity", "Activity registered more than once", "\n                An activity should only be registered once in the manifest. If it is accidentally \\\n                registered more than once, then subtle errors can occur, since attribute declarations \\\n                from the two elements are not merged, so you may accidentally remove previous \\\n                declarations.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.SECURITY;
        severity = IMPLEMENTATION;
        DATA_EXTRACTION_RULES = Issue.Companion.create$default((Issue.Companion)companion, (String)"DataExtractionRules", (String)"Missing data extraction rules", (String)"\n                Before Android 12, the attributes `android:allowBackup` and `android:fullBackupContent` \\\n                were used to configure all forms of backup, including cloud backups, device-to-device \\\n                transfers and adb backup.\n\n                In Android 12 and higher, these attributes have been deprecated and will only apply \\\n                to cloud backups. You should instead use the attribute `android:dataExtractionRules`, \\\n                specifying an `@xml` resource that configures which files to back up, for cloud backups \\\n                and for device-to-device transfers, separately. If your `minSdkVersion` supports older \\\n                versions, you'll still want to specify an `android:fullBackupContent` resource if the default \\\n                behavior is not right for your app.\n                ", (Implementation)severity, (String)"https://developer.android.com/about/versions/12/backup-restore#xml-changes", (Category)category, (int)3, null, (boolean)false, null, null, null, (int)3968, null).addMoreInfo("https://goo.gle/DataExtractionRules");
        UNIQUE_PERMISSION = Issue.Companion.create("UniquePermission", "Permission names are not unique", "\n                The unqualified names or your permissions must be unique. The reason for this is that at \\\n                build time, the `aapt` tool will generate a class named `Manifest` which contains a field \\\n                for each of your permissions. These fields are named using your permission unqualified names \\\n                (i.e. the name portion after the last dot).\n\n                If more than one permission maps to the same field name, that field will arbitrarily name \\\n                just one of them.\n                ", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SET_VERSION = Issue.Companion.create$default((Issue.Companion)companion, (String)"MissingVersion", (String)"Missing application name/version", (String)"\n                You should define the version information for your application.\n\n                `android:versionCode`: An integer value that represents the version of the application code, \\\n                relative to other versions.\n\n                `android:versionName`: A string value that represents the release version of the application \\\n                code, as it should be shown to users.\n                ", (Implementation)implementation, (String)"https://developer.android.com/studio/publish/versioning#appversioning", (Category)category, (int)2, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        ILLEGAL_REFERENCE = Issue.Companion.create("IllegalResourceRef", "Name and version must be integer or string, not resource", "\n                For the `versionCode` attribute, you have to specify an actual integer literal; you cannot \\\n                use an indirection with a `@dimen/name` resource. Similarly, the `versionName` attribute \\\n                should be an actual string, not a string resource url.\n                ", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
        DUPLICATE_USES_FEATURE = Issue.Companion.create("DuplicateUsesFeature", "Feature declared more than once", "A given feature should only be declared once in the manifest.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.ICONS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APPLICATION_ICON = Issue.Companion.create$default((Issue.Companion)companion, (String)"MissingApplicationIcon", (String)"Missing application icon", (String)"\n                You should set an icon for the application as whole because there is no default. This \\\n                attribute must be set as a reference to a drawable resource containing the image (for \\\n                example `@drawable/icon`).\n                ", (Implementation)implementation, (String)"https://developer.android.com/studio/publish/preparing#publishing-configure", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        DEVICE_ADMIN = Issue.Companion.create("DeviceAdmin", "Malformed Device Admin", "\n                If you register a broadcast receiver which acts as a device admin, you must also register \\\n                an `<intent-filter>` for the action `android.app.action.DEVICE_ADMIN_ENABLED`, without any \\\n                `<data>`, such that the device admin can be activated/deactivated.\n\n                To do this, add\n                ```xml\n                `<intent-filter>`\n                    `<action android:name=\"android.app.action.DEVICE_ADMIN_ENABLED\" />`\n                `</intent-filter>`\n                ```\n                to your `<receiver>`.\n                ", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
        MOCK_LOCATION = Issue.Companion.create("MockLocation", "Using mock location provider in production", "\n                Using a mock location provider (by requiring the permission `android.permission.ACCESS_MOCK_LOCATION`) should **only** be done in debug builds (or from tests). In Gradle projects, that means you should only request this permission in a test or debug source set specific manifest file.\n\n                To fix this, create a new manifest file in the debug folder and move the `<uses-permission>` element there. A typical path to a debug manifest override file in a Gradle project is src/debug/AndroidManifest.xml.\n                ", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        GRADLE_OVERRIDES = Issue.Companion.create("GradleOverrides", "Value overridden by Gradle build script", "\n                The value of (for example) `minSdkVersion` is only used if it is not specified in the \\\n                `build.gradle` build scripts. When specified in the Gradle build scripts, the manifest \\\n                value is ignored and can be misleading, so should be removed to avoid ambiguity.\n                ", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        MIPMAP = Issue.Companion.create("MipmapIcons", "Use Mipmap Launcher Icons", "\n                Launcher icons should be provided in the `mipmap` resource directory. This is the same as \\\n                the `drawable` resource directory, except resources in the `mipmap` directory will not get \\\n                stripped out when creating density-specific APKs.\n\n                In certain cases, the Launcher app may use a higher resolution asset (than would normally \\\n                be computed for the device) to display large app shortcuts. If drawables for densities \\\n                other than the device's resolution have been stripped out, then the app shortcut could \\\n                appear blurry.\n\n                To fix this, move your launcher icons from `drawable-`dpi to `mipmap-`dpi and change \\\n                references from @drawable/ and R.drawable to @mipmap/ and R.mipmap.\n\n                In Android Studio this lint warning has a quickfix to perform this automatically.\n                ", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WEARABLE_BIND_LISTENER = Issue.Companion.create$default((Issue.Companion)companion, (String)"WearableBindListener", (String)"Usage of Android Wear BIND_LISTENER is deprecated", (String)"\n                BIND_LISTENER receives all Android Wear events whether the application needs them or not. \\\n                This can be inefficient and cause applications to wake up unnecessarily. With Google Play \\\n                Services 8.2.0 or later it is recommended to use a more efficient combination of manifest \\\n                listeners and api-based live listeners filtered by action, path and/or path prefix.\n                ", (Implementation)implementation, (String)"https://android-developers.googleblog.com/2016/04/deprecation-of-bindlistener.html", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APP_INDEXING_SERVICE = Issue.Companion.create$default((Issue.Companion)companion, (String)"AppIndexingService", (String)"App Indexing Background Services", (String)"\n                Apps targeting Android 8.0 or higher can no longer rely on background services while \\\n                listening for updates to the on-device index. Use a `BroadcastReceiver` for the \\\n                `UPDATE_INDEX` intent to continue supporting indexing in your app.\n                ", (Implementation)implementation, (String)"https://firebase.google.com/docs/app-indexing/android/personal-content#add-a-broadcast-receiver-to-your-app", (Category)category, (int)4, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        REDUNDANT_LABEL = Issue.Companion.create("RedundantLabel", "Redundant label on activity", "\n                When an activity does not have a label attribute, it will use the one from the application tag. \\\n                Since the application has already specified the same label, the label on this activity can be omitted.\n                ", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        MIN_WEARABLE_GMS_VERSION = GradleCoordinate.parseVersionOnly((String)"8.2.0");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector$Companion;", "", "()V", "APPLICATION_ICON", "Lcom/android/tools/lint/detector/api/Issue;", "APP_INDEXING_SERVICE", "ATTR_DATA_EXTRACTION_RULES", "", "DATA_EXTRACTION_RULES", "DEVICE_ADMIN", "DUPLICATE_ACTIVITY", "DUPLICATE_USES_FEATURE", "GRADLE_OVERRIDES", "ILLEGAL_REFERENCE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MIN_WEARABLE_GMS_VERSION", "Lcom/android/ide/common/repository/GradleCoordinate;", "kotlin.jvm.PlatformType", "MIPMAP", "MISSING_EXTRACTION_RESOURCE", "MISSING_FULL_BACKUP_CONTENT_RESOURCE", "MOCK_LOCATION", "MOCK_LOCATION_PERMISSION", "MULTIPLE_USES_SDK", "ORDER", "PLAY_SERVICES_WEARABLE", "REDUNDANT_LABEL", "SET_VERSION", "TARGET_NEWER", "UNIQUE_PERMISSION", "WEARABLE_BIND_LISTENER", "WRONG_PARENT", "findLaunchableCategoryNode", "Lorg/w3c/dom/Attr;", "activity", "Lorg/w3c/dom/Element;", "isLaunchableActivity", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isLaunchableActivity(@NotNull Element activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            return this.findLaunchableCategoryNode(activity) != null;
        }

        @JvmStatic
        @Nullable
        public final Attr findLaunchableCategoryNode(@NotNull Element activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (!Intrinsics.areEqual((Object)"activity", (Object)activity.getTagName())) {
                return null;
            }
            Iterator iterator = DomExtensions.iterator((Element)activity);
            while (iterator.hasNext()) {
                Element filter = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)filter.getTagName(), (Object)"intent-filter")) continue;
                Iterator iterator2 = DomExtensions.iterator((Element)filter);
                while (iterator2.hasNext()) {
                    Attr attribute;
                    Element category = (Element)iterator2.next();
                    if (!Intrinsics.areEqual((Object)category.getTagName(), (Object)"category") || (attribute = category.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)"android.intent.category.LAUNCHER")) continue;
                    return attribute;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

