/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutConsistencyDetector
extends LayoutDetector
implements SourceCodeScanner {
    private final Map<String, List<Pair<File, Map<String, String>>>> mMap = Maps.newHashMapWithExpectedSize((int)64);
    private final Set<String> mRelevantIds = Sets.newLinkedHashSetWithExpectedSize((int)64);
    private Map<String, Map<String, List<Location>>> mLocations;
    private Map<String, Map<String, String>> mErrorMessages;
    public static final Issue INCONSISTENT_IDS = Issue.create((String)"InconsistentLayout", (String)"Inconsistent Layouts", (String)"This check ensures that a layout resource which is defined in multiple resource folders, specifies the same set of widgets.\n\nThis finds cases where you have accidentally forgotten to add a widget to all variations of the layout, which could result in a runtime crash for some resource configurations when a `findViewById()` fails.\n\nThere **are** cases where this is intentional. For example, you may have a dedicated large tablet layout which adds some extra widgets that are not present in the phone version of the layout. As long as the code accessing the layout resource is careful to handle this properly, it is valid. In that case, you can suppress this lint check for the given extra or missing views, or the whole layout", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(LayoutConsistencyDetector.class, Scope.JAVA_AND_RESOURCE_FILES));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    public void visitDocument(XmlContext context, Document document) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root != null) {
            if (context.getPhase() == 1) {
                HashMap fileMap = Maps.newHashMapWithExpectedSize((int)10);
                LayoutConsistencyDetector.addIds(root, fileMap);
                this.getFileMapList(context).add((Pair<File, Map<String, String>>)Pair.of((Object)context.file, (Object)fileMap));
            } else {
                String name = SdkUtils.getLayoutName((File)context.file);
                Map<String, List<Location>> map = this.mLocations.get(name);
                if (map != null) {
                    LayoutConsistencyDetector.lookupLocations(context, root, map);
                }
            }
        }
    }

    private List<Pair<File, Map<String, String>>> getFileMapList(XmlContext context) {
        String name = SdkUtils.getLayoutName((File)context.file);
        ArrayList list = this.mMap.get(name);
        if (list == null) {
            list = Lists.newArrayListWithCapacity((int)4);
            this.mMap.put(name, list);
        }
        return list;
    }

    private static String getId(Element element) {
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id != null && !id.isEmpty() && !id.startsWith("@android:")) {
            return Lint.stripIdPrefix((String)id);
        }
        return null;
    }

    private static void addIds(Element element, Map<String, String> map) {
        String id = LayoutConsistencyDetector.getId(element);
        if (id != null) {
            String s = Lint.stripIdPrefix((String)id);
            map.put(s, element.getTagName());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            LayoutConsistencyDetector.addIds((Element)child, map);
        }
    }

    private static void lookupLocations(XmlContext context, Element element, Map<String, List<Location>> map) {
        String id = LayoutConsistencyDetector.getId(element);
        if (id != null && map.containsKey(id)) {
            if (context.getDriver().isSuppressed(context, INCONSISTENT_IDS, (Node)element)) {
                map.remove(id);
                return;
            }
            ArrayList locations = map.get(id);
            if (locations == null) {
                locations = Lists.newArrayList();
                map.put(id, locations);
            }
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id");
            assert (attr != null);
            Location location = context.getLocation((Node)attr);
            String folder = context.file.getParentFile().getName();
            location.setMessage(String.format("Occurrence in %1$s", folder));
            locations.add(location);
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            LayoutConsistencyDetector.lookupLocations(context, (Element)child, map);
        }
    }

    public void afterCheckRootProject(Context context) {
        LintDriver driver = context.getDriver();
        if (driver.getPhase() == 1) {
            for (Map.Entry<String, List<Pair<File, Map<String, String>>>> entry : this.mMap.entrySet()) {
                String layout = entry.getKey();
                List<Pair<File, Map<String, String>>> files2 = entry.getValue();
                if (files2.size() < 2) continue;
                this.checkConsistentIds(layout, files2);
            }
            if (this.mLocations != null) {
                driver.requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else if (!this.mLocations.isEmpty()) {
            this.reportErrors(context);
        }
    }

    private Set<String> stripIrrelevantIds(Set<String> ids) {
        if (!this.mRelevantIds.isEmpty()) {
            HashSet<String> stripped = new HashSet<String>(ids);
            stripped.retainAll(this.mRelevantIds);
            return stripped;
        }
        return Collections.emptySet();
    }

    private void checkConsistentIds(String layout, List<Pair<File, Map<String, String>>> files2) {
        int layoutCount = files2.size();
        assert (layoutCount >= 2);
        Map<File, Set<String>> idMap = this.getIdMap(files2, layoutCount);
        Set<String> inconsistent = LayoutConsistencyDetector.getInconsistentIds(idMap);
        if (inconsistent.isEmpty()) {
            return;
        }
        if (this.mLocations == null) {
            this.mLocations = Maps.newHashMap();
        }
        if (this.mErrorMessages == null) {
            this.mErrorMessages = Maps.newHashMap();
        }
        int idCount = inconsistent.size();
        HashMap presence = Maps.newHashMapWithExpectedSize((int)idCount);
        HashSet allLayouts = Sets.newHashSetWithExpectedSize((int)layoutCount);
        for (Map.Entry<File, Set<String>> entry : idMap.entrySet()) {
            File file = entry.getKey();
            String folder = file.getParentFile().getName();
            allLayouts.add(folder);
            Set<String> ids = entry.getValue();
            for (String id : ids) {
                List list = (List)presence.get(id);
                if (list == null) {
                    list = Lists.newArrayListWithExpectedSize((int)layoutCount);
                    presence.put(id, list);
                }
                list.add(folder);
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)idCount);
        this.mLocations.put(layout, map);
        HashMap messages = Maps.newHashMapWithExpectedSize((int)idCount);
        this.mErrorMessages.put(layout, messages);
        for (String id : inconsistent) {
            map.put(id, null);
            List layouts = (List)presence.get(id);
            Collections.sort(layouts);
            HashSet missingSet = new HashSet(allLayouts);
            missingSet.removeAll(layouts);
            ArrayList missing = new ArrayList(missingSet);
            Collections.sort(missing);
            String message2 = layouts.size() < layoutCount / 2 ? String.format("The id \"%1$s\" in layout \"%2$s\" is only present in the following layout configurations: %3$s (missing from %4$s)", id, layout, Lint.formatList((List)layouts, (int)Integer.MAX_VALUE), Lint.formatList(missing, (int)Integer.MAX_VALUE)) : String.format("The id \"%1$s\" in layout \"%2$s\" is missing from the following layout configurations: %3$s (present in %4$s)", id, layout, Lint.formatList(missing, (int)Integer.MAX_VALUE), Lint.formatList((List)layouts, (int)Integer.MAX_VALUE));
            messages.put(id, message2);
        }
    }

    private static Set<String> getInconsistentIds(Map<File, Set<String>> idMap) {
        Set<String> union = LayoutConsistencyDetector.getAllIds(idMap);
        HashSet<String> inconsistent = new HashSet<String>();
        for (Map.Entry<File, Set<String>> entry : idMap.entrySet()) {
            Set<String> ids = entry.getValue();
            if (ids.size() >= union.size()) continue;
            HashSet<String> missing = new HashSet<String>(union);
            missing.removeAll(ids);
            inconsistent.addAll(missing);
        }
        return inconsistent;
    }

    private static Set<String> getAllIds(Map<File, Set<String>> idMap) {
        Iterator<Set<String>> iterator = idMap.values().iterator();
        assert (iterator.hasNext());
        HashSet<String> union = new HashSet<String>((Collection)iterator.next());
        while (iterator.hasNext()) {
            union.addAll((Collection<String>)iterator.next());
        }
        return union;
    }

    private Map<File, Set<String>> getIdMap(List<Pair<File, Map<String, String>>> files2, int layoutCount) {
        HashMap<File, Set<String>> idMap = new HashMap<File, Set<String>>(layoutCount);
        for (Pair<File, Map<String, String>> pair : files2) {
            File file = (File)pair.getFirst();
            Map typeMap = (Map)pair.getSecond();
            Set<String> ids = typeMap.keySet();
            idMap.put(file, this.stripIrrelevantIds(ids));
        }
        return idMap;
    }

    private void reportErrors(Context context) {
        ArrayList<String> layouts = new ArrayList<String>(this.mLocations.keySet());
        Collections.sort(layouts);
        for (String layout : layouts) {
            Map<String, List<Location>> locationMap = this.mLocations.get(layout);
            Map<String, String> messageMap = this.mErrorMessages.get(layout);
            assert (locationMap != null);
            assert (messageMap != null);
            ArrayList<String> ids = new ArrayList<String>(locationMap.keySet());
            Collections.sort(ids);
            for (String id : ids) {
                String message2 = messageMap.get(id);
                List<Location> locations = locationMap.get(id);
                if (locations == null) continue;
                Location location = LayoutConsistencyDetector.chainLocations(locations);
                context.report(INCONSISTENT_IDS, location, message2);
            }
        }
    }

    private static Location chainLocations(List<Location> locations) {
        assert (!locations.isEmpty());
        if (locations.size() > 1) {
            locations.sort((location1, location2) -> {
                File file1 = location1.getFile();
                File file2 = location2.getFile();
                String folder1 = file1.getParentFile().getName();
                String folder2 = file2.getParentFile().getName();
                return folder1.compareTo(folder2);
            });
            Iterator<Location> iterator = locations.iterator();
            assert (iterator.hasNext());
            Location prev = iterator.next();
            while (iterator.hasNext()) {
                Location next = iterator.next();
                prev.setSecondary(next);
                prev = next;
            }
        }
        return locations.get(0);
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(JavaContext context, UElement node, ResourceType type, String name, boolean isFramework) {
        if (!isFramework && type == ResourceType.ID) {
            this.mRelevantIds.add(name);
        }
    }
}

