/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.text.Charsets;

public class ApiDatabase {
    protected static final String FILE_HEADER = "API database used by Android lint\u0000";
    protected static final boolean DEBUG_SEARCH = false;
    protected static final boolean WRITE_STATS = false;
    public static final int HAS_EXTRA_BYTE_FLAG = 128;
    public static final int IS_SHORT_FLAG = 64;
    public static final int API_MASK = -129;
    private static final int BINARY_FORMAT_VERSION = 17;
    protected byte[] mData;
    protected int[] mIndices;
    protected int containerCount;
    protected int sdkIndexOffset;
    private static boolean warnedInvalidData = false;

    public static int getBinaryFormatVersion(int majorBinaryFormatVersion) {
        assert ((majorBinaryFormatVersion & 7) == majorBinaryFormatVersion);
        return (majorBinaryFormatVersion << 5) + 17;
    }

    protected void readData(LintClient client, File binaryFile, CacheCreator cacheCreator2, int majorBinaryFormatVersion) {
        if (!binaryFile.exists()) {
            client.log(null, "%1$s does not exist", new Object[]{binaryFile});
            return;
        }
        long start = 0L;
        try {
            byte[] expectedHeader;
            byte[] b = Files.toByteArray((File)binaryFile);
            int offset = 0;
            for (byte anExpectedHeader : expectedHeader = FILE_HEADER.getBytes(Charsets.US_ASCII)) {
                if (anExpectedHeader == b[offset++]) continue;
                client.log(null, "Incorrect file header: not an API database cache file, or a corrupt cache file", new Object[0]);
                return;
            }
            if (b[offset++] != ApiDatabase.getBinaryFormatVersion(majorBinaryFormatVersion)) {
                if (cacheCreator2.create(client, binaryFile)) {
                    this.readData(client, binaryFile, cacheCreator2, majorBinaryFormatVersion);
                }
                return;
            }
            int indexCount = ApiDatabase.get4ByteInt(b, offset);
            this.containerCount = ApiDatabase.get4ByteInt(b, offset += 4);
            this.sdkIndexOffset = ApiDatabase.get4ByteInt(b, offset += 4);
            offset += 4;
            this.mIndices = new int[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                this.mIndices[i] = ApiDatabase.get4ByteInt(b, offset);
                offset += 4;
            }
            this.mData = b;
        }
        catch (Throwable e) {
            client.log(null, "Failure reading binary cache file %1$s", new Object[]{binaryFile.getPath()});
            client.log(null, "Please delete the file and restart the IDE/lint: %1$s", new Object[]{binaryFile.getPath()});
            client.log(e, null, new Object[0]);
        }
    }

    protected static void writeDatabase(LintClient client, File file, Api<? extends ApiClassBase> info, int majorBinaryFormatVersion, File xmlFile) throws IOException {
        Object bytes;
        Map<String, ? extends ApiClassBase> classMap = info.getClasses();
        ArrayList<ApiClassOwner<? extends ApiClassBase>> containers = new ArrayList<ApiClassOwner<? extends ApiClassBase>>(info.getContainers().values());
        Collections.sort(containers);
        int estimatedSize = 0;
        for (ApiClassOwner apiClassOwner : containers) {
            estimatedSize += 4;
            estimatedSize += apiClassOwner.getName().length() + 20;
            for (ApiClassBase cls : apiClassOwner.getClasses()) {
                estimatedSize += 4;
                estimatedSize += cls.getName().length() + 20;
                estimatedSize += cls.computeExtraStorageNeeded(info);
            }
            Collections.sort(apiClassOwner.getClasses());
        }
        estimatedSize += 1920;
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize += 2400);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(FILE_HEADER.getBytes(StandardCharsets.US_ASCII));
        buffer.put((byte)ApiDatabase.getBinaryFormatVersion(majorBinaryFormatVersion));
        int n = buffer.position();
        int indexCount = 0;
        buffer.putInt(0);
        buffer.putInt(containers.size());
        int sdkTableOffsetIndex = buffer.position();
        buffer.putInt(0);
        int newIndex = buffer.position();
        for (ApiClassOwner apiClassOwner : containers) {
            apiClassOwner.indexOffset = newIndex;
            newIndex += 4;
            ++indexCount;
        }
        for (ApiClassOwner apiClassOwner : containers) {
            for (ApiClassBase cls : apiClassOwner.getClasses()) {
                cls.indexOffset = newIndex;
                cls.index = indexCount++;
                newIndex += 4;
            }
        }
        for (ApiClassOwner apiClassOwner : containers) {
            for (ApiClassBase cls : apiClassOwner.getClasses()) {
                if (cls.members != null && !cls.members.isEmpty()) {
                    cls.memberOffsetBegin = newIndex;
                    cls.memberIndexStart = indexCount;
                    for (String ignored : cls.members) {
                        newIndex += 4;
                        ++indexCount;
                    }
                    cls.memberOffsetEnd = newIndex;
                    cls.memberIndexLength = indexCount - cls.memberIndexStart;
                    continue;
                }
                cls.memberOffsetBegin = -1;
                cls.memberOffsetEnd = -1;
                cls.memberIndexStart = -1;
                cls.memberIndexLength = 0;
            }
        }
        buffer.position(n);
        buffer.putInt(indexCount);
        buffer.position(newIndex);
        for (ApiClassOwner apiClassOwner : containers) {
            for (Object apiClass : apiClassOwner.getClasses()) {
                int index2 = ((ApiClassBase)apiClass).memberOffsetBegin;
                List<String> members = ((ApiClassBase)apiClass).members;
                for (int i = 0; i < members.size(); ++i) {
                    String member = members.get(i);
                    int start = buffer.position();
                    buffer.position(index2);
                    if (i == 0 && !((ApiClassBase)apiClass).includeNames) {
                        buffer.putInt(start | Integer.MIN_VALUE);
                    } else {
                        buffer.putInt(start);
                    }
                    index2 = buffer.position();
                    buffer.position(start);
                    ((ApiClassBase)apiClass).writeMemberData(info, member, buffer);
                }
                assert (index2 == ((ApiClassBase)apiClass).memberOffsetEnd) : ((ApiClassBase)apiClass).memberOffsetEnd;
            }
        }
        for (ApiClassOwner apiClassOwner : containers) {
            List classes = apiClassOwner.getClasses();
            for (ApiClassBase cls : classes) {
                int index3 = buffer.position();
                buffer.position(cls.indexOffset);
                buffer.putInt(index3);
                buffer.position(index3);
                String name = cls.getSimpleName();
                int pos = name.lastIndexOf(36);
                if (pos > 0) {
                    name = name.substring(pos + 1);
                }
                byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
                assert (nameBytes.length < 254) : name;
                buffer.put((byte)(nameBytes.length + 2));
                buffer.put(nameBytes);
                buffer.put((byte)0);
                ApiDatabase.put3ByteInt(buffer, cls.memberIndexStart);
                ApiDatabase.put2ByteInt(buffer, cls.memberIndexLength);
                ApiClassBase apiClass = classMap.get(cls.getName());
                assert (apiClass != null) : cls.getName();
                apiClass.writeSuperInterfaces(info, buffer);
            }
        }
        for (ApiClassOwner apiClassOwner : containers) {
            int index4 = buffer.position();
            buffer.position(apiClassOwner.indexOffset);
            buffer.putInt(index4);
            buffer.position(index4);
            bytes = apiClassOwner.getName().getBytes(StandardCharsets.UTF_8);
            buffer.put((byte[])bytes);
            buffer.put(apiClassOwner.isClass() ? (byte)1 : 0);
            List classes = apiClassOwner.getClasses();
            if (classes.isEmpty()) {
                ApiDatabase.put3ByteInt(buffer, 0);
                ApiDatabase.put2ByteInt(buffer, 0);
                continue;
            }
            int firstClassIndex = ((ApiClassBase)classes.get((int)0)).index;
            int classCount = ((ApiClassBase)classes.get((int)(classes.size() - 1))).index - firstClassIndex + 1;
            ApiDatabase.put3ByteInt(buffer, firstClassIndex);
            ApiDatabase.put2ByteInt(buffer, classCount);
        }
        int sdkTableOffset = buffer.position();
        buffer.position(sdkTableOffsetIndex);
        buffer.putInt(sdkTableOffset);
        buffer.position(sdkTableOffset);
        List<String> list = info.getSdks();
        int sdkCount = list.size();
        ApiDatabase.put2ByteInt(buffer, sdkCount);
        bytes = list.iterator();
        while (bytes.hasNext()) {
            String encoded = (String)bytes.next();
            if (encoded.contains(":")) {
                for (String segment : encoded.split(",")) {
                    int colon = segment.indexOf(58);
                    assert (colon != -1) : segment;
                    int sdk = Integer.parseInt(segment.substring(0, colon));
                    int version = Integer.parseInt(segment.substring(colon + 1));
                    if (!ApiConstraint.SdkApiConstraint.isValidApiLevel((int)version)) {
                        if (!warnedInvalidData) {
                            warnedInvalidData = true;
                            String message2 = "Unsupported API level " + version + " in " + encoded + " from " + xmlFile;
                            client.log(null, message2, new Object[0]);
                        }
                        version = 0;
                    }
                    buffer.putInt(sdk);
                    buffer.putInt(version);
                }
                buffer.putInt(-1);
                continue;
            }
            int api2 = Integer.parseInt(encoded);
            buffer.putInt(api2);
            buffer.putInt(-1);
        }
        List<ExtensionSdk> extensionSdks = info.getExtensionSdks();
        buffer.putInt(extensionSdks.size());
        for (ExtensionSdk sdk : extensionSdks) {
            String s = ExtensionSdk.Companion.serialize(sdk);
            byte[] bytes2 = s.getBytes(StandardCharsets.UTF_8);
            buffer.putInt(bytes2.length);
            buffer.put(bytes2);
        }
        int size = buffer.position();
        assert (size <= buffer.limit());
        buffer.mark();
        byte[] b = new byte[size];
        buffer.rewind();
        buffer.get(b);
        if (file.exists()) {
            boolean deleted = file.delete();
            assert (deleted) : file;
        }
        File tmp = new File(file.getPath() + "." + new Random().nextInt());
        Files.asByteSink((File)tmp, (FileWriteMode[])new FileWriteMode[0]).write(b);
        if (!tmp.renameTo(file)) {
            tmp.delete();
        }
    }

    protected static int get4ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset++];
        byte b3 = data[offset++];
        byte b4 = data[offset];
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    protected static void put3ByteInt(ByteBuffer buffer, int value) {
        byte b3 = (byte)(value & 0xFF);
        byte b2 = (byte)((value >>>= 8) & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
        buffer.put(b3);
    }

    protected static void put2ByteInt(ByteBuffer buffer, int value) {
        byte b2 = (byte)(value & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
    }

    protected static int get3ByteInt(byte[] mData, int offset) {
        byte b1 = mData[offset++];
        byte b2 = mData[offset++];
        byte b3 = mData[offset];
        return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    protected static int get2ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset];
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    protected String dumpEntry(int offset) {
        return "<disabled>";
    }

    protected static int compare(byte[] data, int offset, byte terminator, String s, int sOffset, int max) {
        byte b;
        int i = offset;
        for (int j = sOffset; j < max; ++j) {
            byte cb;
            int delta;
            b = data[i];
            char c = s.charAt(j);
            if ((c != '.' || b != 47 && b != 36) && (delta = b - (cb = (byte)c)) != 0) {
                return delta;
            }
            ++i;
        }
        b = data[i];
        if (terminator == 1 && b == 0) {
            return 0;
        }
        return b - terminator;
    }

    protected int findContainer(String packageOrClassName, int containerNameLength, boolean packageOnly) {
        int low = 0;
        int high = this.containerCount;
        while (low < high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            byte terminator = packageOnly ? (byte)0 : 1;
            int c = ApiDatabase.compare(this.mData, offset, terminator, packageOrClassName, 0, containerNameLength);
            if (c == 0) {
                return middle;
            }
            if (c < 0) {
                low = middle + 1;
                continue;
            }
            assert (c > 0);
            high = middle;
        }
        return -1;
    }

    protected int findClass(String className) {
        int lastSeparator = ApiDatabase.lastIndexOfDotOrSlashOrDollar(className);
        int containerNameLength = lastSeparator >= 0 ? lastSeparator : 0;
        int containerNumber = this.findContainer(className, containerNameLength, false);
        if (containerNumber < 0) {
            return -1;
        }
        int classNameLength = className.length();
        int classNameOffset = lastSeparator + 1;
        int curr = this.mIndices[containerNumber];
        while ((this.mData[curr] & 0xFFFFFFFE) != 0) {
            ++curr;
        }
        int low = ApiDatabase.get3ByteInt(this.mData, ++curr);
        int length = ApiDatabase.get2ByteInt(this.mData, curr += 3);
        int high = low + length;
        while (low < high) {
            int c;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if ((c = ApiDatabase.compare(this.mData, ++offset, (byte)0, className, classNameOffset, classNameLength)) == 0) {
                return middle;
            }
            if (c < 0) {
                low = middle + 1;
                continue;
            }
            assert (c > 0);
            high = middle;
        }
        return -1;
    }

    private static int lastIndexOfDotOrSlashOrDollar(String className) {
        int i = className.length();
        while (--i >= 0) {
            char c = className.charAt(i);
            if (c != '.' && c != '/' && c != '$') continue;
            return i;
        }
        return -1;
    }

    @FunctionalInterface
    static interface CacheCreator {
        public boolean create(LintClient var1, File var2);
    }
}

