/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NegativeMarginDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(NegativeMarginDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"NegativeMargin", (String)"Negative Margins", (String)"Margin values should be positive. Negative values are generally a sign that you are making assumptions about views surrounding the current one, or may be tempted to turn off child clipping to allow a view to escape its parent. Turning off child clipping to do this not only leads to poor graphical performance, it also results in wrong touch event handling since touch events are based strictly on a chain of parent-rect hit tests. Finally, making assumptions about the size of strings can lead to localization problems.", (Category)Category.USABILITY, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("layout_margin", "layout_marginLeft", "layout_marginTop", "layout_marginRight", "layout_marginBottom", "layout_marginStart", "layout_marginEnd");
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("style");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String value = attribute.getValue();
        NegativeMarginDetector.checkMarginValue(context, value, attribute);
    }

    public void visitElement(XmlContext context, Element element) {
        if (context.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        NodeList itemNodes = element.getChildNodes();
        int nodeCount = itemNodes.getLength();
        for (int j = 0; j < nodeCount; ++j) {
            Element itemElement;
            String name;
            Node item = itemNodes.item(j);
            if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(name = (itemElement = (Element)item).getAttribute("name")).startsWith("android:") || !name.startsWith("layout_margin", "android:".length())) continue;
            NodeList childNodes = item.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) {
                    return;
                }
                NegativeMarginDetector.checkMarginValue(context, child.getNodeValue(), child);
            }
        }
    }

    private static boolean isNegativeDimension(String value) {
        return value.trim().startsWith("-");
    }

    private static void checkMarginValue(XmlContext context, String value, Node scope) {
        if (NegativeMarginDetector.isNegativeDimension(value)) {
            String message2 = "Margin values should not be negative";
            context.report(ISSUE, scope, context.getLocation(scope), message2);
        } else if (value.startsWith("@dimen/")) {
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null) {
                return;
            }
            LintClient client = context.getClient();
            Project project = context.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
            for (ResourceItem item : items) {
                String dimenValue;
                ResourceValue resourceValue = item.getResourceValue();
                if (resourceValue == null || (dimenValue = resourceValue.getValue()) == null || !NegativeMarginDetector.isNegativeDimension(dimenValue)) continue;
                PathString sourceFile = item.getSource();
                assert (sourceFile != null);
                String message3 = String.format("Margin values should not be negative (`%1$s` is defined as `%2$s` in `%3$s`", value, dimenValue, Lint.getFileNameWithParent((LintClient)client, (PathString)sourceFile));
                context.report(ISSUE, scope, context.getLocation(scope), message3);
                break;
            }
        }
    }
}

