/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequiredAttributeDetector
extends LayoutDetector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"RequiredSize", (String)"Missing `layout_width` or `layout_height` attributes", (String)"All views must specify an explicit `layout_width` and `layout_height` attribute. There is a runtime check for this, so if you fail to specify a size, an exception is thrown at runtime.\n\nIt's possible to specify these widths via styles as well. GridLayout, as a special case, does not require you to specify a size.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)new Implementation(RequiredAttributeDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES))).setEnabledByDefault(LintClient.isStudio());
    public static final String PERCENT_RELATIVE_LAYOUT = "android.support.percent.PercentRelativeLayout";
    public static final String ATTR_LAYOUT_WIDTH_PERCENT = "layout_widthPercent";
    public static final String ATTR_LAYOUT_HEIGHT_PERCENT = "layout_heightPercent";
    private Map<String, String> mStyleParents;
    private Set<String> mWidthStyles;
    private Set<String> mHeightStyles;
    private Set<String> mIncludedWidths;
    private Set<String> mIncludedHeights;
    private Set<String> mNotIncludedWidths;
    private Set<String> mNotIncludedHeights;
    private boolean mSetWidthInTheme;
    private boolean mSetHeightInTheme;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    public void afterCheckRootProject(Context context) {
        if (context.getPhase() == 1) {
            this.checkSizeSetInTheme();
            context.requestRepeat((Detector)this, Scope.RESOURCE_FILE_SCOPE);
        }
    }

    private boolean isWidthStyle(String style) {
        return this.isSizeStyle(style, this.mWidthStyles);
    }

    private boolean isHeightStyle(String style) {
        return this.isSizeStyle(style, this.mHeightStyles);
    }

    private boolean isSizeStyle(String style, Set<String> sizeStyles) {
        if (RequiredAttributeDetector.isFrameworkSizeStyle(style)) {
            return true;
        }
        if (sizeStyles == null) {
            return false;
        }
        return this.isSizeStyle(RequiredAttributeDetector.stripStylePrefix(style), sizeStyles, 0);
    }

    private static boolean isFrameworkSizeStyle(String style) {
        if (style.equals("?android:attr/listSeparatorTextViewStyle") || style.equals("?android/listSeparatorTextViewStyle")) {
            return true;
        }
        return style.startsWith("?android:attr/quickContactBadgeStyle");
    }

    private boolean isSizeStyle(String style, Set<String> sizeStyles, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        if (sizeStyles.contains(style)) {
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isSizeStyle(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), sizeStyles, depth + 1)) {
            return true;
        }
        int index2 = style.lastIndexOf(46);
        if (index2 > 0) {
            return this.isSizeStyle(style.substring(0, index2), sizeStyles, depth + 1);
        }
        return false;
    }

    private void checkSizeSetInTheme() {
        if (this.mStyleParents == null) {
            return;
        }
        HashMap isTheme = Maps.newHashMap();
        for (String style : this.mStyleParents.keySet()) {
            if (!this.isTheme(RequiredAttributeDetector.stripStylePrefix(style), isTheme, 0)) continue;
            this.mSetWidthInTheme = true;
            this.mSetHeightInTheme = true;
            break;
        }
    }

    private boolean isTheme(String style, Map<String, Boolean> isTheme, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        Boolean known = isTheme.get(style);
        if (known != null) {
            return known;
        }
        if (style.contains("Theme")) {
            isTheme.put(style, true);
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isTheme(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), isTheme, depth + 1)) {
            isTheme.put(style, true);
            return true;
        }
        int index2 = style.lastIndexOf(46);
        if (index2 > 0) {
            String parentStyle2 = style.substring(0, index2);
            boolean result = this.isTheme(parentStyle2, isTheme, depth + 1);
            isTheme.put(style, result);
            return result;
        }
        return false;
    }

    @VisibleForTesting
    static boolean hasLayoutVariations(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        File res = parent.getParentFile();
        if (res == null) {
            return false;
        }
        String name = file.getName();
        File[] folders2 = res.listFiles();
        if (folders2 == null) {
            return false;
        }
        for (File folder : folders2) {
            File other;
            if (!folder.getName().startsWith("layout") || folder.equals(parent) || !(other = new File(folder, name)).exists()) continue;
            return true;
        }
        return false;
    }

    private static String stripStylePrefix(String style) {
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        }
        return style;
    }

    private static boolean isRootElement(Node node) {
        return node == node.getOwnerDocument().getDocumentElement();
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public void visitElement(XmlContext context, Element element) {
        ResourceFolderType folderType = context.getResourceFolderType();
        int phase = context.getPhase();
        if (phase == 1 && folderType == ResourceFolderType.VALUES) {
            String tag = element.getTagName();
            if ("style".equals(tag)) {
                String name;
                String parent = element.getAttribute("parent");
                if (parent != null && !parent.isEmpty() && (name = element.getAttribute("name")) != null && !name.isEmpty()) {
                    if (this.mStyleParents == null) {
                        this.mStyleParents = Maps.newHashMap();
                    }
                    this.mStyleParents.put(name, parent);
                }
            } else if ("item".equals(tag) && "style".equals(element.getParentNode().getNodeName())) {
                String styleName;
                String name = element.getAttribute("name");
                if (name.endsWith("layout_width") && name.equals("android:layout_width")) {
                    if (this.mWidthStyles == null) {
                        this.mWidthStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mWidthStyles.add(styleName);
                }
                if (name.endsWith("layout_height") && name.equals("android:layout_height")) {
                    if (this.mHeightStyles == null) {
                        this.mHeightStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mHeightStyles.add(styleName);
                }
            }
        } else if (folderType == ResourceFolderType.LAYOUT) {
            if (phase == 1) {
                String layout;
                if (element.getTagName().equals("include") && (layout = element.getAttribute("layout")) != null && !layout.isEmpty()) {
                    this.recordIncludeWidth(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width"));
                    this.recordIncludeHeight(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height"));
                }
            } else {
                String message2;
                String parentTag;
                assert (phase == 2);
                boolean hasWidth = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                boolean hasHeight = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
                if (this.mSetWidthInTheme) {
                    hasWidth = true;
                }
                if (this.mSetHeightInTheme) {
                    hasHeight = true;
                }
                if (hasWidth && hasHeight) {
                    return;
                }
                String tag = element.getTagName();
                if ("merge".equals(tag) || "include".equals(tag)) {
                    return;
                }
                if (Lint.isLayoutMarkerTag((Element)element)) {
                    return;
                }
                String string = parentTag = element.getParentNode() != null ? element.getParentNode().getNodeName() : "";
                if ("TableLayout".equals(parentTag) || "TableRow".equals(parentTag) || "GridLayout".equals(parentTag) || AndroidXConstants.FQCN_GRID_LAYOUT_V7.isEquals(parentTag)) {
                    return;
                }
                boolean isPercent = parentTag.startsWith("android.support.percent.Percent");
                if (isPercent && (hasWidth |= element.hasAttributeNS("http://schemas.android.com/apk/res-auto", ATTR_LAYOUT_WIDTH_PERCENT)) && (hasHeight |= element.hasAttributeNS("http://schemas.android.com/apk/res-auto", ATTR_LAYOUT_HEIGHT_PERCENT))) {
                    return;
                }
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                boolean certain = true;
                boolean isRoot = RequiredAttributeDetector.isRootElement(element);
                if (isRoot || RequiredAttributeDetector.isRootElement(element.getParentNode()) && "merge".equals(parentTag)) {
                    String name = "@layout/" + Lint.getLayoutName((File)context.file);
                    if (!hasWidth && this.mIncludedWidths != null) {
                        hasWidth = this.mIncludedWidths.contains(name);
                        if (this.mNotIncludedWidths != null && this.mNotIncludedWidths.contains(name)) {
                            hasWidth = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (!hasHeight && this.mIncludedHeights != null) {
                        hasHeight = this.mIncludedHeights.contains(name);
                        if (this.mNotIncludedHeights != null && this.mNotIncludedHeights.contains(name)) {
                            hasHeight = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth || !hasHeight) {
                    String style = element.getAttribute("style");
                    if (style != null && !style.isEmpty()) {
                        if (!hasWidth) {
                            hasWidth = this.isWidthStyle(style);
                        }
                        if (!hasHeight) {
                            hasHeight = this.isHeightStyle(style);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth && !hasHeight) {
                    message2 = certain ? "The required `layout_width` and `layout_height` attributes are missing" : "The required `layout_width` and `layout_height` attributes *may* be missing";
                } else {
                    String attribute = hasWidth ? "layout_height" : "layout_width";
                    message2 = certain ? String.format("The required `%1$s` attribute is missing", attribute) : String.format("The required `%1$s` attribute *may* be missing", attribute);
                }
                if (isPercent) {
                    String escapedLayoutWidth = "`layout_width`";
                    String escapedLayoutHeight = "`layout_height`";
                    String escapedLayoutWidthPercent = "`layout_widthPercent`";
                    String escapedLayoutHeightPercent = "`layout_heightPercent`";
                    message2 = message2.replace(escapedLayoutWidth, escapedLayoutWidth + " or " + escapedLayoutWidthPercent).replace(escapedLayoutHeight, escapedLayoutHeight + " or " + escapedLayoutHeightPercent);
                }
                context.report(ISSUE, (Node)element, context.getElementLocation(element), message2);
            }
        }
    }

    private void recordIncludeWidth(String layout, boolean providesWidth) {
        if (providesWidth) {
            if (this.mIncludedWidths == null) {
                this.mIncludedWidths = Sets.newHashSet();
            }
            this.mIncludedWidths.add(layout);
        } else {
            if (this.mNotIncludedWidths == null) {
                this.mNotIncludedWidths = Sets.newHashSet();
            }
            this.mNotIncludedWidths.add(layout);
        }
    }

    private void recordIncludeHeight(String layout, boolean providesHeight) {
        if (providesHeight) {
            if (this.mIncludedHeights == null) {
                this.mIncludedHeights = Sets.newHashSet();
            }
            this.mIncludedHeights.add(layout);
        } else {
            if (this.mNotIncludedHeights == null) {
                this.mNotIncludedHeights = Sets.newHashSet();
            }
            this.mNotIncludedHeights.add(layout);
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("inflate");
    }

    public void visitMethodCall(JavaContext context, UCallExpression call, PsiMethod method) {
        UExpression viewRoot;
        List args = call.getValueArguments();
        String layout = null;
        int index2 = 0;
        ResourceEvaluator evaluator = new ResourceEvaluator(context.getEvaluator());
        for (UExpression expression : args) {
            ResourceUrl url = evaluator.getResource((UElement)expression);
            if (url != null && url.type == ResourceType.LAYOUT) {
                layout = url.toString();
                break;
            }
            ++index2;
        }
        if (layout == null) {
            return;
        }
        int viewRootPos = index2 + 1;
        if (viewRootPos < args.size() && UastLiteralUtils.isNullLiteral((UElement)(viewRoot = (UExpression)args.get(viewRootPos)))) {
            this.recordIncludeWidth(layout, true);
            this.recordIncludeHeight(layout, true);
        }
    }
}

