/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/MissingPrefixDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "", "isCustomView", "element", "Lorg/w3c/dom/Element;", "isFragment", "isNoPrefixAttribute", "attribute", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class MissingPrefixDetector
extends LayoutDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue MISSING_NAMESPACE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.INTERPOLATOR;
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoPrefixAttribute(String attribute) {
        String string = attribute;
        switch (string.hashCode()) {
            case -1109722326: {
                if (string.equals("layout")) return true;
                return false;
            }
            case -807062458: {
                if (string.equals("package")) return true;
                return false;
            }
            case 109648666: {
                if (string.equals("split")) return true;
                return false;
            }
            case 109780401: {
                if (string.equals("style")) return true;
                return false;
            }
            case 954743298: {
                if (string.equals("coreApp")) return true;
                return false;
            }
            case 94742904: {
                if (!string.equals("class")) return false;
                return true;
            }
        }
        return false;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String uri = attribute.getNamespaceURI();
        if (uri == null || ((CharSequence)uri).length() == 0) {
            Element root;
            String string = attribute.getName();
            if (string == null) {
                return;
            }
            String name = string;
            if (this.isNoPrefixAttribute(name)) {
                return;
            }
            Element element = attribute.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            if (this.isCustomView(element) && context.getResourceFolderType() != null) {
                return;
            }
            if (context.getResourceFolderType() == ResourceFolderType.LAYOUT && Intrinsics.areEqual((Object)"layout", (Object)(root = element.getOwnerDocument().getDocumentElement()).getTagName())) {
                return;
            }
            if (StringsKt.indexOf$default((CharSequence)name, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            String elementNamespace = element.getNamespaceURI();
            if (elementNamespace != null && ((CharSequence)elementNamespace).length() > 0) {
                return;
            }
            XmlContext.report$default((XmlContext)context, (Issue)MISSING_NAMESPACE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)"Attribute is missing the Android namespace prefix", null, (int)16, null);
        } else if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)uri) && !Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)uri) && context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            Element element = attribute.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attribute.ownerElement");
            if (!this.isCustomView(element)) {
                Element element2 = attribute.getOwnerElement();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"attribute.ownerElement");
                if (!this.isFragment(element2)) {
                    String string = attribute.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.localName");
                    if (!StringsKt.startsWith$default((String)string, (String)"layout_", (boolean)false, (int)2, null) && attribute.getOwnerElement().getParentNode().getNodeType() == 1) {
                        String prefix = attribute.getPrefix();
                        if (Intrinsics.areEqual((Object)"xmlns", (Object)prefix)) {
                            String name = attribute.getNodeName();
                            Element root = attribute.getOwnerDocument().getDocumentElement();
                            NamedNodeMap attributes = root.getAttributes();
                            int n = attributes.getLength();
                            for (int i = 0; i < n; ++i) {
                                Node item = attributes.item(i);
                                if (!Intrinsics.areEqual((Object)name, (Object)item.getNodeName()) || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)item.getNodeValue())) continue;
                                Node node = attribute;
                                Location location = context.getLocation((Node)attribute);
                                String string2 = "Unused namespace declaration %1$s; already declared on the root element";
                                Object[] objectArray = new Object[]{name};
                                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                                XmlContext.report$default((XmlContext)context, (Issue)NamespaceDetector.UNUSED, (Node)node, (Location)location, (String)string3, null, (int)16, null);
                            }
                            return;
                        }
                        if (context.getResourceFolderType() == ResourceFolderType.LAYOUT && Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)uri)) {
                            Element root = attribute.getOwnerDocument().getDocumentElement();
                            if (Intrinsics.areEqual((Object)"layout", (Object)root.getTagName())) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"srcCompat") || Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"fontFamily")) {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    private final boolean isFragment(Element element) {
        return Intrinsics.areEqual((Object)"fragment", (Object)element.getTagName());
    }

    private final boolean isCustomView(Element element) {
        String tag = element.getTagName();
        if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
            return true;
        }
        if (AndroidXConstants.CONSTRAINT_LAYOUT.isEquals(tag) || AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEquals(tag)) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        return StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1 && (!StringsKt.startsWith$default((String)tag, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"android.support.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"androidx.", (boolean)false, (int)2, null));
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE};
        MISSING_NAMESPACE = Issue.Companion.create("MissingPrefix", "Missing Android XML namespace", "\n            Most Android views have attributes in the Android namespace. When referencing these attributes \\\n            you **must** include the namespace prefix, or your attribute will be interpreted by `aapt` as \\\n            just a custom attribute.\n\n            Similarly, in manifest files, nearly all attributes should be in the `android:` namespace.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(MissingPrefixDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/MissingPrefixDetector$Issues;", "", "()V", "MISSING_NAMESPACE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

