/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlockedDependencies;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u0099\u00012\u00020\u00012\u00020\u0002:\b\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u0010(\u001a\u0002002\u0006\u00101\u001a\u00020\u0010H\u0002J\u0018\u00102\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u00020\nH\u0002J,\u00104\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u00010\u00102\u0006\u00106\u001a\u00020.2\b\u00107\u001a\u0004\u0018\u00010.H\u0002J\u001a\u00108\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u00109\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010:\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u00010\u00102\b\u0010;\u001a\u0004\u0018\u00010\u0010H\u0002J0\u0010<\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010/\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0002J \u0010?\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u0002002\u0006\u00101\u001a\u00020\u0010H\u0002JJ\u0010@\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020.2\b\u0010D\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0016J0\u0010F\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00106\u001a\u00020.2\u0006\u0010G\u001a\u00020.2\u0006\u0010H\u001a\u00020I2\u0006\u00105\u001a\u00020\u0010H\u0002J \u0010J\u001a\u00020\u00192\u0006\u0010(\u001a\u0002002\u0006\u0010/\u001a\u00020=2\u0006\u00105\u001a\u00020\u0010H\u0002J \u0010K\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010B\u001a\u00020.2\u0006\u00105\u001a\u00020\u0010H\u0002J\u0010\u0010L\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010M\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016JV\u0010N\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010O\u001a\u00020.2\b\u0010C\u001a\u0004\u0018\u00010.2\b\u0010D\u001a\u0004\u0018\u00010.2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020.0S2\u0006\u00105\u001a\u00020\u0010H\u0016J \u0010T\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u0010H\u0002J \u0010U\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010B\u001a\u00020.2\u0006\u00105\u001a\u00020\u0010H\u0002J8\u0010V\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010/\u001a\u00020=2\u0006\u0010H\u001a\u00020I2\u0006\u0010W\u001a\u00020.2\u0006\u00105\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0002J2\u0010X\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010/\u001a\u00020=2\u0006\u0010H\u001a\u00020I2\b\u0010Y\u001a\u0004\u0018\u00010I2\u0006\u00105\u001a\u00020\u0010H\u0002J\u0010\u0010Z\u001a\u00020'2\u0006\u0010(\u001a\u000200H\u0002J:\u0010[\u001a\u00020'2\u0006\u0010(\u001a\u0002002\b\u0010H\u001a\u0004\u0018\u00010I2\u0006\u00105\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000eH\u0002J \u0010_\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0016J\"\u0010d\u001a\u0004\u0018\u00010I2\u0006\u0010/\u001a\u00020=2\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010fH\u0002J\u0016\u0010g\u001a\u00020h2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020h0jH\u0002J\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020l0S2\u0006\u00103\u001a\u00020\nH\u0002J\b\u0010m\u001a\u00020\u0007H\u0004J\u0016\u0010n\u001a\u00020.2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020p0SH\u0002J*\u0010q\u001a\u0004\u0018\u00010I2\u0006\u0010(\u001a\u0002002\u0006\u0010/\u001a\u00020=2\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010fH\u0002J\u000e\u0010r\u001a\u00020\u00122\u0006\u0010s\u001a\u00020tJ\u0010\u0010u\u001a\u00020\u00142\u0006\u0010s\u001a\u00020tH\u0002J\u001a\u0010v\u001a\u0004\u0018\u00010I2\u0006\u0010w\u001a\u00020I2\u0006\u0010x\u001a\u00020IH\u0002J\"\u0010v\u001a\u0004\u0018\u00010I2\u0006\u0010w\u001a\u00020I2\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020\u000eH\u0002J*\u0010v\u001a\u0004\u0018\u00010I2\u0006\u0010w\u001a\u00020I2\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000eH\u0002J\"\u0010y\u001a\u00020.2\u0006\u0010/\u001a\u00020=2\u0006\u0010H\u001a\u00020.2\b\u0010z\u001a\u0004\u0018\u00010IH\u0002J\u0010\u0010{\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020.H\u0002J0\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020.2\u0006\u0010\u007f\u001a\u00020.2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u00192\u000b\b\u0002\u0010\u0081\u0001\u001a\u0004\u0018\u00010IH\u0002J1\u0010\u0082\u0001\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010f2\u0006\u0010(\u001a\u0002002\u0006\u00106\u001a\u00020.2\u0006\u0010G\u001a\u00020.2\u0006\u0010W\u001a\u00020.H\u0002J\u0019\u0010\u0083\u0001\u001a\u00020\u00192\u0006\u00106\u001a\u00020.2\u0006\u0010G\u001a\u00020.H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u0011\u0010\u0085\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002JR\u0010\u0086\u0001\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u00020\u00102\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020.2\u000b\b\u0002\u0010\u008a\u0001\u001a\u0004\u0018\u00010}2\t\b\u0002\u0010\u008b\u0001\u001a\u00020\u00192\f\b\u0002\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001H\u0002J$\u0010\u008e\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0089\u0001\u001a\u00020.H\u0002J\"\u0010\u008e\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u00020\u00102\u0007\u0010\u0089\u0001\u001a\u00020.H\u0002J-\u0010\u008e\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u00020\u00102\u0007\u0010\u0089\u0001\u001a\u00020.2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010}H\u0002J$\u0010\u0091\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0089\u0001\u001a\u00020.H\u0002J/\u0010\u0091\u0001\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u00020\u00102\u0007\u0010\u0089\u0001\u001a\u00020.2\u000b\b\u0002\u0010\u0092\u0001\u001a\u0004\u0018\u00010}H\u0002J$\u0010\u0093\u0001\u001a\u0004\u0018\u00010=2\u0006\u0010(\u001a\u0002002\u0006\u0010A\u001a\u00020.2\u0007\u0010\u0094\u0001\u001a\u00020=H\u0002J\u0011\u0010\u0095\u0001\u001a\u00020\u00192\u0006\u00103\u001a\u00020\nH\u0002J\r\u0010\u0096\u0001\u001a\u00020\u0019*\u00020hH\u0002J\r\u0010\u0097\u0001\u001a\u00020\u0019*\u00020hH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "agpVersionCheckInfo", "Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "artifactCacheHome", "Ljava/io/File;", "blockedDependencies", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlockedDependencies;", "Lkotlin/collections/HashMap;", "compileSdkVersion", "", "compileSdkVersionCookie", "", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "googlePlaySdkIndex", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "gradleUserHome", "getGradleUserHome", "()Ljava/io/File;", "mAppliedJavaPlugin", "", "mAppliedKotlinAndroidPlugin", "mAppliedKotlinKaptPlugin", "mCheckedGms", "mCheckedSupportLibs", "mCheckedWearableLibs", "mDeclaredGoogleMavenRepository", "mDeclaredSourceCompatibility", "mDeclaredTargetCompatibility", "mJavaPluginInfo", "Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "minSdkVersion", "targetSdkVersion", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckRootProject", "beforeCheckRootProject", "checkAnnotationProcessorOnCompilePath", "configuration", "", "dependency", "Lcom/android/tools/lint/detector/api/GradleContext;", "propertyCookie", "checkBlockedDependencies", "project", "checkConsistentLibraries", "cookie", "groupId", "groupId2", "checkConsistentPlayServices", "checkConsistentSupportLibraries", "checkConsistentWearableLibraries", "statementCookie", "checkDependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "checkDeprecatedConfigurations", "checkDslPropertyAssignment", "property", "value", "parent", "parentParent", "valueCookie", "checkForKtxExtension", "artifactId", "version", "Lcom/android/ide/common/repository/GradleVersion;", "checkGradlePluginDependency", "checkIntegerAsString", "checkLibraryConsistency", "checkMergedProject", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkMinSdkVersion", "checkOctal", "checkPlayServices", "revision", "checkSupportLibraries", "newerVersion", "checkTargetCompatibility", "ensureTargetCompatibleWithO", "major", "minor", "micro", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findCachedNewerVersion", "filter", "Ljava/util/function/Predicate;", "findFirst", "Lcom/android/tools/lint/model/LintModelMavenName;", "coordinates", "", "getAllLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "getArtifactCacheHome", "getBlockedDependencyMessage", "path", "Lcom/android/tools/lint/model/LintModelDependency;", "getGoogleMavenRepoVersion", "getGoogleMavenRepository", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGooglePlaySdkIndex", "getNewerVersion", "version1", "version2", "getNewerVersionAvailableMessage", "stable", "getSdkVersion", "getUpdateDependencyFix", "Lcom/android/tools/lint/detector/api/LintFix;", "currentVersion", "suggestedVersion", "suggestedVersionIsSafe", "safeReplacement", "getUpgradeVersionFilter", "isSupportLibraryDependentOnCompileSdk", "isWearApp", "maybeReportAgpVersionIssue", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "partial", "overrideSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "reportNonFatalCompatibilityIssue", "lintFix", "resolveCoordinate", "gc", "usesLegacyHttpLibrary", "isAndroidxArtifact", "isSupportLibArtifact", "AgpVersionCheckInfo", "Companion", "DeprecatedConfiguration", "JavaPluginInfo", "lint-checks"})
public class GradleDetector
extends Detector
implements GradleScanner {
    @NotNull
    public static final Companion Companion;
    private int minSdkVersion;
    private int compileSdkVersion;
    @Nullable
    private Object compileSdkVersionCookie;
    private int targetSdkVersion;
    @Nullable
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedSupportLibs;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private boolean mAppliedJavaPlugin;
    @Nullable
    private JavaPluginInfo mJavaPluginInfo;
    private boolean mDeclaredSourceCompatibility;
    private boolean mDeclaredTargetCompatibility;
    private boolean mDeclaredGoogleMavenRepository;
    @Nullable
    private AgpVersionCheckInfo agpVersionCheckInfo;
    @NotNull
    private final HashMap<Project, BlockedDependencies> blockedDependencies = new HashMap();
    @Nullable
    private GoogleMavenRepository googleMavenRepository;
    @Nullable
    private GooglePlaySdkIndex googlePlaySdkIndex;
    @Nullable
    private static Calendar calendar;
    @NotNull
    public static final String KEY_COORDINATE = "coordinate";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue AGP_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    private static final int MINIMUM_TARGET_SDK_VERSION;
    private static final int PREVIOUS_MINIMUM_TARGET_SDK_VERSION;
    private static final int MINIMUM_TARGET_SDK_VERSION_YEAR;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
    @JvmField
    @NotNull
    public static final Issue KTX_EXTENSION_AVAILABLE;
    @JvmField
    @NotNull
    public static final Issue JAVA_PLUGIN_LANGUAGE_LEVEL;
    @JvmField
    @NotNull
    public static final Issue JCENTER_REPOSITORY_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_NON_COMPLIANT;
    @NotNull
    private static final List<String> JAVA_PLUGIN_IDS;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    @NotNull
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    @NotNull
    private static final GradleCoordinate PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    private static int majorBuildTools;
    @Nullable
    private static GradleVersion latestBuildTools;
    @NotNull
    private static final Set<String> commonAnnotationProcessors;
    @NotNull
    private static Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> playSdkIndexFactory;

    @NotNull
    protected File getGradleUserHome() {
        Object gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File((String)gradleUserHome);
    }

    private final void checkOctal(GradleContext context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || Intrinsics.compare((int)value.charAt(1), (int)56) >= 0 && GradleContext.Companion.isNonNegativeInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            Object object;
            String string;
            Object message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            String string2 = message2;
            try {
                string = string2;
                Long numericValue = Long.decode(value);
                object = " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException numberFormatException) {
                string = string2;
                object = " (and it is not a valid octal number)";
            }
            message2 = string + (String)object;
            GradleDetector.report$default(this, (Context)context, cookie, ACCIDENTAL_OCTAL, (String)message2, null, false, null, 112, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        block76: {
            block75: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
                Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
                Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
                if (!Intrinsics.areEqual((Object)parent, (Object)"defaultConfig")) break block75;
                switch (property.hashCode()) {
                    case -1312692432: {
                        if (property.equals("minSdkVersion")) break;
                        ** break;
                    }
                    case -1074060152: {
                        if (property.equals("minSdk")) break;
                        ** break;
                    }
                    case -815588119: {
                        if (!property.equals("targetSdk")) {
                            ** break;
                        }
                        ** GOTO lbl22
                    }
                    case 1346695087: {
                        if (!property.equals("targetSdkVersion")) ** break;
lbl22:
                        // 2 sources

                        if ((version = this.getSdkVersion(value)) > 0 && version < context.getClient().getHighestKnownApiLevel()) {
                            warned = false;
                            if (version < GradleDetector.MINIMUM_TARGET_SDK_VERSION) {
                                v0 = GradleDetector.calendar;
                                if (v0 == null) {
                                    v0 = Calendar.getInstance();
                                }
                                now = v0;
                                year = now.get(1);
                                month = now.get(2);
                                required = 0;
                                issue = null;
                                if (year > GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR || year == GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR && month >= 10) {
                                    required = GradleDetector.MINIMUM_TARGET_SDK_VERSION;
                                    issue = GradleDetector.EXPIRED_TARGET_SDK_VERSION;
                                } else if (version < GradleDetector.PREVIOUS_MINIMUM_TARGET_SDK_VERSION && year >= GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR - 1) {
                                    required = GradleDetector.PREVIOUS_MINIMUM_TARGET_SDK_VERSION;
                                    issue = GradleDetector.EXPIRED_TARGET_SDK_VERSION;
                                } else if (year == GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR && month >= 4) {
                                    required = GradleDetector.MINIMUM_TARGET_SDK_VERSION;
                                    issue = GradleDetector.EXPIRING_TARGET_SDK_VERSION;
                                } else {
                                    required = -1;
                                    issue = IssueRegistry.LINT_ERROR;
                                }
                                if (required != -1) {
                                    message = Intrinsics.areEqual((Object)issue, (Object)GradleDetector.EXPIRED_TARGET_SDK_VERSION) != false ? "Google Play requires that apps target API level " + required + " or higher.\n" : "Google Play will soon require that apps target API level 31 or higher. This will be required for new apps in August " + GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR + ", and for updates to existing apps in November " + GradleDetector.MINIMUM_TARGET_SDK_VERSION_YEAR + ".";
                                    highest = context.getClient().getHighestKnownApiLevel();
                                    label = "Update " + property + " to " + highest;
                                    fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                                    v1 = alreadySuppressed = Intrinsics.areEqual((Object)issue, (Object)GradleDetector.EXPIRING_TARGET_SDK_VERSION) == false && context.containsCommentSuppress() != false && context.isSuppressedWithComment(statementCookie, issue) != false;
                                    if (!alreadySuppressed) {
                                        GradleDetector.report$default(this, (Context)context, statementCookie, issue, message, fix, true, null, 64, null);
                                    }
                                    warned = true;
                                }
                            }
                            if (!warned) {
                                message = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                                highest = context.getClient().getHighestKnownApiLevel();
                                label = "Update targetSdkVersion to " + highest;
                                fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                                GradleDetector.report$default(this, (Context)context, statementCookie, ManifestDetector.TARGET_NEWER, message, fix, false, null, 96, null);
                            }
                        }
                        if (version > 0) {
                            this.targetSdkVersion = version;
                            this.checkTargetCompatibility(context);
                            ** break;
                        }
                        this.checkIntegerAsString(context, value, statementCookie);
                        ** break;
                    }
                }
                if ((version = this.getSdkVersion(value)) > 0) {
                    this.minSdkVersion = version;
                    this.checkMinSdkVersion(context, version, statementCookie);
                    ** break;
                }
                this.checkIntegerAsString(context, value, statementCookie);
lbl75:
                // 9 sources

                if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                    this.checkOctal(context, value, valueCookie);
                }
                if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                    if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                        message = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                        GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.GRADLE_GETTER, message, null, false, null, 112, null);
                    }
                } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                    message = "Deprecated: Replace 'packageName' with 'applicationId'";
                    fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                    GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, 96, null);
                }
                if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context.isEnabled(GradleDetector.HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                    message = "The 'versionCode' is very high and close to the max allowed value";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.HIGH_APP_VERSION_CODE, message, null, false, null, 112, null);
                }
                break block76;
            }
            if ((Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") || Intrinsics.areEqual((Object)property, (Object)"compileSdk")) && Intrinsics.areEqual((Object)parent, (Object)"android")) {
                version = -1;
                if (GradleContext.Companion.isStringLiteral(value)) {
                    hash = GradleContext.Companion.getStringLiteralValue(value);
                    if (hash != null && !Lint.isNumberString((String)hash)) {
                        if (Intrinsics.areEqual((Object)property, (Object)"compileSdk")) {
                            message = "`compileSdk` does not support strings; did you mean `compileSdkPreview` ?";
                            fix = this.fix().replace().text("compileSdk").with("compileSdkPreview").build();
                            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.STRING_INTEGER, message, fix, false, null, 96, null);
                        }
                        if ((platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                            version = platformVersion.getFeatureLevel();
                        }
                    }
                } else {
                    version = GradleContext.Companion.getIntLiteralValue(value, -1);
                }
                if (version > 0) {
                    this.compileSdkVersion = version;
                    this.compileSdkVersionCookie = statementCookie;
                    this.checkTargetCompatibility(context);
                } else {
                    this.checkIntegerAsString(context, value, statementCookie);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"buildToolsVersion") && Intrinsics.areEqual((Object)parent, (Object)"android")) {
                versionString = GradleContext.Companion.getStringLiteralValue(value);
                if (versionString != null && (version = GradleVersion.tryParse((String)versionString)) != null) {
                    recommended = com.android.tools.lint.checks.GradleDetector$Companion.access$getLatestBuildTools(GradleDetector.Companion, context.getClient(), version.getMajor());
                    if (version.getMajor() == 23 && version.getMinor() == 0 && version.getMicro() == 0 && context.isEnabled(GradleDetector.COMPATIBILITY)) {
                        if (recommended == null || recommended.getMajor() < 23) {
                            recommended = new GradleVersion(23, 0, 3);
                        }
                        message = "Build Tools `23.0.0` should not be used; it has some known serious bugs. Use version `" + recommended + "` instead.";
                        this.reportFatalCompatibilityIssue((Context)context, statementCookie, message);
                    }
                }
            } else if (Intrinsics.areEqual((Object)parent, (Object)"plugins")) {
                if (Intrinsics.areEqual((Object)property, (Object)"id")) {
                    plugin = GradleContext.Companion.getStringLiteralValue(value);
                    isOldAppPlugin = Intrinsics.areEqual((Object)"android", (Object)plugin);
                    if (isOldAppPlugin || Intrinsics.areEqual((Object)"android-library", (Object)plugin)) {
                        replaceWith = isOldAppPlugin != false ? "com.android.application" : "com.android.library";
                        message = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                        fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.DEPRECATED, message, fix, false, null, 96, null);
                    }
                    if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                        this.mAppliedKotlinAndroidPlugin = true;
                    }
                    if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                        this.mAppliedKotlinKaptPlugin = true;
                    }
                    if (CollectionsKt.contains((Iterable)GradleDetector.JAVA_PLUGIN_IDS, (Object)plugin)) {
                        this.mAppliedJavaPlugin = true;
                        this.mJavaPluginInfo = new JavaPluginInfo(statementCookie);
                    }
                }
            } else if (Intrinsics.areEqual((Object)parent, (Object)"dependencies")) {
                if (StringsKt.startsWith$default((String)value, (String)"files('", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"')", (boolean)false, (int)2, null)) {
                    v2 = value.substring("files('".length(), value.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    path = v2;
                    if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                        fix = this.fix().replace().text(path).with(StringsKt.replace$default((String)path, (String)"\\\\", (String)"/", (boolean)false, (int)4, null)).build();
                        message = "Do not use Windows file separators in .gradle files; use / instead";
                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, fix, false, null, 96, null);
                    } else if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                        message = "Avoid using absolute paths in .gradle files";
                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, null, false, null, 112, null);
                    }
                } else {
                    dependency = GradleContext.Companion.getStringLiteralValue(value);
                    if (dependency == null) {
                        dependency = GradleDetector.Companion.getNamedDependency(value);
                    }
                    if (dependency != null) {
                        gc = new Ref.ObjectRef();
                        gc.element = GradleCoordinate.parseCoordinateString((String)dependency);
                        isResolved = new Ref.BooleanRef();
                        if (gc.element != null && StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                            if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context.isEnabled(GradleDetector.NOT_INTERPOLATED)) {
                                message = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                                v3 = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                                v4 = value.substring(1, value.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                fix = v3.with("\"" + v4 + "\"").build();
                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.NOT_INTERPOLATED, (String)message, fix, false, null, 96, null);
                            }
                            v5 = gc.element;
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"gc");
                            gc.element = this.resolveCoordinate(context, property, (GradleCoordinate)v5);
                            isResolved.element = true;
                        }
                        if (gc.element != null) {
                            if (((GradleCoordinate)gc.element).acceptsGreaterRevisions()) {
                                message = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ")";
                                v6 = this.fix();
                                var14_49 = new Object[2];
                                var14_49[0] = "coordinate";
                                Intrinsics.checkNotNullExpressionValue((Object)((GradleCoordinate)gc.element).toString(), (String)"gc.toString()");
                                fix = v6.data(var14_49);
                                GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PLUS, (String)message, fix, false, null, 96, null);
                            }
                            context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, (Ref.ObjectRef<GradleCoordinate>)gc, isResolved, valueCookie, statementCookie){
                                final /* synthetic */ GradleDetector this$0;
                                final /* synthetic */ GradleContext $context;
                                final /* synthetic */ Ref.ObjectRef<GradleCoordinate> $gc;
                                final /* synthetic */ Ref.BooleanRef $isResolved;
                                final /* synthetic */ Object $valueCookie;
                                final /* synthetic */ Object $statementCookie;
                                {
                                    this.this$0 = $receiver;
                                    this.$context = $context;
                                    this.$gc = $gc;
                                    this.$isResolved = $isResolved;
                                    this.$valueCookie = $valueCookie;
                                    this.$statementCookie = $statementCookie;
                                }

                                public final void run() {
                                    Object object = this.$gc.element;
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gc");
                                    GradleDetector.access$checkDependency(this.this$0, this.$context, (GradleCoordinate)object, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                                }
                            });
                        }
                        if (com.android.tools.lint.checks.GradleDetector$Companion.access$hasLifecycleAnnotationProcessor(GradleDetector.Companion, dependency) && com.android.tools.lint.checks.GradleDetector$Companion.access$targetJava8Plus(GradleDetector.Companion, context.getProject())) {
                            GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common` library instead of Lifecycle annotations for faster incremental build.", null, false, null, 96, null);
                        }
                        this.checkAnnotationProcessorOnCompilePath(property, dependency, context, propertyCookie);
                    }
                    this.checkDeprecatedConfigurations(property, context, propertyCookie);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
                message = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
                fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
                GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, 96, null);
            } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
                suffix = GradleContext.Companion.getStringLiteralValue(value);
                if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                    message = "Application ID suffix should probably start with a \".\"";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.PATH, message, null, false, null, 112, null);
                }
            } else if ((Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") || Intrinsics.areEqual((Object)property, (Object)"minSdk")) && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && !Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName())) {
                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, false, null, 112, null);
            } else if (Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && (Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) || Intrinsics.areEqual((Object)parent, (Object)"buildFeatures") && Intrinsics.areEqual((Object)property, (Object)"dataBinding")) {
                if (Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
                    message = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DATA_BINDING_WITHOUT_KAPT, message, null, false, null, 96, null);
                }
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"sourceCompatibility")) {
                this.mDeclaredSourceCompatibility = true;
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"targetCompatibility")) {
                this.mDeclaredTargetCompatibility = true;
            }
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context, Object propertyCookie) {
        GradleVersion gradleVersion = context.getProject().getGradleModelVersion();
        boolean bl = gradleVersion != null ? !gradleVersion.isAtLeastIncludingPreviews(3, 0, 0) : false;
        if (bl) {
            return;
        }
        for (DeprecatedConfiguration deprecatedConfiguration : DeprecatedConfiguration.values()) {
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context.getProject(), configuration)) {
                Object implementation = null;
                Object api = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = prefix + "Implementation";
                    api = prefix + "Api";
                }
                String message2 = "`" + configuration + "` is deprecated; replace with either `" + (String)api + "` to maintain current behavior, or `" + (String)implementation + "` to improve build performance by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + (String)api + "'").family("Replace compile with api").replace().text(configuration).with((String)api).autoFix().build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + (String)implementation + "'").family("Replace compile with implementation").replace().text(configuration).with((String)implementation).autoFix().build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + (String)api + "' or '" + (String)implementation + "'").add(apiFix).add(implementationFix).build();
                GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes, false, null, 96, null);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = "`" + configuration + "` is deprecated; replace with `" + replacement + "`";
            LintFix fix = this.fix().name("Replace '" + configuration + "' with '" + replacement + "'").family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix, false, null, 96, null);
        }
    }

    private final void checkAnnotationProcessorOnCompilePath(String configuration, String dependency, GradleContext context, Object propertyCookie) {
        for (Companion.CompileConfiguration compileConfiguration : Companion.CompileConfiguration.values()) {
            if (!compileConfiguration.matches(configuration) || !GradleDetector.Companion.isCommonAnnotationProcessor(dependency)) continue;
            String replacement = compileConfiguration.replacement(configuration);
            LintFix fix = this.fix().name("Replace " + configuration + " with " + replacement).family("Replace compile classpath with annotationProcessor").replace().text(configuration).with(replacement).autoFix().build();
            String message2 = "Add annotation processor to processor path using `" + replacement + "` instead of `" + configuration + "`";
            GradleDetector.report$default(this, (Context)context, propertyCookie, ANNOTATION_PROCESSOR_ON_COMPILE_PATH, message2, fix, false, null, 96, null);
        }
    }

    private final void checkMinSdkVersion(GradleContext context, int version, Object valueCookie) {
        boolean bl = 1 <= version ? version < 16 : false;
        if (bl) {
            String message2 = "The value of minSdkVersion is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 16";
            LintFix fix = this.fix().name(label).replace().text(String.valueOf(version)).with("16").build();
            GradleDetector.report$default(this, (Context)context, valueCookie, MIN_SDK_TOO_LOW, message2, fix, false, null, 96, null);
        }
    }

    private final void checkIntegerAsString(GradleContext context, String value, Object cookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value);
        if (Lint.isNumberString((String)string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ")";
            LintFix fix = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            GradleDetector.report$default(this, (Context)context, cookie, STRING_INTEGER, message2, fix, false, null, 96, null);
        }
    }

    public void checkMethodCall(@NotNull GradleContext context, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(namedArguments, (String)"namedArguments");
        Intrinsics.checkNotNullParameter(unnamedArguments, (String)"unnamedArguments");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                GradleDetector.report$default(this, (Context)context, cookie, DEPRECATED, message2, fix, false, null, 96, null);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
            if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                this.mAppliedJavaPlugin = true;
                this.mJavaPluginInfo = new JavaPluginInfo(cookie);
            }
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"google") && Intrinsics.areEqual((Object)parent, (Object)"repositories") && Intrinsics.areEqual((Object)parentParent, (Object)"buildscript")) {
            this.mDeclaredGoogleMavenRepository = true;
            this.maybeReportAgpVersionIssue((Context)context);
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"jcenter") && Intrinsics.areEqual((Object)parent, (Object)"repositories")) {
            String message3 = "JCenter Maven repository is no longer receiving updates: newer library versions may be available elsewhere";
            LintFix replaceFix = this.fix().name("Replace with mavenCentral").replace().text("jcenter").with("mavenCentral").build();
            LintFix deleteFix = this.fix().name("Delete this repository declaration").replace().all().with("").build();
            LintFix[] lintFixArray = new LintFix[]{replaceFix, deleteFix};
            GradleDetector.report$default(this, (Context)context, cookie, JCENTER_REPOSITORY_OBSOLETE, message3, this.fix().alternatives(lintFixArray), false, null, 96, null);
        }
    }

    private final void checkTargetCompatibility(GradleContext context) {
        if (this.compileSdkVersion > 0 && this.targetSdkVersion > 0 && this.targetSdkVersion > this.compileSdkVersion) {
            String message2 = "The compileSdkVersion (" + this.compileSdkVersion + ") should not be lower than the targetSdkVersion (" + this.targetSdkVersion + ")";
            LintFix fix = this.fix().name("Set compileSdkVersion to " + this.targetSdkVersion).replace().text(String.valueOf(this.compileSdkVersion)).with(String.valueOf(this.targetSdkVersion)).build();
            Context context2 = (Context)context;
            Object object = this.compileSdkVersionCookie;
            Intrinsics.checkNotNull((Object)object);
            this.reportNonFatalCompatibilityIssue(context2, object, message2, fix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDependency(GradleContext context, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        block58: {
            block56: {
                block57: {
                    block51: {
                        block55: {
                            block52: {
                                block49: {
                                    block50: {
                                        block54: {
                                            block53: {
                                                version = dependency.getVersion();
                                                groupId = dependency.getGroupId();
                                                artifactId = dependency.getArtifactId();
                                                revision = dependency.getRevision();
                                                safeReplacement = null;
                                                if (version == null) {
                                                    return;
                                                }
                                                newerVersion = new Ref.ObjectRef();
                                                Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
                                                Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
                                                Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"revision");
                                                filter = this.getUpgradeVersionFilter(context, groupId, artifactId, revision);
                                                var13_13 = groupId;
                                                switch (var13_13.hashCode()) {
                                                    case 432891823: {
                                                        if (var13_13.equals("com.android.tools.build")) break;
                                                        ** break;
                                                    }
                                                    case -1893440090: {
                                                        if (!var13_13.equals("com.squareup.okhttp3")) {
                                                            ** break;
                                                        }
                                                        break block49;
                                                    }
                                                    case -491662668: {
                                                        if (!var13_13.equals("org.apache.httpcomponents")) {
                                                            ** break;
                                                        }
                                                        break block50;
                                                    }
                                                    case 1502450888: {
                                                        if (!var13_13.equals("com.bugsnag")) {
                                                            ** break;
                                                        }
                                                        break block51;
                                                    }
                                                    case -1266275135: {
                                                        if (!var13_13.equals("com.github.bumptech.glide")) {
                                                            ** break;
                                                        }
                                                        break block52;
                                                    }
                                                    case 2042560118: {
                                                        if (!var13_13.equals("com.google.guava")) {
                                                            ** break;
                                                        }
                                                        break block53;
                                                    }
                                                    case 325967270: {
                                                        if (!var13_13.equals("com.google.android.gms")) {
                                                            ** break;
                                                        }
                                                        ** GOTO lbl68
                                                    }
                                                    case 726153860: {
                                                        if (!var13_13.equals("com.google.code.gson")) {
                                                            ** break;
                                                        }
                                                        break block54;
                                                    }
                                                    case 288657178: {
                                                        if (!var13_13.equals("io.fabric.tools")) {
                                                            ** break;
                                                        }
                                                        break block55;
                                                    }
                                                    case 26640288: {
                                                        if (!var13_13.equals("com.google.android.wearable")) {
                                                            ** break;
                                                        }
                                                        ** GOTO lbl68
                                                    }
                                                    case -1030005853: {
                                                        if (!var13_13.equals("org.jetbrains.kotlin")) {
                                                            ** break;
                                                        }
                                                        break block56;
                                                    }
                                                    case -225004625: {
                                                        if (!var13_13.equals("com.google.firebase")) {
                                                            ** break;
                                                        }
                                                        ** GOTO lbl68
                                                    }
                                                    case -315438450: {
                                                        if (!var13_13.equals("org.robolectric")) {
                                                            ** break;
                                                        }
                                                        break block57;
                                                    }
                                                    case 1356232872: {
                                                        if (!var13_13.equals("com.google.android.support")) ** break;
lbl68:
                                                        // 4 sources

                                                        this.checkPlayServices(context, dependency, version, revision, cookie, statementCookie);
                                                        ** break;
                                                    }
                                                }
                                                if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                                                if (this.checkGradlePluginDependency(context, dependency, statementCookie)) {
                                                    return;
                                                }
                                                newerVersion.element = GradleVersion.max((GradleVersion)version, (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
                                                if (!LintClient.Companion.isGradle()) {
                                                    newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
                                                }
                                                newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context.getClient().getHighestKnownVersion(dependency, filter));
                                                if (newerVersion.element != null && !version.isPreview() && !Intrinsics.areEqual((Object)newerVersion.element, (Object)version)) {
                                                    v0 = version.getMinorSegment();
                                                    v1 = v0 != null ? !v0.acceptsGreaterValue() : false;
                                                    if (v1 && (version.getMajor() != ((GradleVersion)newerVersion.element).getMajor() || version.getMinor() != ((GradleVersion)newerVersion.element).getMinor())) {
                                                        safeReplacement = this.getGoogleMavenRepoVersion(context, dependency, new Predicate(version, (Ref.ObjectRef<GradleVersion>)newerVersion){
                                                            final /* synthetic */ GradleVersion $version;
                                                            final /* synthetic */ Ref.ObjectRef<GradleVersion> $newerVersion;
                                                            {
                                                                this.$version = $version;
                                                                this.$newerVersion = $newerVersion;
                                                            }

                                                            /*
                                                             * Enabled force condition propagation
                                                             * Lifted jumps to return sites
                                                             */
                                                            public final boolean test(@NotNull GradleVersion filterVersion) {
                                                                Intrinsics.checkNotNullParameter((Object)filterVersion, (String)"filterVersion");
                                                                if (filterVersion.getMajor() != this.$version.getMajor()) return false;
                                                                if (filterVersion.getMinor() != this.$version.getMinor()) return false;
                                                                if (filterVersion.getMicro() <= this.$version.getMicro()) return false;
                                                                if (filterVersion.isPreview()) return false;
                                                                Object object = this.$newerVersion.element;
                                                                Intrinsics.checkNotNull((Object)object);
                                                                if (filterVersion.compareTo((GradleVersion)object) >= 0) return false;
                                                                if (filterVersion.isSnapshot()) return false;
                                                                return true;
                                                            }
                                                        });
                                                    }
                                                }
                                                if (newerVersion.element != null && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
                                                    this.agpVersionCheckInfo = new AgpVersionCheckInfo((GradleVersion)newerVersion.element, ((GradleVersion)newerVersion.element).getMajor() == version.getMajor() && ((GradleVersion)newerVersion.element).getMinor() == version.getMinor(), safeReplacement, dependency, isResolved, statementCookie);
                                                    this.maybeReportAgpVersionIssue((Context)context);
                                                }
                                                return;
                                            }
                                            if (!Intrinsics.areEqual((Object)"guava", (Object)artifactId)) ** break;
                                            newerVersion.element = this.getNewerVersion(version, 21, 0);
                                            ** break;
                                        }
                                        if (!Intrinsics.areEqual((Object)"gson", (Object)artifactId)) ** break;
                                        newerVersion.element = this.getNewerVersion(version, 2, 8, 2);
                                        ** break;
                                    }
                                    if (!Intrinsics.areEqual((Object)"httpclient", (Object)artifactId)) ** break;
                                    newerVersion.element = this.getNewerVersion(version, 4, 5, 5);
                                    ** break;
                                }
                                if (!Intrinsics.areEqual((Object)"okhttp", (Object)artifactId)) ** break;
                                newerVersion.element = this.getNewerVersion(version, 3, 10, 0);
                                ** break;
                            }
                            if (!Intrinsics.areEqual((Object)"glide", (Object)artifactId)) ** break;
                            newerVersion.element = this.getNewerVersion(version, 3, 7, 0);
                            ** break;
                        }
                        if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                        parsed = GradleVersion.tryParse((String)revision);
                        if (parsed != null && parsed.compareTo("1.21.6") < 0) {
                            fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "1.22.1", false, null, 12, null);
                            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to improve Instant Run performance (was " + revision + ")", fix, false, null, 96, null);
                            ** break;
                        }
                        newerVersion.element = this.getNewerVersion(version, new GradleVersion(1, 25, 1));
                        ** break;
                    }
                    if (!Intrinsics.areEqual((Object)"bugsnag-android-gradle-plugin", (Object)artifactId)) ** break;
                    if (!version.isAtLeast(2, 1, 2)) {
                        fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "2.4.1", false, null, 12, null);
                        GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to improve Instant Run performance (was " + revision + ")", fix, false, null, 96, null);
                        ** break;
                    }
                    newerVersion.element = this.getNewerVersion(version, 3, 2, 5);
                    ** break;
                }
                if (Intrinsics.areEqual((Object)"robolectric", (Object)artifactId) && SdkConstants.currentPlatform() == 2 && !version.isAtLeast(4, 2, 1)) {
                    fix = GradleDetector.getUpdateDependencyFix$default(this, revision, "4.2.1", false, null, 12, null);
                    GradleDetector.report$default(this, (Context)context, cookie, GradleDetector.DEPENDENCY, "Use robolectric version 4.2.1 or later to fix issues with parsing of Windows paths", fix, false, null, 96, null);
                    ** break;
                }
                break block58;
            }
            if (!Intrinsics.areEqual((Object)artifactId, (Object)"kotlin-gradle-plugin")) ** break;
            return;
        }
        this.checkForKtxExtension((Context)context, groupId, artifactId, version, cookie);
        blockedDependencies = this.blockedDependencies.get(context.getProject());
        if (blockedDependencies != null && (path = blockedDependencies.checkDependency(groupId, artifactId, true)) != null) {
            message = this.getBlockedDependencyMessage(path);
            fix = this.fix().name("Delete dependency").replace().all().build();
            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DUPLICATE_CLASSES, message, fix, true, null, 64, null);
        }
        if ((sdkIndex = this.getGooglePlaySdkIndex(context.getClient())).isReady()) {
            v2 = version.toString();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"version.toString()");
            versionString = v2;
            reportCreated = false;
            buildFile = context.file;
            if (sdkIndex.isLibraryNonCompliant(groupId, artifactId, versionString, buildFile)) {
                message = sdkIndex.generatePolicyMessage(groupId, artifactId, versionString);
                fix = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                reportCreated = GradleDetector.report$default(this, (Context)context, cookie, GradleDetector.PLAY_SDK_INDEX_NON_COMPLIANT, message, fix, false, null, 96, null);
            }
            if (!reportCreated) {
                isBlocking = sdkIndex.hasLibraryBlockingIssues(groupId, artifactId, versionString);
                if (isBlocking) {
                    if (sdkIndex.hasLibraryCriticalIssues(groupId, artifactId, versionString, buildFile)) {
                        message = sdkIndex.generateBlockingCriticalMessage(groupId, artifactId, versionString);
                        fix = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                        reportCreated = GradleDetector.report$default(this, (Context)context, cookie, GradleDetector.RISKY_LIBRARY, message, fix, false, Severity.ERROR, 32, null);
                    }
                    if (!reportCreated && sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, buildFile)) {
                        message = sdkIndex.generateBlockingOutdatedMessage(groupId, artifactId, versionString);
                        fix = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                        GradleDetector.report$default(this, (Context)context, cookie, GradleDetector.DEPRECATED_LIBRARY, message, fix, false, Severity.ERROR, 32, null);
                    }
                } else if (sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, buildFile)) {
                    message = sdkIndex.generateOutdatedMessage(groupId, artifactId, versionString);
                    fix = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                    GradleDetector.report$default(this, (Context)context, cookie, GradleDetector.DEPRECATED_LIBRARY, message, fix, false, null, 96, null);
                }
            }
        }
        issue = GradleDetector.DEPENDENCY;
        if (context.getScope().size() > 1 && context.isEnabled(GradleDetector.REMOTE_VERSION) && !StringsKt.startsWith$default((String)groupId, (String)"androidx.", (boolean)false, (int)2, null) && (latest = GradleDetector.Companion.getLatestVersionFromRemoteRepo(context.getClient(), dependency, filter, dependency.isPreview())) != null && version.compareTo(latest) < 0) {
            newerVersion.element = latest;
            issue = GradleDetector.REMOTE_VERSION;
        }
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context.getClient().getHighestKnownVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.support") || Intrinsics.areEqual((Object)groupId, (Object)"com.android.support.test")) {
            this.checkSupportLibraries(context, dependency, version, (GradleVersion)newerVersion.element, cookie);
        }
        if (newerVersion.element != null && version.compareTo(new GradleVersion(0, 0, 0)) > 0 && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
            v3 = ((GradleVersion)newerVersion.element).toString();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"newerVersion.toString()");
            versionString = v3;
            message = Intrinsics.areEqual((Object)dependency.getGroupId(), (Object)"androidx.slidingpanelayout") != false && Intrinsics.areEqual((Object)dependency.getArtifactId(), (Object)"slidingpanelayout") != false ? "Upgrade `androidx.slidingpanelayout` for keyboard and mouse support" : (Intrinsics.areEqual((Object)dependency.getGroupId(), (Object)"androidx.compose.foundation") != false && Intrinsics.areEqual((Object)dependency.getArtifactId(), (Object)"foundation") != false ? "Upgrade `androidx.compose.foundation` for keyboard and mouse support" : this.getNewerVersionAvailableMessage(dependency, versionString, null));
            fix = isResolved == false ? GradleDetector.getUpdateDependencyFix$default(this, revision, versionString, false, null, 12, null) : null;
            GradleDetector.report$default(this, (Context)context, cookie, issue, message, fix, false, null, 96, null);
        }
    }

    private final Predicate<GradleVersion> getUpgradeVersionFilter(GradleContext context, String groupId, String artifactId, String revision) {
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId)) {
            if (this.compileSdkVersion >= 18) {
                return new Predicate(this){
                    final /* synthetic */ GradleDetector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                        return version.getMajor() == GradleDetector.access$getCompileSdkVersion$p(this.this$0);
                    }
                };
            }
            if (this.targetSdkVersion > 0) {
                return new Predicate(this){
                    final /* synthetic */ GradleDetector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                        return version.getMajor() >= GradleDetector.access$getTargetSdkVersion$p(this.this$0);
                    }
                };
            }
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") && LintClient.Companion.isStudio()) {
            String string = context.getClient().getClientRevision();
            if (string == null) {
                return null;
            }
            String clientRevision = string;
            GradleVersion ideVersion = GradleVersion.parse((String)clientRevision);
            GradleVersion version = GradleVersion.parse((String)revision);
            return new Predicate(ideVersion, version){
                final /* synthetic */ GradleVersion $ideVersion;
                final /* synthetic */ GradleVersion $version;
                {
                    this.$ideVersion = $ideVersion;
                    this.$version = $version;
                }

                public final boolean test(@NotNull GradleVersion v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v.getMajor() == this.$ideVersion.getMajor() && v.getMinor() == this.$ideVersion.getMinor() || v.getMajor() == this.$version.getMajor() && v.getMinor() == this.$version.getMinor();
                }
            };
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final File getArtifactCacheHome() {
        File file = this.artifactCacheHome;
        if (file == null) {
            void var3_3;
            File home;
            GradleDetector $this$getArtifactCacheHome_u24lambda_u2d0 = this;
            boolean bl = false;
            $this$getArtifactCacheHome_u24lambda_u2d0.artifactCacheHome = home = new File($this$getArtifactCacheHome_u24lambda_u2d0.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = var3_3;
        }
        return file;
    }

    private final GradleVersion findCachedNewerVersion(GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        Path versionDir = this.getArtifactCacheHome().toPath().resolve(dependency.getGroupId() + File.separator + dependency.getArtifactId());
        return CancellableFileIo.exists((Path)versionDir, (LinkOption[])new LinkOption[0]) ? MavenRepositories.getHighestVersion((Path)versionDir, filter, (boolean)MavenRepositories.isPreview((GradleCoordinate)dependency)) : null;
    }

    private final void ensureTargetCompatibleWithO(GradleContext context, GradleVersion version, Object cookie, int major, int minor, int micro) {
        if (version != null && !version.isAtLeast(major, minor, micro)) {
            GradleVersion revision = new GradleVersion(major, minor, micro);
            GradleVersion newest = this.getNewerVersion(version, revision);
            if (newest != null) {
                revision = newest;
            }
            String message2 = "Version must be at least " + revision + " when targeting O";
            this.reportFatalCompatibilityIssue((Context)context, cookie, message2);
        }
    }

    private final boolean checkGradlePluginDependency(GradleContext context, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate minimum = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:3.2.0");
        if (minimum != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, minimum) < 0) {
            GradleVersion recommended = GradleVersion.max((GradleVersion)this.getGoogleMavenRepoVersion(context, minimum, null), (GradleVersion)GradleVersion.tryParse((String)"7.0.3"));
            String message2 = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 3.2.0 and the recommended version is " + recommended;
            GradleDetector.report$default(this, (Context)context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, false, null, 112, null);
            return true;
        }
        return false;
    }

    private final void checkSupportLibraries(GradleContext context, GradleCoordinate dependency, GradleVersion version, GradleVersion newerVersion, Object cookie) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId) && this.compileSdkVersion >= 18 && dependency.getMajorVersion() != this.compileSdkVersion && dependency.getMajorVersion() != -1 && context.isEnabled(COMPATIBILITY)) {
            if (this.compileSdkVersion >= 29 && dependency.getMajorVersion() < 29) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "Version 28 (intended for Android Pie and below) is the last version of the legacy support library, so we recommend that you migrate to AndroidX libraries when using Android Q and moving forward. The IDE can help with this: Refactor > Migrate to AndroidX...", null, 8, null);
                return;
            }
            LintFix fix = null;
            if (newerVersion != null) {
                fix = this.fix().name("Replace with " + newerVersion).replace().text(version.toString()).with(newerVersion.toString()).build();
            }
            String message2 = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.compileSdkVersion + ")";
            this.reportNonFatalCompatibilityIssue((Context)context, cookie, message2, fix);
        }
        if (!(this.mCheckedSupportLibs || StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations"))) {
            this.mCheckedSupportLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                this.checkConsistentSupportLibraries((Context)context, cookie);
            }
        }
        if (Intrinsics.areEqual((Object)"appcompat-v7", (Object)artifactId)) {
            IAndroidTarget buildTarget;
            boolean compile26Beta;
            boolean supportLib26Beta = version.isAtLeast(26, 0, 0, "beta", 1, true);
            boolean bl = compile26Beta = this.compileSdkVersion >= 26;
            if (this.compileSdkVersion == 26 && (buildTarget = context.getProject().getBuildTarget()) != null && buildTarget.getVersion().isPreview()) {
                boolean bl2 = compile26Beta = buildTarget.getRevision() != 1;
            }
            if (supportLib26Beta && !compile26Beta && this.compileSdkVersion == version.getMajor()) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "When using a `compileSdkVersion` older than android-O revision 2, the support library version must be 26.0.0-alpha1 or lower (was " + version + ")", null, 8, null);
            } else if (!supportLib26Beta && compile26Beta) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "When using a `compileSdkVersion` android-O revision 2 or higher, the support library version should be 26.0.0-beta1 or higher (was " + version + ")", null, 8, null);
            }
        }
    }

    private final void checkPlayServices(GradleContext context, GradleCoordinate dependency, GradleVersion version, String revision, Object cookie, Object statementCookie) {
        Object message2;
        LintFix fix;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (Intrinsics.areEqual((Object)"5.2.08", (Object)revision) && context.isEnabled(COMPATIBILITY)) {
            GradleVersion maxVersion = GradleVersion.max((GradleVersion)GradleVersion.parse((String)"10.2.1"), (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, null));
            String string = maxVersion.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"maxVersion.toString()");
            fix = GradleDetector.getUpdateDependencyFix$default(this, revision, string, false, null, 12, null);
            String message3 = "Version `5.2.08` should not be used; the app can not be published with this version. Use version `" + maxVersion + "` instead.";
            this.reportFatalCompatibilityIssue((Context)context, cookie, message3, fix);
        }
        if (context.isEnabled(BUNDLED_GMS) && PLAY_SERVICES_V650.isSameArtifact(dependency) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, PLAY_SERVICES_V650) >= 0) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, (Context)context, cookie, BUNDLED_GMS, (String)message2, null, false, null, 112, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + revision + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix = this.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + revision).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            GradleDetector.report$default(this, (Context)context, cookie, DEPRECATED, (String)message2, fix, false, null, 96, null);
        }
        if (this.targetSdkVersion >= 26) {
            if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-gcm", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"firebase-messaging", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)"firebase-jobdispatcher", (Object)artifactId) || Intrinsics.areEqual((Object)"firebase-jobdispatcher-with-gcm-dep", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 0, 6, 0);
            }
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) || Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                    this.checkConsistentPlayServices((Context)context, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                this.checkConsistentWearableLibraries((Context)context, cookie, statementCookie);
            }
        }
    }

    private final boolean isSupportLibArtifact(LintModelMavenName $this$isSupportLibArtifact) {
        return this.isSupportLibraryDependentOnCompileSdk($this$isSupportLibArtifact.getGroupId(), $this$isSupportLibArtifact.getArtifactId());
    }

    private final boolean isAndroidxArtifact(LintModelMavenName $this$isAndroidxArtifact) {
        return StringsKt.startsWith$default((String)$this$isAndroidxArtifact.getGroupId(), (String)"androidx.", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)$this$isAndroidxArtifact.getGroupId(), (Object)"androidx.navigation");
    }

    private final void checkConsistentSupportLibraries(Context context, Object cookie) {
        Iterator $this$filterIsInstanceTo$iv$iv;
        this.checkConsistentLibraries(context, cookie, "com.android.support", null);
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(context.getProject());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List androidLibraries = (List)destination$iv$iv;
        LintModelMavenName usesOldSupportLib = null;
        LintModelMavenName usesAndroidX = null;
        for (LintModelExternalLibrary library : androidLibraries) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (usesOldSupportLib == null && this.isSupportLibArtifact(coordinates)) {
                usesOldSupportLib = coordinates;
            }
            if (usesAndroidX == null && this.isAndroidxArtifact(coordinates)) {
                usesAndroidX = coordinates;
            }
            if (usesOldSupportLib == null || usesAndroidX == null) continue;
        }
        if (usesOldSupportLib != null && usesAndroidX != null) {
            String message2 = "Dependencies using groupId `com.android.support` and `androidx.*` can not be combined but found `" + usesOldSupportLib + "` and `" + usesAndroidX + "` incompatible dependencies";
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context, cookie, message2, null, 8, null);
            } else {
                Location location = Companion.getDependencyLocation(context, usesOldSupportLib, usesAndroidX);
                this.reportNonFatalCompatibilityIssue(context, location, message2);
            }
        }
    }

    private final void checkConsistentPlayServices(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentWearableLibraries(Context context, Object cookie, Object statementCookie) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LintModelExternalLibrary library : (List)destination$iv$iv) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) && Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) {
                supportVersions.add(coordinates.getVersion());
            }
            if (!Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!library.getProvided()) {
                String message2 = "This dependency should be marked as `compileOnly`, not `compile`";
                if (statementCookie != null) {
                    this.reportFatalCompatibilityIssue(context, statementCookie, message2);
                } else {
                    Location location = Companion.getDependencyLocation(context, coordinates);
                    if (location.getStart() == null) {
                        message2 = "The com.google.android.wearable:wearable dependency should be marked as `compileOnly`, not `compile`";
                    }
                    this.reportFatalCompatibilityIssue(context, location, message2);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        if (!((Collection)supportVersions).isEmpty()) {
            Location location;
            if (wearableVersions.isEmpty()) {
                ArrayList list = new ArrayList(supportVersions);
                String first = (String)Collections.min(list);
                String message3 = "Project depends on com.google.android.support:wearable:" + first + ", so it must also depend (as a provided dependency) on com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message3);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)first, (String)"first");
                    location = Companion.getDependencyLocation(context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, first);
                    this.reportFatalCompatibilityIssue(context, location, message3);
                }
            } else if (!Intrinsics.areEqual(supportVersions, wearableVersions)) {
                ArrayList sortedSupportVersions = new ArrayList(supportVersions);
                CollectionsKt.sort((List)sortedSupportVersions);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                String string = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? (String)sortedSupportVersions.get(0) : sortedSupportVersions.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String message4 = string2;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message4);
                } else {
                    Object e = sortedSupportVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"sortedSupportVersions[0]");
                    String string3 = (String)e;
                    Object e2 = supportedWearableVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"supportedWearableVersions[0]");
                    location = com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(Companion, context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, string3, ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID, (String)e2, null, 128, null);
                    this.reportFatalCompatibilityIssue(context, location, message4);
                }
            }
        }
    }

    private final List<LintModelLibrary> getAllLibraries(Project project) {
        Object object = project.getBuildVariant();
        if (object == null || (object = object.getMainArtifact()) == null || (object = object.getDependencies()) == null || (object = object.getAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentLibraries(Context context, Object cookie, String groupId, String groupId2) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allLibraries = (List)destination$iv$iv;
        for (LintModelExternalLibrary library : allLibraries) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (!Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"renderscript", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"firebase-jobdispatcher", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"support-annotations")) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            List list;
            LintModelDependencyGraph lintModelDependencyGraph;
            Object object;
            LintModelAndroidArtifact lintModelAndroidArtifact;
            GradleVersion version;
            ArrayList sortedVersions = new ArrayList(versions);
            List list2 = sortedVersions;
            Comparator comparator = Collections.reverseOrder();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"reverseOrder()");
            CollectionsKt.sortWith((List)list2, comparator);
            List list3 = versionToCoordinate.get(sortedVersions.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"versionToCoordinate.get(sortedVersions[0])");
            LintModelMavenName c1 = this.findFirst(list3);
            List list4 = versionToCoordinate.get(sortedVersions.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"versionToCoordinate.get(sortedVersions[1])");
            LintModelMavenName c2 = this.findFirst(list4);
            if ((Intrinsics.areEqual((Object)groupId, (Object)GMS_GROUP_ID) || Intrinsics.areEqual((Object)groupId, (Object)FIREBASE_GROUP_ID)) && (version = GradleVersion.tryParse((String)c2.getVersion())) != null && (version.getMajor() >= 14 || version.getMajor() == 0)) {
                return;
            }
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String groupDesc = Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) ? "gms/firebase" : groupId;
            String message2 = "All " + groupDesc + " libraries must use the exact same version specification (mixing versions can lead to runtime crashes). Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". Examples include `" + example1 + "` and `" + example2 + "`";
            LintModelVariant lintModelVariant = project.getBuildVariant();
            List allItems = lintModelVariant != null && (lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) != null && (object = lintModelAndroidArtifact.getDependencies()) != null && (lintModelDependencyGraph = object.getCompileDependencies()) != null && (list = lintModelDependencyGraph.getAllGraphItems()) != null ? list : CollectionsKt.emptyList();
            for (LintModelDependency library : allItems) {
                if (!Intrinsics.areEqual((Object)library.getArtifactName(), (Object)"com.android.databinding:library")) continue;
                for (LintModelDependency dep : library.getDependencies()) {
                    LintModelLibrary lintModelLibrary;
                    LintModelExternalLibrary lintModelExternalLibrary;
                    if (!Intrinsics.areEqual((Object)dep.getArtifactName(), (Object)"com.android.support:support-v4") || Intrinsics.areEqual(sortedVersions.get(0), (lintModelExternalLibrary = (lintModelLibrary = dep.findLibrary()) instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null) != null && (lintModelExternalLibrary = lintModelExternalLibrary.getResolvedCoordinates()) != null ? lintModelExternalLibrary.getVersion() : null)) continue;
                    lintModelLibrary = library.findLibrary();
                    LintModelExternalLibrary lintModelExternalLibrary2 = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
                    String string = lintModelExternalLibrary2 != null && (lintModelExternalLibrary2 = lintModelExternalLibrary2.getResolvedCoordinates()) != null ? lintModelExternalLibrary2.getVersion() : null;
                    lintModelLibrary = dep.findLibrary();
                    LintModelExternalLibrary lintModelExternalLibrary3 = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
                    message2 = message2 + ". Note that this project is using data binding (com.android.databinding:library:" + string + ") which pulls in com.android.support:support-v4:" + (lintModelExternalLibrary3 != null && (lintModelExternalLibrary3 = lintModelExternalLibrary3.getResolvedCoordinates()) != null ? lintModelExternalLibrary3.getVersion() : null) + ". You can try to work around this by adding an explicit dependency on com.android.support:support-v4:" + sortedVersions.get(0);
                    break;
                }
                break;
            }
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context, cookie, message2, null, 8, null);
            } else {
                Location location = Companion.getDependencyLocation(context, c1, c2);
                this.reportNonFatalCompatibilityIssue(context, location, message2);
            }
        }
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        ((Map)this.blockedDependencies).put(project, new BlockedDependencies(project));
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        this.checkBlockedDependencies(context, project);
    }

    private final void checkLibraryConsistency(Context context) {
        this.checkConsistentPlayServices(context, null);
        this.checkConsistentSupportLibraries(context, null);
        this.checkConsistentWearableLibraries(context, null, null);
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!this.mAppliedJavaPlugin || this.mDeclaredSourceCompatibility && this.mDeclaredTargetCompatibility)) {
            File file = context.file;
            String contents = ((Object)context.getClient().readFile(file)).toString();
            String message2 = this.mDeclaredTargetCompatibility ? "no Java sourceCompatibility directive" : (this.mDeclaredSourceCompatibility ? "no Java targetCompatibility directive" : "no Java language level directives");
            String fixDisplayName = this.mDeclaredTargetCompatibility ? "Insert sourceCompatibility directive for JDK8" : (this.mDeclaredSourceCompatibility ? "Insert targetCompatibility directive for JDK8" : "Insert JDK8 language level directives");
            String insertion = this.mDeclaredTargetCompatibility ? "\njava.sourceCompatibility = JavaVersion.VERSION_1_8" : (this.mDeclaredSourceCompatibility ? "\njava.targetCompatibility = JavaVersion.VERSION_1_8" : "\njava {\n    sourceCompatibility = JavaVersion.VERSION_1_8\n    targetCompatibility = JavaVersion.VERSION_1_8\n}");
            LintFix fix = this.fix().replace().name(fixDisplayName).range(Location.Companion.create(context.file, (CharSequence)contents, 0, contents.length())).end().with(insertion).build();
            JavaPluginInfo javaPluginInfo = this.mJavaPluginInfo;
            Intrinsics.checkNotNull((Object)javaPluginInfo);
            GradleDetector.report$default(this, context, javaPluginInfo.getCookie(), JAVA_PLUGIN_LANGUAGE_LEVEL, message2, fix, false, null, 96, null);
        }
    }

    private final void maybeReportAgpVersionIssue(Context context) {
        block3: {
            if (!this.mDeclaredGoogleMavenRepository) break block3;
            AgpVersionCheckInfo agpVersionCheckInfo = this.agpVersionCheckInfo;
            if (agpVersionCheckInfo != null) {
                LintFix lintFix;
                AgpVersionCheckInfo it = agpVersionCheckInfo;
                boolean bl = false;
                String string = it.getNewerVersion().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.newerVersion.toString()");
                String versionString = string;
                String message2 = this.getNewerVersionAvailableMessage(it.getDependency(), versionString, it.getSafeReplacement());
                if (it.isResolved()) {
                    lintFix = null;
                } else {
                    String string2 = it.getDependency().getRevision();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.dependency.revision");
                    lintFix = this.getUpdateDependencyFix(string2, versionString, it.getNewerVersionIsSafe(), it.getSafeReplacement());
                }
                LintFix fix = lintFix;
                GradleDetector.report$default(this, context, it.getCookie(), AGP_DEPENDENCY, message2, fix, false, null, 96, null);
            }
        }
    }

    private final void checkForKtxExtension(Context context, String groupId, String artifactId, GradleVersion version, Object cookie) {
        if (!this.mAppliedKotlinAndroidPlugin) {
            return;
        }
        if (StringsKt.endsWith$default((String)artifactId, (String)"-ktx", (boolean)false, (int)2, null)) {
            return;
        }
        String mavenName = groupId + ":" + artifactId;
        if (!GradleDetector.Companion.libraryHasKtxExtension(mavenName)) {
            return;
        }
        LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
        if (lintModelVariant == null) {
            return;
        }
        LintModelVariant variant = lintModelVariant;
        if (variant.getMainArtifact().findCompileDependency("org.jetbrains.kotlin:kotlin-stdlib") == null) {
            return;
        }
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        if (repository2.findVersion(groupId, artifactId + "-ktx", (Function1)new Function1<GradleVersion, Boolean>(version){
            final /* synthetic */ GradleVersion $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GradleVersion it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$version);
            }
        }, true) == null) {
            return;
        }
        String msg = "Add suffix `-ktx` to enable the Kotlin extensions for this library";
        LintFix fix = this.fix().name("Replace with KTX dependency").replace().text(mavenName).with(mavenName + "-ktx").build();
        GradleDetector.report$default(this, context, cookie, KTX_EXTENSION_AVAILABLE, msg, fix, false, null, 96, null);
    }

    private final void checkBlockedDependencies(Context context, Project project) {
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(project);
        if (blockedDependencies == null) {
            return;
        }
        BlockedDependencies blockedDependencies2 = blockedDependencies;
        List<List<LintModelDependency>> dependencies = blockedDependencies2.getForbiddenDependencies();
        if (!((Collection)dependencies).isEmpty()) {
            for (List<LintModelDependency> path : dependencies) {
                Location location;
                LintModelMavenName gc;
                LintModelMavenName lintModelMavenName;
                String message2 = this.getBlockedDependencyMessage(path);
                File projectDir = context.getProject().getDir();
                if (path.get(0).findLibrary() != null) {
                    LintModelLibrary it;
                    boolean bl = false;
                    lintModelMavenName = it instanceof LintModelExternalLibrary ? ((LintModelExternalLibrary)it).getResolvedCoordinates() : null;
                } else {
                    lintModelMavenName = gc = null;
                }
                if (gc != null) {
                    location = Companion.getDependencyLocation(context, gc.getGroupId(), gc.getArtifactId(), gc.getVersion());
                } else {
                    String mavenName = path.get(0).getArtifactName();
                    LintClient lintClient = context.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)projectDir, (String)"projectDir");
                    location = Lint.guessGradleLocation((LintClient)lintClient, (File)projectDir, (String)mavenName);
                }
                Location location2 = location;
                context.report(new Incident(DUPLICATE_CLASSES, location2, message2), this.map());
            }
        }
        this.blockedDependencies.remove(project);
    }

    private final boolean report(Context context, Object cookie, Issue issue, String message2, LintFix fix, boolean partial, Severity overrideSeverity) {
        Ref.BooleanRef reportCreated = new Ref.BooleanRef();
        context.getClient().runReadAction(new Runnable(context, issue, cookie, message2, fix, overrideSeverity, partial, this, reportCreated){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;
            final /* synthetic */ Severity $overrideSeverity;
            final /* synthetic */ boolean $partial;
            final /* synthetic */ GradleDetector this$0;
            final /* synthetic */ Ref.BooleanRef $reportCreated;
            {
                this.$context = $context;
                this.$issue = $issue;
                this.$cookie = $cookie;
                this.$message = $message;
                this.$fix = $fix;
                this.$overrideSeverity = $overrideSeverity;
                this.$partial = $partial;
                this.this$0 = $receiver;
                this.$reportCreated = $reportCreated;
            }

            public final void run() {
                if (this.$context.isEnabled(this.$issue) && this.$context instanceof GradleContext) {
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && ((GradleContext)this.$context).isSuppressedWithComment(this.$cookie, this.$issue)) {
                        return;
                    }
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    Incident incident = new Incident(this.$issue, location, this.$message, this.$fix);
                    Severity severity = this.$overrideSeverity;
                    if (severity != null) {
                        Severity it = severity;
                        boolean bl = false;
                        incident.overrideSeverity(it);
                    }
                    if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                    this.$reportCreated.element = true;
                }
            }
        });
        return reportCreated.element;
    }

    static /* synthetic */ boolean report$default(GradleDetector gradleDetector, Context context, Object object, Issue issue, String string, LintFix lintFix, boolean bl, Severity severity, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            severity = null;
        }
        return gradleDetector.report(context, object, issue, string, lintFix, bl, severity);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, null, false, null, 112, null);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix fix) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, fix, false, null, 96, null);
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix lintFix) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, lintFix, false, null, 96, null);
    }

    static /* synthetic */ void reportNonFatalCompatibilityIssue$default(GradleDetector gradleDetector, Context context, Object object, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonFatalCompatibilityIssue");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        gradleDetector.reportNonFatalCompatibilityIssue(context, object, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context, Location location, String message2) {
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
        });
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Location location, String message2) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
        });
    }

    private final int getSdkVersion(String value) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value);
            if (codeName != null) {
                if (Lint.isNumberString((String)codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final GradleCoordinate resolveCoordinate(GradleContext context, String property, GradleCoordinate gc) {
        String string = gc.getRevision();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.revision");
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String string2 = gc.getRevision();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gc.revision");
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = string2;
            throw new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22);
        }
        Project project = context.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            LintModelArtifact lintModelArtifact = StringsKt.startsWith$default((String)property, (String)"androidTest", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getAndroidTestArtifact() : (StringsKt.startsWith$default((String)property, (String)"testFixtures", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestFixturesArtifact() : (StringsKt.startsWith$default((String)property, (String)"test", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestArtifact() : (LintModelArtifact)variant.getMainArtifact()));
            if (lintModelArtifact == null) {
                return null;
            }
            LintModelArtifact artifact = lintModelArtifact;
            for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                LintModelMavenName mc;
                if (!(library instanceof LintModelExternalLibrary) || !Intrinsics.areEqual((Object)(mc = ((LintModelExternalLibrary)library).getResolvedCoordinates()).getGroupId(), (Object)gc.getGroupId()) || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)gc.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc.getVersion());
                Intrinsics.checkNotNullExpressionValue((Object)revisions, (String)"revisions");
                if (!(!((Collection)revisions).isEmpty())) break;
                return new GradleCoordinate(mc.getGroupId(), mc.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return false;
        }
        LintModelModule model2 = lintModelModule;
        for (File file : model2.getBootClassPath()) {
            if (!FilesKt.endsWith((File)file, (String)"org.apache.http.legacy.jar")) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion, boolean suggestedVersionIsSafe, GradleVersion safeReplacement) {
        LintFix lintFix;
        LintFix fix = this.fix().name("Change to " + suggestedVersion).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix(suggestedVersionIsSafe, suggestedVersionIsSafe).build();
        if (safeReplacement != null) {
            String string = safeReplacement.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"safeReplacement.toString()");
            String stableVersion = string;
            LintFix stableFix = this.fix().name("Change to " + stableVersion).sharedName("Update versions").replace().text(currentVersion).with(stableVersion).autoFix().build();
            LintFix[] lintFixArray = new LintFix[]{fix, stableFix};
            lintFix = this.fix().alternatives(lintFixArray);
        } else {
            lintFix = fix;
        }
        return lintFix;
    }

    static /* synthetic */ LintFix getUpdateDependencyFix$default(GradleDetector gradleDetector, String string, String string2, boolean bl, GradleVersion gradleVersion, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdateDependencyFix");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            gradleVersion = null;
        }
        return gradleDetector.getUpdateDependencyFix(string, string2, bl, gradleVersion);
    }

    private final String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version, GradleVersion stable) {
        StringBuilder message2;
        StringBuilder $this$getNewerVersionAvailableMessage_u24lambda_u2d4 = message2 = new StringBuilder();
        boolean bl = false;
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append("A newer version of ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(dependency.getGroupId());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(":");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(dependency.getArtifactId());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(" than ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(dependency.getRevision());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(" is available: ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(version);
        if (stable != null) {
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(". (There is also a newer version of ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(String.valueOf(stable.getMajor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(".");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(String.valueOf(stable.getMinor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(".\ud835\udc65 available, if upgrading to ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(version);
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(" is difficult: ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(stable.toString());
            $this$getNewerVersionAvailableMessage_u24lambda_u2d4.append(")");
        }
        String string = message2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.toString()");
        return string;
    }

    private final boolean isSupportLibraryDependentOnCompileSdk(String groupId, String artifactId) {
        return Intrinsics.areEqual((Object)"com.android.support", (Object)groupId) && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations");
    }

    private final LintModelMavenName findFirst(Collection<? extends LintModelMavenName> coordinates) {
        LintModelMavenName lintModelMavenName = Collections.min(coordinates, findFirst.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)lintModelMavenName, (String)"min(coordinates) { o1, o\u2026ompareTo(o2.toString()) }");
        return lintModelMavenName;
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Issue issue = incident.getIssue();
        if (issue == DUPLICATE_CLASSES) {
            return context.getMainProject().getMinSdk() < 23 || this.usesLegacyHttpLibrary(context.getMainProject());
        }
        if (Intrinsics.areEqual((Object)issue, (Object)EXPIRING_TARGET_SDK_VERSION) || Intrinsics.areEqual((Object)issue, (Object)EXPIRED_TARGET_SDK_VERSION)) {
            return !this.isWearApp(context);
        }
        throw new IllegalStateException(issue.getId().toString());
    }

    private final boolean isWearApp(Context context) {
        Document document = context.getMainProject().getMergedManifest();
        Element element = document != null ? document.getDocumentElement() : null;
        if (element == null) {
            return false;
        }
        Element manifest = element;
        Iterator iterator = DomExtensions.iterator((Element)manifest);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)element2.getTagName(), (Object)"uses-feature") || !Intrinsics.areEqual((Object)element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)"android.hardware.type.watch")) continue;
            return true;
        }
        return false;
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis() && context.getDriver().isIsolated()) {
            return;
        }
        this.checkLibraryConsistency(context);
    }

    private final String getBlockedDependencyMessage(List<? extends LintModelDependency> path) {
        boolean direct = path.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            message2 = "`" + path.get(0).getArtifactId() + "` defines classes that conflict with classes now provided by Android. " + resolution;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (LintModelDependency lintModelDependency : path) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" \u2192 ");
                }
                String coordinates = lintModelDependency.getArtifactName();
                sb.append(coordinates);
            }
            sb.append(") ");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            String chain = string;
            message2 = "`" + path.get(0).getArtifactId() + "` depends on a library (" + path.get(path.size() - 1).getArtifactName() + ") which defines classes that conflict with classes now provided by Android. " + resolution + " Dependency chain: " + chain;
        }
        return message2;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor, int micro) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && !version1.isAtLeast(major, minor, micro) ? new GradleVersion(major, minor, micro) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && !version1.isAtLeast(major, minor, 0) ? new GradleVersion(major, minor) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, GradleVersion version2) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && version1.compareTo(version2) < 0 ? version2 : null;
    }

    private final GradleVersion getGoogleMavenRepoVersion(GradleContext context, GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        return repository2.findVersion(dependency, filter, dependency.isPreview());
    }

    @NotNull
    public final GoogleMavenRepository getGoogleMavenRepository(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        GoogleMavenRepository googleMavenRepository = this.googleMavenRepository;
        if (googleMavenRepository == null) {
            File cacheDir;
            GradleDetector $this$getGoogleMavenRepository_u24lambda_u2d5 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("maven.google", true);
            Path path = file != null ? file.toPath() : null;
            GoogleMavenRepository repository2 = new GoogleMavenRepository(client, path){
                final /* synthetic */ LintClient $client;
                {
                    this.$client = $client;
                    super($super_call_param$1, 0, 0, false, 14, null);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return Lint.readUrlData((LintClient)this.$client, (String)url, (int)timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    this.$client.log(throwable, message2, new Object[0]);
                }
            };
            $this$getGoogleMavenRepository_u24lambda_u2d5.googleMavenRepository = repository2;
            googleMavenRepository = repository2;
        }
        return googleMavenRepository;
    }

    private final GooglePlaySdkIndex getGooglePlaySdkIndex(LintClient client) {
        GooglePlaySdkIndex googlePlaySdkIndex = this.googlePlaySdkIndex;
        if (googlePlaySdkIndex == null) {
            GooglePlaySdkIndex repository2;
            File cacheDir;
            GradleDetector $this$getGooglePlaySdkIndex_u24lambda_u2d6 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("sdk_index", true);
            $this$getGooglePlaySdkIndex_u24lambda_u2d6.googlePlaySdkIndex = repository2 = (GooglePlaySdkIndex)((Object)playSdkIndexFactory.invoke((Object)(file != null ? file.toPath() : null), (Object)client));
            googlePlaySdkIndex = repository2;
        }
        return googlePlaySdkIndex;
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    @NotNull
    public static final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
        return Companion.getPlaySdkIndexFactory();
    }

    public static final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
        Companion.setPlaySdkIndexFactory(function2);
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, GradleContext context, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ int access$getCompileSdkVersion$p(GradleDetector $this) {
        return $this.compileSdkVersion;
    }

    public static final /* synthetic */ int access$getTargetSdkVersion$p(GradleDetector $this) {
        return $this.targetSdkVersion;
    }

    public static final /* synthetic */ LintMap access$map(GradleDetector $this) {
        return $this.map();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        Object[] objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Object object = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        AGP_DEPENDENCY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AndroidGradlePluginVersion", (String)"Obsolete Android Gradle Plugin Version", (String)"\n                This detector looks for usage of the Android Gradle Plugin where the version \\\n                you are using is not the current stable release. Using older versions is fine, \\\n                and there are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is available, \\\n                and that is what this lint check helps find.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecatedConfiguration", (String)"Deprecated Gradle Configuration", (String)"\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", (Implementation)implementation, (String)"https://d.android.com/r/tools/update-dependency-configurations", (Category)category, (int)6, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_GETTER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        STRING_INTEGER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"StringShouldBeInt", (String)"String should be int", (String)"\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        NOT_INTERPOLATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", (Implementation)implementation, (String)"https://www.groovy-lang.org/syntax.html#_string_interpolation", (Category)category, (int)8, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        REMOTE_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"\n                This detector checks with a central repository to see if there are newer \\\n                versions available for the dependencies used by this project. This is \\\n                similar to the `GradleDependency` check, which checks for newer versions \\\n                available in the Android SDK tools and libraries, but this works with any \\\n                MavenCentral dependency, and connects to the library every time, which \\\n                makes it more flexible but also **much** slower.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, null, null, null, (int)3600, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"MinSdkTooLow", (String)"API Version Too Low", (String)"\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        BUNDLED_GMS = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UseOfBundledGooglePlayServices", (String)"Use of bundled version of Google Play services", (String)"\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (https://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", (Implementation)implementation, (String)"https://developers.google.com/android/guides/setup#split", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"HighAppVersionCode", (String)"VersionCode too high", (String)"\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", (Implementation)implementation, (String)"https://developer.android.com/studio/publish/versioning.html", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DevModeObsolete", (String)"Dev Mode Obsolete", (String)"\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", (Implementation)implementation, null, (Category)category, (int)2, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        DUPLICATE_CLASSES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DuplicatePlatformClasses", (String)"Duplicate Platform Classes", (String)"\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        MINIMUM_TARGET_SDK_VERSION = 31;
        PREVIOUS_MINIMUM_TARGET_SDK_VERSION = MINIMUM_TARGET_SDK_VERSION - 1;
        MINIMUM_TARGET_SDK_VERSION_YEAR = 2022;
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiringTargetSdkVersion", (String)"TargetSdkVersion Soon Expiring", (String)"\n                In the second half of 2018, Google Play will require that new apps and app \\\n                updates target API level 26 or higher. This will be required for new apps in \\\n                August 2018, and for updates to existing apps in November 2018.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                This lint check starts warning you some months **before** these changes go \\\n                into effect if your `targetSdkVersion` is 25 or lower. This is intended to \\\n                give you a heads up to update your app, since depending on your current \\\n                `targetSdkVersion` the work can be nontrivial.\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiredTargetSdkVersion", (String)"TargetSdkVersion No Longer Supported", (String)"\n                As of the second half of 2018, Google Play requires that new apps and app \\\n                updates target API level 26 or higher.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, (String)"https://support.google.com/googleplay/android-developer/answer/113469#targetsdk", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"OutdatedLibrary", (String)"Outdated Library", (String)"\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", (Implementation)implementation, (String)"https://play.google.com/sdks", (Category)category, (int)5, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DataBindingWithoutKapt", (String)"Data Binding without Annotation Processing", (String)"\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin.\n                ", (Implementation)implementation, (String)"https://kotlinlang.org/docs/reference/kapt.html", (Category)category, (int)1, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"LifecycleAnnotationProcessorWithJava8", (String)"Lifecycle Annotation Processor with Java 8 Compile Option", (String)"\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n                ```gradle\n                annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                ```\n                with\n                ```gradle\n                implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"\n                ```\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ", (Implementation)implementation, (String)"https://d.android.com/r/studio-ui/lifecycle-release-notes", (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.SECURITY;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        RISKY_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"RiskyLibrary", (String)"Libraries with Privacy or Security Risks", (String)"\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", (Implementation)implementation, (String)"https://play.google.com/sdks", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ANNOTATION_PROCESSOR_ON_COMPILE_PATH = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AnnotationProcessorOnCompilePath", (String)"Annotation Processor on Compile Classpath", (String)"\n               This dependency is identified as an annotation processor. Consider adding it to the \\\n               processor path using `annotationProcessor` instead of including it to the \\\n               compile path.\n            ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.PRODUCTIVITY;
        object = Severity.INFORMATIONAL;
        implementation = IMPLEMENTATION;
        KTX_EXTENSION_AVAILABLE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"KtxExtensionAvailable", (String)"KTX Extension Available", (String)"\n                Android KTX extensions augment some libraries with support for modern Kotlin \\\n                language features like extension functions, extension properties, lambdas, named \\\n                parameters, coroutines, and more.\n\n                In Kotlin projects, use the KTX version of a library by replacing the \\\n                dependency in your `build.gradle` file. For example, you can replace \\\n                `androidx.fragment:fragment` with `androidx.fragment:fragment-ktx`.\n            ", (Implementation)implementation, (String)"https://developer.android.com/kotlin/ktx", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        JAVA_PLUGIN_LANGUAGE_LEVEL = Issue.Companion.create("JavaPluginLanguageLevel", "No Explicit Java Language Level Given", "\n                In modules using plugins deriving from the Gradle `java` plugin (e.g. \\\n                `java-library` or `application`), the java source and target compatibility \\\n                default to the version of the JDK being used to run Gradle, which may cause \\\n                compatibility problems with Android (or other) modules.\n\n                You can specify an explicit sourceCompatibility and targetCompatibility in this \\\n                module to maintain compatibility no matter which JDK is used to run Gradle.\n            ", Category.INTEROPERABILITY, 6, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        JCENTER_REPOSITORY_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"JcenterRepositoryObsolete", (String)"JCenter Maven repository is read-only", (String)"\n                The JCenter Maven repository is no longer accepting submissions of Maven \\\n                artifacts since 31st March 2021.  Ensure that the project is configured \\\n                to search in repositories with the latest versions of its dependencies.\n            ", (Implementation)implementation, (String)"https://developer.android.com/r/tools/jcenter-end-of-service", (Category)category, (int)8, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        PLAY_SDK_INDEX_NON_COMPLIANT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexNonCompliant", (String)"Library has policy issues in SDK Index", (String)"\n                This library version has policy issues that will block publishing in the Google Play Store.\n            ", (Implementation)implementation, (String)"https://play.google.com/sdks", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = new String[]{"java", "java-library", "application"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it, "org.gradle." + it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        JAVA_PLUGIN_IDS = (List)implementation;
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)"com.google.android.gms:play-services:6.5.0");
        Intrinsics.checkNotNull((Object)gradleCoordinate);
        PLAY_SERVICES_V650 = gradleCoordinate;
        objectArray = new String[]{"com.jakewharton:butterknife-compiler", "com.github.bumptech.glide:compiler", "androidx.databinding:databinding-compiler", "com.google.dagger:dagger-compiler", "com.google.auto.service:auto-service", "android.arch.persistence.room:compiler", "android.arch.lifecycle:compiler", "io.realm:realm-annotations-processor", "com.google.dagger:dagger-android-processor", "androidx.room:room-compiler", "com.android.databinding:compiler", "androidx.lifecycle:lifecycle-compiler", "org.projectlombok:lombok", "com.google.auto.value:auto-value", "org.parceler:parceler", "com.github.hotchemi:permissionsdispatcher-processor", "com.alibaba:arouter-compiler", "org.androidannotations:androidannotations", "com.github.Raizlabs.DBFlow:dbflow-processor", "frankiesardo:icepick-processor", "org.greenrobot:eventbus-annotation-processor", "com.ryanharter.auto.value:auto-value-gson", "io.objectbox:objectbox-processor", "com.arello-mobile:moxy-compiler", "com.squareup.dagger:dagger-compiler", "io.realm:realm-android", "com.bluelinelabs:logansquare-compiler", "com.tencent.tinker:tinker-android-anno", "com.raizlabs.android:DBFlow-Compiler", "com.google.auto.factory:auto-factory", "com.airbnb:deeplinkdispatch-processor", "com.alipay.android.tools:androidannotations", "org.permissionsdispatcher:permissionsdispatcher-processor", "com.airbnb.android:epoxy-processor", "org.immutables:value", "com.github.stephanenicolas.toothpick:toothpick-compiler", "com.mindorks.android:placeholderview-compiler", "com.github.frankiesardo:auto-parcel-processor", "com.hannesdorfmann.fragmentargs:processor", "com.evernote:android-state-processor", "org.mapstruct:mapstruct-processor", "com.iqiyi.component.router:qyrouter-compiler", "com.iqiyi.component.mm:mm-compiler", "dk.ilios:realmfieldnameshelper", "com.lianjia.common.android.router2:compiler", "com.smile.gifshow.annotation:invoker_processor", "com.f2prateek.dart:dart-processor", "com.sankuai.waimai.router:compiler", "org.qiyi.card:card-action-compiler", "com.iqiyi.video:eventbus-annotation-processor", "ly.img.android.pesdk:build-processor", "org.apache.logging.log4j:log4j-core", "com.github.jokermonn:permissions4m", "com.arialyy.aria:aria-compiler", "com.smile.gifshow.annotation:provide_processor", "com.smile.gifshow.annotation:preference_processor", "com.smile.gifshow.annotation:plugin_processor", "org.inferred:freebuilder", "com.smile.gifshow.annotation:router_processor"};
        commonAnnotationProcessors = SetsKt.setOf((Object[])objectArray);
        playSdkIndexFactory = Companion.playSdkIndexFactory.1.INSTANCE;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "", "cookie", "(Ljava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class JavaPluginInfo {
        @NotNull
        private final Object cookie;

        public JavaPluginInfo(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.cookie = cookie;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final Object component1() {
            return this.cookie;
        }

        @NotNull
        public final JavaPluginInfo copy(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            return new JavaPluginInfo(cookie);
        }

        public static /* synthetic */ JavaPluginInfo copy$default(JavaPluginInfo javaPluginInfo, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = javaPluginInfo.cookie;
            }
            return javaPluginInfo.copy(object);
        }

        @NotNull
        public String toString() {
            return "JavaPluginInfo(cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            return this.cookie.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaPluginInfo)) {
                return false;
            }
            JavaPluginInfo javaPluginInfo = (JavaPluginInfo)other;
            return Intrinsics.areEqual((Object)this.cookie, (Object)javaPluginInfo.cookie);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0001H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "", "newerVersion", "Lcom/android/ide/common/repository/GradleVersion;", "newerVersionIsSafe", "", "safeReplacement", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "cookie", "(Lcom/android/ide/common/repository/GradleVersion;ZLcom/android/ide/common/repository/GradleVersion;Lcom/android/ide/common/repository/GradleCoordinate;ZLjava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "getDependency", "()Lcom/android/ide/common/repository/GradleCoordinate;", "()Z", "getNewerVersion", "()Lcom/android/ide/common/repository/GradleVersion;", "getNewerVersionIsSafe", "getSafeReplacement", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class AgpVersionCheckInfo {
        @NotNull
        private final GradleVersion newerVersion;
        private final boolean newerVersionIsSafe;
        @Nullable
        private final GradleVersion safeReplacement;
        @NotNull
        private final GradleCoordinate dependency;
        private final boolean isResolved;
        @NotNull
        private final Object cookie;

        public AgpVersionCheckInfo(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.newerVersion = newerVersion;
            this.newerVersionIsSafe = newerVersionIsSafe;
            this.safeReplacement = safeReplacement;
            this.dependency = dependency;
            this.isResolved = isResolved;
            this.cookie = cookie;
        }

        @NotNull
        public final GradleVersion getNewerVersion() {
            return this.newerVersion;
        }

        public final boolean getNewerVersionIsSafe() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion getSafeReplacement() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate getDependency() {
            return this.dependency;
        }

        public final boolean isResolved() {
            return this.isResolved;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final GradleVersion component1() {
            return this.newerVersion;
        }

        public final boolean component2() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion component3() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate component4() {
            return this.dependency;
        }

        public final boolean component5() {
            return this.isResolved;
        }

        @NotNull
        public final Object component6() {
            return this.cookie;
        }

        @NotNull
        public final AgpVersionCheckInfo copy(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            return new AgpVersionCheckInfo(newerVersion, newerVersionIsSafe, safeReplacement, dependency, isResolved, cookie);
        }

        public static /* synthetic */ AgpVersionCheckInfo copy$default(AgpVersionCheckInfo agpVersionCheckInfo, GradleVersion gradleVersion, boolean bl, GradleVersion gradleVersion2, GradleCoordinate gradleCoordinate, boolean bl2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                gradleVersion = agpVersionCheckInfo.newerVersion;
            }
            if ((n & 2) != 0) {
                bl = agpVersionCheckInfo.newerVersionIsSafe;
            }
            if ((n & 4) != 0) {
                gradleVersion2 = agpVersionCheckInfo.safeReplacement;
            }
            if ((n & 8) != 0) {
                gradleCoordinate = agpVersionCheckInfo.dependency;
            }
            if ((n & 0x10) != 0) {
                bl2 = agpVersionCheckInfo.isResolved;
            }
            if ((n & 0x20) != 0) {
                object = agpVersionCheckInfo.cookie;
            }
            return agpVersionCheckInfo.copy(gradleVersion, bl, gradleVersion2, gradleCoordinate, bl2, object);
        }

        @NotNull
        public String toString() {
            return "AgpVersionCheckInfo(newerVersion=" + this.newerVersion + ", newerVersionIsSafe=" + this.newerVersionIsSafe + ", safeReplacement=" + this.safeReplacement + ", dependency=" + this.dependency + ", isResolved=" + this.isResolved + ", cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            int result = this.newerVersion.hashCode();
            int n = this.newerVersionIsSafe ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.safeReplacement == null ? 0 : this.safeReplacement.hashCode());
            result = result * 31 + this.dependency.hashCode();
            int n2 = this.isResolved ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.cookie.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgpVersionCheckInfo)) {
                return false;
            }
            AgpVersionCheckInfo agpVersionCheckInfo = (AgpVersionCheckInfo)other;
            if (!Intrinsics.areEqual((Object)this.newerVersion, (Object)agpVersionCheckInfo.newerVersion)) {
                return false;
            }
            if (this.newerVersionIsSafe != agpVersionCheckInfo.newerVersionIsSafe) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.safeReplacement, (Object)agpVersionCheckInfo.safeReplacement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dependency, (Object)agpVersionCheckInfo.dependency)) {
                return false;
            }
            if (this.isResolved != agpVersionCheckInfo.isResolved) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cookie, (Object)agpVersionCheckInfo.cookie);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "COMPILE", "PROVIDED", "APK", "lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        @NotNull
        private final String deprecatedName;
        @NotNull
        private final String replacementName;
        @NotNull
        private final String deprecatedSuffix;
        @NotNull
        private final String replacementSuffix;
        public static final /* enum */ DeprecatedConfiguration COMPILE = new DeprecatedConfiguration("compile", "implementation");
        public static final /* enum */ DeprecatedConfiguration PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
        public static final /* enum */ DeprecatedConfiguration APK = new DeprecatedConfiguration("apk", "runtimeOnly");
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.usLocaleCapitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.usLocaleCapitalize((String)this.replacementName);
        }

        public final boolean matches(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix) + this.replacementSuffix;
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String value) {
            return Enum.valueOf(DeprecatedConfiguration.class, value);
        }

        static {
            $VALUES = deprecatedConfigurationArray = new DeprecatedConfiguration[]{DeprecatedConfiguration.COMPILE, DeprecatedConfiguration.PROVIDED, DeprecatedConfiguration.APK};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001yB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XJ\u001e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020XJ&\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\u0007JJ\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010^\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\n\b\u0002\u0010d\u001a\u0004\u0018\u00010\u0007J\u001a\u0010e\u001a\u0004\u0018\u00010G2\u0006\u0010f\u001a\u00020L2\u0006\u0010g\u001a\u00020)H\u0002J2\u0010h\u001a\u0004\u0018\u00010G2\u0006\u0010f\u001a\u00020L2\u0006\u0010i\u001a\u0002052\u000e\u0010j\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010k2\u0006\u0010l\u001a\u00020mH\u0007J\u0012\u0010n\u001a\u0004\u0018\u00010\u00072\u0006\u0010o\u001a\u00020\u0007H\u0007J\u0010\u0010p\u001a\u00020m2\u0006\u0010i\u001a\u00020\u0007H\u0002J\u0010\u0010q\u001a\u00020m2\u0006\u0010i\u001a\u00020\u0007H\u0002J\u0010\u0010r\u001a\u00020m2\u0006\u0010s\u001a\u00020\u0007H\u0002J\u0018\u0010t\u001a\u00020m2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0007H\u0002J\u0010\u0010x\u001a\u00020m2\u0006\u0010u\u001a\u00020vH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020)X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u0010\u0010.\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020)X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010+R\u0010\u00109\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020)X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010I\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010K\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020M0J8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bN\u0010\u0002\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010R\u00a8\u0006z"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "()V", "ACCIDENTAL_OCTAL", "Lcom/android/tools/lint/detector/api/Issue;", "AGP_DEPENDENCY", "ANDROID_WEAR_GROUP_ID", "", "ANNOTATION_PROCESSOR_ON_COMPILE_PATH", "APP_PLUGIN_ID", "BUNDLED_GMS", "COMPATIBILITY", "DATA_BINDING_WITHOUT_KAPT", "DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "DEPRECATED_LIBRARY", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "EXPIRED_TARGET_SDK_VERSION", "EXPIRING_TARGET_SDK_VERSION", "FIREBASE_GROUP_ID", "GMS_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "GRADLE_GETTER", "GRADLE_PLUGIN_COMPATIBILITY", "HIGH_APP_VERSION_CODE", "IDE_SUPPORT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "JAVA_PLUGIN_IDS", "", "getJAVA_PLUGIN_IDS", "()Ljava/util/List;", "JAVA_PLUGIN_LANGUAGE_LEVEL", "JCENTER_REPOSITORY_OBSOLETE", "KEY_COORDINATE", "KTX_EXTENSION_AVAILABLE", "LIB_PLUGIN_ID", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "MINIMUM_TARGET_SDK_VERSION", "", "getMINIMUM_TARGET_SDK_VERSION", "()I", "MINIMUM_TARGET_SDK_VERSION_YEAR", "getMINIMUM_TARGET_SDK_VERSION_YEAR", "MIN_SDK_TOO_LOW", "NOT_INTERPOLATED", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "PATH", "PLAY_SDK_INDEX_NON_COMPLIANT", "PLAY_SERVICES_V650", "Lcom/android/ide/common/repository/GradleCoordinate;", "PLUS", "PREVIOUS_MINIMUM_TARGET_SDK_VERSION", "getPREVIOUS_MINIMUM_TARGET_SDK_VERSION", "REMOTE_VERSION", "RISKY_LIBRARY", "STRING_INTEGER", "VERSION_CODE_HIGH_THRESHOLD", "WEARABLE_ARTIFACT_ID", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "commonAnnotationProcessors", "", "latestBuildTools", "Lcom/android/ide/common/repository/GradleVersion;", "majorBuildTools", "playSdkIndexFactory", "Lkotlin/Function2;", "Ljava/nio/file/Path;", "Lcom/android/tools/lint/client/api/LintClient;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "getPlaySdkIndexFactory$annotations", "getPlaySdkIndexFactory", "()Lkotlin/jvm/functions/Function2;", "setPlaySdkIndexFactory", "(Lkotlin/jvm/functions/Function2;)V", "getDependencyLocation", "Lcom/android/tools/lint/detector/api/Location;", "context", "Lcom/android/tools/lint/detector/api/Context;", "c", "Lcom/android/tools/lint/model/LintModelMavenName;", "address1", "address2", "groupId", "artifactId", "version", "groupId1", "artifactId1", "version1", "groupId2", "artifactId2", "version2", "message", "getLatestBuildTools", "client", "major", "getLatestVersionFromRemoteRepo", "dependency", "filter", "Ljava/util/function/Predicate;", "allowPreview", "", "getNamedDependency", "expression", "hasLifecycleAnnotationProcessor", "isCommonAnnotationProcessor", "libraryHasKtxExtension", "mavenName", "suggestApiConfigurationUse", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "targetJava8Plus", "CompileConfiguration", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        public final int getMINIMUM_TARGET_SDK_VERSION() {
            return MINIMUM_TARGET_SDK_VERSION;
        }

        public final int getPREVIOUS_MINIMUM_TARGET_SDK_VERSION() {
            return PREVIOUS_MINIMUM_TARGET_SDK_VERSION;
        }

        public final int getMINIMUM_TARGET_SDK_VERSION_YEAR() {
            return MINIMUM_TARGET_SDK_VERSION_YEAR;
        }

        @NotNull
        public final List<String> getJAVA_PLUGIN_IDS() {
            return JAVA_PLUGIN_IDS;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull LintModelMavenName c) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return this.getDependencyLocation(context, c.getGroupId(), c.getArtifactId(), c.getVersion());
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            LintClient client = context.getClient();
            File projectDir = context.getProject().getDir();
            String withoutQuotes = groupId + ":" + artifactId + ":" + version;
            Intrinsics.checkNotNullExpressionValue((Object)projectDir, (String)"projectDir");
            Location location = Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)withoutQuotes);
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)(groupId + ":" + artifactId + ":"));
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)artifactId);
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)groupId);
            return location;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull LintModelMavenName address1, @NotNull LintModelMavenName address2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)address1, (String)"address1");
            Intrinsics.checkNotNullParameter((Object)address2, (String)"address2");
            return com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(this, context, address1.getGroupId(), address1.getArtifactId(), address1.getVersion(), address2.getGroupId(), address2.getArtifactId(), address2.getVersion(), null, 128, null);
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId1, @NotNull String artifactId1, @NotNull String version1, @NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @Nullable String message2) {
            Location location1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)groupId1, (String)"groupId1");
                Intrinsics.checkNotNullParameter((Object)artifactId1, (String)"artifactId1");
                Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
                Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId2");
                Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId2");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
                location1 = this.getDependencyLocation(context, groupId1, artifactId1, version1);
                Location location2 = this.getDependencyLocation(context, groupId2, artifactId2, version2);
                if (location2.getStart() == null && Intrinsics.areEqual((Object)location1.getFile(), (Object)location2.getFile())) break block1;
                location1.setSecondary(location2);
                String string = message2;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    location2.setMessage(it);
                }
            }
            return location1;
        }

        public static /* synthetic */ Location getDependencyLocation$default(Companion companion, Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
            if ((n & 0x80) != 0) {
                string7 = null;
            }
            return companion.getDependencyLocation(context, string, string2, string3, string4, string5, string6, string7);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
            GradleVersion it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filter$iv2;
            GradleVersion version22;
            Object jre2;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            StringBuilder query = new StringBuilder();
            String encoding = Charsets.UTF_8.name();
            try {
                query.append("http://search.maven.org/solrsearch/select?q=g:%22");
                query.append(URLEncoder.encode(groupId, encoding));
                query.append("%22+AND+a:%22");
                query.append(URLEncoder.encode(artifactId, encoding));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            query.append("%22&core=gav");
            if (!Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava") && !Intrinsics.areEqual((Object)artifactId, (Object)"kotlinx-coroutines-core") && filter == null && allowPreview) {
                query.append("&rows=1");
            }
            query.append("&wt=json");
            String response = null;
            try {
                String string = query.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.toString()");
                response = Lint.readUrlDataAsString((LintClient)client, (String)string, (int)20000);
                if (response == null) {
                    return null;
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{dependency};
                client.log(null, "Could not connect to maven central to look up the latest available version for %1$s", objectArray);
                return null;
            }
            int index2 = StringsKt.indexOf$default((CharSequence)response, (String)"\"response\"", (int)0, (boolean)false, (int)6, null);
            List versions = new ArrayList();
            while (index2 != -1) {
                String substring;
                if ((index2 = StringsKt.indexOf$default((CharSequence)response, (String)"\"v\":", (int)index2, (boolean)false, (int)4, null)) == -1) continue;
                int start = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(index2 += 4), (boolean)false, (int)4, null) + 1;
                int end = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null);
                boolean bl = 0 <= start ? start < end : false;
                if (!bl) continue;
                Intrinsics.checkNotNullExpressionValue((Object)response.substring(start, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                GradleVersion revision = GradleVersion.tryParse((String)substring);
                if (revision == null) continue;
                versions.add(revision);
            }
            if (Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava")) {
                GradleVersion version = dependency.getVersion();
                if (version != null) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv3;
                    String string = version.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.toString()");
                    String suffix = string;
                    jre2 = getLatestVersionFromRemoteRepo.jre.1.INSTANCE;
                    Function1 android2 = getLatestVersionFromRemoteRepo.android.1.INSTANCE;
                    Iterable iterable = versions;
                    Object predicate$iv2 = StringsKt.endsWith$default((String)suffix, (String)"-jre", (boolean)false, (int)2, null) ? jre2 : android2;
                    boolean $i$f$filter = false;
                    void var19_33 = $this$filter$iv3;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        if (!((Boolean)predicate$iv2.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (GradleVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                }
            } else if (Intrinsics.areEqual((Object)artifactId, (Object)"kotlinx-coroutines-core") && (version22 = dependency.getVersion()) != null) {
                void $this$filterTo$iv$iv3;
                String string = version22.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.toString()");
                String suffix = string;
                jre2 = versions;
                Function1 predicate$iv = StringsKt.indexOf$default((CharSequence)suffix, (char)'-', (int)0, (boolean)false, (int)6, null) == -1 ? (Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GradleVersion it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$allowPreview || !it.isPreview()) {
                            String string = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"-native-mt", (boolean)false, (int)2, null)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                } : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt-2", (boolean)false, (int)2, null) ? (Function1)getLatestVersionFromRemoteRepo.2.INSTANCE : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt", (boolean)false, (int)2, null) ? (Function1)getLatestVersionFromRemoteRepo.3.INSTANCE : (Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GradleVersion it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$allowPreview || !it.isPreview()) {
                            String string = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"-native-mt", (boolean)false, (int)2, null)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }));
                boolean $i$f$filter = false;
                void predicate$iv2 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (GradleVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            }
            Iterable version22 = versions;
            boolean $i$f$filter = false;
            $this$filter$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GradleVersion)element$iv$iv;
                boolean bl = false;
                if (!(filter == null || filter.test(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GradleVersion)element$iv$iv;
                boolean bl = false;
                if (!(allowPreview || !it.isPreview())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (GradleVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                for (String property : splitter.split((CharSequence)expression)) {
                    String value;
                    int valueEnd;
                    Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
                    int colon = StringsKt.indexOf$default((CharSequence)property, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    if ((valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(++valueStart), (boolean)false, (int)4, null)) == -1) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)property.substring(valueStart, valueEnd), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ":" + artifact + ":" + version;
                }
            }
            return null;
        }

        private final GradleVersion getLatestBuildTools(LintClient client, int major) {
            if (major != majorBuildTools) {
                File[] dirs;
                majorBuildTools = major;
                ArrayList<GradleVersion> revisions = new ArrayList<GradleVersion>();
                switch (major) {
                    case 267: {
                        revisions.add(new GradleVersion(27, 0, 3));
                        break;
                    }
                    case 26: {
                        revisions.add(new GradleVersion(26, 0, 3));
                        break;
                    }
                    case 25: {
                        revisions.add(new GradleVersion(25, 0, 3));
                        break;
                    }
                    case 24: {
                        revisions.add(new GradleVersion(24, 0, 3));
                        break;
                    }
                    case 23: {
                        revisions.add(new GradleVersion(23, 0, 3));
                        break;
                    }
                    case 22: {
                        revisions.add(new GradleVersion(22, 0, 1));
                        break;
                    }
                    case 21: {
                        revisions.add(new GradleVersion(21, 1, 2));
                        break;
                    }
                    case 20: {
                        revisions.add(new GradleVersion(20, 0));
                        break;
                    }
                    case 19: {
                        revisions.add(new GradleVersion(19, 1));
                        break;
                    }
                    case 18: {
                        revisions.add(new GradleVersion(18, 1, 1));
                    }
                }
                File sdkHome = client.getSdkHome();
                if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                    for (File dir : dirs) {
                        GradleVersion v;
                        String name = dir.getName();
                        if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleVersion.tryParse((String)name)) == null || v.getMajor() != major) continue;
                        revisions.add(v);
                    }
                }
                if (!((Collection)revisions).isEmpty()) {
                    latestBuildTools = (GradleVersion)Collections.max((Collection)revisions);
                }
            }
            return latestBuildTools;
        }

        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            boolean bl;
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                bl = false;
            } else {
                LintModelModuleType lintModelModuleType = project.getType();
                switch (lintModelModuleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelModuleType.ordinal()]) {
                    case 1: {
                        bl = project.hasDynamicFeatures();
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 6: {
                        bl = false;
                        break;
                    }
                    case 7: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return bl;
        }

        private final boolean targetJava8Plus(Project project) {
            return Lint.getLanguageLevel((Project)project, (LanguageLevel)LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private final boolean isCommonAnnotationProcessor(String dependency) {
            boolean bl;
            int index2 = StringsKt.lastIndexOf$default((CharSequence)dependency, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                bl = false;
            } else {
                Set set = commonAnnotationProcessors;
                String string = dependency.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                bl = set.contains(string);
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean libraryHasKtxExtension(String mavenName) {
            String string = mavenName;
            switch (string.hashCode()) {
                case -2871177: {
                    if (string.equals("androidx.palette:palette")) return true;
                    return false;
                }
                case 143019008: {
                    if (string.equals("androidx.paging:paging-runtime")) return true;
                    return false;
                }
                case 2126822828: {
                    if (string.equals("androidx.lifecycle:lifecycle-viewmodel")) return true;
                    return false;
                }
                case 268228117: {
                    if (string.equals("androidx.dynamicanimation:dynamicanimation")) return true;
                    return false;
                }
                case -264025202: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata")) return true;
                    return false;
                }
                case -1586715678: {
                    if (string.equals("androidx.lifecycle:lifecycle-reactivestreams")) return true;
                    return false;
                }
                case -1128017812: {
                    if (string.equals("androidx.navigation:navigation-ui")) return true;
                    return false;
                }
                case 72318654: {
                    if (string.equals("com.google.android.play:core")) return true;
                    return false;
                }
                case -1307799938: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata-core")) return true;
                    return false;
                }
                case 291543125: {
                    if (string.equals("androidx.activity:activity")) return true;
                    return false;
                }
                case 1493179093: {
                    if (string.equals("androidx.core:core")) return true;
                    return false;
                }
                case 1496698848: {
                    if (string.equals("androidx.lifecycle:lifecycle-runtime")) return true;
                    return false;
                }
                case -378178304: {
                    if (string.equals("androidx.navigation:navigation-runtime")) return true;
                    return false;
                }
                case -568948541: {
                    if (string.equals("androidx.paging:paging-common")) return true;
                    return false;
                }
                case -1453117067: {
                    if (string.equals("androidx.fragment:fragment")) return true;
                    return false;
                }
                case 224658418: {
                    if (string.equals("androidx.paging:paging-rxjava2")) return true;
                    return false;
                }
                case 346279413: {
                    if (string.equals("androidx.sqlite:sqlite")) return true;
                    return false;
                }
                case 1039658464: {
                    if (string.equals("androidx.slice:slice-builders")) return true;
                    return false;
                }
                case -1324096984: {
                    if (string.equals("androidx.navigation:navigation-fragment")) return true;
                    return false;
                }
                case 2032872629: {
                    if (string.equals("androidx.collection:collection")) return true;
                    return false;
                }
                case -1825909611: {
                    if (!string.equals("androidx.preference:preference")) return false;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
            return playSdkIndexFactory;
        }

        public final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            playSdkIndexFactory = function2;
        }

        @JvmStatic
        public static /* synthetic */ void getPlaySdkIndexFactory$annotations() {
        }

        public static final /* synthetic */ GradleVersion access$getLatestBuildTools(Companion $this, LintClient client, int major) {
            return $this.getLatestBuildTools(client, major);
        }

        public static final /* synthetic */ boolean access$hasLifecycleAnnotationProcessor(Companion $this, String dependency) {
            return $this.hasLifecycleAnnotationProcessor(dependency);
        }

        public static final /* synthetic */ boolean access$targetJava8Plus(Companion $this, Project project) {
            return $this.targetJava8Plus(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$CompileConfiguration;", "", "compileConfigName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "annotationProcessor", "compileConfigSuffix", "matches", "", "configurationName", "replacement", "API", "COMPILE", "IMPLEMENTATION", "COMPILE_ONLY", "lint-checks"})
        private static final class CompileConfiguration
        extends Enum<CompileConfiguration> {
            @NotNull
            private final String compileConfigName;
            @NotNull
            private final String annotationProcessor;
            @NotNull
            private final String compileConfigSuffix;
            public static final /* enum */ CompileConfiguration API = new CompileConfiguration("api");
            public static final /* enum */ CompileConfiguration COMPILE = new CompileConfiguration("compile");
            public static final /* enum */ CompileConfiguration IMPLEMENTATION = new CompileConfiguration("implementation");
            public static final /* enum */ CompileConfiguration COMPILE_ONLY = new CompileConfiguration("compileOnly");
            private static final /* synthetic */ CompileConfiguration[] $VALUES;

            private CompileConfiguration(String compileConfigName) {
                this.compileConfigName = compileConfigName;
                this.annotationProcessor = "annotationProcessor";
                this.compileConfigSuffix = StringHelper.usLocaleCapitalize((String)this.compileConfigName);
            }

            public final boolean matches(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) || StringsKt.endsWith$default((String)configurationName, (String)this.compileConfigSuffix, (boolean)false, (int)2, null);
            }

            @NotNull
            public final String replacement(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) ? this.annotationProcessor : StringHelper.appendCapitalized((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.compileConfigSuffix), (String)this.annotationProcessor);
            }

            public static CompileConfiguration[] values() {
                return (CompileConfiguration[])$VALUES.clone();
            }

            public static CompileConfiguration valueOf(String value) {
                return Enum.valueOf(CompileConfiguration.class, value);
            }

            static {
                $VALUES = compileConfigurationArray = new CompileConfiguration[]{CompileConfiguration.API, CompileConfiguration.COMPILE, CompileConfiguration.IMPLEMENTATION, CompileConfiguration.COMPILE_ONLY};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintModelModuleType.values().length];
                nArray[LintModelModuleType.APP.ordinal()] = 1;
                nArray[LintModelModuleType.LIBRARY.ordinal()] = 2;
                nArray[LintModelModuleType.JAVA_LIBRARY.ordinal()] = 3;
                nArray[LintModelModuleType.FEATURE.ordinal()] = 4;
                nArray[LintModelModuleType.DYNAMIC_FEATURE.ordinal()] = 5;
                nArray[LintModelModuleType.TEST.ordinal()] = 6;
                nArray[LintModelModuleType.INSTANT_APP.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

