/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelVariant;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/VectorDrawableCompatDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "skipChecks", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableAttributes", "", "", "getApplicableElements", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class VectorDrawableCompatDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean skipChecks;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.skipChecks = context.getProject().getMinSdk() >= 21;
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return !this.skipChecks && (folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT);
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"vector", "animated-vector"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context.getProject().getMinSdk() >= 21 || context.getResourceFolderType() != ResourceFolderType.DRAWABLE) {
            return;
        }
        LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
        Boolean bl2 = bl = lintModelVariant == null ? null : Boolean.valueOf(lintModelVariant.getUseSupportLibraryVectorDrawables());
        if (bl == null) {
            return;
        }
        boolean usingLibraryVectors = bl;
        String string = context.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
        String name = ResourcesUtil.fileNameToResourceName((String)string);
        context.getPartialResults(ISSUE).map().put(name, usingLibraryVectors);
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        Collection collection;
        if (this.skipChecks) {
            collection = null;
        } else {
            Object[] objectArray = new String[]{"src", "srcCompat"};
            collection = CollectionsKt.listOf((Object[])objectArray);
        }
        return collection;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (context.getResourceFolderType() != ResourceFolderType.LAYOUT) {
            return;
        }
        String name = attribute.getLocalName();
        String namespace = attribute.getNamespaceURI();
        if (Intrinsics.areEqual((Object)"src", (Object)name) && !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace) || Intrinsics.areEqual((Object)"srcCompat", (Object)name) && !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)namespace)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)attribute.getValue());
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        PartialResult partialResults = context.getPartialResults(ISSUE);
        String drawableName = resourceUrl2.name;
        LintMap lintMap = partialResults.map();
        Intrinsics.checkNotNullExpressionValue((Object)drawableName, (String)"drawableName");
        Boolean bl = LintMap.getBoolean$default((LintMap)lintMap, (String)drawableName, null, (int)2, null);
        if (bl == null) {
            return;
        }
        boolean useSupportLibrary = bl;
        if (useSupportLibrary && Intrinsics.areEqual((Object)"src", (Object)name)) {
            Location location = context.getNameLocation((Node)attribute);
            String message2 = "When using VectorDrawableCompat, you need to use `app:srcCompat`";
            Incident incident = new Incident(ISSUE, (Object)attribute, location, message2);
            context.report(incident, Constraints.minSdkLessThan((int)21));
        } else if (!useSupportLibrary && Intrinsics.areEqual((Object)"srcCompat", (Object)name)) {
            Location location = context.getNameLocation((Node)attribute);
            Project iconProject = context.getProject();
            if (LintMap.getBoolean$default((LintMap)partialResults.mapFor(iconProject), (String)drawableName, null, (int)2, null) == null) {
                for (Project project : partialResults.projects()) {
                    LintMap projectMap = partialResults.mapFor(project);
                    if (LintMap.getBoolean$default((LintMap)projectMap, (String)drawableName, null, (int)2, null) == null) continue;
                    iconProject = project;
                    break;
                }
            }
            String path = "build.gradle";
            LintModelModule model = iconProject.getBuildModule();
            if (model != null) {
                path = model.getModulePath() + File.separator + path;
            }
            String message3 = "To use VectorDrawableCompat, you need to set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in `" + path + '`';
            Incident incident = new Incident(ISSUE, (Object)attribute, location, message3);
            context.report(incident, Constraints.minSdkLessThan((int)21));
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        ISSUE = Issue.Companion.create("VectorDrawableCompat", "Using VectorDrawableCompat", "\n                To use VectorDrawableCompat, you need to make two modifications to your project. \\\n                First, set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in your \\\n                `build.gradle` file, and second, use `app:srcCompat` instead of `android:src` to \\\n                refer to vector drawables.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(VectorDrawableCompatDetector.class, Scope.ALL_RESOURCES_SCOPE, enumSetArray)).addMoreInfo("https://developer.android.com/guide/topics/graphics/vector-drawable-resources").addMoreInfo("https://medium.com/androiddevelopers/using-vector-assets-in-android-apps-4318fd662eb9");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/VectorDrawableCompatDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

