/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J0\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002JH\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002JH\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u001bH\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(H\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J8\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J6\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040(H\u0002J \u0010-\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/TypoDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "language", "", "lastLanguage", "lastRegion", "lookup", "Lcom/android/tools/lint/checks/TypoLookup;", "region", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "check", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "node", "Lorg/w3c/dom/Node;", "text", "checkForExclamation", "index", "", "begin", "checkRepeatedWords", "lastWordBegin", "lastWordEnd", "end", "checkUtf8Text", "utf8Text", "", "byteStart", "byteEnd", "charStart", "getApplicableElements", "", "initLocale", "reportRepeatedWord", "reportTypo", "replacements", "visit", "parent", "visitElement", "Companion", "lint-checks"})
public final class TypoDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TypoLookup lookup;
    @Nullable
    private String lastLanguage;
    @Nullable
    private String lastRegion;
    @Nullable
    private String language;
    @Nullable
    private String region;
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("Typos", "Spelling error", "\n                This check looks through the string definitions, and if it finds any words \\\n                that look like likely misspellings, they are flagged.", Category.MESSAGES, 7, Severity.WARNING, new Implementation(TypoDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    private final void initLocale(XmlContext context) {
        LocaleQualifier locale;
        LocaleQualifier localeQualifier = locale = Lint.getLocale((XmlContext)context);
        if (localeQualifier == null ? false : localeQualifier.hasLanguage()) {
            this.language = locale.getLanguage();
            this.region = locale.hasRegion() ? locale.getRegion() : null;
        }
    }

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initLocale((XmlContext)context);
        String string = this.language;
        if (string == null) {
            string = this.language = "en";
        }
        if (Intrinsics.areEqual((Object)this.lastLanguage, (Object)this.language) || this.region == null || !Intrinsics.areEqual((Object)this.lastRegion, (Object)this.region)) {
            LintClient lintClient = context.getClient();
            String string2 = this.language;
            Intrinsics.checkNotNull((Object)string2);
            this.lookup = TypoLookup.Companion.get(lintClient, string2, this.region);
            this.lastLanguage = this.language;
            this.lastRegion = this.region;
        }
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.lookup == null) {
            return;
        }
        this.visit(context, element, element);
    }

    private final void visit(XmlContext context, Element parent, Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 3 || nodeType == 4) {
            String string = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeValue");
            this.check(context, parent, node, string);
        } else {
            Iterator iterator = DomExtensions.childrenIterator((Node)node);
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                this.visit(context, parent, child);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void check(XmlContext context, Element element, Node node, String text) {
        int wordStart;
        int n;
        boolean checkedTypos;
        int lastWordEnd;
        int lastWordBegin;
        int max;
        block19: {
            int n2;
            if (!TypoDetector.Companion.isTranslatable(element)) {
                return;
            }
            max = text.length();
            lastWordBegin = -1;
            lastWordEnd = -1;
            checkedTypos = false;
            CharSequence $this$indexOfFirst$iv = text;
            boolean $i$f$indexOfFirst = false;
            int n3 = 0;
            n = $this$indexOfFirst$iv.length();
            while (n3 < n) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) {
                    n2 = index$iv;
                    break block19;
                }
                ++index$iv;
            }
            n2 = wordStart = -1;
        }
        if (wordStart == -1) {
            return;
        }
        char it = text.charAt(wordStart);
        int n4 = 0;
        boolean bl = it == '@' || it == '?';
        if (bl) {
            return;
        }
        int index = wordStart;
        while (index < max) {
            while (index < max) {
                char c = text.charAt(index);
                if (c == '\\') {
                    index += 2;
                    continue;
                }
                if (Character.isLetter(c)) break;
                n4 = index;
                index = n4 + 1;
            }
            if (index >= max) {
                return;
            }
            int begin = index;
            while (index < max) {
                char c = text.charAt(index);
                if (c == '\\') {
                    n = index;
                    index = n + 1;
                    break;
                }
                if (!Character.isLetter(c) && c != '_') {
                    if (c != '1' && c != '!' || index <= begin + 1) break;
                    this.checkForExclamation(context, node, text, index, begin);
                    break;
                }
                if (text.charAt(index) >= '\u0080') {
                    if (checkedTypos) {
                        String string = text;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.substring(begin);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        String string3 = string2;
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string4.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] utf8Text = byArray;
                        this.checkUtf8Text(context, element, node, utf8Text, 0, utf8Text.length, text, begin);
                    } else {
                        String string = text;
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        String string5 = string;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string5.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] utf8Text = byArray;
                        this.checkUtf8Text(context, element, node, utf8Text, 0, utf8Text.length, text, 0);
                    }
                    return;
                }
                int utf8Text = index;
                index = utf8Text + 1;
            }
            int end = index;
            checkedTypos = true;
            TypoLookup typoLookup = this.lookup;
            Intrinsics.checkNotNull((Object)typoLookup);
            List<String> replacements = typoLookup.getTypos(text, begin, end);
            if (replacements != null) {
                this.reportTypo(context, node, text, begin, replacements);
            }
            this.checkRepeatedWords(context, element, node, text, lastWordBegin, lastWordEnd, begin, end);
            lastWordBegin = begin;
            lastWordEnd = end;
            index = end + 1;
        }
    }

    private final void checkForExclamation(XmlContext context, Node node, String text, int index, int begin) {
        boolean problem = true;
        boolean found1 = text.charAt(index) == '1';
        int end = index + 1;
        CharSequence charSequence = text.subSequence(index + 1, text.length());
        int n = 0;
        while (n < charSequence.length()) {
            char ch = charSequence.charAt(n);
            ++n;
            if (ch == '\n') break;
            if (ch == '1') {
                found1 = true;
            } else if (ch != '!' && !CharsKt.isWhitespace((char)ch)) {
                if (Character.isLowerCase(ch) || Character.isDigit(ch)) {
                    problem = false;
                    break;
                }
                if (ch != ',' && ch != '.' && ch != ':' && ch != ';') break;
                problem = false;
                break;
            }
            int n2 = end;
            end = n2 + 1;
        }
        if (problem && found1) {
            String string = text;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(begin, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String actual = string2;
            String intended = StringsKt.replace$default((String)actual, (char)'1', (char)'!', (boolean)false, (int)4, null);
            LintFix fix = this.fix().name("Replace with \"" + intended + '\"').replace().text(actual).with(intended).range(context.getLocation(node)).build();
            context.report(ISSUE, node, context.getLocation(node, begin, index), "Did you mean \"" + intended + "\" instead of \"" + actual + "\"?", fix);
        }
    }

    private final void checkRepeatedWords(XmlContext context, Element element, Node node, String text, int lastWordBegin, int lastWordEnd, int begin, int end) {
        if (lastWordBegin != -1 && end - begin == lastWordEnd - lastWordBegin && end - begin > 1) {
            boolean different = false;
            int i = lastWordBegin;
            int j = begin;
            while (i < lastWordEnd) {
                if (text.charAt(i) != text.charAt(j)) {
                    different = true;
                    break;
                }
                int n = i;
                i = n + 1;
                n = j;
                j = n + 1;
            }
            if (!different && TypoDetector.Companion.onlySpace(text, lastWordEnd, begin) && TypoDetector.Companion.isTranslatable(element)) {
                this.reportRepeatedWord(context, node, text, lastWordBegin, begin, end);
            }
        }
    }

    private final void checkUtf8Text(XmlContext context, Element element, Node node, byte[] utf8Text, int byteStart, int byteEnd, String text, int charStart) {
        int charStart2 = charStart;
        int lastWordBegin = -1;
        int lastWordEnd = -1;
        int index = byteStart;
        while (index < byteEnd) {
            while (index < byteEnd) {
                int n;
                byte b = utf8Text[index];
                if (b == 92) {
                    n = index;
                    index = n + 1;
                    n = charStart2;
                    charStart2 = n + 1;
                    if (index < byteEnd) {
                        b = utf8Text[index];
                    }
                } else if (TypoLookup.Companion.isLetter(b)) break;
                n = index;
                index = n + 1;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                n = charStart2;
                charStart2 = n + 1;
            }
            if (index >= byteEnd) {
                return;
            }
            int charEnd = charStart2;
            int begin = index;
            while (index < byteEnd) {
                byte b = utf8Text[index];
                if (b == 92) {
                    int n = index;
                    index = n + 1;
                    n = charEnd;
                    charEnd = n + 1;
                    if (index >= byteEnd) break;
                    n = index;
                    index = n + 1;
                    b = utf8Text[n];
                    if ((b & 0x80) != 0 && (b & 0xC0) != 192) break;
                    n = charEnd;
                    charEnd = n + 1;
                    break;
                }
                if (!TypoLookup.Companion.isLetter(b)) break;
                int n = index;
                index = n + 1;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                n = charEnd;
                charEnd = n + 1;
            }
            int end = index;
            TypoLookup typoLookup = this.lookup;
            Intrinsics.checkNotNull((Object)typoLookup);
            List<String> replacements = typoLookup.getTypos(utf8Text, begin, end);
            if (replacements != null && TypoDetector.Companion.isTranslatable(element)) {
                this.reportTypo(context, node, text, charStart2, replacements);
            }
            this.checkRepeatedWords(context, element, node, text, lastWordBegin, lastWordEnd, charStart2, charEnd);
            lastWordBegin = charStart2;
            lastWordEnd = charEnd;
            charStart2 = charEnd;
        }
    }

    private final void reportTypo(XmlContext context, Node node, String text, int begin, List<String> replacements) {
        String string;
        if (replacements.size() < 2) {
            return;
        }
        String typo = replacements.get(0);
        String string2 = text;
        int n = begin + typo.length();
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(begin, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String word = string4;
        String first = null;
        String message2 = null;
        LintFix.GroupBuilder fixBuilder = this.fix().alternatives();
        boolean isCapitalized = Character.isUpperCase(word.charAt(0));
        StringBuilder sb = new StringBuilder(40);
        int i = 1;
        int n2 = replacements.size();
        while (i < n2) {
            String replacement = replacements.get(i);
            if (first == null) {
                first = replacement;
            }
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append('\"');
            if (isCapitalized) {
                replacement = StringHelper.usLocaleCapitalize((String)replacement);
            }
            sb.append(replacement);
            fixBuilder.add(this.fix().name("Replace with \"" + replacement + '\"').replace().text(word).with(replacement).build());
            sb.append('\"');
            int n3 = i;
            i = n3 + 1;
        }
        LintFix fix = fixBuilder.build();
        if (first != null && StringsKt.equals((String)first, (String)word, (boolean)true)) {
            if (Intrinsics.areEqual((Object)first, (Object)word)) {
                return;
            }
            string = '\"' + word + "\" is usually capitalized as \"" + first + '\"';
        } else {
            string = '\"' + word + "\" is a common misspelling; did you mean " + sb + '?';
        }
        message2 = string;
        int end = begin + word.length();
        context.report(ISSUE, node, context.getLocation(node, begin, end), message2, fix);
    }

    private final void reportRepeatedWord(XmlContext context, Node node, String text, int lastWordBegin, int begin, int end) {
        String string = text;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(begin, end);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String word = string2;
        if (TypoDetector.Companion.isAllowed(word)) {
            return;
        }
        String message2 = "Repeated word \"" + word + "\" in message: possible typo";
        String replace = lastWordBegin > 1 && text.charAt(lastWordBegin - 1) == ' ' ? Intrinsics.stringPlus((String)" ", (Object)word) : (end < text.length() - 1 && text.charAt(end) == ' ' ? Intrinsics.stringPlus((String)word, (Object)" ") : word);
        LintFix fix = this.fix().name("Delete repeated word").replace().text(replace).with("").build();
        Location location = context.getLocation(node, lastWordBegin, end);
        context.report(ISSUE, node, location, message2, fix);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/TypoDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "isAllowed", "", "word", "", "isTranslatable", "element", "Lorg/w3c/dom/Element;", "onlySpace", "text", "fromInclusive", "", "toExclusive", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean onlySpace(String text, int fromInclusive, int toExclusive) {
            int n = fromInclusive;
            while (n < toExclusive) {
                int i;
                if (CharsKt.isWhitespace((char)text.charAt(i = n++))) continue;
                return false;
            }
            return true;
        }

        private final boolean isTranslatable(Element element) {
            Attr translatable = element.getAttributeNode("translatable");
            return translatable == null || Intrinsics.areEqual((Object)translatable.getValue(), (Object)"true");
        }

        private final boolean isAllowed(String word) {
            if (Character.isUpperCase(word.charAt(0))) {
                return true;
            }
            switch (word) {
                case "that": 
                case "no": 
                case "night": 
                case "dot": 
                case "choo": 
                case "tsk": 
                case "yadda": 
                case "bye": {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

