/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "checkTileProvider", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "service", "Lorg/w3c/dom/Element;", "getApplicableElements", "", "", "visitElement", "Issues", "lint-checks"})
public final class TileProviderDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String BIND_TILE_PROVIDER_PERMISSION = "com.google.android.wearable.permission.BIND_TILE_PROVIDER";
    @NotNull
    public static final String BIND_TILE_PROVIDER_ACTION = "androidx.wear.tiles.action.BIND_TILE_PROVIDER";

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element service) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Element intentFilter = XmlUtils.getFirstSubTagByName((Node)service, (String)"intent-filter");
        while (intentFilter != null) {
            Element action = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"action");
            while (action != null) {
                if (Intrinsics.areEqual((Object)action.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)BIND_TILE_PROVIDER_ACTION)) {
                    this.checkTileProvider(context, service);
                    return;
                }
                action = XmlUtils.getNextTagByName((Node)action, (String)"action");
            }
            intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
        }
    }

    private final void checkTileProvider(XmlContext context, Element service) {
        String permission = service.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
        if (!Intrinsics.areEqual((Object)permission, (Object)BIND_TILE_PROVIDER_PERMISSION)) {
            LintFix.SetAttributeBuilder setAttributeBuilder = this.fix().set().attribute("permission").value(BIND_TILE_PROVIDER_PERMISSION).android();
            Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"permission");
            CharSequence charSequence = permission;
            boolean bl = false;
            LintFix fix = setAttributeBuilder.name(charSequence.length() == 0 ? "Add BIND_TILE_PROVIDER permission" : "Change permission to BIND_TILE_PROVIDER").build();
            context.report(new Incident(ISSUE, (Object)service, context.getNameLocation((Node)service), "TileProvider does not specify BIND_TILE_PROVIDER permission", fix));
        }
    }

    static {
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(TileProviderDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"TileProviderPermissions", (String)"TileProvider does not set permission", (String)"\n                TileProviders should require the `com.google.android.wearable.permission.BIND_TILE_PROVIDER` \\\n                permission to prevent arbitrary apps from binding to it.\n            ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$Issues;", "", "()V", "BIND_TILE_PROVIDER_ACTION", "", "BIND_TILE_PROVIDER_PERMISSION", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

