/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.CharSequences;
import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "checkEscapes", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "contents", "", "line", "", "offset", "", "valueStart", "checkLine", "checkNewerVersion", "isGitIgnored", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "run", "Companion", "lint-checks"})
public final class PropertyFileDetector
extends Detector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_VERSION_KEY = "android.experimental.lint.version";
    @JvmField
    @NotNull
    public static final Issue ESCAPE = Issue.Companion.create("PropertyEscape", "Incorrect property escapes", "\n                All backslashes and colons in .property files must be escaped with a \\\n                backslash (\\). This means that when writing a Windows path, you must \\\n                escape the file separators, so the path \\My\\Files should be written as \\\n                `key=\\\\My\\\\Files.`", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    @JvmField
    @NotNull
    public static final Issue HTTP = Issue.Companion.create("UsingHttp", "Using HTTP instead of HTTPS", "\n                The Gradle Wrapper is available both via HTTP and HTTPS. HTTPS is more \\\n                secure since it protects against man-in-the-middle attacks etc. Older \\\n                projects created in Android Studio used HTTP but we now default to HTTPS \\\n                and recommend upgrading existing projects.", Category.SECURITY, 6, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    @JvmField
    @NotNull
    public static final Issue PROXY_PASSWORD = Issue.Companion.create("ProxyPassword", "Proxy Password in Cleartext", "\n                Storing proxy server passwords in clear text is dangerous if this file is \\\n                shared via version control. If this is deliberate or this is a truly private \\\n                project, suppress this warning.", Category.SECURITY, 2, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));

    public void run(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        int offset = 0;
        Iterator iterator = Splitter.on((char)'\n').split(contents).iterator();
        String line = null;
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Intrinsics.checkNotNullExpressionValue(t, (String)"iterator.next()");
            line = (String)t;
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) {
                offset += line.length() + 1;
                continue;
            }
            int valueStart = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
            if (valueStart == 0) {
                offset += line.length() + 1;
                continue;
            }
            this.checkLine(context, contents, offset, line, valueStart);
            offset += line.length() + 1;
        }
    }

    private final void checkLine(Context context, CharSequence contents, int offset, String line, int valueStart) {
        String distributionPrefix = "distributionUrl=http\\";
        if (StringsKt.startsWith$default((String)line, (String)distributionPrefix, (boolean)false, (int)2, null)) {
            String string = line;
            int n = distributionPrefix.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String https = Intrinsics.stringPlus((String)"https", (Object)string3);
            String escaped = StringsKt.replace$default((String)https, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
            int startOffset = offset + valueStart;
            int endOffset = startOffset + 4;
            Incident incident = IncidentKt.Incident((Context)context, (Issue)HTTP).message(Intrinsics.stringPlus((String)"Replace HTTP with HTTPS for better security; use ", (Object)escaped)).fix(this.fix().replace().text("http").with("https").build()).location(Location.Companion.create(context.file, contents, startOffset, endOffset));
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        } else if (StringsKt.startsWith$default((String)line, (String)"systemProp.http.proxyPassword=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"systemProp.https.proxyPassword=", (boolean)false, (int)2, null)) {
            if (this.isGitIgnored(context.getClient(), context.file)) {
                return;
            }
            int startOffset = offset + valueStart;
            int endOffset = line.length();
            Incident incident = IncidentKt.Incident((Context)context, (Issue)PROXY_PASSWORD).message("Storing passwords in clear text is risky; make sure this file is not shared or checked in via version control").location(Location.Companion.create(context.file, contents, startOffset, endOffset));
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        } else if (StringsKt.indexOf$default((CharSequence)line, (char)'\\', (int)0, (boolean)false, (int)6, null) != -1 || StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
            this.checkEscapes(context, contents, line, offset, valueStart);
        } else if (StringsKt.startsWith$default((String)line, (String)LINT_VERSION_KEY, (boolean)false, (int)2, null)) {
            this.checkNewerVersion(context, contents, line);
        }
    }

    private final void checkNewerVersion(Context context, CharSequence contents, String line) {
        boolean allowPreview;
        GradleCoordinate gc;
        int n;
        int index;
        block12: {
            block11: {
                index = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index == -1) break block11;
                String string = line;
                int n2 = 0;
                n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string3;
                n2 = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string4)).toString(), (Object)LINT_VERSION_KEY)) break block12;
            }
            return;
        }
        CharSequence charSequence = line;
        n = index + 1;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        charSequence = string5;
        n = 0;
        String string6 = charSequence;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String versionString = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        charSequence = versionString;
        n = 0;
        if (charSequence.length() == 0) {
            return;
        }
        GradleVersion gradleVersion = GradleVersion.tryParse((String)versionString);
        if (gradleVersion == null) {
            return;
        }
        GradleVersion version = gradleVersion;
        GoogleMavenRepository repository2 = new GradleDetector().getGoogleMavenRepository(context.getClient());
        GradleVersion gradleVersion2 = repository2.findVersion(gc = new GradleCoordinate("com.android.tools.build", "gradle", versionString), null, allowPreview = true);
        if (gradleVersion2 == null) {
            return;
        }
        GradleVersion newerVersion = gradleVersion2;
        if (newerVersion.compareTo(version) > 0) {
            int startOffset = StringsKt.indexOf$default((CharSequence)contents, (String)versionString, (int)0, (boolean)false, (int)6, null);
            int endOffset = startOffset + versionString.length();
            String string7 = newerVersion.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"newerVersion.toString()");
            String newerVersionString = string7;
            LintFix fix = this.fix().name(Intrinsics.stringPlus((String)"Update lint to ", (Object)newerVersionString)).replace().all().with(newerVersionString).build();
            Location location = Location.Companion.create(context.file, contents, startOffset, endOffset);
            Incident incident = IncidentKt.Incident((Context)context, (Issue)GradleDetector.DEPENDENCY).location(location).message(Intrinsics.stringPlus((String)"Newer version of lint available: ", (Object)newerVersion)).fix(fix);
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        }
    }

    private final boolean isGitIgnored(LintClient client, File file) {
        for (File curr = file.getParentFile(); curr != null; curr = curr.getParentFile()) {
            CharSequence ignored;
            File ignoreFile = new File(curr, ".gitignore");
            if (!ignoreFile.exists() || CharSequences.indexOf((CharSequence)(ignored = client.readFile(ignoreFile)), (CharSequence)file.getName()) == -1) continue;
            return true;
        }
        return false;
    }

    private final void checkEscapes(Context context, CharSequence contents, String line, int offset, int valueStart) {
        char c2;
        boolean escaped = false;
        boolean hadNonPathEscape = false;
        int errorStart = -1;
        int errorEnd = -1;
        StringBuilder path = new StringBuilder();
        int n = valueStart;
        int n2 = line.length();
        if (n < n2) {
            do {
                int i;
                if ((c2 = line.charAt(i = n++)) == '\\') {
                    boolean bl = escaped = !escaped;
                    if (!escaped) continue;
                    path.append(c2);
                    continue;
                }
                if (c2 == ':') {
                    if (!escaped) {
                        hadNonPathEscape = true;
                        if (errorStart < 0) {
                            errorStart = i;
                        }
                        errorEnd = i;
                    } else {
                        escaped = false;
                    }
                    path.append(c2);
                    continue;
                }
                if (escaped) {
                    hadNonPathEscape = true;
                    if (errorStart < 0) {
                        errorStart = i;
                    }
                    errorEnd = i;
                }
                escaped = false;
                path.append(c2);
            } while (n < n2);
        }
        String string = path.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.toString()");
        String pathString = string;
        String i = line;
        c2 = '\u0000';
        int n3 = 0;
        String string2 = i;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(c2, valueStart);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String key = string3;
        if (hadNonPathEscape && StringsKt.endsWith$default((String)key, (String)".dir=", (boolean)false, (int)2, null) || new File(pathString).exists()) {
            String c2 = line;
            n3 = line.length();
            boolean bl = false;
            String string4 = c2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(valueStart, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String escapedPath = Companion.suggestEscapes(string5);
            String message2 = Intrinsics.stringPlus((String)"Windows file separators (`\\`) and drive letter separators (':') must be escaped (`\\\\`) in property files; use ", (Object)StringsKt.replace$default((String)escapedPath, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null));
            int startOffset = offset + errorStart;
            int endOffset = offset + errorEnd + 1;
            String locationRange = ((Object)contents.subSequence(startOffset, endOffset)).toString();
            String escapedRange = Companion.suggestEscapes(locationRange);
            LintFix fix = this.fix().name("Escape").replace().text(locationRange).with(escapedRange).build();
            Location location = Location.Companion.create(context.file, contents, startOffset, endOffset);
            Incident incident = IncidentKt.Incident((Context)context, (Issue)ESCAPE).message(message2).fix(fix).location(location);
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector$Companion;", "", "()V", "ESCAPE", "Lcom/android/tools/lint/detector/api/Issue;", "HTTP", "LINT_VERSION_KEY", "", "PROXY_PASSWORD", "isSuppressed", "", "issue", "source", "", "offset", "", "report", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "startOffset", "suggestEscapes", "value", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String suggestEscapes(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\\:", (String)":", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
            String string = SdkUtils.escapePropertyValue((String)escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapePropertyValue(escaped)");
            return string;
        }

        private final void report(Incident incident, CharSequence source, int startOffset) {
            if (this.isSuppressed(incident.getIssue(), source, startOffset)) {
                return;
            }
            incident.report();
        }

        public final boolean isSuppressed(@NotNull Issue issue, @NotNull CharSequence source, int offset) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int prevLineEnd = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)offset, (boolean)false, (int)4, null) - 1;
            if (prevLineEnd < 0) {
                return false;
            }
            int n = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)prevLineEnd, (boolean)false, (int)4, null);
            int n2 = 0;
            boolean bl = false;
            int it = n;
            boolean bl2 = false;
            int prevLineBegin = it == -1 ? 0 : it;
            int suppress = StringsKt.indexOf$default((CharSequence)source, (String)"noinspection ", (int)prevLineBegin, (boolean)false, (int)4, null);
            return (0 <= suppress ? suppress < prevLineEnd : false) ? (0 <= (n2 = StringsKt.indexOf$default((CharSequence)source, (String)issue.getId(), (int)suppress, (boolean)false, (int)4, null)) ? n2 < prevLineEnd : false) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

