/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/FullBackupContentDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkSection", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "root", "Lorg/w3c/dom/Element;", "validateDomain", "", "element", "validatePath", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class FullBackupContentDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String DOMAIN_SHARED_PREF = "sharedpref";
    @NotNull
    private static final String DOMAIN_ROOT = "root";
    @NotNull
    private static final String DOMAIN_FILE = "file";
    @NotNull
    private static final String DOMAIN_DATABASE = "database";
    @NotNull
    private static final String DOMAIN_EXTERNAL = "external";
    @NotNull
    private static final String TAG_EXCLUDE = "exclude";
    @NotNull
    private static final String TAG_INCLUDE = "include";
    @NotNull
    private static final String TAG_FULL_BACKUP_CONTENT = "full-backup-content";
    @NotNull
    private static final String TAG_DATA_EXTRACTION_RULES = "data-extraction-rules";
    @NotNull
    private static final String ATTR_PATH = "path";
    @NotNull
    private static final String ATTR_DOMAIN = "domain";
    @NotNull
    private static final String[] VALID_DOMAINS;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        String rootTag = root.getTagName();
        if (Intrinsics.areEqual((Object)rootTag, (Object)TAG_FULL_BACKUP_CONTENT)) {
            this.checkSection(context, root);
        } else if (Intrinsics.areEqual((Object)rootTag, (Object)TAG_DATA_EXTRACTION_RULES)) {
            Iterator iterator = DomExtensions.iterator((Element)root);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                this.checkSection(context, child);
            }
        }
    }

    private final void checkSection(XmlContext context, Element root) {
        CharSequence path;
        boolean bl = false;
        List includes = new ArrayList();
        boolean bl2 = false;
        List excludes = new ArrayList();
        NodeList children = root.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element element = (Element)child;
                String tag = element.getTagName();
                if (Intrinsics.areEqual((Object)TAG_INCLUDE, (Object)tag)) {
                    includes.add(element);
                } else if (Intrinsics.areEqual((Object)TAG_EXCLUDE, (Object)tag)) {
                    excludes.add(element);
                } else {
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)("Unexpected element `<" + tag + ">`"), null, (int)16, null);
                }
            }
            int n2 = i;
            i = n2 + 1;
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((int)includes.size(), (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(includes.size, 4)");
        Multimap includePaths = (Multimap)arrayListMultimap;
        for (Element include : includes) {
            String domain = this.validateDomain(context, include);
            path = this.validatePath(context, include);
            if (domain == null) continue;
            includePaths.put((Object)domain, (Object)path);
        }
        for (Element exclude : excludes) {
            String string;
            String excludePath = this.validatePath(context, exclude);
            path = excludePath;
            boolean bl3 = false;
            if (path.length() == 0 || (string = this.validateDomain(context, exclude)) == null) continue;
            String domain = string;
            if (includePaths.isEmpty()) continue;
            boolean hasPrefix = false;
            Collection collection = includePaths.get((Object)domain);
            if (collection == null) continue;
            Collection included = collection;
            for (String includePath : included) {
                Intrinsics.checkNotNullExpressionValue((Object)includePath, (String)"includePath");
                if (!StringsKt.startsWith$default((String)excludePath, (String)includePath, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)includePath, (Object)".")) continue;
                if (Intrinsics.areEqual((Object)excludePath, (Object)includePath)) {
                    Attr attr = exclude.getAttributeNode(ATTR_PATH);
                    if (attr == null) continue;
                    Attr pathNode = attr;
                    Location location = context.getValueLocation(pathNode);
                    for (Element include : includes) {
                        Attr includePathNode = include.getAttributeNode(ATTR_PATH);
                        String includeDomain = include.getAttribute(ATTR_DOMAIN);
                        if (includePathNode == null || !Intrinsics.areEqual((Object)excludePath, (Object)includePathNode.getValue()) || !Intrinsics.areEqual((Object)domain, (Object)includeDomain)) continue;
                        Location earlier = context.getLocation((Node)includePathNode);
                        earlier.setMessage("Unnecessary/conflicting <include>");
                        location.setSecondary(earlier);
                    }
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)exclude, (Location)location, (String)("Include `" + excludePath + "` is also excluded"), null, (int)16, null);
                }
                hasPrefix = true;
                break;
            }
            if (hasPrefix) continue;
            Attr pathNode = exclude.getAttributeNode(ATTR_PATH);
            Node node = exclude;
            Intrinsics.checkNotNullExpressionValue((Object)pathNode, (String)"pathNode");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getValueLocation(pathNode), (String)('`' + excludePath + "` is not in an included path"), null, (int)16, null);
        }
    }

    private final String validatePath(XmlContext context, Element element) {
        String domain;
        Attr attr = element.getAttributeNode(ATTR_PATH);
        if (attr == null) {
            return "";
        }
        Attr pathNode = attr;
        String value = pathNode.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)"//", (boolean)false, (int)2, null)) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(pathNode), (String)"Paths are not allowed to contain `//`", null, (int)16, null);
        } else if (StringsKt.contains$default((CharSequence)value, (CharSequence)"..", (boolean)false, (int)2, null)) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(pathNode), (String)"Paths are not allowed to contain `..`", null, (int)16, null);
        } else if (StringsKt.contains$default((CharSequence)value, (CharSequence)"/", (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)DOMAIN_SHARED_PREF, (Object)(domain = element.getAttribute(ATTR_DOMAIN))) || Intrinsics.areEqual((Object)DOMAIN_DATABASE, (Object)domain))) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(pathNode), (String)("Subdirectories are not allowed for domain `" + domain + '`'), null, (int)16, null);
        }
        return value;
    }

    private final String validateDomain(XmlContext context, Element element) {
        Attr domainNode = element.getAttributeNode(ATTR_DOMAIN);
        if (domainNode == null) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)Intrinsics.stringPlus((String)"Missing domain attribute, expected one of ", (Object)ArraysKt.joinToString$default((Object[])VALID_DOMAINS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), null, (int)16, null);
            return null;
        }
        String domain = domainNode.getValue();
        for (String availableDomain : VALID_DOMAINS) {
            if (!Intrinsics.areEqual((Object)availableDomain, (Object)domain)) continue;
            return domain;
        }
        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(domainNode), (String)("Unexpected domain `" + domain + "`, expected one of " + ArraysKt.joinToString$default((Object[])VALID_DOMAINS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), null, (int)16, null);
        return domain;
    }

    static {
        String[] stringArray = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(FullBackupContentDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"FullBackupContent", (String)"Valid Full Backup Content File", (String)"\n                Ensures that `<data-extraction-rules`> and `<full-backup-content>` files, which configure \\\n                backup options, are valid.\n                ", (Implementation)implementation, (String)"https://android-developers.googleblog.com/2015/07/auto-backup-for-apps-made-simple.html", (Category)stringArray, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        stringArray = new String[]{DOMAIN_ROOT, DOMAIN_FILE, DOMAIN_DATABASE, DOMAIN_SHARED_PREF, DOMAIN_EXTERNAL};
        VALID_DOMAINS = stringArray;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/FullBackupContentDetector$Companion;", "", "()V", "ATTR_DOMAIN", "", "ATTR_PATH", "DOMAIN_DATABASE", "DOMAIN_EXTERNAL", "DOMAIN_FILE", "DOMAIN_ROOT", "DOMAIN_SHARED_PREF", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "TAG_DATA_EXTRACTION_RULES", "TAG_EXCLUDE", "TAG_FULL_BACKUP_CONTENT", "TAG_INCLUDE", "VALID_DOMAINS", "", "[Ljava/lang/String;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

