/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "checkExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "checkMethod", "declaration", "Lorg/jetbrains/uast/UMethod;", "defaultEquals", "", "type", "Lcom/intellij/psi/PsiClassType;", "Lorg/jetbrains/uast/UElement;", "isCastWithEquals", "Lorg/jetbrains/uast/UExpression;", "target", "Lcom/intellij/psi/PsiElement;", "visitClass", "Lorg/jetbrains/uast/UClass;", "withinCastWithEquals", "Companion", "lint-checks"})
public final class DiffUtilDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(DiffUtilDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{"android.support.v7.util.DiffUtil.ItemCallback", "androidx.recyclerview.widget.DiffUtil.ItemCallback", "android.support.v17.leanback.widget.DiffCallback", "androidx.leanback.widget.DiffCallback"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        for (UMethod method : declaration.getMethods()) {
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"areContentsTheSame") || evaluator.getParameterCount((PsiMethod)method) != 2) continue;
            this.checkMethod(context, method);
        }
    }

    private final void checkMethod(JavaContext context, UMethod declaration) {
        declaration.accept((UastVisitor)new AbstractUastVisitor(this, context){
            final /* synthetic */ DiffUtilDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                DiffUtilDetector.access$checkExpression(this.this$0, this.$context, node);
                return super.visitBinaryExpression(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                DiffUtilDetector.access$checkCall(this.this$0, this.$context, node);
                return super.visitCallExpression(node);
            }
        });
    }

    private final boolean defaultEquals(JavaContext context, UElement node) {
        PsiClass psiClass;
        PsiMethod resolved = null;
        UElement uElement = node;
        if (uElement instanceof UBinaryExpression) {
            resolved = ((UBinaryExpression)node).resolveOperator();
            if (resolved == null) {
                PsiType psiType = ((UBinaryExpression)node).getLeftOperand().getExpressionType();
                PsiClassType left = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                return this.defaultEquals(context, left);
            }
        } else if (uElement instanceof UCallExpression) {
            resolved = ((UCallExpression)node).resolve();
        } else {
            if (uElement instanceof UParenthesizedExpression) {
                return this.defaultEquals(context, (UElement)((UParenthesizedExpression)node).getExpression());
            }
            return false;
        }
        return Intrinsics.areEqual((uElement = resolved) == null ? null : ((psiClass = uElement.getContainingClass()) == null ? null : psiClass.getQualifiedName()), (Object)"java.lang.Object");
    }

    private final boolean defaultEquals(JavaContext context, PsiClassType type) {
        PsiMethod[] psiMethodArray;
        PsiClassType psiClassType = type;
        PsiMethod[] psiMethodArray2 = psiMethodArray = psiClassType == null ? null : psiClassType.resolve();
        if (psiMethodArray == null) {
            return false;
        }
        PsiMethod[] psiMethodArray3 = psiMethodArray;
        PsiMethod[] cls = psiMethodArray3;
        if (Lint.isKotlin((PsiElement)((PsiElement)cls)) && (context.getEvaluator().isSealed((PsiModifierListOwner)cls) || context.getEvaluator().isData((PsiModifierListOwner)cls))) {
            return false;
        }
        psiMethodArray = cls.findMethodsByName("equals", true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"cls.findMethodsByName(\"equals\", true)");
        for (PsiMethod m : psiMethodArray) {
            PsiParameter[] parameters;
            if (m == null || (parameters = m.getParameterList().getParameters()).length != 1 || !Intrinsics.areEqual((Object)parameters[0].getType().getCanonicalText(), (Object)"java.lang.Object")) continue;
            PsiClass psiClass = m.getContainingClass();
            return Intrinsics.areEqual((Object)(psiClass == null ? null : psiClass.getQualifiedName()), (Object)"java.lang.Object");
        }
        return false;
    }

    private final void checkCall(JavaContext context, UCallExpression node) {
        if (this.defaultEquals(context, (UElement)node)) {
            String string;
            String string2;
            if (this.withinCastWithEquals(context, (UExpression)node)) {
                return;
            }
            PsiType psiType = node.getReceiverType();
            String targetType = string2 = psiType == null ? "target" : ((string = psiType.getCanonicalText()) == null ? "target" : string);
            String message2 = Intrinsics.stringPlus((String)"Suspicious equality check: `equals()` is not implemented in ", (Object)targetType);
            Location location = context.getCallLocation(node, false, true);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
        }
    }

    private final boolean withinCastWithEquals(JavaContext context, UExpression node) {
        PsiElement target2;
        Object object;
        UExpression uExpression;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
        if (parent instanceof UQualifiedReferenceExpression) {
            parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
        }
        PsiElement psiElement = (uExpression = node) instanceof UCallExpression ? ((object = ((UCallExpression)node).getReceiver()) == null ? null : UastUtils.tryResolve((UElement)((UElement)object))) : (target2 = uExpression instanceof UBinaryExpression ? UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)node).getLeftOperand())) : null);
        if (parent instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)parent).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
            UExpression operand;
            List operands = ((UPolyadicExpression)parent).getOperands();
            object = operands.iterator();
            while (object.hasNext() && (operand = (UExpression)object.next()) != node) {
                if (!this.isCastWithEquals(context, operand, target2)) continue;
                return true;
            }
        }
        Class[] classArray = new Class[]{UMethod.class};
        UElement uElement = UastUtils.getParentOfType((UElement)((UElement)node), UIfExpression.class, (boolean)false, (Class[])classArray);
        Object object2 = object = uElement instanceof UIfExpression ? (UIfExpression)uElement : null;
        if (object == null) {
            return false;
        }
        Object ifStatement = object;
        UExpression condition = ifStatement.getCondition();
        return this.isCastWithEquals(context, condition, target2);
    }

    private final boolean isCastWithEquals(JavaContext context, UExpression node, PsiElement target2) {
        if (node instanceof UBinaryExpressionWithType) {
            PsiElement resolved;
            if (target2 != null && (resolved = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpressionWithType)node).getOperand()))) != null && !Intrinsics.areEqual((Object)target2, (Object)resolved) && !target2.isEquivalentTo(resolved)) {
                return false;
            }
            PsiType psiType = ((UBinaryExpressionWithType)node).getType();
            return !this.defaultEquals(context, psiType instanceof PsiClassType ? (PsiClassType)psiType : null);
        }
        if (node instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)node).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
            for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                if (!this.isCastWithEquals(context, operand, target2)) continue;
                return true;
            }
        } else if (node instanceof UParenthesizedExpression) {
            return this.isCastWithEquals(context, ((UParenthesizedExpression)node).getExpression(), target2);
        }
        return false;
    }

    private final void checkExpression(JavaContext context, UBinaryExpression node) {
        if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.IDENTITY_EQUALS) || Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) {
            PsiType psiType = node.getLeftOperand().getExpressionType();
            if (psiType == null) {
                return;
            }
            PsiType left = psiType;
            PsiType psiType2 = node.getRightOperand().getExpressionType();
            if (psiType2 == null) {
                return;
            }
            PsiType right = psiType2;
            if (left instanceof PsiClassType && right instanceof PsiClassType) {
                String message2;
                if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) {
                    if (this.defaultEquals(context, (UElement)node)) {
                        Location location;
                        if (this.withinCastWithEquals(context, (UExpression)node)) {
                            return;
                        }
                        message2 = Intrinsics.stringPlus((String)"Suspicious equality check: `equals()` is not implemented in ", (Object)((PsiClassType)left).getClassName());
                        UIdentifier uIdentifier = node.getOperatorIdentifier();
                        if (uIdentifier == null) {
                            location = null;
                        } else {
                            UIdentifier uIdentifier2 = uIdentifier;
                            boolean bl = false;
                            boolean bl2 = false;
                            UIdentifier it = uIdentifier2;
                            boolean bl3 = false;
                            location = context.getLocation((UElement)it);
                        }
                        Location location2 = location;
                        Location location3 = location2 == null ? context.getLocation((UElement)node) : location2;
                        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location3, (String)message2, null, (int)16, null);
                    }
                } else {
                    Location location;
                    message2 = Lint.isKotlin((PsiElement)node.getSourcePsi()) ? "Suspicious equality check: Did you mean `==` instead of `===` ?" : "Suspicious equality check: Did you mean `.equals()` instead of `==` ?";
                    UIdentifier uIdentifier = node.getOperatorIdentifier();
                    if (uIdentifier == null) {
                        location = null;
                    } else {
                        UIdentifier uIdentifier3 = uIdentifier;
                        boolean bl = false;
                        boolean bl4 = false;
                        UIdentifier it = uIdentifier3;
                        boolean bl5 = false;
                        location = context.getLocation((UElement)it);
                    }
                    Location location4 = location;
                    Location location5 = location4 == null ? context.getLocation((UElement)node) : location4;
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location5, (String)message2, null, (int)16, null);
                }
            }
        }
    }

    public static final /* synthetic */ void access$checkExpression(DiffUtilDetector $this, JavaContext context, UBinaryExpression node) {
        $this.checkExpression(context, node);
    }

    public static final /* synthetic */ void access$checkCall(DiffUtilDetector $this, JavaContext context, UCallExpression node) {
        $this.checkCall(context, node);
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DiffUtilEquals", (String)"Suspicious DiffUtil Equality", (String)"\n                `areContentsTheSame` is used by `DiffUtil` to produce diffs. If the \\\n                method is implemented incorrectly, such as using identity equals \\\n                instead of equals, or calling equals on a class that has not implemented \\\n                it, weird visual artifacts can occur.\n                ", (Implementation)implementation, (String)"https://issuetracker.google.com/116789824", (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

