/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.DomExtensions;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002DEB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J \u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010/\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020#H\u0002J\u0018\u00101\u001a\u00020\f2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u001dH\u0002J<\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00108\u001a\u0002092\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00182\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0018\u0010>\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J \u0010B\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010C\u001a\u00020#2\u0006\u0010)\u001a\u00020:H\u0016R\u0018\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "mAlreadyWarned", "", "", "sceneIds", "", "Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkProperty", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "propertyNameExpression", "Lorg/jetbrains/uast/UExpression;", "targetClass", "Lcom/intellij/psi/PsiClass;", "expectedType", "", "checkPropertyValueHolders", "expressions", "", "filterIncident", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findHolderConstruction", "Lorg/jetbrains/uast/UCallExpression;", "arg", "getApplicableElements", "", "getApplicableMethodNames", "getExpectedType", "method", "evaluatorIndex", "", "getMethodName", "prefix", "propertyName", "isHolderConstructionMethod", "callExpression", "isInSameCompilationUnit", "element1", "Lorg/jetbrains/uast/UElement;", "element2", "Lcom/intellij/psi/PsiElement;", "isShrinking", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/intellij/psi/PsiMethod;", "originalMessage", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "node", "Companion", "SceneReference", "lint-checks"})
public final class ObjectAnimatorDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<Object> mAlreadyWarned;
    @Nullable
    private List<SceneReference> sceneIds;
    @NotNull
    private static final String MOTION_LAYOUT_URI = "http://schemas.android.com/apk/res-auto";
    private static final AndroidxName KEEP_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Keep");
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING_KEEP;
    @JvmField
    @NotNull
    public static final Issue BROKEN_PROPERTY;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        PsiClassType psiClassType;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || Intrinsics.areEqual((Object)method.getName(), (Object)"ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        List expressions = node.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        PsiType psiType = TypeEvaluator.evaluate((UElement)((UElement)expressions.get(0)));
        PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        Object object = type.resolve();
        if (object == null) {
            return;
        }
        PsiType targetClass = psiType = object;
        object = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"method.name");
        Object methodName = object;
        if (Intrinsics.areEqual((Object)methodName, (Object)"ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context, (PsiClass)targetClass, expressions);
        } else {
            String string = this.getExpectedType(node, 2);
            if (string == null) {
                return;
            }
            String expectedType = string;
            this.checkProperty(context, (UExpression)expressions.get(1), (PsiClass)targetClass, expectedType);
        }
    }

    private final void checkPropertyValueHolders(JavaContext context, PsiClass targetClass, List<? extends UExpression> expressions) {
        int n = 1;
        int n2 = expressions.size();
        if (n < n2) {
            do {
                int i;
                UExpression arg;
                UCallExpression uCallExpression;
                if ((uCallExpression = this.findHolderConstruction(context, arg = expressions.get(i = n++))) == null) {
                    return;
                }
                UCallExpression holder = uCallExpression;
                List args = holder.getValueArguments();
                if (args.size() < 2) continue;
                String string = this.getExpectedType(holder, 1);
                if (string == null) {
                    return;
                }
                String expectedType = string;
                this.checkProperty(context, (UExpression)args.get(0), targetClass, expectedType);
            } while (n < n2);
        }
    }

    private final void checkProperty(JavaContext context, UExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        String string;
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)propertyNameExpression));
        String string2 = string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String property = string;
        String string3 = targetClass.getQualifiedName();
        if (string3 == null) {
            return;
        }
        object = string3;
        Object qualifiedName = object;
        if (StringsKt.indexOf$default((CharSequence)((CharSequence)qualifiedName), (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            return;
        }
        String methodName = this.getMethodName("set", property);
        PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
        PsiMethod[] psiMethodArray = methods;
        int n = 0;
        int n2 = psiMethodArray.length;
        while (n < n2) {
            PsiMethod m = psiMethodArray[n];
            ++n;
            if (m.getParameterList().getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m;
                }
                JavaEvaluator javaEvaluator = context.getEvaluator();
                Intrinsics.checkExpressionValueIsNotNull((Object)m, (String)"m");
                String[] stringArray = new String[]{expectedType};
                if (!javaEvaluator.parametersMatch(m, stringArray)) continue;
                bestMethod = m;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m;
        }
        if (bestMethod == null) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, null, "Could not find property setter method `" + methodName + "` on `" + (String)qualifiedName + '`', null);
            return;
        }
        if (!isExactMatch) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property does not match the expected signature (`public void " + methodName + '(' + expectedType + " arg`)", null);
        } else if (context.getEvaluator().isStatic((PsiModifierListOwner)bestMethod)) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property (" + (String)qualifiedName + '.' + methodName + ") should not be static", null);
        } else {
            PsiModifierListOwner owner = (PsiModifierListOwner)bestMethod;
            while (owner != null) {
                for (PsiAnnotation annotation : context.getEvaluator().getAllAnnotations(owner, false)) {
                    if (!Companion.getKEEP_ANNOTATION().isEquals(annotation.getQualifiedName())) continue;
                    return;
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
            }
            if (!this.isShrinking((Context)context)) {
                return;
            }
            LintFix.Builder builder = this.fix();
            String string4 = Companion.getKEEP_ANNOTATION().newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KEEP_ANNOTATION.newName()");
            LintFix fix = LintFix.Builder.annotate$default((LintFix.Builder)builder, (String)string4, (boolean)false, (int)2, null).range(context.getLocation((PsiElement)bestMethod)).build();
            this.report(context, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", fix);
        }
    }

    private final void report(JavaContext context, Issue issue, UExpression propertyNameExpression, PsiMethod method, String originalMessage, LintFix fix) {
        Set alreadyWarned;
        Set set;
        boolean bl;
        boolean reportOnMethod;
        String message2 = originalMessage;
        boolean bl2 = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        UExpression locationNode = reportOnMethod && method != null ? method : propertyNameExpression;
        Set set2 = this.mAlreadyWarned;
        if (set2 == null) {
            Set set3;
            ObjectAnimatorDetector objectAnimatorDetector = this;
            boolean bl3 = false;
            bl = false;
            ObjectAnimatorDetector $this$report_u24lambda_u2d0 = objectAnimatorDetector;
            boolean bl4 = false;
            Set set4 = Sets.newIdentityHashSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"newIdentityHashSet()");
            $this$report_u24lambda_u2d0.mAlreadyWarned = set3 = set4;
            set = set3;
        } else {
            set = alreadyWarned = set2;
        }
        if (alreadyWarned.contains(locationNode)) {
            return;
        }
        alreadyWarned.add((Object)locationNode);
        Location methodLocation = null;
        if (method != null && !(method instanceof PsiCompiledElement)) {
            Location location;
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                PsiElement psiElement = (PsiElement)nameIdentifier;
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                location = context.getRangeLocation(psiElement, 0, (PsiElement)psiParameterList, 0);
            } else {
                location = context.getNameLocation((PsiElement)method);
            }
            methodLocation = location;
        }
        Location location = null;
        if (reportOnMethod && methodLocation != null && method != null) {
            location = methodLocation;
            Location secondary = context.getLocation((UElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (this.isInSameCompilationUnit((UElement)propertyNameExpression, (PsiElement)method)) {
                secondary.setVisible(false);
            } else {
                bl = issue == MISSING_KEEP;
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String secondaryMessage = "The method referenced here (" + method.getName() + ") has not been annotated with `@Keep` which means it could be discarded or renamed in release builds";
                if (location == Location.NONE) {
                    location = secondary;
                    message2 = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else {
            location = context.getNameLocation((UElement)propertyNameExpression);
            if (methodLocation != null) {
                location = Location.withSecondary$default((Location)location, (Location)methodLocation, (String)"Property setter here", (boolean)false, (int)4, null);
            }
        }
        UElement owner = UastUtils.getParentOfType((UElement)((UElement)propertyNameExpression), UDeclaration.class, (boolean)false);
        if (owner != null && context.getDriver().isSuppressed(context, issue, owner)) {
            return;
        }
        context.report(issue, (PsiElement)method, location, message2, fix);
    }

    private final String getExpectedType(UCallExpression method, int evaluatorIndex) {
        String methodName;
        String string = Lint.getMethodName((UCallExpression)method);
        if (string == null) {
            return null;
        }
        switch (methodName = string) {
            case "ofInt": 
            case "ofArgb": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                String string2;
                List args = method.getValueArguments();
                if (args.size() <= evaluatorIndex) break;
                Object object = TypeEvaluator.evaluate((UElement)((UElement)args.get(evaluatorIndex)));
                if (object == null) {
                    return null;
                }
                PsiType evaluatorType = object;
                switch (evaluatorType.getCanonicalText()) {
                    case "android.animation.FloatEvaluator": {
                        string2 = "float";
                        break;
                    }
                    case "android.animation.FloatArrayEvaluator": {
                        string2 = "float[]";
                        break;
                    }
                    case "android.animation.IntEvaluator": 
                    case "android.animation.ArgbEvaluator": {
                        string2 = "int";
                        break;
                    }
                    case "android.animation.IntArrayEvaluator": {
                        string2 = "int[]";
                        break;
                    }
                    case "android.animation.PointFEvaluator": {
                        string2 = "android.graphics.PointF";
                        break;
                    }
                    default: {
                        string2 = null;
                    }
                }
                return string2;
            }
        }
        return null;
    }

    private final UCallExpression findHolderConstruction(JavaContext context, UExpression arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof UCallExpression) {
            if (this.isHolderConstructionMethod(context, (UCallExpression)arg)) {
                return (UCallExpression)arg;
            }
        } else if (arg instanceof UReferenceExpression) {
            UCallExpression selector;
            if (arg instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)arg).getSelector() instanceof UCallExpression && this.isHolderConstructionMethod(context, selector = (UCallExpression)((UQualifiedReferenceExpression)arg).getSelector())) {
                return selector;
            }
            PsiElement resolved = ((UReferenceExpression)arg).resolve();
            if (resolved instanceof PsiVariable) {
                UCallExpression callExpression;
                UExpression expression;
                PsiElement el;
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)arg);
                while (lastAssignment instanceof USimpleNameReferenceExpression && (el = ((USimpleNameReferenceExpression)lastAssignment).resolve()) instanceof PsiLocalVariable) {
                    lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)el, (UElement)lastAssignment);
                }
                if (lastAssignment instanceof UCallExpression) {
                    UExpression callExpression2 = lastAssignment;
                    if (this.isHolderConstructionMethod(context, (UCallExpression)callExpression2)) {
                        return (UCallExpression)callExpression2;
                    }
                } else if (lastAssignment instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)(expression = lastAssignment)).getSelector() instanceof UCallExpression && this.isHolderConstructionMethod(context, callExpression = (UCallExpression)((UQualifiedReferenceExpression)expression).getSelector())) {
                    return callExpression;
                }
            }
        }
        return null;
    }

    private final boolean isHolderConstructionMethod(JavaContext context, UCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = Lint.getMethodName((UCallExpression)callExpression);
        return referenceName != null && StringsKt.startsWith$default((String)referenceName, (String)"of", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)referenceName, (Object)"ofKeyframe") && (resolved = callExpression.resolve()) != null && context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private final boolean isInSameCompilationUnit(UElement element1, PsiElement element2) {
        PsiElement psi;
        PsiFile file;
        UFile containingFile = UastUtils.getContainingUFile((UElement)element1);
        UFile uFile = containingFile;
        PsiFile psiFile = file = uFile == null ? null : uFile.getPsi();
        if (file == null && (psi = element1.getPsi()) != null) {
            file = psi.getContainingFile();
        }
        return Intrinsics.areEqual((Object)file, (Object)element2.getContainingFile());
    }

    private final String getMethodName(String prefix, String propertyName) {
        block3: {
            block2: {
                if (propertyName == null) break block2;
                CharSequence charSequence = propertyName;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String string = propertyName;
        int n = 1;
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String theRest = string2;
        return prefix + firstLetter + theRest;
    }

    private final boolean isShrinking(Context context) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        LintModelModule model = project.getBuildModule();
        return model != null ? !model.neverShrinking() : true;
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[3];
        String string = SdkConstants.MOTION_LAYOUT.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MOTION_LAYOUT.oldName()");
        objectArray[0] = string;
        string = SdkConstants.MOTION_LAYOUT.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MOTION_LAYOUT.newName()");
        objectArray[1] = string;
        objectArray[2] = "CustomAttribute";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            String sceneReference = element.getAttributeNS(MOTION_LAYOUT_URI, "layoutDescription");
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneReference, (String)"sceneReference");
            CharSequence charSequence = sceneReference;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
            Object object = sceneReference;
            int n = StringsKt.indexOf$default((CharSequence)sceneReference, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl2 = false;
            String string = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String sceneName22 = string;
            object = DomExtensions.iterator((Element)element);
            while (object.hasNext()) {
                List list;
                boolean bl3;
                Object object2;
                Element view22 = (Element)object.next();
                String string2 = view22.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"view.tagName");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)".", (boolean)false, (int)2, null)) continue;
                String id = Lint.stripIdPrefix((String)view22.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
                CharSequence charSequence2 = id;
                boolean bl4 = false;
                if (!(charSequence2.length() > 0)) continue;
                Collection<ObjectAnimatorDetector> collection = this.sceneIds;
                if (collection == null) {
                    object2 = this;
                    bl3 = false;
                    boolean bl5 = false;
                    ObjectAnimatorDetector $this$visitElement_u24lambda_u2d1 = object2;
                    boolean bl6 = false;
                    ArrayList list2 = new ArrayList();
                    $this$visitElement_u24lambda_u2d1.sceneIds = list2;
                    list = list2;
                } else {
                    list = collection;
                }
                List list3 = list;
                collection = list3;
                object2 = view22.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"view.tagName");
                object2 = new SceneReference((String)object2, id, sceneName22);
                bl3 = false;
                collection.add((ObjectAnimatorDetector)((Object)object2));
            }
        } else {
            Element id;
            boolean sceneReference = context.getResourceFolderType() == ResourceFolderType.XML;
            boolean sceneName22 = false;
            boolean bl = false;
            if (_Assertions.ENABLED && !sceneReference) {
                boolean view22 = false;
                String view22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)view22));
            }
            List<SceneReference> sceneName22 = this.sceneIds;
            if (sceneName22 == null) {
                return;
            }
            List<SceneReference> ids = sceneName22;
            Attr attribute = element.getAttributeNodeNS(MOTION_LAYOUT_URI, "attributeName");
            Attr attr = attribute;
            if (attr == null) {
                return;
            }
            String attributeName = attribute.getValue();
            Node list3 = element.getParentNode();
            Element element2 = id = list3 instanceof Element ? (Element)list3 : null;
            if (id == null) {
                return;
            }
            Element parent = id;
            String parentId = Lint.stripIdPrefix((String)parent.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            String string = context.file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
            String sceneName = Lint.getBaseName((String)string);
            for (SceneReference s : ids) {
                if (!Intrinsics.areEqual((Object)parentId, (Object)s.getId()) || !Intrinsics.areEqual((Object)s.getScene(), (Object)sceneName)) continue;
                String viewClass = s.getViewClass();
                UastParser uastParser = context.getClient().getUastParser(context.getProject());
                JavaEvaluator evaluator = uastParser.getEvaluator();
                PsiClass list2 = evaluator.findClass(viewClass);
                if (list2 == null) continue;
                PsiClass targetClass = list2;
                String methodName = this.getMethodName("set", attributeName);
                PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
                Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
                PsiMethod[] psiMethodArray = methods;
                int n = 0;
                int n2 = psiMethodArray.length;
                while (n < n2) {
                    PsiMethod m = psiMethodArray[n];
                    ++n;
                    if (m.getParameterList().getParametersCount() != 1) continue;
                    PsiModifierListOwner owner = (PsiModifierListOwner)m;
                    while (owner != null) {
                        PsiModifierList modifierList = owner.getModifierList();
                        if (modifierList != null) {
                            PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"modifierList.annotations");
                            for (PsiAnnotation annotation : psiAnnotationArray) {
                                if (!Companion.getKEEP_ANNOTATION().isEquals(annotation.getQualifiedName())) continue;
                                return;
                            }
                        }
                        owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
                    }
                    if (!this.isShrinking((Context)context)) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"attribute");
                    Location location = context.getValueLocation(attribute);
                    LintDriver lintDriver = context.getDriver();
                    Project project = context.getProject();
                    Project project2 = context.getProject();
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)targetClass.getContainingFile().getVirtualFile());
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(targetClass.containingFile.virtualFile)");
                    JavaContext javaContext = new JavaContext(lintDriver, project, project2, file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)m, (String)"m");
                    location.withSecondary(uastParser.getLocation(javaContext, (PsiElement)m), "This method is accessed via reflection from a MotionScene (" + sceneName + ") so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", true);
                    Incident incident = new Incident(MISSING_KEEP, (Object)element, location, "This attribute references a method or property in custom view " + viewClass + " which is not annotated with `@Keep`; it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds");
                    context.report(incident, this.map());
                }
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        return this.isShrinking(context);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(ObjectAnimatorDetector.class, Scope.JAVA_AND_RESOURCE_FILES, enumSetArray);
        enumSetArray = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        MISSING_KEEP = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"AnimatorKeep", (String)"Missing @Keep for Animated Properties", (String)"\n                    When you use property animators, properties can be accessed via reflection. \\\n                    Those methods should be annotated with @Keep to ensure that during release \\\n                    builds, the methods are not potentially treated as unused and removed, or \\\n                    treated as internal only and get renamed to something shorter.\n\n                    This check will also flag other potential reflection problems it encounters, \\\n                    such as a missing property, wrong argument types, etc.\n                    ", (Implementation)implementation, null, (Category)enumSetArray, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        enumSetArray = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        BROKEN_PROPERTY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ObjectAnimatorBinding", (String)"Incorrect ObjectAnimator Property", (String)"\n                    This check cross references properties referenced by String from \\\n                    `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that \\\n                    the corresponding setter methods exist and have the right signatures.\n                    ", (Implementation)implementation, null, (Category)enumSetArray, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "", "viewClass", "", "id", "scene", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getScene", "getViewClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
    private static final class SceneReference {
        @NotNull
        private final String viewClass;
        @NotNull
        private final String id;
        @NotNull
        private final String scene;

        public SceneReference(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            this.viewClass = viewClass;
            this.id = id;
            this.scene = scene;
        }

        @NotNull
        public final String getViewClass() {
            return this.viewClass;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getScene() {
            return this.scene;
        }

        @NotNull
        public final String component1() {
            return this.viewClass;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.scene;
        }

        @NotNull
        public final SceneReference copy(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            return new SceneReference(viewClass, id, scene);
        }

        public static /* synthetic */ SceneReference copy$default(SceneReference sceneReference, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = sceneReference.viewClass;
            }
            if ((n & 2) != 0) {
                string2 = sceneReference.id;
            }
            if ((n & 4) != 0) {
                string3 = sceneReference.scene;
            }
            return sceneReference.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SceneReference(viewClass=" + this.viewClass + ", id=" + this.id + ", scene=" + this.scene + ')';
        }

        public int hashCode() {
            int result = this.viewClass.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + this.scene.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SceneReference)) {
                return false;
            }
            SceneReference sceneReference = (SceneReference)other;
            if (!Intrinsics.areEqual((Object)this.viewClass, (Object)sceneReference.viewClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)sceneReference.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scene, (Object)sceneReference.scene);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$Companion;", "", "()V", "BROKEN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEEP_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getKEEP_ANNOTATION", "()Lcom/android/support/AndroidxName;", "MISSING_KEEP", "MOTION_LAYOUT_URI", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final AndroidxName getKEEP_ANNOTATION() {
            return KEEP_ANNOTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

