/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.kotlin.KotlinUClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "()V", "checkedClasses", "", "", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkClassReference", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "pkg", "className", "classNameNode", "Lorg/w3c/dom/Node;", "element", "Lorg/w3c/dom/Element;", "requireInstantiatable", "expectedParent", "checkExpectedParent", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "nameNode", "cls", "Lcom/intellij/psi/PsiClass;", "checkInnerClassReference", "checkInstantiatable", "fqcn", "getApplicableElements", "", "getRefLocation", "Lcom/android/tools/lint/detector/api/Location;", "hasImplicitDefaultConstructor", "psiClass", "reportMissing", "location", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Companion", "lint-checks"})
public final class MissingClassDetector
extends LayoutDetector
implements ClassScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, Boolean> checkedClasses;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue INSTANTIATABLE;
    @JvmField
    @NotNull
    public static final Issue INNERCLASS;

    public MissingClassDetector() {
        boolean bl = false;
        this.checkedClasses = new LinkedHashMap();
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ALL");
        return list;
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.TRANSITION;
    }

    /*
     * Unable to fully structure code
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        tag = element.getTagName();
        var4_4 = context.getResourceFolderType();
        var5_5 = var4_4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var4_4.ordinal()];
        switch (var5_5) {
            case -1: {
                if (!Intrinsics.areEqual((Object)"application", (Object)tag) && !Intrinsics.areEqual((Object)"activity", (Object)tag) && !Intrinsics.areEqual((Object)"service", (Object)tag) && !Intrinsics.areEqual((Object)"receiver", (Object)tag) && !Intrinsics.areEqual((Object)"provider", (Object)tag)) break;
                var7_6 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (var7_6 == null) {
                    return;
                }
                attr = var7_6;
                pkg = context.getProject().getPackage();
                var8_22 = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)var8_22, (String)"attr.value");
                v0 = var8_22;
                v1 = attr;
                var8_22 = tag;
                if (var8_22 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var8_22.hashCode()) {
                    case -1655966961: {
                        if (var8_22.equals("activity")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -808719889: {
                        if (var8_22.equals("receiver")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1554253136: {
                        if (var8_22.equals("application")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -987494927: {
                        if (var8_22.equals("provider")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 1984153269: {
                        if (var8_22.equals("service")) {
                            tmp = 5;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v2 = "android.app.Activity";
                        break;
                    }
                    case 5: {
                        v2 = "android.app.Service";
                        break;
                    }
                    case 2: {
                        v2 = "android.content.BroadcastReceiver";
                        break;
                    }
                    case 4: {
                        v2 = "android.content.ContentProvider";
                        break;
                    }
                    case 3: {
                        v2 = "android.app.Application";
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                }
                this.checkClassReference(context, pkg, v0, v1, element, true, v2);
                break;
            }
            case 1: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"string") || !SdkUtils.endsWith((CharSequence)context.file.getPath(), (CharSequence)"analytics.xml")) break;
                pkg = element.getAttributeNode("name");
                if (pkg == null) {
                    return;
                }
                attr = pkg;
                pkg = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context, null, (String)pkg, attr, element, false, null, 96, null);
                break;
            }
            case 2: {
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
                if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                    MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                    break;
                }
                if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
                    pkg = element.getAttributeNode("class");
                    if (pkg == null) {
                        return;
                    }
                    attr = pkg;
                    pkg = attr.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pkg, (String)"attr.value");
                    MissingClassDetector.checkClassReference$default(this, context, null, (String)pkg, attr, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                    break;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"fragment")) break;
                var8_23 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                v3 = pkg = var8_23 == null ? element.getAttributeNode("class") : var8_23;
                if (pkg == null) {
                    return;
                }
                attr = pkg;
                pkg = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg, (String)"attr.value");
                this.checkClassReference(context, null, (String)pkg, attr, element, true, "android.app.Fragment");
                break;
            }
            case 3: {
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
                if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                    MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, null, 96, null);
                    break;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"drawable")) break;
                pkg = element.getAttributeNode("class");
                if (pkg == null) {
                    return;
                }
                attr = pkg;
                pkg = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context, null, (String)pkg, attr, element, false, "android.graphics.drawable.Drawable", 32, null);
                break;
            }
            case 4: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"transition") && !Intrinsics.areEqual((Object)tag, (Object)"pathMotion")) break;
                pkg = element.getAttributeNode("class");
                if (pkg == null) {
                    return;
                }
                attr = pkg;
                expectedParent = Intrinsics.areEqual((Object)tag, (Object)"transition") != false ? "android.transition.Transition" : "android.transition.PathMotion";
                var8_24 = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)var8_24, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context, null, var8_24, attr, element, false, expectedParent, 32, null);
                break;
            }
            case 5: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"header")) break;
                expectedParent = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
                if (expectedParent == null) {
                    return;
                }
                attr = expectedParent;
                expectedParent = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedParent, (String)"attr.value");
                this.checkClassReference(context, null, (String)expectedParent, attr, element, true, "android.app.Fragment");
                break;
            }
            case 6: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"item")) break;
                expectedParent = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionViewClass");
                v4 = view = expectedParent == null ? element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionViewClass") : expectedParent;
                if (view != null) {
                    expectedParent = view.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)expectedParent, (String)"view.value");
                    MissingClassDetector.checkClassReference$default(this, context, null, (String)expectedParent, view, element, false, "android.view.View", 32, null);
                }
                v5 = var8_25 = (var9_26 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionProviderClass")) == null ? element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionProviderClass") : var9_26;
                if (var8_25 == null) {
                    return;
                }
                provider = var8_25;
                var8_25 = provider.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)var8_25, (String)"provider.value");
                MissingClassDetector.checkClassReference$default(this, context, null, (String)var8_25, provider, element, false, null, 96, null);
            }
        }
    }

    private final void checkClassReference(XmlContext context, String pkg, String className, Node classNameNode, Element element, boolean requireInstantiatable, String expectedParent) {
        CharSequence charSequence = className;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        String fqcn = null;
        int dotIndex = StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? Intrinsics.stringPlus((String)pkg, (Object)className) : pkg + '.' + className;
        } else {
            fqcn = className;
        }
        if (StringsKt.startsWith$default((String)fqcn, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqcn, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            return;
        }
        Boolean ok = this.checkedClasses.get(fqcn);
        if (ok == null) {
            UastParser parser = context.getClient().getUastParser(context.getProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass cls = evaluator.findClass(StringsKt.replace$default((String)fqcn, (char)'$', (char)'.', (boolean)false, (int)4, null));
            if (cls != null) {
                ok = true;
                if (requireInstantiatable) {
                    this.checkInstantiatable(context, evaluator, cls, fqcn, classNameNode);
                }
                this.checkInnerClassReference(context, cls, className, classNameNode, element);
                if (expectedParent != null) {
                    this.checkExpectedParent(context, evaluator, classNameNode, cls, expectedParent);
                }
            } else {
                ok = false;
            }
            Map<String, Boolean> map = this.checkedClasses;
            boolean bl2 = false;
            map.put(fqcn, ok);
        }
        if (Intrinsics.areEqual((Object)ok, (Object)false)) {
            Location location = this.getRefLocation(context, classNameNode);
            this.reportMissing(location, fqcn, (Context)context);
        }
    }

    static /* synthetic */ void checkClassReference$default(MissingClassDetector missingClassDetector, XmlContext xmlContext, String string, String string2, Node node, Element element, boolean bl, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        missingClassDetector.checkClassReference(xmlContext, string, string2, node, element, bl, string3);
    }

    private final void checkExpectedParent(XmlContext context, JavaEvaluator evaluator, Node nameNode, PsiClass cls, String expectedParent) {
        if (!evaluator.inheritsFrom(cls, expectedParent, false)) {
            String name;
            PsiClass superTypes;
            PsiClass psiClass;
            if (Intrinsics.areEqual((Object)expectedParent, (Object)"android.app.Fragment")) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.oldName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.oldName()");
                this.checkExpectedParent(context, evaluator, nameNode, cls, string);
                return;
            }
            if (Intrinsics.areEqual((Object)expectedParent, (Object)SdkConstants.CLASS_V4_FRAGMENT.oldName())) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.newName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.newName()");
                this.checkExpectedParent(context, evaluator, nameNode, cls, string);
                return;
            }
            PsiClass psiClass2 = cls.getSuperClass();
            if (psiClass2 == null) {
                return;
            }
            PsiClass superClass = psiClass = psiClass2;
            psiClass2 = cls.getSuperTypes();
            if (psiClass2 == null) {
                return;
            }
            psiClass2 = superTypes = psiClass2;
            boolean bl = false;
            PsiClass psiClass3 = psiClass2;
            boolean bl2 = false;
            if (!(((PsiClassType[])psiClass3).length == 0) && (name = superTypes[0].getClassName()) != null && !Intrinsics.areEqual((Object)name, (Object)superClass.getName())) {
                return;
            }
            PsiClass curr = superClass;
            while (true) {
                String qualifiedName;
                if (Intrinsics.areEqual((Object)(qualifiedName = curr.getQualifiedName()), (Object)expectedParent)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.lang.Object")) break;
                psiClass3 = curr.getSuperClass();
                if (psiClass3 == null) {
                    return;
                }
                curr = psiClass3;
            }
            String message2 = StringsKt.contains$default((CharSequence)expectedParent, (CharSequence)"Fragment", (boolean)false, (int)2, null) ? '`' + cls.getName() + "` must be a fragment" : '`' + cls.getName() + "` must extend " + expectedParent;
            Context.report$default((Context)((Context)context), (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message2, null, (int)8, null);
        }
    }

    private final void checkInnerClassReference(XmlContext context, PsiClass cls, String className, Node nameNode, Element element) {
        String full;
        String string;
        String name = cls.getName();
        if (cls.getContainingClass() == null || name == null || StringsKt.contains$default((CharSequence)className, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return;
        }
        String string2 = Lint.getInternalName((PsiClass)cls);
        String string3 = string = string2 == null ? null : StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        if (string == null) {
            return;
        }
        string2 = full = string;
        int n = full.length() - className.length();
        boolean bl = false;
        String string4 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String fixed = string4;
        String message2 = "Use '$' instead of '.' for inner classes; replace \"" + className + "\" with \"" + fixed + '\"';
        Location location = this.getRefLocation(context, nameNode);
        LintFix fix = this.fix().replace().text(className).with(fixed).autoFix().build();
        context.report(INNERCLASS, (Node)element, location, message2, fix);
    }

    private final void checkInstantiatable(XmlContext context, JavaEvaluator evaluator, PsiClass cls, String fqcn, Node nameNode) {
        if (evaluator.isPrivate((PsiModifierListOwner)cls)) {
            String message2 = "This class should be public (`" + fqcn + "`)";
            Context.report$default((Context)((Context)context), (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message2, null, (int)8, null);
        } else if (cls.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)cls)) {
            String message3 = "This inner class should be static (`" + fqcn + "`)";
            Context.report$default((Context)((Context)context), (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message3, null, (int)8, null);
        } else {
            PsiMethod[] constructors = cls.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)constructors, (String)"constructors");
            PsiMethod[] psiMethodArray = constructors;
            boolean bl = false;
            if (psiMethodArray.length == 0 && this.hasImplicitDefaultConstructor(cls)) {
                return;
            }
            PsiMethod[] psiMethodArray2 = cls.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray2, (String)"cls.constructors");
            for (PsiMethod constructor : psiMethodArray2) {
                if (!constructor.getParameterList().isEmpty()) continue;
                if (evaluator.isPrivate((PsiModifierListOwner)constructor)) {
                    String message4 = "The default constructor must be public in `" + fqcn + '`';
                    Context.report$default((Context)((Context)context), (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message4, null, (int)8, null);
                    return;
                }
                return;
            }
            String message5 = "This class should provide a default constructor (a public constructor with no arguments) (`" + fqcn + "`)";
            Context.report$default((Context)((Context)context), (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message5, null, (int)8, null);
        }
    }

    private final Location getRefLocation(XmlContext context, Node nameNode) {
        return nameNode instanceof Attr ? context.getValueLocation((Attr)nameNode) : context.getLocation(nameNode);
    }

    private final boolean hasImplicitDefaultConstructor(PsiClass psiClass) {
        if (psiClass instanceof KotlinUClass && ((KotlinUClass)psiClass).getSourcePsi() == null) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)constructors, (String)"constructors");
        PsiMethod[] psiMethodArray = constructors;
        boolean bl = false;
        if (psiMethodArray.length == 0 && !psiClass.isInterface() && !psiClass.isAnnotationType() && !psiClass.isEnum()) {
            if (PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
                return true;
            }
            if (psiClass.hasModifierProperty("final") && !psiClass.hasModifierProperty("abstract") && psiClass.hasModifierProperty("public")) {
                return true;
            }
        }
        return false;
    }

    private final void reportMissing(Location location, String fqcn, Context context) {
        String string;
        File parentFile = location.getFile().getParentFile();
        if (parentFile != null) {
            String parent = parentFile.getName();
            ResourceFolderType type = ResourceFolderType.getFolderType((String)parent);
            int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n) {
                case -1: {
                    string = "manifest";
                    break;
                }
                case 2: {
                    string = "layout file";
                    break;
                }
                case 5: {
                    string = "preference header file";
                    break;
                }
                case 1: {
                    string = "analytics file";
                    break;
                }
                default: {
                    String string2 = type.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.getName()");
                    Locale locale = Locale.US;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"US");
                    boolean bl = false;
                    String string3 = string2;
                    boolean bl2 = false;
                    String string4 = string3.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    string = Intrinsics.stringPlus((String)string4, (Object)" file");
                    break;
                }
            }
        } else {
            string = "the manifest";
        }
        String target2 = string;
        String message2 = "Class referenced in the " + target2 + ", `" + fqcn + "`, was not found in the project or the libraries";
        Context.report$default((Context)context, (Issue)MISSING, (Location)location, (String)message2, null, (int)8, null);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(MissingClassDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray);
        enumSetArray = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = Companion.getIMPLEMENTATION();
        MISSING = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MissingClass", (String)"Missing registered class", (String)"\n                    If a class is referenced in the manifest or in a layout file, it must \\\n                    also exist in the project (or in one of the libraries included by the \\\n                    project. This check helps uncover typos in registration names, or \\\n                    attempts to rename or move classes without updating the XML references\n                    properly.\n                    ", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/manifest/manifest-intro.html", (Category)enumSetArray, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null).setAliases(CollectionsKt.listOf((Object)"MissingRegistered"));
        enumSetArray = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = Companion.getIMPLEMENTATION();
        INSTANTIATABLE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Instantiatable", (String)"Registered class is not instantiatable", (String)"\n                    Activities, services, broadcast receivers etc. registered in the \\\n                    manifest file (or for custom views, in a layout file) must be \\\n                    \"instantiatable\" by the system, which means that the class must \\\n                    be public, it must have an empty public constructor, and if it's an \\\n                    inner class, it must be a static inner class.", (Implementation)implementation, null, (Category)enumSetArray, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        enumSetArray = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = Companion.getIMPLEMENTATION();
        INNERCLASS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"InnerclassSeparator", (String)"Inner classes should use `$` rather than `.`", (String)"\n                    When you reference an inner class in a manifest file, you must use '$' \\\n                    instead of '.' as the separator character, i.e. Outer$Inner instead of \\\n                    Outer.Inner.\n\n                    (If you get this warning for a class which is not actually an inner class, \\\n                    it's because you are using uppercase characters in your package name, which \\\n                    is not conventional.)\n                    ", (Implementation)implementation, null, (Category)enumSetArray, (int)3, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "INNERCLASS", "Lcom/android/tools/lint/detector/api/Issue;", "INSTANTIATABLE", "MISSING", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceFolderType.values().length];
            nArray[ResourceFolderType.VALUES.ordinal()] = 1;
            nArray[ResourceFolderType.LAYOUT.ordinal()] = 2;
            nArray[ResourceFolderType.DRAWABLE.ordinal()] = 3;
            nArray[ResourceFolderType.TRANSITION.ordinal()] = 4;
            nArray[ResourceFolderType.XML.ordinal()] = 5;
            nArray[ResourceFolderType.MENU.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

