/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.StringHelper;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "JavaVisitor", "KotlinVisitor", "lint-checks"})
public final class InteroperabilityDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(InteroperabilityDetector.class, Scope.JAVA_FILE_SCOPE);
    private static final boolean IGNORE_DEPRECATED = Intrinsics.areEqual((Object)"true", (Object)System.getenv("ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED")) || Intrinsics.areEqual((Object)"true", (Object)System.getProperty("lint.nullness.ignore-deprecated"));
    @JvmField
    @NotNull
    public static final Issue NO_HARD_KOTLIN_KEYWORDS;
    @JvmField
    @NotNull
    public static final Issue LAMBDA_LAST;
    @JvmField
    @NotNull
    public static final Issue PLATFORM_NULLNESS;
    @JvmField
    @NotNull
    public static final Issue KOTLIN_PROPERTY;

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UFile uFile = context.getUastFile();
        if (Lint.isKotlin((PsiElement)((PsiElement)(uFile == null ? null : uFile.getPsi())))) {
            boolean checkNullness = context.isEnabled(PLATFORM_NULLNESS);
            if (checkNullness) {
                return new KotlinVisitor(context);
            }
            return null;
        }
        return new JavaVisitor(context);
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UField.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Category category = Category.INTEROPERABILITY_KOTLIN;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        NO_HARD_KOTLIN_KEYWORDS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NoHardKeywords", (String)"No Hard Kotlin Keywords", (String)"\n            Do not use Kotlin\u2019s hard keywords as the name of methods or fields.\n            These require the use of backticks to escape when calling from Kotlin.\n            Soft keywords, modifier keywords, and special identifiers are allowed.\n\n            For example, Mockito\u2019s `when` function requires backticks when used from Kotlin:\n\n                val callable = Mockito.mock(Callable::class.java)\n                Mockito.\\`when\\`(callable.call()).thenReturn(/* \u2026 */)\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#no-hard-keywords", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LAMBDA_LAST = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"LambdaLast", (String)"Lambda Parameters Last", (String)"\n            To improve calling this code from Kotlin,\n            parameter types eligible for SAM conversion should be last.\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#lambda-parameters-last", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        PLATFORM_NULLNESS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UnknownNullness", (String)"Unknown nullness", (String)"\n            To improve referencing this code from Kotlin, consider adding\n            explicit nullness information here with either `@NonNull` or `@Nullable`.\n\n            You can set the environment variable\n            ```\n                `ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED=true`\n            ```\n            if you want lint to ignore classes and members that have been annotated with\n            `@Deprecated`.\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#nullability-annotations", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        KOTLIN_PROPERTY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"KotlinPropertyAccess", (String)"Kotlin Property Access", (String)"\n            For a method to be represented as a property in Kotlin, strict \u201cbean\u201d-style prefixing must be used.\n\n            Accessor methods require a `get` prefix or for boolean-returning methods an `is` prefix can be used.\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#property-prefixes", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$Issues;", "", "()V", "IGNORE_DEPRECATED", "", "getIGNORE_DEPRECATED", "()Z", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KOTLIN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "LAMBDA_LAST", "NO_HARD_KOTLIN_KEYWORDS", "PLATFORM_NULLNESS", "isApi", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "isKotlinHardKeyword", "keyword", "", "isNonNullAnnotation", "qualifiedName", "isNullableAnnotation", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public final boolean getIGNORE_DEPRECATED() {
            return IGNORE_DEPRECATED;
        }

        private final boolean isKotlinHardKeyword(String keyword) {
            switch (keyword) {
                case "for": 
                case "do": 
                case "interface": 
                case "while": 
                case "when": 
                case "continue": 
                case "else": 
                case "typealias": 
                case "class": 
                case "if": 
                case "typeof": 
                case "val": 
                case "package": 
                case "break": 
                case "in": 
                case "var": 
                case "false": 
                case "this": 
                case "is": 
                case "super": 
                case "as": 
                case "null": 
                case "throw": 
                case "true": 
                case "try": 
                case "fun": 
                case "return": 
                case "object": {
                    return true;
                }
            }
            return false;
        }

        private final boolean isNullableAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"Nullable", (boolean)false, (int)2, null);
        }

        private final boolean isNonNullAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"NonNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"NotNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"Nonnull", (boolean)false, (int)2, null);
        }

        private final boolean isApi(JavaContext context, UDeclaration declaration) {
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.isPublic((PsiModifierListOwner)declaration) || evaluator.isProtected((PsiModifierListOwner)declaration)) {
                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)declaration), UClass.class, (boolean)false, (int)2, null);
                if (uClass == null) {
                    return true;
                }
                UClass cls = uClass;
                return evaluator.isPublic((PsiModifierListOwner)cls) && !(cls instanceof UAnonymousClass);
            }
            return false;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "hasNullnessAnnotation", "", "node", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/uast/UAnnotated;", "reportMissingExplicitType", "", "Lorg/jetbrains/uast/UElement;", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "lint-checks"})
    public static final class KotlinVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public KotlinVisitor(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node) && node.getReturnTypeReference() == null) {
                UBlockExpression uBlockExpression;
                PsiType psiType = node.getReturnType();
                if (psiType == null) {
                    return;
                }
                PsiType type = psiType;
                if (type instanceof PsiPrimitiveType) {
                    return;
                }
                if (this.hasNullnessAnnotation((UAnnotated)node)) {
                    return;
                }
                UExpression uExpression = node.getUastBody();
                UBlockExpression uBlockExpression2 = uBlockExpression = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
                if (uBlockExpression == null) {
                    return;
                }
                UBlockExpression body = uBlockExpression;
                List expressions = body.getExpressions();
                if (expressions.size() == 1) {
                    UReturnExpression uReturnExpression;
                    Object object = expressions.get(0);
                    UReturnExpression uReturnExpression2 = uReturnExpression = object instanceof UReturnExpression ? (UReturnExpression)object : null;
                    if (uReturnExpression == null) {
                        return;
                    }
                    UReturnExpression statement = uReturnExpression;
                    UExpression uExpression2 = statement.getReturnExpression();
                    Object object2 = object = uExpression2 instanceof UReferenceExpression ? (UReferenceExpression)uExpression2 : null;
                    if (object == null) {
                        return;
                    }
                    Object expression = object;
                    uExpression2 = expression.resolve();
                    if (uExpression2 == null) {
                        return;
                    }
                    UExpression resolved = uExpression2;
                    if (Lint.isKotlin((PsiElement)resolved)) {
                        return;
                    }
                    if (resolved instanceof PsiModifierListOwner && this.hasNullnessAnnotation((PsiModifierListOwner)resolved)) {
                        return;
                    }
                    this.reportMissingExplicitType((UElement)node);
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node) && node.getTypeReference() == null) {
                UReferenceExpression uReferenceExpression;
                PsiType psiType = node.getType();
                if (psiType == null) {
                    return;
                }
                PsiType type = psiType;
                if (type instanceof PsiPrimitiveType) {
                    return;
                }
                if (this.hasNullnessAnnotation((UAnnotated)node)) {
                    return;
                }
                UExpression uExpression = node.getUastInitializer();
                UReferenceExpression uReferenceExpression2 = uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
                if (uReferenceExpression == null) {
                    return;
                }
                UReferenceExpression expression = uReferenceExpression;
                uExpression = expression.resolve();
                if (uExpression == null) {
                    return;
                }
                UExpression resolved = uExpression;
                if (Lint.isKotlin((PsiElement)resolved)) {
                    return;
                }
                this.reportMissingExplicitType((UElement)node);
            }
        }

        private final void reportMissingExplicitType(UElement node) {
            JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)node, (Location)this.context.getNameLocation(node), (String)"Should explicitly declare type here since implicit type does not specify nullness", null, (int)16, null);
        }

        private final boolean hasNullnessAnnotation(UAnnotated node) {
            for (UAnnotation annotation : this.context.getEvaluator().getAllAnnotations(node, false)) {
                String name;
                String string = annotation.getQualifiedName();
                if (string == null || !Issues.isNullableAnnotation(name = string) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }

        private final boolean hasNullnessAnnotation(PsiModifierListOwner node) {
            for (PsiAnnotation annotation : this.context.getEvaluator().getAllAnnotations(node, false)) {
                String string;
                String name;
                String string2 = annotation.getQualifiedName();
                if (string2 == null || !Issues.isNullableAnnotation(name = (string = string2)) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\"\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkForKeywords", "", "checkLambdaLast", "checkNullness", "checkPropertyAccess", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "nonNullAnnotation", "", "nullableAnnotation", "ensureLambdaLastParameter", "", "method", "Lorg/jetbrains/uast/UMethod;", "ensureNonKeyword", "name", "node", "Lorg/jetbrains/uast/UDeclaration;", "typeLabel", "ensureNullnessKnown", "type", "Lcom/intellij/psi/PsiType;", "ensureValidProperty", "setter", "methodName", "getNonNullAnnotation", "getNullableAnnotation", "getPropertyLocation", "Lcom/android/tools/lint/detector/api/Location;", "location1", "Lcom/intellij/psi/PsiMethod;", "location2", "hasSetter", "cls", "Lorg/jetbrains/uast/UClass;", "setterName", "initializeAnnotationNames", "isEqualsParameter", "isFunctionalInterface", "isLikelySetter", "isToStringMethod", "isTypeVariableReference", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "lint-checks"})
    public static final class JavaVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;
        private final boolean checkForKeywords;
        private final boolean checkNullness;
        private final boolean checkLambdaLast;
        private final boolean checkPropertyAccess;
        @Nullable
        private String nonNullAnnotation;
        @Nullable
        private String nullableAnnotation;

        public JavaVisitor(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.checkForKeywords = this.context.isEnabled(NO_HARD_KOTLIN_KEYWORDS);
            this.checkNullness = this.context.isEnabled(PLATFORM_NULLNESS);
            this.checkLambdaLast = this.context.isEnabled(LAMBDA_LAST);
            this.checkPropertyAccess = this.context.isEnabled(KOTLIN_PROPERTY);
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                String methodName = node.getName();
                if (this.checkForKeywords) {
                    this.ensureNonKeyword(methodName, (UDeclaration)node, "method");
                }
                if (this.checkPropertyAccess && this.isLikelySetter(methodName, node)) {
                    this.ensureValidProperty(node, methodName);
                }
                if (this.checkLambdaLast) {
                    this.ensureLambdaLastParameter(node);
                }
                if (this.checkNullness) {
                    PsiType type = node.getReturnType();
                    if (type != null) {
                        this.ensureNullnessKnown((UDeclaration)node, type);
                    }
                    for (UParameter parameter : node.getUastParameters()) {
                        this.ensureNullnessKnown((UDeclaration)parameter, parameter.getType());
                    }
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                if (this.checkForKeywords) {
                    String string = node.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.name");
                    this.ensureNonKeyword(string, (UDeclaration)node, "field");
                }
                if (this.checkNullness) {
                    this.ensureNullnessKnown((UDeclaration)node, node.getType());
                }
            }
        }

        private final boolean isLikelySetter(String methodName, UMethod node) {
            return StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null) && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && node.getUastParameters().size() == 1 && this.context.getEvaluator().isPublic((PsiModifierListOwner)node) && !this.context.getEvaluator().isStatic((PsiModifierListOwner)node);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void ensureValidProperty(UMethod setter, String methodName) {
            Object superClass;
            int n;
            int n2;
            int n3;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)setter));
            if (uClass == null) {
                return;
            }
            UClass cls = uClass;
            String string = methodName;
            int n4 = 3;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String propertySuffix = string3;
            String propertyName = StringHelper.usLocaleDecapitalize((String)propertySuffix);
            String getterName1 = Intrinsics.stringPlus((String)"get", (Object)propertySuffix);
            String getterName2 = Intrinsics.stringPlus((String)"is", (Object)propertySuffix);
            String badGetterName = Intrinsics.stringPlus((String)"has", (Object)propertySuffix);
            UMethod getter = null;
            UMethod badGetter = null;
            UMethod[] uMethodArray = cls.getMethods();
            boolean $i$f$forEach = false;
            UMethod[] uMethodArray2 = uMethodArray;
            int n5 = uMethodArray2.length;
            for (n3 = 0; n3 < n5; ++n3) {
                UParameter uParameter;
                UMethod element$iv;
                UMethod uMethod = element$iv = uMethodArray2[n3];
                boolean bl2 = false;
                JvmParameter[] jvmParameterArray = uMethod.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmParameterArray, (String)"it.parameters");
                Object[] objectArray = jvmParameterArray;
                n2 = 0;
                if (!(objectArray.length == 0)) continue;
                String string4 = uMethod.getName();
                if (Intrinsics.areEqual((Object)string4, (Object)getterName1) || Intrinsics.areEqual((Object)string4, (Object)getterName2)) {
                    getter = uMethod;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string4, (Object)badGetterName) && !Intrinsics.areEqual((Object)string4, (Object)propertyName) && !StringsKt.endsWith$default((String)string4, (String)propertySuffix, (boolean)false, (int)2, null) || !this.getContext().getEvaluator().isPublic((PsiModifierListOwner)uMethod) || uMethod.isConstructor() || !Intrinsics.areEqual((Object)uMethod.getReturnType(), (Object)((uParameter = (UParameter)CollectionsKt.firstOrNull((List)setter.getUastParameters())) == null ? null : uParameter.getType()))) continue;
                badGetter = uMethod;
            }
            if (getter == null) {
                Iterable iterable = cls.getUastSuperTypes();
                $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    Unit unit;
                    PsiClassType bl2;
                    UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                    boolean bl3 = false;
                    PsiType psiType = it.getType();
                    PsiClassType psiClassType = bl2 = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    if (bl2 == null) {
                        unit = null;
                        continue;
                    }
                    PsiClass psiClass = bl2.resolve();
                    if (psiClass == null) {
                        unit = null;
                        continue;
                    }
                    PsiClass psiClass2 = psiClass;
                    n2 = 0;
                    n = 0;
                    superClass = psiClass2;
                    boolean bl4 = false;
                    PsiMethod[] psiMethodArray = superClass.findMethodsByName(getterName1, true);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"superClass.findMethodsByName(getterName1, true)");
                    for (PsiMethod inherited : psiMethodArray) {
                        if (inherited.getParameterList().getParametersCount() != 0) continue;
                        getter = inherited;
                        break;
                    }
                    if (getter == null) {
                        PsiMethod[] psiMethodArray2 = superClass.findMethodsByName(getterName2, true);
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray2, (String)"superClass.findMethodsByName(getterName2, true)");
                        for (PsiMethod inherited : psiMethodArray2) {
                            if (inherited.getParameterList().getParametersCount() != 0) continue;
                            getter = inherited;
                            break;
                        }
                    }
                    unit = Unit.INSTANCE;
                }
            }
            if (getter != null && !(getter instanceof PsiCompiledElement)) {
                PsiType psiType;
                PsiType getterType;
                PsiType psiType2;
                PsiMethod superMethod;
                PsiMethod psiMethod;
                block26: {
                    psiMethod = (PsiMethod)getter;
                    if (!this.context.getEvaluator().isPublic((PsiModifierListOwner)psiMethod)) {
                        String message2 = "This getter should be public such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                        Location location = this.context.getNameLocation((PsiElement)psiMethod);
                        JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)((PsiElement)psiMethod), (Location)location, (String)message2, null, (int)16, null);
                        return;
                    }
                    if (this.context.getEvaluator().isStatic((PsiModifierListOwner)psiMethod)) {
                        PsiElement staticElement = null;
                        PsiModifierList element$iv = psiMethod.getModifierList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)element$iv, (String)"getter.modifierList");
                        PsiModifierList psiModifierList = element$iv;
                        if (psiModifierList.hasExplicitModifier("static")) {
                            for (PsiElement child = psiModifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                                if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                                staticElement = child;
                                break;
                            }
                        }
                        Location location = staticElement != null ? this.context.getLocation(staticElement) : this.context.getNameLocation((PsiElement)psiMethod);
                        String message3 = "This getter should not be static such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                        Object object = location.getSource();
                        PsiElement bl3 = object instanceof PsiElement ? (PsiElement)object : null;
                        JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)(bl3 == null ? (PsiElement)setter : bl3), (Location)location, (String)message3, null, (int)16, null);
                        return;
                    }
                    PsiType setterParameterType = ((UParameter)CollectionsKt.first((List)setter.getUastParameters())).getType();
                    if (!(Intrinsics.areEqual((Object)setterParameterType, (Object)psiMethod.getReturnType()) || this.hasSetter(cls, psiMethod.getReturnType(), setter.getName()) || this.isTypeVariableReference(setterParameterType))) {
                        PsiType location;
                        String string5 = "The getter return type (`" + ((location = psiMethod.getReturnType()) == null ? null : location.getPresentableText()) + "`) and setter parameter type (`" + setterParameterType.getPresentableText() + "`) getter and setter methods for property `" + propertyName + "` should have exactly the same type to allow be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                        location = this.getPropertyLocation(psiMethod, (PsiMethod)setter);
                        Object bl3 = location.getSource();
                        PsiElement message3 = bl3 instanceof PsiElement ? (PsiElement)bl3 : null;
                        JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)(message3 == null ? (PsiElement)setter : message3), (Location)location, (String)string5, null, (int)16, null);
                        return;
                    }
                    PsiMethod[] location22 = psiMethod.findSuperMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)location22, (String)"getter.findSuperMethods()");
                    PsiMethod[] psiMethodArray = location22;
                    int location22 = 0;
                    int message3 = psiMethodArray.length;
                    while (location22 < message3) {
                        superMethod = psiMethodArray[location22];
                        ++location22;
                        PsiClass psiClass = superMethod.getContainingClass();
                        if (Intrinsics.areEqual((Object)(psiClass == null ? null : Boolean.valueOf(psiClass.isInterface())), (Object)true)) continue;
                        PsiType psiType3 = superMethod.getReturnType();
                        if (psiType3 == null) {
                            return;
                        }
                        PsiType bl2 = psiType3;
                        psiType2 = bl2;
                        getterType = psiMethod.getReturnType();
                        if (Intrinsics.areEqual((Object)psiType2, (Object)getterType)) {
                            continue;
                        }
                        break block26;
                    }
                    return;
                }
                String string6 = "The getter return type (`" + ((psiType = getterType) == null ? null : psiType.getPresentableText()) + "`) is not the same as the super return type (`" + psiType2.getPresentableText() + "`); they should have exactly the same type to allow `" + StringHelper.usLocaleDecapitalize((String)propertySuffix) + "` be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                Intrinsics.checkExpressionValueIsNotNull((Object)superMethod, (String)"superMethod");
                Location location = this.getPropertyLocation(psiMethod, superMethod);
                Location location2 = location.getSecondary();
                if (location2 != null) {
                    location2.setMessage("Super method here");
                }
                superClass = location.getSource();
                location2 = superClass instanceof PsiElement ? (PsiElement)superClass : null;
                JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)(location2 == null ? (PsiElement)setter : location2), (Location)location, (String)string6, null, (int)16, null);
                return;
            }
            if (badGetter == null) return;
            PsiMethod[] psiMethodArray = badGetter.findSuperMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"!!.findSuperMethods()");
            if (ArraysKt.any((Object[])psiMethodArray)) return;
            JavaVisitor javaVisitor = this;
            char setterParameterType = '\u0000';
            boolean bl5 = false;
            JavaVisitor $this$ensureValidProperty_u24lambda_u2d522 = javaVisitor;
            boolean bl6 = false;
            String matchingName = Intrinsics.stringPlus((String)"set", (Object)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)badGetter.getName(), (CharSequence)"is"), (CharSequence)"get"), (CharSequence)"has"));
            if (!Intrinsics.areEqual((Object)methodName, (Object)matchingName)) {
                UMethod[] uMethodArray3 = cls.getMethods();
                boolean $i$f$none = false;
                UMethod[] uMethodArray4 = uMethodArray3;
                n2 = uMethodArray4.length;
                for (n = 0; n < n2; ++n) {
                    UMethod element$iv;
                    UMethod it = element$iv = uMethodArray4[n];
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)matchingName)) continue;
                    return;
                }
                boolean bl8 = true;
                if (!bl8) return;
            }
            boolean bl9 = true;
            if (!bl9) return;
            String string7 = badGetter.getName();
            if (StringsKt.startsWith$default((String)string7, (String)"is", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)methodName, (String)"setIs", (boolean)false, (int)2, null)) {
                setterParameterType = string7.charAt(2);
                boolean bl10 = false;
                if (Character.isUpperCase(setterParameterType)) {
                    char c = string7.charAt(2);
                    boolean $this$ensureValidProperty_u24lambda_u2d522 = false;
                    n3 = c;
                    boolean bl11 = false;
                    char c2 = Character.toLowerCase((char)n3);
                    String $this$ensureValidProperty_u24lambda_u2d522 = string7;
                    n3 = 3;
                    bl11 = false;
                    String string8 = $this$ensureValidProperty_u24lambda_u2d522;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                    $this$ensureValidProperty_u24lambda_u2d522 = string9;
                    n3 = 0;
                    String newProperty = String.valueOf(c2) + $this$ensureValidProperty_u24lambda_u2d522;
                    String string10 = "This method should be called `set" + StringHelper.usLocaleCapitalize((String)newProperty) + "` such that (along with the `" + string7 + "` getter) Kotlin code can access it as a property (`" + newProperty + "`); see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location = this.context.getNameLocation(setter);
                    this.context.report(KOTLIN_PROPERTY, setter, location, string10);
                    return;
                }
            }
            Location location = this.context.getNameLocation(badGetter);
            String string11 = "This method should be called `get" + propertySuffix + "` such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
            this.context.report(KOTLIN_PROPERTY, badGetter, location, string11);
        }

        private final boolean isTypeVariableReference(PsiType type) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass;
                PsiClass psiClass2 = ((PsiClassType)type).resolve();
                if (psiClass2 == null) {
                    return false;
                }
                PsiClass cls = psiClass = psiClass2;
                return cls instanceof PsiTypeParameter;
            }
            return false;
        }

        private final boolean hasSetter(UClass cls, PsiType type, String setterName) {
            PsiMethod[] psiMethodArray = cls.findMethodsByName(setterName, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"cls.findMethodsByName(setterName, true)");
            for (PsiMethod method : psiMethodArray) {
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                PsiParameterList parameterList = psiParameterList;
                PsiParameter[] parameters = parameterList.getParameters();
                if (parameters.length != 1 || !Intrinsics.areEqual((Object)parameters[0].getType(), (Object)type)) continue;
                return true;
            }
            return false;
        }

        private final Location getPropertyLocation(PsiMethod location1, PsiMethod location2) {
            PsiMethod primary = null;
            PsiMethod secondary = null;
            if (location1 instanceof PsiCompiledElement) {
                primary = location2;
                secondary = location1;
            } else {
                primary = location1;
                secondary = location2;
            }
            Location location = this.context.getNameLocation((PsiElement)primary);
            Location location3 = this.context.getNameLocation((PsiElement)secondary);
            String string = secondary.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"secondary.name");
            return Location.withSecondary$default((Location)location, (Location)location3, (String)Intrinsics.stringPlus((String)(StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null) ? "Setter" : "Getter"), (Object)" here"), (boolean)false, (int)4, null);
        }

        private final void ensureNullnessKnown(UDeclaration node, PsiType type) {
            Location location;
            Location location2;
            UTypeReferenceExpression name2;
            UDeclaration curr;
            Object annotation;
            Object object;
            if (type instanceof PsiPrimitiveType) {
                return;
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiTypeParameter) {
                return;
            }
            if (node instanceof UField && Intrinsics.areEqual((Object)((object = ((UField)node).getModifierList()) == null ? null : Boolean.valueOf(object.hasModifierProperty("final"))), (Object)true)) {
                return;
            }
            object = this.context.getEvaluator().getAllAnnotations((UAnnotated)node, false).iterator();
            while (object.hasNext()) {
                Location location3;
                annotation = (UAnnotation)object.next();
                String string = annotation.getQualifiedName();
                if (string == null) continue;
                String name2 = string;
                if (Issues.isNullableAnnotation(name2)) {
                    if (this.isToStringMethod(node)) {
                        location3 = this.context.getLocation((UElement)annotation);
                        String message2 = "Unexpected `@Nullable`: `toString` should never return null";
                        JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)location3, (String)message2, null, (int)16, null);
                    }
                    return;
                }
                if (!Issues.isNonNullAnnotation(name2)) continue;
                if (this.isEqualsParameter(node)) {
                    location3 = this.context.getLocation((UElement)annotation);
                    String message3 = "Unexpected @NonNull: The `equals` contract allows the parameter to be null";
                    JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)location3, (String)message3, null, (int)16, null);
                }
                return;
            }
            if (this.isEqualsParameter(node) || this.isToStringMethod(node)) {
                return;
            }
            if (node instanceof UMethod && (object = UastUtils.getContainingUClass((UElement)((UElement)node))) != null) {
                annotation = object;
                boolean name2 = false;
                boolean location4 = false;
                Object it = annotation;
                boolean bl = false;
                if (it.isAnnotationType()) {
                    return;
                }
            }
            if (Issues.getIGNORE_DEPRECATED() || this.context.getConfiguration().getOptionAsBoolean(PLATFORM_NULLNESS, "ignore-deprecated", false)) {
                UElement deprecatedNode = node instanceof UParameter ? node.getUastParent() : (UElement)node;
                UElement location4 = deprecatedNode;
                PsiElement name2 = location4 == null ? null : location4.getSourcePsi();
                annotation = name2 instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)name2 : null;
                if (Intrinsics.areEqual((Object)(annotation == null ? null : Boolean.valueOf(annotation.isDeprecated())), (Object)true)) {
                    return;
                }
                curr = deprecatedNode;
                while (curr != null && (name2 = UastUtils.getContainingUClass((UElement)curr)) != null) {
                    curr = (UElement)name2;
                    location4 = curr.getSourcePsi();
                    if (!Intrinsics.areEqual((Object)((name2 = location4 instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)location4 : null) == null ? null : Boolean.valueOf(name2.isDeprecated())), (Object)true)) continue;
                    return;
                }
            }
            if ((curr = node) instanceof UVariable) {
                name2 = ((UVariable)node).getTypeReference();
                if (name2 == null) {
                    return;
                }
                location2 = this.context.getLocation((UElement)name2);
            } else if (curr instanceof UMethod) {
                PsiTypeElement location4 = ((UMethod)node).getReturnTypeElement();
                if (location4 == null) {
                    return;
                }
                name2 = location4;
                location2 = this.context.getLocation((PsiElement)name2);
            } else {
                return;
            }
            Location location5 = location2;
            if (node instanceof UParameter) {
                location = location5;
            } else if (node instanceof UMethod && ((UMethod)node).getModifierList() != null) {
                name2 = ((UMethod)node).getModifierList();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"node.modifierList");
                location = this.context.getLocation((PsiElement)name2);
            } else if (node instanceof UField && ((UField)node).getModifierList() != null) {
                PsiModifierList location4 = ((UField)node).getModifierList();
                if (location4 == null) {
                    Intrinsics.throwNpe();
                }
                name2 = location4;
                location = this.context.getLocation((PsiElement)name2);
            } else {
                return;
            }
            Location replaceLocation = location;
            String message4 = "Unknown nullability; explicitly declare as `@Nullable` or `@NonNull` to improve Kotlin interoperability; see https://android.github.io/kotlin-guides/interop.html#nullability-annotations";
            LintFix[] lintFixArray = new LintFix[]{LintFix.Companion.create().replace().name("Annotate @NonNull").range(replaceLocation).beginning().shortenNames().reformat(true).with(Intrinsics.stringPlus((String)this.getNonNullAnnotation(this.context), (Object)" ")).build(), LintFix.Companion.create().replace().name("Annotate @Nullable").range(replaceLocation).beginning().shortenNames().reformat(true).with(Intrinsics.stringPlus((String)this.getNullableAnnotation(this.context), (Object)" ")).build()};
            LintFix fix = LintFix.Companion.create().alternatives(lintFixArray);
            this.context.report(PLATFORM_NULLNESS, (UElement)node, location5, message4, fix);
        }

        private final boolean isEqualsParameter(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return false;
                }
                UMethod method = uMethod;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"equals") && method.getUastParameters().size() == 1) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isToStringMethod(UDeclaration node) {
            UDeclaration method;
            return node instanceof UMethod && Intrinsics.areEqual((Object)((UMethod)(method = node)).getName(), (Object)"toString") && ((UMethod)method).getUastParameters().isEmpty();
        }

        private final String getNonNullAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nonNullAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private final String getNullableAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nullableAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private final void initializeAnnotationNames(JavaContext context) {
            if (this.nonNullAnnotation == null) {
                if (context.getEvaluator().findClass("android.support.annotation.NonNull") != null) {
                    this.nonNullAnnotation = "@android.support.annotation.NonNull";
                    this.nullableAnnotation = "@android.support.annotation.Nullable";
                } else {
                    this.nonNullAnnotation = "@androidx.annotation.NonNull";
                    this.nullableAnnotation = "@androidx.annotation.Nullable";
                }
            }
        }

        private final void ensureNonKeyword(String name, UDeclaration node, String typeLabel) {
            if (Issues.isKotlinHardKeyword(name)) {
                if (node instanceof UMethod && JavaEvaluator.isOverride$default((JavaEvaluator)this.context.getEvaluator(), (UMethod)((UMethod)node), (boolean)false, (int)2, null)) {
                    return;
                }
                String message2 = "Avoid " + typeLabel + " names that are Kotlin hard keywords (\"" + name + "\"); see https://android.github.io/kotlin-guides/interop.html#no-hard-keywords";
                JavaContext.report$default((JavaContext)this.context, (Issue)NO_HARD_KOTLIN_KEYWORDS, (UElement)((UElement)node), (Location)this.context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }

        private final void ensureLambdaLastParameter(UMethod method) {
            int n;
            int lastIndex;
            List parameters = method.getUastParameters();
            if (parameters.size() > 1 && !this.isFunctionalInterface(((UParameter)parameters.get(lastIndex = parameters.size() - 1)).getType()) && 0 <= (n = lastIndex - 1)) {
                do {
                    PsiClass psiClass;
                    int i;
                    UParameter parameter;
                    if (!this.isFunctionalInterface((parameter = (UParameter)parameters.get(i = n--)).getType()) || Intrinsics.areEqual((Object)parameter.getType().getCanonicalText(), (Object)"java.util.concurrent.Executor")) continue;
                    String message2 = "Functional interface parameters (such as parameter " + (i + 1) + ", \"" + parameter.getName() + "\", in " + ((psiClass = method.getContainingClass()) == null ? null : psiClass.getQualifiedName()) + '.' + method.getName() + ") should be last to improve Kotlin interoperability; see https://kotlinlang.org/docs/reference/java-interop.html#sam-conversions";
                    this.context.report(LAMBDA_LAST, method, this.context.getLocation((UElement)parameters.get(lastIndex)), message2);
                    break;
                } while (0 <= n);
            }
        }

        private final boolean isFunctionalInterface(PsiType type) {
            int n;
            PsiMethod method;
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiMethod[] psiMethodArray = ((PsiClassType)type).resolve();
            if (psiMethodArray == null) {
                return false;
            }
            PsiMethod[] psiMethodArray2 = psiMethodArray;
            PsiMethod[] cls = psiMethodArray2;
            if (!cls.isInterface()) {
                return false;
            }
            int abstractCount = 0;
            PsiMethod[] psiMethodArray3 = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray3, (String)"cls.methods");
            psiMethodArray = psiMethodArray3;
            int n2 = psiMethodArray.length;
            for (int i = 0; i < n2; ++i) {
                method = psiMethodArray[i];
                if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                n = abstractCount;
                abstractCount = n + 1;
            }
            if (abstractCount != 1) {
                if (abstractCount > 1) {
                    abstractCount = 0;
                    PsiMethod[] psiMethodArray4 = cls.getMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray4, (String)"cls.methods");
                    psiMethodArray = psiMethodArray4;
                    n2 = psiMethodArray.length;
                    for (int i = 0; i < n2; ++i) {
                        method = psiMethodArray[i];
                        if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                        JavaEvaluator javaEvaluator = this.context.getEvaluator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"method");
                        if (javaEvaluator.isOverride(method, true)) continue;
                        n = abstractCount;
                        abstractCount = n + 1;
                    }
                }
                if (abstractCount != 1) {
                    return false;
                }
            }
            return !Intrinsics.areEqual((Object)((psiMethodArray = cls.getSuperClass()) == null ? null : Boolean.valueOf(psiMethodArray.isInterface())), (Object)true);
        }
    }
}

