/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.NetworkCache;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u0007H\u0014R,\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/DeprecatedSdkRegistry;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "groupToArtifactToElement", "", "", "", "Lkotlin/Pair;", "Lorg/w3c/dom/Element;", "findDeclaration", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "getRecommendedVersion", "Lcom/android/ide/common/repository/GradleVersion;", "getVersionInfo", "Lcom/android/tools/lint/checks/DeprecatedSdkRegistry$DeprecatedLibrary;", "initialize", "", "stream", "Ljava/io/InputStream;", "matches", "", "version", "fromString", "toString", "readDefaultData", "relative", "DeprecatedLibrary", "lint-checks"})
public abstract class DeprecatedSdkRegistry
extends NetworkCache {
    @NotNull
    private final Map<String, List<Pair<String, Element>>> groupToArtifactToElement;

    public DeprecatedSdkRegistry(@Nullable Path cacheDir) {
        super("https://dl.google.com/dl/android/sdk/metadata/sdk_registry.xml", "sdk-registry.xml", cacheDir, 0, 0, false, 56, null);
        this.groupToArtifactToElement = new HashMap(100);
    }

    public /* synthetic */ DeprecatedSdkRegistry(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    public final void initialize(@NotNull InputStream stream) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        try {
            document = XmlUtils.parseDocument((Reader)new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8)), (boolean)false);
        }
        catch (SAXException e) {
            return;
        }
        Document document2 = document;
        Element root = document2.getDocumentElement();
        boolean bl = Intrinsics.areEqual((Object)root.getTagName(), (Object)"sdk_metadata");
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DeprecatedSdkRegistry$initialize$22 = false;
            String string = root.getTagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root.tagName");
            String $i$a$-assert-DeprecatedSdkRegistry$initialize$22 = string;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DeprecatedSdkRegistry$initialize$22));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)root, (String)"root");
        Iterator iterator = DomExtensions.iterator((Element)root);
        while (iterator.hasNext()) {
            List list;
            Element library = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)library.getTagName(), (Object)"library")) continue;
            String groupId = library.getAttribute("groupId");
            String artifactId = library.getAttribute("artifactId");
            List list2 = this.groupToArtifactToElement.get(groupId);
            if (list2 == null) {
                DeprecatedSdkRegistry deprecatedSdkRegistry = this;
                boolean bl3 = false;
                boolean bl4 = false;
                DeprecatedSdkRegistry $this$initialize_u24lambda_u2d1 = deprecatedSdkRegistry;
                boolean bl5 = false;
                boolean bl6 = false;
                List list3 = new ArrayList();
                Map<String, List<Pair<String, Element>>> map = $this$initialize_u24lambda_u2d1.groupToArtifactToElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)groupId, (String)"groupId");
                String string = groupId;
                boolean bl7 = false;
                map.put(string, list3);
                list = list3;
            } else {
                list = list2;
            }
            List artifactList = list;
            artifactList.add((Pair<String, Element>)new Pair((Object)artifactId, (Object)library));
        }
    }

    @Nullable
    public final GradleVersion getRecommendedVersion(@NotNull GradleCoordinate dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Element element = this.findDeclaration(dependency);
        if (element == null) {
            return null;
        }
        Element library = element;
        String recommendedVersion = library.getAttribute("recommended-version");
        Intrinsics.checkExpressionValueIsNotNull((Object)recommendedVersion, (String)"recommendedVersion");
        return StringsKt.isBlank((CharSequence)recommendedVersion) ? null : GradleVersion.tryParse((String)StringsKt.removeSuffix((String)recommendedVersion, (CharSequence)"+"));
    }

    @Nullable
    public final Element findDeclaration(@NotNull GradleCoordinate dependency) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (this.groupToArtifactToElement.isEmpty()) {
            object = this.findData("");
            if (object == null) {
                return null;
            }
            Iterator stream = object;
            this.initialize((InputStream)((Object)stream));
        }
        if ((object = this.groupToArtifactToElement.get(groupId)) == null) {
            return null;
        }
        Iterator artifactsInGroup = object;
        object = artifactsInGroup.iterator();
        while (object.hasNext()) {
            Pair artifact = (Pair)object.next();
            if (!Intrinsics.areEqual((Object)artifact.getFirst(), (Object)artifactId)) continue;
            return (Element)artifact.getSecond();
        }
        return null;
    }

    @Nullable
    public final DeprecatedLibrary getVersionInfo(@NotNull GradleCoordinate dependency) {
        Iterator iterator;
        Iterator iterator2;
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Element element = this.findDeclaration(dependency);
        if (element == null) {
            return null;
        }
        Element library = element;
        GradleVersion gradleVersion = dependency.getVersion();
        if (gradleVersion == null) {
            iterator2 = null;
        } else {
            GradleVersion gradleVersion2 = gradleVersion;
            boolean bl = false;
            boolean bl2 = false;
            GradleVersion it = gradleVersion2;
            boolean bl3 = false;
            iterator2 = iterator = it.compareTo(new GradleVersion(0, 0, 0)) > 0 ? gradleVersion2 : null;
        }
        if (iterator == null) {
            return null;
        }
        Iterator currentVersion = iterator;
        iterator = DomExtensions.iterator((Element)library);
        while (iterator.hasNext()) {
            Element versionElement = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)versionElement.getTagName(), (Object)"versions")) continue;
            String from = versionElement.getAttribute("from");
            String to = versionElement.getAttribute("to");
            Intrinsics.checkExpressionValueIsNotNull((Object)from, (String)"from");
            Intrinsics.checkExpressionValueIsNotNull((Object)to, (String)"to");
            if (!this.matches((GradleVersion)currentVersion, from, to)) continue;
            String recommendedVersion = library.getAttribute("recommended-version");
            String status = versionElement.getAttribute("status");
            String description = versionElement.getAttribute("description");
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)recommendedVersion, (String)"recommendedVersion");
            CharSequence charSequence = recommendedVersion;
            boolean bl = false;
            if (charSequence.length() > 0) {
                GradleVersion version = dependency.getVersion();
                GradleVersion recommended = GradleVersion.tryParse((String)recommendedVersion);
                if (version != null && recommended != null && version.compareTo(recommended) >= 0) {
                    return null;
                }
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkExpressionValueIsNotNull((Object)description, (String)"description");
            Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"status");
            return new DeprecatedLibrary(groupId, artifactId, description, status, Severity.WARNING, recommendedVersion);
        }
        return null;
    }

    private final boolean matches(GradleVersion version, String fromString, String toString) {
        GradleVersion from;
        Object to;
        CharSequence charSequence = toString;
        boolean bl = false;
        if (charSequence.length() > 0 && (to = GradleVersion.tryParse((String)toString)) != null && version.compareTo((GradleVersion)to) > 0) {
            return false;
        }
        to = fromString;
        bl = false;
        return !(to.length() > 0) || (from = GradleVersion.tryParse((String)fromString)) == null || version.compareTo(from) >= 0;
    }

    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        CharSequence charSequence = relative;
        boolean bl = false;
        boolean bl2 = charSequence.length() == 0;
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return DeprecatedSdkRegistry.class.getResourceAsStream("/sdks-offline.xml");
    }

    public DeprecatedSdkRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JG\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/DeprecatedSdkRegistry$DeprecatedLibrary;", "", "groupId", "", "artifactId", "message", "status", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "recommended", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Severity;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "getGroupId", "getMessage", "getRecommended", "getSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "getStatus", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
    public static final class DeprecatedLibrary {
        @NotNull
        private final String groupId;
        @NotNull
        private final String artifactId;
        @NotNull
        private final String message;
        @NotNull
        private final String status;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String recommended;

        public DeprecatedLibrary(@NotNull String groupId, @NotNull String artifactId, @NotNull String message2, @NotNull String status, @NotNull Severity severity, @Nullable String recommended) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.message = message2;
            this.status = status;
            this.severity = severity;
            this.recommended = recommended;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getRecommended() {
            return this.recommended;
        }

        @NotNull
        public final String component1() {
            return this.groupId;
        }

        @NotNull
        public final String component2() {
            return this.artifactId;
        }

        @NotNull
        public final String component3() {
            return this.message;
        }

        @NotNull
        public final String component4() {
            return this.status;
        }

        @NotNull
        public final Severity component5() {
            return this.severity;
        }

        @Nullable
        public final String component6() {
            return this.recommended;
        }

        @NotNull
        public final DeprecatedLibrary copy(@NotNull String groupId, @NotNull String artifactId, @NotNull String message2, @NotNull String status, @NotNull Severity severity, @Nullable String recommended) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
            return new DeprecatedLibrary(groupId, artifactId, message2, status, severity, recommended);
        }

        public static /* synthetic */ DeprecatedLibrary copy$default(DeprecatedLibrary deprecatedLibrary, String string, String string2, String string3, String string4, Severity severity, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = deprecatedLibrary.groupId;
            }
            if ((n & 2) != 0) {
                string2 = deprecatedLibrary.artifactId;
            }
            if ((n & 4) != 0) {
                string3 = deprecatedLibrary.message;
            }
            if ((n & 8) != 0) {
                string4 = deprecatedLibrary.status;
            }
            if ((n & 0x10) != 0) {
                severity = deprecatedLibrary.severity;
            }
            if ((n & 0x20) != 0) {
                string5 = deprecatedLibrary.recommended;
            }
            return deprecatedLibrary.copy(string, string2, string3, string4, severity, string5);
        }

        @NotNull
        public String toString() {
            return "DeprecatedLibrary(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", message=" + this.message + ", status=" + this.status + ", severity=" + this.severity + ", recommended=" + this.recommended + ')';
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = result * 31 + this.artifactId.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + this.status.hashCode();
            result = result * 31 + this.severity.hashCode();
            result = result * 31 + (this.recommended == null ? 0 : this.recommended.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecatedLibrary)) {
                return false;
            }
            DeprecatedLibrary deprecatedLibrary = (DeprecatedLibrary)other;
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)deprecatedLibrary.groupId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifactId, (Object)deprecatedLibrary.artifactId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)deprecatedLibrary.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.status, (Object)deprecatedLibrary.status)) {
                return false;
            }
            if (this.severity != deprecatedLibrary.severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.recommended, (Object)deprecatedLibrary.recommended);
        }
    }
}

