/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TranslationDetectorKt;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J<\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\nH\u0016J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010!\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010(2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010,\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JD\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010,\u001a\u00020*2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00104\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u00105\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0002J*\u00107\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J.\u00108\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J2\u0010:\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020*H\u0002J\u0018\u0010>\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0016J<\u0010A\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "()V", "baseNames", "", "Lcom/android/resources/ResourceType;", "", "", "locales", "", "missingMap", "nonBaseNames", "nonTranslatable", "pendingLocales", "translations", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "batchVisitResource", "type", "folderName", "Lcom/android/tools/lint/detector/api/ResourceContext;", "name", "element", "Lorg/w3c/dom/Element;", "defaultLocale", "checkBinaryResource", "checkFolder", "filterLocalesByResConfigs", "project", "Lcom/android/tools/lint/detector/api/Project;", "getLanguageTagFromFolder", "getLanguageTagFromQualifiers", "getLocaleTagFromFolder", "getLocaleTagFromQualifiers", "getResConfigLanguages", "", "handleNonTranslatable", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "isDefaultFolder", "ignoreFile", "incrementalVisitResource", "originalName", "configuration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "processExtraTranslations", "processMissingTranslations", "recordTranslatable", "recordTranslation", "language", "reportExtraResource", "reportMissingTranslation", "missingFrom", "reportTranslatedUntranslatable", "locationNode", "Lorg/w3c/dom/Node;", "translatableDefinedLocally", "visitDocument", "document", "Lorg/w3c/dom/Document;", "visitResource", "Companion", "lint-checks"})
public final class TranslationDetector
extends Detector
implements XmlScanner,
ResourceFolderScanner,
BinaryResourceScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ResourceType, Set<String>> baseNames;
    @NotNull
    private final Map<ResourceType, Set<String>> nonBaseNames;
    @Nullable
    private Map<String, Set<String>> missingMap;
    @Nullable
    private Set<String> locales;
    @Nullable
    private Set<String> pendingLocales;
    @Nullable
    private Set<String> nonTranslatable;
    @Nullable
    private Map<String, Set<String>> translations;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue EXTRA;
    @JvmField
    @NotNull
    public static final Issue MISSING_BASE;
    @JvmField
    @NotNull
    public static final Issue TRANSLATED_UNTRANSLATABLE;

    public TranslationDetector() {
        EnumMap enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"newEnumMap(ResourceType::class.java)");
        this.baseNames = enumMap;
        enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"newEnumMap(ResourceType::class.java)");
        this.nonBaseNames = enumMap;
    }

    private final boolean ignoreFile(Context context) {
        String string = context.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
        return StringsKt.startsWith$default((String)string, (String)"donottranslate", (boolean)false, (int)2, null) || ResourceUsageModel.isAnalyticsFile((File)context.file) || !context.getProject().getReportIssues();
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getPhase() == 2) {
            return;
        }
        this.processMissingTranslations(context);
        this.processExtraTranslations(context);
    }

    private final void processMissingTranslations(Context context) {
        Set<String> set;
        Boolean bl;
        Map<String, Set<String>> nameToLocales = this.translations;
        Map<String, Set<String>> map = nameToLocales;
        if (map == null) {
            bl = null;
        } else {
            set = map;
            boolean bl2 = false;
            bl = !set.isEmpty();
        }
        if (Intrinsics.areEqual(bl, (Object)true) && context.isEnabled(MISSING) && this.pendingLocales != null) {
            Project project = context.getProject();
            set = this.pendingLocales;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            Set<String> allLocales = this.filterLocalesByResConfigs(project, set);
            int localeCount = allLocales.size();
            Set<String> set2 = this.nonTranslatable;
            Set<String> nonTranslatable = set2 == null ? SetsKt.emptySet() : set2;
            Set<String> set3 = this.baseNames.get(ResourceType.STRING);
            if (set3 == null) {
                return;
            }
            for (String key : set3) {
                Map map2;
                Map map3;
                boolean bl3;
                TranslationDetector translationDetector;
                Set<String> set4 = nameToLocales.get(key);
                Set<String> locales = set4 == null ? SetsKt.emptySet() : set4;
                if (locales.size() >= localeCount || nonTranslatable.contains(key)) continue;
                Sets.SetView missing = Sets.difference(allLocales, locales);
                Map map4 = this.missingMap;
                if (map4 == null) {
                    translationDetector = this;
                    bl3 = false;
                    boolean bl4 = false;
                    TranslationDetector $this$processMissingTranslations_u24lambda_u2d0 = translationDetector;
                    boolean bl5 = false;
                    HashMap map5 = new HashMap();
                    $this$processMissingTranslations_u24lambda_u2d0.missingMap = map5;
                    map3 = map5;
                } else {
                    map3 = map4;
                }
                map4 = map2 = map3;
                Intrinsics.checkExpressionValueIsNotNull((Object)missing, (String)"missing");
                translationDetector = missing;
                bl3 = false;
                map4.put((String)key, (Set<String>)((Object)translationDetector));
            }
            if (this.missingMap != null) {
                context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        }
    }

    private final void processExtraTranslations(Context context) {
        Map<ResourceType, Set<String>> map = this.nonBaseNames;
        boolean bl = false;
        if (!map.isEmpty()) {
            for (ResourceType type : this.nonBaseNames.keySet()) {
                Set<String> set = this.baseNames.get(type);
                Set<String> base = set == null ? SetsKt.emptySet() : set;
                Set<String> set2 = this.nonBaseNames.get(type);
                if (set2 == null) {
                    Intrinsics.throwNpe();
                }
                for (String name : set2) {
                    if (base.contains(name)) continue;
                    context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
                    return;
                }
            }
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)folderName, (String)"folderName");
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES) && context.getDriver().getPhase() == 1 && context.getResourceFolderType() == ResourceFolderType.VALUES && context.getProject().getReportIssues()) {
            Object object = this.getLanguageTagFromFolder(folderName);
            if (object == null) {
                return;
            }
            String language = object;
            if (this.pendingLocales == null) {
                this.pendingLocales = new HashSet();
            }
            if ((object = this.pendingLocales) != null) {
                object.add(language);
            }
        }
    }

    public void checkBinaryResource(@NotNull ResourceContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        File file = context.file;
        if (folderType != ResourceFolderType.VALUES) {
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl = type != ResourceType.ID;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                ResourceFolderType resourceFolderType2 = folderType;
                throw (Throwable)((Object)new AssertionError(resourceFolderType2));
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"type");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
            this.visitResource(context, type, name, name, null, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (this.ignoreFile((Context)context)) {
            return;
        }
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        Element root = document.getDocumentElement();
        Object object = root;
        Attr translatable = object == null ? null : object.getAttributeNode("translatable");
        object = translatable;
        if (Intrinsics.areEqual((Object)(object == null ? null : object.getValue()), (Object)"false")) {
            object = context.file.getParentFile();
            if (!Intrinsics.areEqual((Object)(object == null ? null : ((File)object).getName()), (Object)"values")) {
                object = context.file.getParentFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.file.parentFile.name");
                if (Lint.getLocaleAndRegion((String)object) != null) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)root, (String)"root");
                    this.reportTranslatedUntranslatable(context, null, root, translatable, true);
                }
            }
            return;
        }
        File file = context.file;
        if (folderType != ResourceFolderType.VALUES) {
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl = type != ResourceType.ID;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-TranslationDetector$visitDocument$22 = false;
                ResourceFolderType $i$a$-assert-TranslationDetector$visitDocument$22 = folderType;
                throw (Throwable)((Object)new AssertionError($i$a$-assert-TranslationDetector$visitDocument$22));
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            ResourceContext resourceContext = (ResourceContext)context;
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"type");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
            this.visitResource(resourceContext, type, name, name, root, null);
        } else {
            Element types = root;
            if (types == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources")) {
                return;
            }
            TranslationDetector type = this;
            boolean name = false;
            boolean bl = false;
            Object $this$visitDocument_u24lambda_u2d3 = type;
            boolean bl3 = false;
            String attribute = root.getAttributeNS("http://schemas.android.com/tools", "locale");
            Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"attribute");
            CharSequence charSequence = attribute;
            boolean bl4 = false;
            String defaultLocale = !StringsKt.isBlank((CharSequence)charSequence) ? attribute : null;
            if (defaultLocale != null && context.getDriver().getPhase() == 1) {
                String defaultLanguage;
                String parentFolderName = context.file.getParentFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)parentFolderName, (String)"parentFolderName");
                String folderLanguage = this.getLanguageTagFromFolder(parentFolderName);
                if (folderLanguage != null && !Intrinsics.areEqual((Object)folderLanguage, (Object)(defaultLanguage = StringsKt.substringBefore$default((String)defaultLocale, (String)"-", null, (int)2, null)))) {
                    Context context2 = (Context)context;
                    $this$visitDocument_u24lambda_u2d3 = root.getAttributeNodeNS("http://schemas.android.com/tools", "locale");
                    Intrinsics.checkExpressionValueIsNotNull((Object)$this$visitDocument_u24lambda_u2d3, (String)"root.getAttributeNodeNS(\n                                    TOOLS_URI,\n                                    ATTR_LOCALE\n                                )");
                    Context.report$default((Context)context2, (Issue)MISSING, (Location)context.getValueLocation((Attr)$this$visitDocument_u24lambda_u2d3), (String)("Suspicious `tools:locale` declaration of language `" + defaultLanguage + "`; the parent folder `" + parentFolderName + "` implies language " + folderLanguage), null, (int)8, null);
                }
            }
            Element child = XmlUtils.getFirstSubTag((Node)root);
            while (child != null) {
                ResourceType type2 = ResourceType.fromXmlTag((Node)child);
                if (type2 != null && type2 != ResourceType.ID && type2 != ResourceType.PUBLIC && type2 != ResourceType.AAPT) {
                    String originalName = child.getAttribute("name");
                    $this$visitDocument_u24lambda_u2d3 = originalName;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if ($this$visitDocument_u24lambda_u2d3 == null || StringsKt.isBlank((CharSequence)$this$visitDocument_u24lambda_u2d3)) {
                        if (!child.hasAttribute("name")) {
                            LintFix fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), null, (String)"name", null, null, (int)12, null).build();
                            Element element = child;
                            context.report(MISSING, (Node)child, context.getLocation((Node)element), "Missing `name` attribute in `<" + child.getTagName() + ">` declaration", fix);
                        }
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)originalName, (String)"originalName");
                        String name2 = ResourcesUtil.resourceNameToFieldName((String)originalName);
                        this.visitResource((ResourceContext)context, type2, name2, originalName, child, defaultLocale);
                    }
                }
                child = XmlUtils.getNextTag((Node)child);
            }
        }
    }

    private final void visitResource(ResourceContext context, ResourceType type, String name, String originalName, Element element, String defaultLocale) {
        ResourceType resourceType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        String folderName = context.file.getParentFile().getName();
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            Intrinsics.checkExpressionValueIsNotNull((Object)folderName, (String)"folderName");
            this.batchVisitResource(type, folderName, context, name, element, defaultLocale);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)folderName, (String)"folderName");
            this.incrementalVisitResource(context, type, name, originalName, element, folderName, defaultLocale);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void incrementalVisitResource(ResourceContext context, ResourceType type, String name, String originalName, Element element, String folderName, String defaultLocale) {
        block13: {
            block12: {
                client = context.getClient();
                if (!context.isGlobalAnalysis()) {
                    return;
                }
                resources = client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                namespace = context.getProject().getResourceNamespace();
                var12_11 = resources.getResources(namespace, type, originalName);
                Intrinsics.checkExpressionValueIsNotNull((Object)var12_11, (String)"resources.getResources(namespace, type, originalName)");
                items = var12_11;
                if (items.isEmpty() && !Intrinsics.areEqual((Object)originalName, (Object)name)) {
                    var12_11 = resources.getResources(namespace, type, name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)var12_11, (String)"resources.getResources(namespace, type, name)");
                    items = var12_11;
                    if (items.isEmpty()) {
                        return;
                    }
                }
                $this$filter$iv = items;
                $i$f$filter = false;
                var15_17 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ResourceItem)element$iv$iv;
                    $i$a$-filter-TranslationDetector$incrementalVisitResource$hasDefault$1 = false;
                    if (!this.isDefaultFolder(it.getConfiguration(), null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                hasDefault = CollectionsKt.any((Iterable)((List)destination$iv$iv));
                if (hasDefault) break block12;
                this.reportExtraResource(type, name, context, element);
                break block13;
            }
            if (type != ResourceType.STRING || StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null) || element == null || !(context instanceof XmlContext)) break block13;
            if (this.handleNonTranslatable(name, element, (XmlContext)context, true)) {
                return;
            }
            if (this.locales == null) {
                $this$filter$iv = TranslationDetectorKt.getStringLocales(resources);
                var33_31 = context.getProject();
                var32_32 = this;
                var31_33 = this;
                $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = it.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (LocaleQualifier)element$iv$iv;
                    $i$a$-mapNotNull-TranslationDetector$incrementalVisitResource$1 = false;
                    if ((it.hasLanguage() ? it.getLanguage() : defaultLocale) == null) continue;
                    var26_40 = var26_40;
                    var27_41 = false;
                    var28_42 = false;
                    it$iv$iv = var26_40;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var34_45 = (List)destination$iv$iv;
                var31_33.locales = var32_32.filterLocalesByResConfigs(var33_31, CollectionsKt.toSet((Iterable)var34_45));
            }
            if ((var14_16 = this.locales) == null) {
                Intrinsics.throwNpe();
            }
            locales = CollectionsKt.toHashSet((Iterable)((Iterable)var14_16));
            for (ResourceItem item : items) {
                $i$f$mapNotNullTo = this;
                var18_23 = false;
                var19_26 = false;
                $this$incrementalVisitResource_u24lambda_u2d6 = $i$f$mapNotNullTo;
                $i$a$-run-TranslationDetector$incrementalVisitResource$qualifiers$1 = false;
                s = item.getConfiguration().getQualifierString();
                if (defaultLocale == null) ** GOTO lbl-1000
                Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                var23_36 = s;
                var24_38 = false;
                if (var23_36.length() == 0) {
                    v0 = StringsKt.substringBefore$default((String)defaultLocale, (char)'-', null, (int)2, null);
                } else lbl-1000:
                // 2 sources

                {
                    Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                    v0 = StringsKt.substringBefore$default((String)s, (char)'-', null, (int)2, null);
                }
                qualifiers = v0;
                var18_22 = this.getLanguageTagFromQualifiers(qualifiers);
                if (var18_22 == null) continue;
                language = var18_22;
                locales.remove(language);
            }
            var14_16 = locales;
            var15_18 = false;
            if (var14_16.isEmpty() == false) {
                this.reportMissingTranslation(name, (XmlContext)context, element, locales);
            }
        }
    }

    private final void batchVisitResource(ResourceType type, String folderName, ResourceContext context, String name, Element element, String defaultLocale) {
        boolean isDefault = this.isDefaultFolder(context.getFolderConfiguration(), folderName);
        if (isDefault) {
            if (context.getPhase() == 1) {
                Set set;
                Set set2 = this.baseNames.get(type);
                if (set2 == null) {
                    TranslationDetector translationDetector = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    TranslationDetector $this$batchVisitResource_u24lambda_u2d7 = translationDetector;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Set set3 = new LinkedHashSet();
                    Map<ResourceType, Set<String>> map = $this$batchVisitResource_u24lambda_u2d7.baseNames;
                    boolean bl5 = false;
                    map.put(type, set3);
                    set = set3;
                } else {
                    set = set2;
                }
                Set names = set;
                names.add((String)name);
            } else if (element != null && type == ResourceType.STRING && context instanceof XmlContext) {
                Set<String> missingFrom;
                Map<String, Set<String>> map = this.missingMap;
                Set<String> set = missingFrom = map == null ? null : map.get(name);
                if (missingFrom != null) {
                    this.reportMissingTranslation(name, (XmlContext)context, element, missingFrom);
                }
            }
            if (type == ResourceType.STRING && element != null && context instanceof XmlContext) {
                String language;
                if (defaultLocale != null && (language = this.getLanguageTagFromQualifiers(defaultLocale)) != null) {
                    this.recordTranslation(name, language);
                }
                this.handleNonTranslatable(name, element, (XmlContext)context, true);
            }
        } else if (context.getPhase() == 1) {
            Set set;
            Object object;
            Set set4 = this.nonBaseNames.get(type);
            if (set4 == null) {
                object = this;
                boolean bl = false;
                boolean bl6 = false;
                TranslationDetector $this$batchVisitResource_u24lambda_u2d8 = object;
                boolean bl7 = false;
                boolean bl8 = false;
                Set set5 = new LinkedHashSet();
                Map<ResourceType, Set<String>> map = $this$batchVisitResource_u24lambda_u2d8.nonBaseNames;
                boolean bl9 = false;
                map.put(type, set5);
                set = set5;
            } else {
                set = set4;
            }
            Set names = set;
            names.add((String)name);
            if (type == ResourceType.STRING && element != null && context instanceof XmlContext) {
                String string;
                if (this.handleNonTranslatable(name, element, (XmlContext)context, false)) {
                    return;
                }
                object = this.getLanguageTagFromFolder(folderName);
                Object language = object == null ? ((string = this.getLanguageTagFromQualifiers(defaultLocale)) == null ? "" : string) : object;
                this.recordTranslation(name, (String)language);
            }
        } else {
            Set<String> set = this.baseNames.get(type);
            if (!Intrinsics.areEqual((Object)(set == null ? null : Boolean.valueOf(set.contains(name))), (Object)true)) {
                this.reportExtraResource(type, name, context, element);
            }
        }
    }

    private final boolean isDefaultFolder(FolderConfiguration configuration, String folderName) {
        FolderConfiguration folderConfiguration;
        if (configuration != null) {
            folderConfiguration = configuration;
        } else if (folderName != null) {
            if (!StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null)) {
                return true;
            }
            if (!StringsKt.contains$default((CharSequence)folderName, (CharSequence)"dpi", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)folderName, (CharSequence)"-v", (boolean)false, (int)2, null)) {
                return false;
            }
            FolderConfiguration folderConfiguration2 = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfiguration2 == null) {
                return false;
            }
            folderConfiguration = folderConfiguration2;
        } else {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return true;
        }
        FolderConfiguration config = folderConfiguration;
        return !config.any((Predicate)isDefaultFolder.1.INSTANCE);
    }

    private final void recordTranslation(String name, String language) {
        Object object;
        Map<String, Set<String>> map;
        boolean bl;
        Object object2;
        Map<String, Set<String>> map2 = this.translations;
        if (map2 == null) {
            object2 = this;
            boolean bl2 = false;
            bl = false;
            TranslationDetector $this$recordTranslation_u24lambda_u2d9 = object2;
            boolean bl3 = false;
            $this$recordTranslation_u24lambda_u2d9.translations = new HashMap();
            Map<String, Set<String>> map3 = $this$recordTranslation_u24lambda_u2d9.translations;
            if (map3 == null) {
                Intrinsics.throwNpe();
            }
            map = map3;
        } else {
            map = map2;
        }
        Map<String, Set<String>> translations = map;
        object2 = translations.get(name);
        if (object2 == null) {
            TranslationDetector translationDetector = this;
            bl = false;
            boolean bl4 = false;
            TranslationDetector $this$recordTranslation_u24lambda_u2d10 = translationDetector;
            boolean bl5 = false;
            HashSet set = new HashSet();
            Map<String, Set<String>> map4 = translations;
            boolean bl6 = false;
            map4.put(name, set);
            object = set;
        } else {
            object = object2;
        }
        Object languages = object;
        languages.add(language);
    }

    private final boolean handleNonTranslatable(String name, Element element, XmlContext context, boolean isDefaultFolder2) {
        Object object;
        Attr translatable = element.getAttributeNode("translatable");
        if (translatable != null) {
            object = translatable.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            boolean bl = false;
            String string = object;
            boolean bl2 = false;
            if (!Boolean.parseBoolean(string)) {
                if (!isDefaultFolder2) {
                    object = context.file.getParentFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.file.parentFile.name");
                    if (Lint.getLocaleAndRegion((String)object) != null) {
                        this.reportTranslatedUntranslatable(context, name, element, translatable, true);
                    }
                }
                this.recordTranslatable(context, name);
                return true;
            }
        }
        if (SdkUtils.isServiceKey((String)name) || Intrinsics.areEqual((Object)name, (Object)"google_maps_key") || Intrinsics.areEqual((Object)name, (Object)"google_maps_key_instructions")) {
            this.recordTranslatable(context, name);
            return true;
        }
        if (!isDefaultFolder2 && Intrinsics.areEqual((Object)((object = this.nonTranslatable) == null ? null : Boolean.valueOf(object.contains(name))), (Object)true)) {
            object = context.file.getParentFile().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.file.parentFile.name");
            if (Lint.getLocaleAndRegion((String)object) != null) {
                object = element.getAttributeNode("name");
                this.reportTranslatedUntranslatable(context, name, element, object == null ? (Node)element : (Node)object, false);
            }
        }
        return false;
    }

    private final void recordTranslatable(XmlContext context, String name) {
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            Set<String> set;
            if (this.nonTranslatable == null) {
                boolean bl = false;
                this.nonTranslatable = new LinkedHashSet();
            }
            if ((set = this.nonTranslatable) == null) {
                Intrinsics.throwNpe();
            }
            set.add(name);
        }
    }

    private final void reportTranslatedUntranslatable(XmlContext context, String name, Element element, Node locationNode, boolean translatableDefinedLocally) {
        String string = context.file.getParentFile().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.parentFile.name");
        String string2 = this.getLanguageTagFromFolder(string);
        if (string2 == null) {
            return;
        }
        String language = string2;
        if (context.getDriver().isSuppressed(context, EXTRA, locationNode)) {
            return;
        }
        String languageDescription = Companion.getLanguageDescription(language);
        String message2 = name == null ? "This resource folder is marked as non-translatable yet is in a translated resource folder (" + languageDescription + ')' : (translatableDefinedLocally ? "The resource string \"" + name + "\" is marked as translatable=\"false\", but is translated to " + languageDescription + " here" : "The resource string \"" + name + "\" has been marked as translatable=\"false\" elsewhere (usually in the `values` folder), but is translated to " + languageDescription + " here");
        LintFix fix = this.fix().name("Remove translation").replace().range(context.getLocation((Node)element)).with("").build();
        context.report(TRANSLATED_UNTRANSLATABLE, locationNode, context.getLocation(locationNode), message2, fix);
    }

    private final void reportExtraResource(ResourceType type, String name, ResourceContext context, Element element) {
        String message2;
        String parentFolder = context.file.getParentFile().getName();
        ResourceType resourceType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()];
        switch (n) {
            case 4: {
                String string = '\"' + name + "\" is translated here but not found in default locale";
                break;
            }
            case 5: {
                String string = "The drawable \"" + name + "\" in " + parentFolder + " has no declaration in the base `drawable` folder or in a `drawable-`*density*`dpi` folder; this can lead to crashes when the drawable is queried in a configuration that does not match this qualifier";
                break;
            }
            default: {
                String typeName = type.getName();
                ResourceFolderType resourceFolderType = context.getResourceFolderType();
                String baseFolder = resourceFolderType == null ? null : resourceFolderType.getName();
                String string = message2 = "The " + typeName + " \"" + name + "\" in " + parentFolder + " has no declaration in the base `" + baseFolder + "` folder; this can lead to crashes when the resource is queried in a configuration that does not match this qualifier";
            }
        }
        if (element != null && context instanceof XmlContext) {
            LintFix lintFix;
            if (context.getResourceFolderType() == ResourceFolderType.VALUES) {
                String fixLabel = type == ResourceType.STRING ? "Remove translation" : "Remove resource override";
                lintFix = this.fix().name(fixLabel).replace().range(((XmlContext)context).getLocation((Node)element)).with("").build();
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Issue issue = type == ResourceType.STRING || type == ResourceType.ARRAY && Intrinsics.areEqual((Object)element.getTagName(), (Object)"string-array") ? EXTRA : MISSING_BASE;
            Location location = XmlContext.getElementLocation$default((XmlContext)((XmlContext)context), (Element)element, null, null, (String)"name", (int)6, null);
            ((XmlContext)context).report(issue, (Node)element, location, message2, fix);
        } else {
            Location location = Location.Companion.create(context.file);
            Context.report$default((Context)((Context)context), (Issue)MISSING_BASE, (Location)location, (String)message2, null, (int)8, null);
        }
    }

    private final void reportMissingTranslation(String name, XmlContext context, Element element, Set<String> missingFrom) {
        String separator = missingFrom.size() == 2 ? " or " : ", ";
        String localeList2 = CollectionsKt.joinToString$default((Iterable)missingFrom, (CharSequence)separator, null, null, (int)0, null, (Function1)reportMissingTranslation.localeList.1.INSTANCE, (int)30, null);
        String message2 = '\"' + name + "\" is not translated in " + localeList2;
        Attr attr = element.getAttributeNode("name");
        Node locationNode = attr == null ? (Node)element : (Node)attr;
        LintFix fix = this.fix().name("Mark non-translatable").set(null, "translatable", "false").build();
        context.report(MISSING, (Node)element, context.getLocation(locationNode), message2, fix);
    }

    private final String getLanguageTagFromFolder(String name) {
        String string;
        String string2 = this.getLocaleTagFromFolder(name);
        if (string2 == null) {
            return null;
        }
        String locale = string2;
        int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = locale;
            int n = 0;
            boolean bl = false;
            String string4 = string3.substring(n, index);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromFolder(String name) {
        LocaleQualifier locale;
        if (Intrinsics.areEqual((Object)name, (Object)"values")) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final String getLanguageTagFromQualifiers(String name) {
        String string;
        String string2 = name;
        if (string2 == null) {
            return null;
        }
        String string3 = this.getLocaleTagFromQualifiers(name);
        if (string3 == null) {
            return null;
        }
        String locale = string3;
        int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string4 = locale;
            int n = 0;
            boolean bl = false;
            String string5 = string4.substring(n, index);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromQualifiers(String name) {
        LocaleQualifier locale;
        boolean bl = !StringsKt.startsWith$default((String)name, (String)"values", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CharSequence charSequence = name;
        bl2 = false;
        if (charSequence.length() == 0) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final Set<String> filterLocalesByResConfigs(Project project, Set<String> locales) {
        List<String> list = this.getResConfigLanguages(project);
        if (list == null) {
            return locales;
        }
        List<String> configLanguages = list;
        return CollectionsKt.intersect((Iterable)locales, (Iterable)configLanguages);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getResConfigLanguages(Project project) {
        void $this$filterTo$iv$iv;
        LintModelVariant lintModelVariant = project.getBuildVariant();
        if (lintModelVariant == null) {
            return null;
        }
        LintModelVariant variant = lintModelVariant;
        Collection resourceConfigurations = variant.getResourceConfigurations();
        if (resourceConfigurations.isEmpty()) {
            return null;
        }
        Iterable $this$filter$iv = resourceConfigurations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String resConfig = (String)element$iv$iv;
            boolean bl = false;
            if (!(resConfig.length() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
    }

    @JvmStatic
    @NotNull
    public static final String getLanguageDescription(@NotNull String locale) {
        return Companion.getLanguageDescription(locale);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(TranslationDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER, (Enum)Scope.BINARY_RESOURCE_FILE), enumSetArray);
        MISSING = Issue.Companion.create("MissingTranslation", "Incomplete translation", "\n                If an application has more than one locale, then all the strings declared \\\n                in one language should also be translated in all other languages.\n\n                If the string should **not** be translated, you can add the attribute \\\n                `translatable=\"false\"` on the `<string>` element, or you can define all \\\n                your non-translatable strings in a resource file called \\\n                `donottranslate.xml`. Or, you can ignore the issue with a \\\n                `tools:ignore=\"MissingTranslation\"` attribute.\n\n                You can tell lint (and other tools) which language is the default language \\\n                in your `res/values/` folder by specifying `tools:locale=\"languageCode\"` \\\n                for the root `<resources>` element in your resource file. \\\n                (The `tools` prefix refers to the namespace declaration \\\n                `http://schemas.android.com/tools`.)", Category.MESSAGES, 8, Severity.ERROR, IMPLEMENTATION);
        EXTRA = Issue.Companion.create("ExtraTranslation", "Extra translation", "\n                If a string appears in a specific language translation file, but there is \\\n                no corresponding string in the default locale, then this string is probably \\\n                unused. (It's technically possible that your application is only intended \\\n                to run in a specific locale, but it's still a good idea to provide a fallback.)\n\n                Note that these strings can lead to crashes if the string is looked up on \\\n                any locale not providing a translation, so it's important to clean them up.", Category.MESSAGES, 6, Severity.FATAL, IMPLEMENTATION);
        MISSING_BASE = Issue.Companion.create("MissingDefaultResource", "Missing Default", "\n                If a resource is only defined in folders with qualifiers like `-land` or \\\n                `-en`, and there is no default declaration in the base folder (`layout` or \\\n                `values` etc), then the app will crash if that resource is accessed on a \\\n                device where the device is in a configuration missing the given qualifier.\n\n                As a special case, drawables do not have to be specified in the base folder; \\\n                if there is a match in a density folder (such as `drawable-mdpi`) that image \\\n                will be used and scaled. Note however that if you  only specify a drawable in \\\n                a folder like `drawable-en-hdpi`, the app will crash in non-English locales.\n\n                There may be scenarios where you have a resource, such as a `-fr` drawable, \\\n                which is only referenced from some other resource with the same qualifiers \\\n                (such as a `-fr` style), which itself has safe fallbacks. However, this still \\\n                makes it possible for somebody to accidentally reference the drawable and \\\n                crash, so it is safer to create a default fallback in the base folder. \\\n                Alternatively, you can suppress the issue by adding \\\n                `tools:ignore=\"MissingDefaultResource\"` on the element.\n\n                (This scenario frequently happens with string translations, where you might \\\n                delete code and the corresponding resources, but forget to delete a \\\n                translation. There is a dedicated issue id for that scenario, with the id \\\n                `ExtraTranslation`.)", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        TRANSLATED_UNTRANSLATABLE = Issue.Companion.create("Untranslatable", "Translated Untranslatable", "\n                Strings can be marked with `translatable=false` to indicate that they are not \\\n                intended to be translated, but are present in the resource file for other \\\n                purposes (for example for non-display strings that should vary by some other \\\n                configuration qualifier such as screen size or API level).\n\n                There are cases where translators accidentally translate these strings anyway, \\\n                and lint will flag these occurrences with this lint check.", Category.MESSAGES, 6, Severity.WARNING, IMPLEMENTATION);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector$Companion;", "", "()V", "EXTRA", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING", "MISSING_BASE", "TRANSLATED_UNTRANSLATABLE", "getLanguageDescription", "", "locale", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getLanguageDescription(@NotNull String locale) {
            String string;
            String languageName;
            Object object;
            boolean bl;
            Object object2;
            Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
            int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
            String regionCode = null;
            String languageCode = locale;
            if (index != -1) {
                String string2 = locale;
                int n = index + 1;
                boolean bl2 = false;
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string3;
                Locale locale2 = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"US");
                bl2 = false;
                object2 = string2;
                bl = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = ((String)object3).toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
                regionCode = string4;
                string2 = locale;
                int n2 = 0;
                bl2 = false;
                String string5 = string2.substring(n2, index);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string5;
                object = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"US");
                bl2 = false;
                object2 = string2;
                bl = false;
                Object object4 = object2;
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)object4).toLowerCase((Locale)object);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                languageCode = string6;
            }
            if ((languageName = LocaleManager.getLanguageName((String)languageCode)) != null) {
                String regionName;
                if (regionCode != null && (regionName = LocaleManager.getRegionName(regionCode)) != null) {
                    languageName = languageName + ": " + regionName;
                }
                object = StringCompanionObject.INSTANCE;
                String string7 = "\"%1$s\" (%2$s)";
                object2 = new Object[]{locale, languageName};
                bl = false;
                Object object5 = object2;
                String string8 = String.format(string7, Arrays.copyOf(object5, ((Object[])object5).length));
                string = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
            } else {
                string = '\"' + locale + '\"';
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.MIPMAP.ordinal()] = 1;
            nArray[ResourceType.STYLE.ordinal()] = 2;
            nArray[ResourceType.STYLEABLE.ordinal()] = 3;
            nArray[ResourceType.STRING.ordinal()] = 4;
            nArray[ResourceType.DRAWABLE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

