/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivateResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final String ATTR_OVERRIDE = "override";
    private static final String KEY_URL = "url";
    private static final Implementation IMPLEMENTATION = new Implementation(PrivateResourceDetector.class, Scope.JAVA_AND_RESOURCE_FILES, new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE});
    public static final Issue ISSUE = Issue.create((String)"PrivateResource", (String)"Using private resources", (String)"Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project instead.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private List<String> overriding;

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(JavaContext context, UElement node, ResourceType resourceType, String name, boolean isFramework) {
        if (!isFramework && PrivateResourceDetector.isPrivate((Context)context, resourceType, name)) {
            String pkgName;
            PsiPackage pkg;
            PsiElement resolved;
            boolean foreignPackage = false;
            boolean globalAnalysis = context.isGlobalAnalysis();
            if (!(!(node instanceof UReferenceExpression) || !((resolved = ((UReferenceExpression)node).resolve()) instanceof PsiField) || (pkg = context.getEvaluator().getPackage(resolved)) == null || (pkgName = pkg.getQualifiedName()).equals(context.getProject().getPackage()) || globalAnalysis && pkgName.equals(context.getMainProject().getPackage()))) {
                foreignPackage = true;
            }
            if (!foreignPackage) {
                if (globalAnalysis && PrivateResourceDetector.referencedInMain((Context)context, resourceType, name)) {
                    return;
                }
                if (this.overriding != null && this.overriding.contains(resourceType + ":" + name)) {
                    return;
                }
            }
            String message2 = PrivateResourceDetector.createUsageErrorMessage((Context)context, resourceType, name);
            Incident incident = new Incident(ISSUE, (Object)node, context.getLocation(node), message2);
            if (globalAnalysis) {
                context.report(incident);
            } else {
                context.report(incident, this.map().put(KEY_URL, "@" + resourceType + "/" + name));
            }
        }
    }

    public boolean filterIncident(Context context, Incident incident, LintMap map) {
        String urlString = map.getString(KEY_URL, null);
        if (urlString != null) {
            ResourceUrl url = ResourceUrl.parse((String)urlString);
            return url != null && !PrivateResourceDetector.referencedInMain(context, url.type, url.name);
        }
        return false;
    }

    private static boolean referencedInMain(Context context, ResourceType resourceType, String name) {
        LintClient client = context.getClient();
        Project mainProject = context.getMainProject();
        ResourceRepository repository2 = client.getResources(mainProject, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        return repository2.hasResources(ResourceNamespace.TODO(), resourceType, name);
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String value = attribute.getNodeValue();
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (PrivateResourceDetector.isPrivate((Context)context, url)) {
            String message2 = PrivateResourceDetector.createUsageErrorMessage((Context)context, url.type, url.name);
            context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), message2);
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "integer-array", "plurals");
    }

    public void visitElement(XmlContext context, Element element) {
        if ("resources".equals(element.getTagName())) {
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                Attr nameAttribute = item.getAttributeNode("name");
                if (nameAttribute == null) continue;
                String name = ResourcesUtil.resourceNameToFieldName((String)nameAttribute.getValue());
                ResourceType resourceType = ResourceType.fromXmlTag((Node)item);
                if (resourceType == null || !PrivateResourceDetector.isPrivate((Context)context, resourceType, name)) continue;
                if (this.overriding == null) {
                    this.overriding = Lists.newArrayList();
                }
                this.overriding.add(resourceType.getName() + ":" + name);
                if ("true".equals(item.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE))) continue;
                String message2 = PrivateResourceDetector.createOverrideErrorMessage((Context)context, resourceType, name);
                Location location = context.getValueLocation(nameAttribute);
                context.report(ISSUE, (Node)nameAttribute, location, message2);
            }
        } else {
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "integer-array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                PrivateResourceDetector.checkChildRefs(context, item);
            }
        }
    }

    private static boolean isPrivate(Context context, ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return false;
        }
        ResourceVisibilityLookup lookup2 = context.getProject().getResourceVisibility();
        return lookup2.isPrivate(type, name);
    }

    private static boolean isPrivate(Context context, ResourceUrl url) {
        return url != null && !url.isFramework() && PrivateResourceDetector.isPrivate(context, url.type, url.name);
    }

    private static void checkChildRefs(XmlContext context, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        block0: for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int index = text.indexOf("?attr/");
            if (index != -1) {
                String name = text.substring(index + "?attr/".length()).trim();
                if (!PrivateResourceDetector.isPrivate((Context)context, ResourceType.ATTR, name)) continue;
                String message2 = PrivateResourceDetector.createUsageErrorMessage((Context)context, ResourceType.ATTR, name);
                context.report(ISSUE, (Node)item, context.getLocation(child), message2);
                continue;
            }
            int m = text.length();
            for (int j = 0; j < m; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url = ResourceUrl.parse((String)text.trim());
                    if (!PrivateResourceDetector.isPrivate((Context)context, url)) continue block0;
                    String message3 = PrivateResourceDetector.createUsageErrorMessage((Context)context, url.type, url.name);
                    context.report(ISSUE, (Node)item, context.getLocation(child), message3);
                    continue block0;
                }
                if (!Character.isWhitespace(c)) continue block0;
            }
        }
    }

    public void beforeCheckFile(Context context) {
        String resourceName;
        File file = context.file;
        if (!Lint.isXmlFile((File)file) && !SdkUtils.isBitmapFile((File)file)) {
            return;
        }
        String parentName = file.getParentFile().getName();
        int dash = parentName.indexOf(45);
        if (dash != -1 || "values".equals(parentName)) {
            return;
        }
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
        if (folderType == null) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        if (types.isEmpty()) {
            return;
        }
        ResourceType type = (ResourceType)types.get(0);
        if (PrivateResourceDetector.isPrivate(context, type, resourceName = ResourcesUtil.resourceNameToFieldName((String)Lint.getBaseName((String)file.getName())))) {
            String message2 = PrivateResourceDetector.createOverrideErrorMessage(context, type, resourceName);
            Location location = Location.create((File)file);
            context.report(ISSUE, location, message2);
        }
    }

    private static String createOverrideErrorMessage(Context context, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context, type, name);
        return String.format("Overriding `@%1$s/%2$s` which is marked as private in %3$s. If deliberate, use tools:override=\"true\", otherwise pick a different name.", type, name, libraryName);
    }

    private static String createUsageErrorMessage(Context context, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context, type, name);
        return String.format("The resource `@%1$s/%2$s` is marked as private in %3$s", type, name, libraryName);
    }

    private static String getLibraryName(Context context, ResourceType type, String name) {
        ResourceVisibilityLookup lookup2 = context.getProject().getResourceVisibility();
        String library = lookup2.getPrivateIn(type, name);
        if (library != null) {
            return library;
        }
        return "the library";
    }
}

