/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u00012\u00020\u0002:\u000256B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002JB\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001a\u0010\u001f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020\u0006H\u0002J(\u0010!\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006H\u0002J4\u0010'\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00062\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002J$\u0010*\u001a\u00020\u001d2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J0\u00102\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00104\u001a\u00020\fH\u0016\u00a8\u00067"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "addAttribute", "", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attributeName", "existing", "data", "Lorg/w3c/dom/Element;", "addMatcher", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "type", "", "matcher", "checkIntent", "Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "intent", "activity", "createUriInfos", "", "ensureExported", "", "getApplicableElements", "", "hasActionView", "", "isBrowsable", "replaceUrlWithValue", "str", "reportTestUrlFailure", "node", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "reportUrlError", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "requireNonEmpty", "attribute", "Lorg/w3c/dom/Attr;", "value", "testElement", "testUrl", "Ljava/net/URL;", "infos", "validateAttribute", "visitElement", "element", "Companion", "UriInfo", "lint-checks"})
public final class AppLinksValidDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksValidDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue TEST_URL = Issue.Companion.create("TestAppLink", "Unmatched URLs", "\n                Using one or more `tools:validation testUrl=\"some url\"/>` elements in your manifest allows \\\n                the link attributes in your intent filter to be checked for matches.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue VALIDATION;
    @NotNull
    private static final Issue _OLD_ISSUE_URL;
    @NotNull
    private static final String TAG_VALIDATION = "validation";

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        List<UriInfo> infos = this.createUriInfos(element, context);
        Element current = XmlUtils.getFirstSubTagByName((Node)element, (String)TAG_VALIDATION);
        while (current != null) {
            if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)current.getNamespaceURI())) {
                Attr testUrlAttr = current.getAttributeNode("testUrl");
                if (testUrlAttr == null) {
                    String message2 = "Expected `testUrl` attribute";
                    Element element2 = current;
                    Node node = element2;
                    element2 = current;
                    AppLinksValidDetector.reportUrlError$default(this, context, node, context.getLocation((Node)element2), message2, null, 16, null);
                } else {
                    String testUrlString = testUrlAttr.getValue();
                    try {
                        URL testUrl = new URL(testUrlString);
                        String reason = this.testElement(testUrl, infos);
                        if (reason != null) {
                            this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), reason);
                        }
                    }
                    catch (MalformedURLException e) {
                        String message3 = Intrinsics.stringPlus((String)"Invalid test URL: ", (Object)e.getLocalizedMessage());
                        this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), message3);
                    }
                }
            } else {
                Element element3 = current;
                Node node = element3;
                element3 = current;
                this.reportTestUrlFailure(context, node, context.getNameLocation((Node)element3), "Validation nodes should be in the `tools:` namespace to ensure they are removed from the manifest at build time");
            }
            current = XmlUtils.getNextTagByName((Node)current, (String)TAG_VALIDATION);
        }
    }

    private final void reportUrlError(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        if (context.getDriver().isSuppressed(context, _OLD_ISSUE_URL, node)) {
            return;
        }
        context.report(VALIDATION, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlError$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlError(xmlContext, node, location, string, lintFix);
    }

    private final void reportTestUrlFailure(XmlContext context, Node node, Location location, String message2) {
        XmlContext.report$default((XmlContext)context, (Issue)TEST_URL, (Node)node, (Location)location, (String)message2, null, (int)16, null);
    }

    @NotNull
    public final List<UriInfo> createUriInfos(@NotNull Element activity, @Nullable XmlContext context) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Element intent = XmlUtils.getFirstSubTagByName((Node)activity, (String)"intent-filter");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"newArrayList()");
        List infos = arrayList;
        while (intent != null) {
            Element element = intent;
            UriInfo uriInfo = this.checkIntent(context, element, activity);
            if (uriInfo != null) {
                infos.add(uriInfo);
            }
            intent = XmlUtils.getNextTagByName((Node)intent, (String)"intent-filter");
        }
        return infos;
    }

    @Nullable
    public final String testElement(@NotNull URL testUrl, @NotNull List<UriInfo> infos) {
        Intrinsics.checkParameterIsNotNull((Object)testUrl, (String)"testUrl");
        Intrinsics.checkParameterIsNotNull(infos, (String)"infos");
        boolean bl = false;
        List reasons = new ArrayList();
        for (UriInfo info : infos) {
            String string = info.match(testUrl);
            if (string == null) {
                return null;
            }
            String reason = string;
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
        }
        Collection collection = reasons;
        boolean bl2 = false;
        return !collection.isEmpty() ? Intrinsics.stringPlus((String)"Test URL ", (Object)Joiner.on((String)" or ").join((Iterable)reasons)) : (String)null;
    }

    private final UriInfo checkIntent(XmlContext context, Element intent, Element activity) {
        List<AndroidPatternMatcher> paths2;
        List<String> ports;
        List<String> hosts;
        List<String> schemes;
        block20: {
            LintFix fix;
            boolean hasScheme;
            boolean implicitSchemes;
            boolean isHttp;
            boolean browsable;
            boolean actionView;
            block21: {
                Element firstData;
                block22: {
                    block19: {
                        block18: {
                            firstData = XmlUtils.getFirstSubTagByName((Node)intent, (String)"data");
                            actionView = this.hasActionView(intent);
                            browsable = this.isBrowsable(intent);
                            if (actionView && context != null) {
                                this.ensureExported(context, activity, intent);
                            }
                            if (firstData == null) {
                                if (actionView && browsable && context != null) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, intent, context.getLocation((Node)intent), "Missing data element", null, 16, null);
                                }
                                return null;
                            }
                            schemes = null;
                            hosts = null;
                            ports = null;
                            paths2 = null;
                            boolean hasMimeType = false;
                            Element data = firstData;
                            while (data != null) {
                                Object mimeTypeValue;
                                Attr mimeType = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "mimeType");
                                if (mimeType != null) {
                                    hasMimeType = true;
                                    if (context != null) {
                                        mimeTypeValue = mimeType.getValue();
                                        Project project = context.getProject();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)mimeTypeValue, (String)"mimeTypeValue");
                                        String resolved = Lint.resolvePlaceHolders((Project)project, (String)mimeTypeValue, null);
                                        if (CharSequences.containsUpperCase((CharSequence)resolved)) {
                                            String message2 = "Mime-type matching is case sensitive and should only use lower-case characters";
                                            if (!CharSequences.containsUpperCase((CharSequence)Lint.resolvePlaceHolders(null, (String)mimeTypeValue, null))) {
                                                message2 = message2 + " (without placeholders, value is `" + resolved + "`)";
                                            }
                                            AppLinksValidDetector.reportUrlError$default(this, context, mimeType, context.getValueLocation(mimeType), message2, null, 16, null);
                                        }
                                    }
                                }
                                mimeTypeValue = data;
                                schemes = this.addAttribute(context, "scheme", schemes, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                hosts = this.addAttribute(context, "host", hosts, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                ports = this.addAttribute(context, "port", ports, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "path", 0, paths2, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "pathPrefix", 1, paths2, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "pathPattern", 2, paths2, (Element)mimeTypeValue);
                                data = XmlUtils.getNextTagByName((Node)data, (String)"data");
                            }
                            if (actionView && browsable && schemes == null && !hasMimeType && context != null) {
                                AppLinksValidDetector.reportUrlError$default(this, context, firstData, context.getLocation((Node)firstData), "Missing URL for the intent filter", null, 16, null);
                            }
                            isHttp = false;
                            implicitSchemes = false;
                            if (schemes != null) break block18;
                            if (!hasMimeType) break block19;
                            schemes = Lists.newArrayList();
                            schemes.add("content");
                            schemes.add("file");
                            implicitSchemes = true;
                            break block19;
                        }
                        for (String scheme : schemes) {
                            if (!Intrinsics.areEqual((Object)"http", (Object)scheme) && !Intrinsics.areEqual((Object)"https", (Object)scheme)) continue;
                            isHttp = true;
                            break;
                        }
                    }
                    if (context == null) break block20;
                    boolean bl = hasScheme = schemes != null;
                    if (!(hasScheme || hosts == null && paths2 == null && ports == null)) {
                        fix = LintFix.Companion.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                        this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `scheme` must be specified", fix);
                    }
                    if (hosts != null || paths2 == null && ports == null) break block21;
                    if (!hasScheme) break block22;
                    if (schemes == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!schemes.contains("http") && !schemes.contains("https")) break block21;
                }
                fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)LintFix.Companion.create().set(), (String)"http://schemas.android.com/apk/res/android", (String)"host", null, null, (int)12, null).build();
                this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `host` must be specified", fix);
            }
            if (actionView && isHttp && !browsable) {
                AppLinksValidDetector.reportUrlError$default(this, context, intent, context.getLocation((Node)intent), "Activity supporting ACTION_VIEW is not set as BROWSABLE", null, 16, null);
            }
            if (actionView && (!hasScheme || implicitSchemes)) {
                fix = LintFix.Companion.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                this.reportUrlError(context, intent, context.getLocation((Node)intent), "Missing URL", fix);
            }
        }
        return new UriInfo(schemes, hosts, ports, paths2);
    }

    private final void ensureExported(XmlContext context, Element activity, Element intent) {
        Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (attr == null) {
            return;
        }
        Attr exported = attr;
        if (Intrinsics.areEqual((Object)"true", (Object)exported.getValue())) {
            return;
        }
        Element prevIntent = XmlUtils.getPreviousTagByName((Node)intent, (String)"intent-filter");
        while (prevIntent != null) {
            Element element = prevIntent;
            if (this.hasActionView(element)) {
                return;
            }
            prevIntent = XmlUtils.getNextTagByName((Node)prevIntent, (String)"intent-filter");
        }
        AppLinksValidDetector.reportUrlError$default(this, context, activity, context.getLocation((Node)activity), "Activity supporting ACTION_VIEW is not exported", null, 16, null);
    }

    private final boolean hasActionView(Element intent) {
        for (Element action : XmlUtils.getSubTagsByName((Node)intent, (String)"action")) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue(), (Object)"android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private final boolean isBrowsable(Element intent) {
        for (Element e : XmlUtils.getSubTagsByName((Node)intent, (String)"category")) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue(), (Object)"android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private final List<String> addAttribute(XmlContext context, String attributeName, List<String> existing, Element data) {
        List current;
        block10: {
            String string;
            String value;
            Attr attribute;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            current = existing;
                            attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                            if (attribute == null) break block10;
                            value = attribute.getValue();
                            if (this.requireNonEmpty(context, attribute, value)) {
                                return current;
                            }
                            string = value;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                            if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block11;
                            string = value;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                            if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block12;
                        }
                        string = value;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                        value = this.replaceUrlWithValue(context, string);
                    }
                    if (current == null) {
                        current = Lists.newArrayListWithCapacity((int)4);
                    }
                    if (current == null) {
                        Intrinsics.throwNpe();
                    }
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    current.add(string);
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (AppLinksValidDetector.Companion.isSubstituted(string)) break block13;
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block13;
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block14;
                }
                return current;
            }
            if (context != null) {
                string = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                this.validateAttribute(context, attributeName, data, attribute, string);
            }
        }
        return current;
    }

    private final void validateAttribute(XmlContext context, String attributeName, Element data, Attr attribute, String value) {
        switch (attributeName) {
            case "scheme": {
                if (StringsKt.endsWith$default((String)value, (String)":", (boolean)false, (int)2, null)) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Don't include trailing colon in the `scheme` declaration", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Scheme matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "host": {
                if (StringsKt.lastIndexOf$default((CharSequence)value, (char)'*', (int)0, (boolean)false, (int)6, null) > 0) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The host wildcard (`*`) can only be the first character", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Host matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "port": {
                try {
                    String string = value;
                    boolean bl = false;
                    int port = Integer.parseInt(string);
                    if (port < 1 || port > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "not a valid port number", null, 16, null);
                }
                if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The port must be specified in the same `<data>` element as the `host`", null, 16, null);
            }
        }
    }

    private final List<AndroidPatternMatcher> addMatcher(XmlContext context, String attributeName, int type, List<AndroidPatternMatcher> matcher, Element data) {
        List current;
        block10: {
            String value;
            Attr attribute;
            block12: {
                String string;
                block11: {
                    current = matcher;
                    attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                    if (attribute == null) break block10;
                    value = attribute.getValue();
                    if (this.requireNonEmpty(context, attribute, value)) {
                        return current;
                    }
                    if (current == null) {
                        current = Lists.newArrayListWithCapacity((int)4);
                    }
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block11;
                    string = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                    if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block12;
                }
                string = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
                value = this.replaceUrlWithValue(context, string);
            }
            AndroidPatternMatcher currentMatcher = new AndroidPatternMatcher(value, type);
            Object object = current;
            if (object != null) {
                object.add(currentMatcher);
            }
            if (context != null) {
                object = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                if (!StringsKt.startsWith$default((String)object, (String)"/", (boolean)false, (int)2, null)) {
                    object = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                    if (!AppLinksValidDetector.Companion.isSubstituted((String)object)) {
                        object = value;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                        if (!StringsKt.startsWith$default((String)object, (String)"@", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)attributeName, (Object)"pathPattern")) {
                            LintFix fix = LintFix.Companion.create().replace().text(attribute.getValue()).with(Intrinsics.stringPlus((String)"/", (Object)value)).build();
                            this.reportUrlError(context, attribute, context.getValueLocation(attribute), '`' + attribute.getName() + "` attribute should start with `/`, but it is `" + value + '`', fix);
                        }
                    }
                }
            }
        }
        return current;
    }

    private final boolean requireNonEmpty(XmlContext context, Attr attribute, String value) {
        block2: {
            block3: {
                if (context == null) break block2;
                if (value == null) break block3;
                CharSequence charSequence = value;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block2;
            }
            AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getLocation((Node)attribute), '`' + attribute.getName() + "` cannot be empty", null, 16, null);
            return true;
        }
        return false;
    }

    private final String replaceUrlWithValue(XmlContext context, String str) {
        String string;
        if (context == null) {
            return str;
        }
        LintClient client = context.getClient();
        ResourceUrl url = ResourceUrl.parse((String)str);
        if (url == null || url.isFramework()) {
            return str;
        }
        Project project = context.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, url.name);
        if (items.isEmpty()) {
            return str;
        }
        Object object = ((ResourceItem)items.get(0)).getResourceValue();
        if (object == null) {
            return str;
        }
        ResourceValue resourceValue = object;
        if (resourceValue.getValue() == null) {
            string = str;
        } else {
            object = resourceValue.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            string = object;
        }
        return string;
    }

    static {
        Category category = Category.USABILITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        VALIDATION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"AppLinkUrlError", (String)"URL not supported by app for Firebase App Indexing", (String)"\n                Ensure the URL is supported by your app, to get installs and traffic to your app from \\\n                Google Search.", (Implementation)implementation, (String)"https://g.co/AppIndexing/AndroidStudio", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        _OLD_ISSUE_URL = Issue.Companion.create("GoogleAppIndexingUrlError", "?", "?", Category.USABILITY, 5, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003H\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "", "schemes", "", "", "hosts", "ports", "paths", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "containsUpperCase", "", "matchers", "match", "testUrl", "Ljava/net/URL;", "matchesHost", "actualHost", "hostPattern", "lint-checks"})
    public static final class UriInfo {
        @Nullable
        private final List<String> schemes;
        @Nullable
        private final List<String> hosts;
        @Nullable
        private final List<String> ports;
        @Nullable
        private final List<AndroidPatternMatcher> paths;

        public UriInfo(@Nullable List<String> schemes, @Nullable List<String> hosts, @Nullable List<String> ports, @Nullable List<? extends AndroidPatternMatcher> paths2) {
            this.schemes = schemes;
            this.hosts = hosts;
            this.ports = ports;
            this.paths = paths2;
        }

        @Nullable
        public final String match(@NotNull URL testUrl) {
            boolean $i$f$any;
            Iterable $this$any$iv;
            Intrinsics.checkParameterIsNotNull((Object)testUrl, (String)"testUrl");
            if (this.schemes != null) {
                boolean schemeOk;
                block25: {
                    boolean bl;
                    $this$any$iv = this.schemes;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String scheme = (String)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)scheme, (Object)testUrl.getProtocol()) || Companion.isSubstituted(scheme))) continue;
                            bl = true;
                            break block25;
                        }
                        bl = schemeOk = false;
                    }
                }
                if (!schemeOk) {
                    return Intrinsics.stringPlus((String)"did not match scheme ", (Object)Joiner.on((String)", ").join((Iterable)this.schemes));
                }
            }
            if (this.hosts != null) {
                boolean hostOk;
                block26: {
                    boolean bl;
                    $this$any$iv = this.hosts;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String host = (String)element$iv;
                            boolean bl3 = false;
                            String string = testUrl.getHost();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"testUrl.host");
                            if (!(this.matchesHost(string, host) || Companion.isSubstituted(host))) continue;
                            bl = true;
                            break block26;
                        }
                        bl = hostOk = false;
                    }
                }
                if (!hostOk) {
                    return Intrinsics.stringPlus((String)"did not match host ", (Object)Joiner.on((String)", ").join((Iterable)this.hosts));
                }
            }
            boolean portOk = false;
            if (testUrl.getPort() != -1) {
                String testPort = String.valueOf(testUrl.getPort());
                if (this.ports != null) {
                    boolean bl;
                    block27: {
                        Iterable $this$any$iv2 = this.ports;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv2) {
                                String port = (String)element$iv;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)testPort, (Object)port) || Companion.isSubstituted(port))) continue;
                                bl = true;
                                break block27;
                            }
                            bl = false;
                        }
                    }
                    portOk = bl;
                }
            } else if (this.ports == null) {
                portOk = true;
            }
            if (!portOk) {
                String portList = this.ports == null ? "none" : Joiner.on((String)", ").join((Iterable)this.ports);
                return Intrinsics.stringPlus((String)"did not match port ", (Object)portList);
            }
            if (this.paths != null) {
                boolean pathOk;
                String testPath;
                block28: {
                    boolean bl;
                    testPath = testUrl.getPath();
                    Iterable $this$any$iv3 = this.paths;
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv3) {
                            AndroidPatternMatcher it = (AndroidPatternMatcher)element$iv;
                            boolean bl5 = false;
                            String string = it.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.path");
                            if (!(Companion.isSubstituted(string) || it.match(testPath))) continue;
                            bl = true;
                            break block28;
                        }
                        bl = pathOk = false;
                    }
                }
                if (!pathOk) {
                    StringBuilder sb = new StringBuilder();
                    this.paths.forEach(new Consumer<AndroidPatternMatcher>(sb){
                        final /* synthetic */ StringBuilder $sb;
                        {
                            this.$sb = $sb;
                        }

                        public final void accept(@NotNull AndroidPatternMatcher matcher) {
                            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
                            this.$sb.append("path ").append(matcher.toString()).append(", ");
                        }
                    });
                    if (CharSequences.endsWith((CharSequence)sb, (CharSequence)", ", (boolean)true)) {
                        sb.setLength(sb.length() - 2);
                    }
                    String message2 = Intrinsics.stringPlus((String)"did not match ", (Object)sb);
                    if (this.containsUpperCase(this.paths) || CharSequences.containsUpperCase((CharSequence)testPath)) {
                        message2 = Intrinsics.stringPlus((String)message2, (Object)" Note that matching is case sensitive.");
                    }
                    return message2;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean containsUpperCase(List<? extends AndroidPatternMatcher> matchers) {
            AndroidPatternMatcher it;
            if (matchers == null) return false;
            Iterable $this$any$iv = matchers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (AndroidPatternMatcher)element$iv;
                boolean bl = false;
            } while (!CharSequences.containsUpperCase((CharSequence)it.getPath()));
            return true;
        }

        private final boolean matchesHost(String actualHost, String hostPattern) {
            boolean bl;
            if (!StringsKt.startsWith$default((String)hostPattern, (String)"*", (boolean)false, (int)2, null)) {
                bl = Intrinsics.areEqual((Object)actualHost, (Object)hostPattern);
            } else {
                boolean bl2;
                try {
                    CharSequence charSequence = hostPattern;
                    int n = 1;
                    boolean bl3 = false;
                    String string = charSequence;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    Regex pattern = new Regex(Intrinsics.stringPlus((String)".*", (Object)Pattern.quote(string2)));
                    charSequence = actualHost;
                    n = 0;
                    bl2 = pattern.matches(charSequence);
                }
                catch (Throwable ignore) {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TAG_VALIDATION", "", "TEST_URL", "Lcom/android/tools/lint/detector/api/Issue;", "VALIDATION", "_OLD_ISSUE_URL", "get_OLD_ISSUE_URL$annotations", "isSubstituted", "", "expression", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void get_OLD_ISSUE_URL$annotations() {
        }

        private final boolean isSubstituted(String expression) {
            return Lint.isDataBindingExpression((String)expression) || Lint.isManifestPlaceHolderExpression((String)expression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

