/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000234B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000eH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J|\u0010(\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u00101\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020'0\u000eH\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "mIsAndroidThingsProject", "", "Ljava/lang/Boolean;", "mPermissions", "Lcom/android/tools/lint/checks/PermissionHolder;", "addLocalPermissions", "permissions", "node", "Lorg/jetbrains/uast/UElement;", "applicableAnnotations", "", "", "checkParameterPermission", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "signature", "method", "Lcom/intellij/psi/PsiMethod;", "argument", "Lorg/jetbrains/uast/UExpression;", "checkPermission", "result", "Lcom/android/tools/lint/checks/PermissionFinder$Result;", "requirement", "Lcom/android/tools/lint/checks/PermissionRequirement;", "containsSecurityException", "types", "Lcom/intellij/psi/PsiType;", "getPermissions", "handlesSecurityException", "isAndroidThingsProject", "Lcom/android/tools/lint/detector/api/Context;", "mergeAnnotationPermissions", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "CheckPermissionVisitor", "Companion", "lint-checks"})
public final class PermissionDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private PermissionHolder mPermissions;
    private Boolean mIsAndroidThingsProject;
    private static final Implementation IMPLEMENTATION;
    private static final String THINGS_LIBRARY = "com.google.android.things";
    @JvmField
    @NotNull
    public static final Issue MISSING_PERMISSION;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.PERMISSION_ANNOTATION.oldName(), AnnotationDetector.PERMISSION_ANNOTATION.newName(), AnnotationDetector.PERMISSION_ANNOTATION_READ.oldName(), AnnotationDetector.PERMISSION_ANNOTATION_READ.newName(), AnnotationDetector.PERMISSION_ANNOTATION_WRITE.oldName(), AnnotationDetector.PERMISSION_ANNOTATION_WRITE.newName()});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (annotations == allMemberAnnotations) {
            PermissionRequirement permissionRequirement = PermissionRequirement.create(annotation);
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionRequirement, (String)"PermissionRequirement.create(annotation)");
            PermissionRequirement requirement = permissionRequirement;
            this.checkPermission(context, usage, method, null, requirement);
        } else if (usage instanceof UExpression && method != null) {
            this.checkParameterPermission(context, qualifiedName, method, (UExpression)usage);
        }
    }

    private final void checkParameterPermission(JavaContext context, String signature, PsiMethod method, UExpression argument) {
        PermissionFinder.Operation operation = null;
        if (AnnotationDetector.PERMISSION_ANNOTATION_READ.isEquals(signature)) {
            operation = PermissionFinder.Operation.READ;
        } else if (AnnotationDetector.PERMISSION_ANNOTATION_WRITE.isEquals(signature)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type = argument.getExpressionType();
            if (type != null && Intrinsics.areEqual((Object)"android.content.Intent", (Object)type.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(context, operation, (UElement)argument);
        if (result != null) {
            UElement uElement = (UElement)argument;
            PermissionRequirement permissionRequirement = result.requirement;
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionRequirement, (String)"result.requirement");
            this.checkPermission(context, uElement, method, result, permissionRequirement);
        }
    }

    private final void checkPermission(JavaContext context, UElement node, PsiMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = this.addLocalPermissions(permissions, node))) {
                UIdentifier callIdentifier;
                PermissionFinder.Operation operation = null;
                String name = null;
                if (result != null) {
                    String string = result.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.name");
                    name = string;
                    PermissionFinder.Operation operation2 = result.operation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)operation2), (String)"result.operation");
                    operation = operation2;
                } else {
                    String string;
                    PsiClass containingClass;
                    boolean bl = method != null;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    PsiMethod psiMethod = method;
                    if (psiMethod == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((containingClass = psiMethod.getContainingClass()) != null) {
                        string = containingClass.getName() + "." + method.getName();
                    } else {
                        String string3 = method.getName();
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"method.name");
                    }
                    name = string;
                    if (Intrinsics.areEqual((Object)name, (Object)"Builder.setPersisted") && node instanceof UCallExpression && ((UCallExpression)node).getValueArguments().size() == 1 && Intrinsics.areEqual((Object)ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)((UCallExpression)node).getValueArguments().get(0))), (Object)false)) {
                        return;
                    }
                    operation = PermissionFinder.Operation.CALL;
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Missing permissions required %1$s %2$s: %3$s";
                Object[] objectArray = new Object[]{operation.prefix(), name, requirement.describeMissingPermissions(permissions)};
                boolean bl = false;
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                String message2 = StringsKt.replace$default((String)string4, (String)"carrier privileges", (String)"carrier privileges (see TelephonyManager#hasCarrierPrivileges)", (boolean)false, (int)4, null);
                Location location = context.getLocation(node);
                UCallExpression expressionNode = (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true);
                if (expressionNode != null && (callIdentifier = expressionNode.getMethodIdentifier()) != null && Intrinsics.areEqual((Object)callIdentifier, (Object)node) ^ true) {
                    location = context.getRangeLocation((UElement)callIdentifier, 0, node, 0);
                }
                Set<String> missingPermissions = requirement.getMissingPermissions(permissions);
                PsiMethod psiMethod = method;
                if (Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)"getAllCellInfo") && missingPermissions.size() == 1) {
                    Set<String> set = missingPermissions;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"missingPermissions");
                    if (Intrinsics.areEqual((Object)((String)CollectionsKt.first((Iterable)set)), (Object)"android.permission.ACCESS_COARSE_LOCATION") && permissions.hasPermission("android.permission.ACCESS_FINE_LOCATION")) {
                        return;
                    }
                }
                this.report(context, MISSING_PERMISSION, node, location, message2, this.fix().data(new Object[]{missingPermissions, requirement.getLastApplicableApi()}));
            }
        } else if (requirement.isRevocable(permissions)) {
            AndroidVersion androidVersion = context.getMainProject().getTargetSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.targetSdkVersion");
            if (androidVersion.getFeatureLevel() >= 23 && requirement.getLastApplicableApi() >= 23 && !this.isAndroidThingsProject((Context)context)) {
                boolean handlesMissingPermission = this.handlesSecurityException(node);
                if (!handlesMissingPermission) {
                    boolean message2 = false;
                    message2 = false;
                    PermissionHolder localRequirements = this.addLocalPermissions(new PermissionHolder.SetPermissionLookup(new LinkedHashSet(), new LinkedHashSet(), permissions.getMinSdkVersion(), permissions.getTargetSdkVersion()), node);
                    if (requirement.isSatisfied(localRequirements)) {
                        return;
                    }
                    UMethod methodNode = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                    if (methodNode != null) {
                        CheckPermissionVisitor visitor2 = new CheckPermissionVisitor(node);
                        methodNode.accept((UastVisitor)visitor2);
                        handlesMissingPermission = visitor2.checksPermission();
                    }
                }
                if (!handlesMissingPermission) {
                    String message3 = "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
                    Location location = context.getLocation(node);
                    this.report(context, MISSING_PERMISSION, node, location, message3, this.fix().data(new Object[]{requirement.getRevocablePermissions(permissions), requirement}));
                }
            }
        }
    }

    private final boolean handlesSecurityException(UElement node) {
        UTryExpression tryCatch;
        UElement parent = node;
        while ((tryCatch = (UTryExpression)UastUtils.getParentOfType((UElement)parent, UTryExpression.class, (boolean)true)) != null) {
            for (UCatchClause catchClause : tryCatch.getCatchClauses()) {
                if (!this.containsSecurityException(catchClause.getTypes())) continue;
                return true;
            }
            parent = (UElement)tryCatch;
        }
        UMethod declaration = (UMethod)UastUtils.getParentOfType((UElement)parent, UMethod.class, (boolean)false);
        if (declaration != null) {
            PsiReferenceList psiReferenceList = declaration.getThrowsList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceList, (String)"declaration.throwsList");
            PsiClassType[] thrownTypes = psiReferenceList.getReferencedTypes();
            List<PsiClassType> list = Arrays.asList(Arrays.copyOf(thrownTypes, thrownTypes.length));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<PsiClassType>(*thrownTypes)");
            if (this.containsSecurityException(list)) {
                return true;
            }
        }
        return false;
    }

    private final PermissionHolder addLocalPermissions(PermissionHolder permissions, UElement node) {
        PermissionHolder merged = permissions;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (uMethod == null) {
            return merged;
        }
        UMethod method = uMethod;
        String string = AnnotationDetector.PERMISSION_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PERMISSION_ANNOTATION.oldName()");
        UAnnotation uAnnotation = method.findAnnotation(string);
        if (uAnnotation == null) {
            String string2 = AnnotationDetector.PERMISSION_ANNOTATION.newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PERMISSION_ANNOTATION.newName()");
            uAnnotation = method.findAnnotation(string2);
        }
        UAnnotation annotation = uAnnotation;
        merged = this.mergeAnnotationPermissions(merged, annotation);
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (containingClass != null) {
            String string3 = AnnotationDetector.PERMISSION_ANNOTATION.oldName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PERMISSION_ANNOTATION.oldName()");
            UAnnotation uAnnotation2 = containingClass.findAnnotation(string3);
            if (uAnnotation2 == null) {
                String string4 = AnnotationDetector.PERMISSION_ANNOTATION.newName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"PERMISSION_ANNOTATION.newName()");
                uAnnotation2 = containingClass.findAnnotation(string4);
            }
            annotation = uAnnotation2;
            merged = this.mergeAnnotationPermissions(merged, annotation);
        }
        return merged;
    }

    private final PermissionHolder mergeAnnotationPermissions(PermissionHolder permissions, UAnnotation annotation) {
        PermissionHolder merged = permissions;
        if (annotation != null) {
            PermissionRequirement permissionRequirement = PermissionRequirement.create(annotation);
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionRequirement, (String)"PermissionRequirement.create(annotation)");
            PermissionRequirement requirement = permissionRequirement;
            PermissionHolder permissionHolder = PermissionHolder.SetPermissionLookup.join(merged, requirement);
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionHolder, (String)"PermissionHolder.SetPerm\u2026join(merged, requirement)");
            merged = permissionHolder;
        }
        return merged;
    }

    private final boolean containsSecurityException(List<? extends PsiType> types) {
        for (PsiType psiType : types) {
            PsiClass cls;
            if (!(psiType instanceof PsiClassType) || (cls = ((PsiClassType)psiType).resolve()) == null || !Intrinsics.areEqual((Object)"java.lang.SecurityException", (Object)cls.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private final PermissionHolder getPermissions(JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            Project mainProject = context.getMainProject();
            Document mergedManifest = mainProject.getMergedManifest();
            if (mergedManifest != null) {
                Iterator iterator = XmlUtils.getSubTags((Node)mergedManifest.getDocumentElement()).iterator();
                while (iterator.hasNext()) {
                    String name;
                    String protectionLevel;
                    Element element;
                    Element element2 = element = (Element)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                    String nodeName = element2.getNodeName();
                    if (Intrinsics.areEqual((Object)"uses-permission", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-23", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-m", (Object)nodeName)) {
                        String name2;
                        String string = name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                        CharSequence charSequence = string;
                        boolean bl = false;
                        if (charSequence.length() == 0) continue;
                        permissions.add(name2);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)nodeName, (Object)"permission") || !Intrinsics.areEqual((Object)"dangerous", (Object)(protectionLevel = element.getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")))) continue;
                    String string = name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    CharSequence charSequence = string;
                    boolean bl = false;
                    if (charSequence.length() == 0) continue;
                    revocable.add(name);
                }
            }
            AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
            AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
        }
        PermissionHolder permissionHolder = this.mPermissions;
        if (permissionHolder == null) {
            Intrinsics.throwNpe();
        }
        return permissionHolder;
    }

    private final boolean isAndroidThingsProject(Context context) {
        if (this.mIsAndroidThingsProject == null) {
            Project project = context.getMainProject();
            Document document = project.getMergedManifest();
            if (document == null) {
                return false;
            }
            Document mergedManifest = document;
            Element element = mergedManifest.getDocumentElement();
            if (element == null) {
                return false;
            }
            Element manifest = element;
            Element element2 = XmlUtils.getFirstSubTagByName((Node)manifest, (String)"application");
            if (element2 == null) {
                return false;
            }
            Element application = element2;
            Element usesLibrary = XmlUtils.getFirstSubTagByName((Node)application, (String)"uses-library");
            while (usesLibrary != null && this.mIsAndroidThingsProject == null) {
                String name = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                boolean isThingsLibraryRequired = true;
                String required = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                if (Intrinsics.areEqual((Object)"false", (Object)required)) {
                    isThingsLibraryRequired = false;
                }
                if (Intrinsics.areEqual((Object)THINGS_LIBRARY, (Object)name) && isThingsLibraryRequired) {
                    this.mIsAndroidThingsProject = true;
                }
                usesLibrary = XmlUtils.getNextTagByName((Node)usesLibrary, (String)"uses-library");
            }
            if (this.mIsAndroidThingsProject == null) {
                this.mIsAndroidThingsProject = false;
            }
        }
        Boolean bl = this.mIsAndroidThingsProject;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(PermissionDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 9;
        String string = null;
        Category category = Category.CORRECTNESS;
        MISSING_PERMISSION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MissingPermission", (String)"Missing Permissions", (String)"\n                This check scans through your code and libraries and looks at the APIs being \\\n                used, and checks this against the set of permissions required to access \\\n                those APIs. If the code using those APIs is called at runtime, then the \\\n                program will crash.\n\n                Furthermore, for permissions that are revocable (with `targetSdkVersion` 23), \\\n                client code must also be prepared to handle the calls throwing an exception \\\n                if the user rejects the request for permission at runtime.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$CheckPermissionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "mTarget", "Lorg/jetbrains/uast/UElement;", "(Lorg/jetbrains/uast/UElement;)V", "mChecksPermission", "", "mDone", "checksPermission", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitElement", "visitMethodCallExpression", "", "lint-checks"})
    private static final class CheckPermissionVisitor
    extends AbstractUastVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final UElement mTarget;

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.mDone || super.visitElement(node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node))) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private final void visitMethodCallExpression(UCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodName()) != null && (StringsKt.startsWith$default((String)name, (String)"check", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null)) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null)) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public final boolean checksPermission() {
            return this.mChecksPermission;
        }

        public CheckPermissionVisitor(@NotNull UElement mTarget) {
            Intrinsics.checkParameterIsNotNull((Object)mTarget, (String)"mTarget");
            this.mTarget = mTarget;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "THINGS_LIBRARY", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

