/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OnClickDetector
extends LayoutDetector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"OnClick", (String)"`onClick` method does not exist", (String)"The `onClick` attribute value should be the name of a method in this View's context to invoke when the view is clicked. This name must correspond to a public method that takes exactly one parameter of type `View`.\n\nMust be a string value, using '\\\\;' to escape characters such as '\\\\n' or '\\\\uxxxx' for a unicode character.", (Category)Category.CORRECTNESS, (int)10, (Severity)Severity.ERROR, (Implementation)new Implementation(OnClickDetector.class, Scope.JAVA_AND_RESOURCE_FILES, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE}));
    private Map<String, Location.Handle> names;
    private Map<String, List<String>> similar;

    public void afterCheckRootProject(Context context) {
        if (this.names != null && !this.names.isEmpty() && context.getScope().contains(Scope.JAVA_FILE)) {
            ArrayList<String> missing = new ArrayList<String>(this.names.keySet());
            Collections.sort(missing);
            LintDriver driver = context.getDriver();
            for (String name : missing) {
                List<String> matches;
                Location.Handle handle = this.names.get(name);
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && driver.isSuppressed(null, ISSUE, (Node)clientData)) continue;
                Location location = handle.resolve();
                String message2 = String.format("Corresponding method handler '`public void %1$s(android.view.View)`' not found", name);
                List<String> list = matches = this.similar != null ? this.similar.get(name) : null;
                if (matches != null) {
                    Collections.sort(matches);
                    message2 = message2 + String.format(" (did you mean `%1$s` ?)", Joiner.on((String)", ").join(matches));
                }
                context.report(ISSUE, location, message2);
            }
        }
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("onClick");
    }

    private static String validateJavaIdentifier(String text) {
        if (Lint.isJavaKeyword((String)text)) {
            return "cannot be a Java keyword";
        }
        int len = text.length();
        if (len == 0) {
            return "cannot be empty";
        }
        if (!Character.isJavaIdentifierStart(text.charAt(0))) {
            return "cannot start with the character '`" + text.charAt(0) + "`'";
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
            return "cannot contain the character '`" + text.charAt(i) + "`'";
        }
        return null;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Project project = context.getProject();
        if (!project.getReportIssues()) {
            return;
        }
        String value = attribute.getValue();
        if (value.isEmpty() || value.trim().isEmpty()) {
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "`onClick` attribute value cannot be empty");
        } else {
            if (value.startsWith("@{") || value.startsWith("@={")) {
                return;
            }
            if (value.contains(" ")) {
                context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), "There should be no spaces in the `onClick` handler name");
            } else if (!value.startsWith("@")) {
                Element root;
                String ctx;
                String validationError;
                if (value.contains("\\u")) {
                    Pattern pattern = Pattern.compile("\\\\u(\\d\\d\\d\\d)");
                    Matcher matcher = pattern.matcher(value);
                    StringBuilder sb = new StringBuilder(value.length());
                    int remainder = 0;
                    while (matcher.find()) {
                        sb.append(value.substring(0, matcher.start()));
                        String unicode = matcher.group(1);
                        int hex = Integer.parseInt(unicode, 16);
                        sb.append((char)hex);
                        remainder = matcher.end();
                    }
                    sb.append(value.substring(remainder));
                    value = sb.toString();
                }
                if ((validationError = OnClickDetector.validateJavaIdentifier(value)) != null) {
                    context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), "`onClick` handler method name " + validationError);
                    return;
                }
                if (this.names == null) {
                    this.names = new HashMap<String, Location.Handle>();
                }
                Location.Handle handle = context.createLocationHandle((Node)attribute);
                handle.setClientData((Object)attribute);
                this.names.put(value, handle);
                if (!context.getScope().contains(Scope.JAVA_FILE) && !(ctx = (root = attribute.getOwnerDocument().getDocumentElement()).getAttributeNS("http://schemas.android.com/tools", "context")).isEmpty()) {
                    JavaEvaluator evaluator;
                    PsiClass cls;
                    UastParser parser;
                    String pkg;
                    if ((ctx.startsWith(".") || !ctx.contains(".")) && (pkg = project.getPackage()) != null) {
                        ctx = pkg + (ctx.startsWith(".") ? "" : ".") + ctx;
                    }
                    if ((parser = context.getClient().getUastParser(project)) != null && (cls = (evaluator = parser.getEvaluator()).findClass(ctx)) != null) {
                        PsiMethod[] methods;
                        boolean found = false;
                        for (PsiMethod method : methods = cls.findMethodsByName(value, false)) {
                            boolean rightArguments;
                            boolean bl = rightArguments = method.getParameterList().getParametersCount() == 1 && evaluator.parameterHasType(method, 0, "android.view.View");
                            if (!rightArguments) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            String message2 = String.format("Corresponding method handler '`public void %1$s(android.view.View)`' not found", value);
                            context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), message2);
                        }
                    }
                }
            }
        }
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        if (this.names == null) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        block0: for (UMethod method : declaration.getMethods()) {
            boolean rightArguments;
            String methodName = method.getName();
            boolean bl = rightArguments = method.getParameterList().getParametersCount() == 1 && evaluator.parameterHasType((PsiMethod)method, 0, "android.view.View");
            if (!this.names.containsKey(methodName)) {
                if (!rightArguments) continue;
                for (String n : this.names.keySet()) {
                    if (!Lint.isEditableTo((String)n, (String)methodName, (int)2)) continue;
                    this.recordSimilar(n, declaration, (PsiMethod)method);
                    continue block0;
                }
                continue;
            }
            if (!rightArguments) continue;
            this.names.remove(methodName);
            if (!evaluator.isPublic((PsiModifierListOwner)method)) {
                Location location = context.getLocation((PsiElement)method);
                String message2 = String.format("`onClick` handler `%1$s(View)` must be public", methodName);
                context.report(ISSUE, (PsiElement)method, location, message2);
            } else if (evaluator.isStatic((PsiModifierListOwner)method)) {
                UMethod locationNode = method;
                PsiModifierList modifierList = method.getModifierList();
                if (modifierList.hasExplicitModifier("static")) {
                    for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (!(child instanceof PsiKeyword) || !"static".equals(child.getText())) continue;
                        locationNode = child;
                        break;
                    }
                }
                Location location = context.getLocation((PsiElement)locationNode);
                String message3 = String.format("`onClick` handler `%1$s(View)` should not be static", methodName);
                context.report(ISSUE, (PsiElement)method, location, message3);
            }
            if (!this.names.isEmpty()) continue;
            this.names = null;
            return;
        }
    }

    private void recordSimilar(String name, UClass containingClass, PsiMethod method) {
        if (this.similar == null) {
            this.similar = new HashMap<String, List<String>>();
        }
        List list = this.similar.computeIfAbsent(name, k -> new ArrayList());
        String signature = containingClass.getName() + '#' + method.getName();
        list.add(signature);
    }
}

