/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class WorkManagerDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String CLASS_WORK_MANAGER = "androidx.work.WorkManager";
    private static final String CLASS_WORK_CONTINUATION = "androidx.work.WorkContinuation";
    private static final String METHOD_BEGIN_WITH = "beginWith";
    private static final String METHOD_BEGIN_UNIQUE_WORK = "beginUniqueWork";
    private static final String METHOD_ENQUEUE = "enqueue";
    private static final String METHOD_ENQUEUE_SYNC = "enqueueSync";
    private static final String METHOD_ENQUEUE_UNIQUE = "enqueueUniquePeriodicWork";
    private static final String METHOD_THEN = "then";
    private static final String METHOD_COMBINE = "combine";
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{METHOD_BEGIN_WITH, METHOD_BEGIN_UNIQUE_WORK, METHOD_THEN, METHOD_COMBINE});
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        void enqueued;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_MANAGER) && !context.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_CONTINUATION)) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
        if (uMethod == null) {
            return;
        }
        UMethod surrounding = uMethod;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        surrounding.accept((UastVisitor)new DataFlowAnalyzer((Ref.BooleanRef)enqueued, node, CollectionsKt.listOf((Object)node)){
            final /* synthetic */ Ref.BooleanRef $enqueued;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                String methodName = Lint.getMethodName((UCallExpression)call);
                if (Intrinsics.areEqual((Object)methodName, (Object)"enqueue") || Intrinsics.areEqual((Object)methodName, (Object)"enqueueSync") || Intrinsics.areEqual((Object)methodName, (Object)"enqueueUniquePeriodicWork")) {
                    this.$enqueued.element = true;
                } else if (Intrinsics.areEqual((Object)methodName, (Object)"then") || Intrinsics.areEqual((Object)methodName, (Object)"combine")) {
                    this.$enqueued.element = true;
                }
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                String methodName = Lint.getMethodName((UCallExpression)call);
                if (Intrinsics.areEqual((Object)methodName, (Object)"combine")) {
                    this.$enqueued.element = true;
                } else {
                    UElement parent = call.getUastParent();
                    if (parent instanceof UQualifiedReferenceExpression) {
                        PsiElement listVariable = UastUtils.tryResolve((UElement)((UElement)((UQualifiedReferenceExpression)parent).getReceiver()));
                        if (listVariable instanceof PsiLocalVariable) {
                            this.getReferences().add((PsiVariable)listVariable);
                        } else {
                            UElement parentParent = parent.getUastParent();
                            if (parentParent instanceof ULocalVariable) {
                                this.addVariableReference((UVariable)parentParent);
                            }
                        }
                    } else if (parent instanceof ULocalVariable) {
                        this.addVariableReference((UVariable)parent);
                    }
                }
            }

            public boolean returnsSelf(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                String methodName = Lint.getMethodName((UCallExpression)call);
                if (Intrinsics.areEqual((Object)methodName, (Object)"synchronous")) {
                    return true;
                }
                return super.returnsSelf(call);
            }
            {
                this.$enqueued = $captured_local_variable$0;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2, null, 2, null);
            }
        });
        if (!enqueued.element) {
            UElement uElement = node.getUastParent();
            Object object = uElement != null ? uElement.getUastParent() : null;
            if (!(object instanceof ULocalVariable)) {
                object = null;
            }
            ULocalVariable uLocalVariable = (ULocalVariable)object;
            String name = uLocalVariable != null ? uLocalVariable.getName() : null;
            String nameString = name != null ? '`' + name + "` " : "";
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("WorkContinuation " + nameString + "not enqueued: did you forget to call enqueue()?"), null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(WorkManagerDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"EnqueueWork", (String)"WorkManager Enqueue", (String)"\n                `WorkContinuations` cannot be enqueued automatically.  You must call `enqueue()` \\\n                on a `WorkContinuation` to have it and its parent continuations enqueued inside \\\n                `WorkManager`.\n            ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector$Companion;", "", "()V", "CLASS_WORK_CONTINUATION", "", "CLASS_WORK_MANAGER", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "METHOD_BEGIN_UNIQUE_WORK", "METHOD_BEGIN_WITH", "METHOD_COMBINE", "METHOD_ENQUEUE", "METHOD_ENQUEUE_SYNC", "METHOD_ENQUEUE_UNIQUE", "METHOD_THEN", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

