/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.LibraryDesugaringKt;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScannerConstants;
import com.android.utils.SdkUtils;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u0003:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000f\u001a\u00020 H\u0016J0\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010+H\u0016J\u0010\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010+H\u0016J\u0018\u0010-\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\"0/\u0018\u00010.H\u0016J\u0010\u00100\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00101\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u00102\u001a\u000203H\u0016J\u0018\u00105\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/ApiDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/ApiLookup;", "cachedMinApi", "", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "tag", "", "api", "gradleVersion", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "checkFolder", "Lcom/android/tools/lint/detector/api/ResourceContext;", "folderName", "checkLevelList", "checkObsoleteSdkVersion", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApiErrorMessage", "minSdk", "requires", "type", "sig", "getApplicableAttributes", "", "getApplicableElements", "getApplicableUastTypes", "", "Ljava/lang/Class;", "getMinSdk", "isAttributeOfGradientOrGradientItem", "attribute", "Lorg/w3c/dom/Attr;", "visitAttribute", "visitElement", "ApiVisitor", "Companion", "lint-checks"})
public final class ApiDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
ResourceFolderScanner {
    private ApiLookup apiDatabase;
    private int cachedMinApi = -1;
    @JvmField
    public static final AndroidxName REQUIRES_API_ANNOTATION;
    private static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED;
    @JvmField
    @NotNull
    public static final Issue INLINED;
    @JvmField
    @NotNull
    public static final Issue OVERRIDE;
    @JvmField
    @NotNull
    public static final Issue UNUSED;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_SDK;
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";
    public static final Companion Companion;

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.apiDatabase == null) {
            this.apiDatabase = ApiLookup.get(context.getClient(), context.getMainProject().getBuildTarget());
        }
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return true;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return XmlScannerConstants.ALL;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return XmlScannerConstants.ALL;
    }

    /*
     * Unable to fully structure code
     */
    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        block40: {
            block42: {
                block41: {
                    block39: {
                        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
                        v0 = this.apiDatabase;
                        if (v0 == null) {
                            return;
                        }
                        apiDatabase = v0;
                        attributeApiLevel = -1;
                        if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
                            name = attribute.getLocalName();
                            if (Intrinsics.areEqual((Object)name, (Object)"layout_width") ^ true && Intrinsics.areEqual((Object)name, (Object)"layout_height") ^ true && Intrinsics.areEqual((Object)name, (Object)"id") ^ true && (!this.isAttributeOfGradientOrGradientItem(attribute) && Intrinsics.areEqual((Object)name, (Object)"fillType") ^ true || !com.android.tools.lint.checks.ApiDetector$Companion.access$dependsOnAppCompat(ApiDetector.Companion, context.getProject())) && (attributeApiLevel = apiDatabase.getFieldVersion(owner = "android/R$attr", name)) > (minSdk = this.getMinSdk((Context)context)) && attributeApiLevel > context.getFolderVersion()) {
                                v1 = attribute.getOwnerElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"attribute.ownerElement");
                                if (attributeApiLevel > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, v1)) {
                                    v2 = name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"name");
                                    if (!ApiDetector.Companion.isBenignUnusedAttribute(v2) && !com.android.tools.lint.checks.ApiDetector$Companion.access$isAlreadyWarnedDrawableFile(ApiDetector.Companion, context, attribute, attributeApiLevel)) {
                                        if (RtlDetector.isRtlAttributeName(name) || Intrinsics.areEqual((Object)"supportsRtl", (Object)name)) {
                                            if (Intrinsics.areEqual((Object)name, (Object)"paddingStart")) {
                                                buildTools = context.getProject().getBuildToolsRevision();
                                                v3 = isOldBuildTools = buildTools != null && (buildTools.getMajor() < 23 || buildTools.getMajor() == 23 && buildTools.getMinor() == 0 && buildTools.getMicro() == 0);
                                                if (buildTools == null || isOldBuildTools) {
                                                    v4 = attribute.getOwnerElement();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"attribute.ownerElement");
                                                    if (com.android.tools.lint.checks.ApiDetector$Companion.access$viewMayExtendTextView(ApiDetector.Companion, v4)) {
                                                        location = context.getLocation((Node)attribute);
                                                        messagePart = "Attribute `" + attribute.getLocalName() + "` referenced here can result in a crash on " + "some specific devices older than API " + attributeApiLevel + ' ' + "(current min is " + minSdk + ')';
                                                        if (buildTools != null) {
                                                            version = buildTools.toShortString();
                                                            lowCased = StringHelper.usLocaleDecapitalize((String)messagePart);
                                                            v5 = "Upgrade `buildToolsVersion` from `" + version + "` to at least `23.0.1`; if not, " + lowCased;
                                                        } else {
                                                            v5 = messagePart;
                                                        }
                                                        message = v5;
                                                        context.report(ApiDetector.UNSUPPORTED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, attributeApiLevel));
                                                    }
                                                }
                                            }
                                        } else {
                                            location = context.getLocation((Node)attribute);
                                            localName = attribute.getLocalName();
                                            message = "Attribute `" + localName + "` is only used in API level " + attributeApiLevel + " and higher (current min is " + minSdk + ')';
                                            if (Intrinsics.areEqual((Object)"fontFamily", (Object)localName) && com.android.tools.lint.checks.ApiDetector$Companion.access$dependsOnAppCompat(ApiDetector.Companion, context.getMainProject())) {
                                                prefix = XmlUtils.lookupNamespacePrefix((Node)attribute, (String)"http://schemas.android.com/apk/res-auto", (String)"app", (boolean)false);
                                                message = message + " Did you mean `" + prefix + ":fontFamily` ?";
                                            }
                                            context.report(ApiDetector.UNUSED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, attributeApiLevel));
                                        }
                                    }
                                }
                            }
                            if (Intrinsics.areEqual((Object)name, (Object)"divider")) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)name, (Object)"theme")) {
                                v6 = attribute.getOwnerElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"attribute.ownerElement");
                                if (Intrinsics.areEqual((Object)"include", (Object)v6.getTagName()) && Math.max(minSdk = this.getMinSdk((Context)context), context.getFolderVersion()) < 23) {
                                    location = context.getLocation((Node)attribute);
                                    message = "Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is " + minSdk + ')';
                                    context.report(ApiDetector.UNUSED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, 23));
                                }
                            }
                            if (Intrinsics.areEqual((Object)name, (Object)"foreground") && context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
                                v7 = attribute.getOwnerElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"attribute.ownerElement");
                                v8 = v7.getTagName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"attribute.ownerElement.tagName");
                                if (!com.android.tools.lint.checks.ApiDetector$Companion.access$isFrameLayout(ApiDetector.Companion, context, v8, true) && Math.max(minSdk = this.getMinSdk((Context)context), context.getFolderVersion()) < 23) {
                                    location = context.getLocation((Node)attribute);
                                    message = "Attribute `android:foreground` has no effect on API levels lower than 23 (current min is " + minSdk + ')';
                                    context.report(ApiDetector.UNUSED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, 23));
                                }
                            }
                        }
                        value = attribute.getValue();
                        owner = null;
                        name = null;
                        prefix = null;
                        v9 = value;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"value");
                        if (!StringsKt.startsWith$default((String)v9, (String)"@android:", (boolean)false, (int)2, null)) break block39;
                        prefix = "@android:";
                        break block40;
                    }
                    if (!StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) break block41;
                    prefix = "?android:";
                    if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api = 21) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion()) {
                        v10 = attribute.getOwnerElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"attribute.ownerElement");
                        if (api > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, v10)) {
                            location = context.getLocation((Node)attribute);
                            message = "Using theme references in XML drawables requires API level " + api + " (current min is " + minSdk + ')';
                            context.report(ApiDetector.UNSUPPORTED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, api));
                            return;
                        }
                    }
                    break block40;
                }
                if (!StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)"name", (Object)attribute.getName())) break block42;
                v11 = attribute.getOwnerElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"attribute.ownerElement");
                if (!Intrinsics.areEqual((Object)"item", (Object)v11.getTagName())) break block42;
                v12 = attribute.getOwnerElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"attribute.ownerElement");
                if (v12.getParentNode() == null) break block42;
                v13 = attribute.getOwnerElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"attribute.ownerElement");
                v14 = v13.getParentNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"attribute.ownerElement.parentNode");
                if (!Intrinsics.areEqual((Object)"style", (Object)v14.getNodeName())) break block42;
                owner = "android/R$attr";
                api = value;
                minSdk = "android:".length();
                location = false;
                v15 = api.substring(minSdk);
                Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"(this as java.lang.String).substring(startIndex)");
                name = v15;
                prefix = null;
                break block40;
            }
            if (!StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)"parent", (Object)attribute.getName())) ** GOTO lbl-1000
            v16 = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"attribute.ownerElement");
            if (Intrinsics.areEqual((Object)"style", (Object)v16.getTagName())) {
                owner = "android/R$style";
                api = value;
                minSdk = "android:".length();
                location = false;
                v17 = api.substring(minSdk);
                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"(this as java.lang.String).substring(startIndex)");
                name = SdkUtils.getResourceFieldName((String)v17);
                prefix = null;
            } else lbl-1000:
            // 2 sources

            {
                return;
            }
        }
        if (owner == null) {
            v18 = prefix;
            index = StringsKt.indexOf$default((CharSequence)value, (char)'/', (int)(v18 != null ? v18.length() : 0), (boolean)false, (int)4, null);
            if (index >= 0) {
                minSdk = value;
                v19 = prefix;
                location = v19 != null ? v19.length() : 0;
                var16_40 = new StringBuilder().append("android/R$");
                message = false;
                v20 = minSdk.substring(location, index);
                Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var17_41 = v20;
                owner = var16_40.append(var17_41).toString();
                minSdk = value;
                location = index + 1;
                message = false;
                v21 = minSdk.substring(location);
                Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"(this as java.lang.String).substring(startIndex)");
                name = SdkUtils.getResourceFieldName((String)v21);
            } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
                owner = "android/R$attr";
                minSdk = value;
                location = "?android:".length();
                message = false;
                v22 = minSdk.substring(location);
                Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"(this as java.lang.String).substring(startIndex)");
                name = v22;
            } else {
                return;
            }
        }
        if (name == null) {
            return;
        }
        api = apiDatabase.getFieldVersion(owner, name);
        minSdk = this.getMinSdk((Context)context);
        if (api > minSdk && api > context.getFolderVersion()) {
            v23 = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"attribute.ownerElement");
            if (api > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, v23)) {
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attribute.getNamespaceURI())) {
                    return;
                }
                if (attributeApiLevel < api) {
                    if (attributeApiLevel > minSdk) {
                        attributeName = attribute.getLocalName();
                        location = context.getLocation((Node)attribute);
                        message = '`' + name + "` requires API level " + api + " (current min is " + minSdk + "), but note " + "that attribute `" + attributeName + "` is only used in API level " + attributeApiLevel + " and higher";
                        context.report(ApiDetector.UNSUPPORTED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, api));
                    } else {
                        if (api == 17 && RtlDetector.isRtlAttributeName(name) && Intrinsics.areEqual((Object)name, (Object)(old = RtlDetector.convertNewToOld(name))) ^ true) {
                            v24 = parent = attribute.getOwnerElement();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"parent");
                            if (Intrinsics.areEqual((Object)"item", (Object)v24.getTagName())) {
                                v25 = parent.getParentNode();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"parent.parentNode");
                                for (Element item : Lint.getChildren((Node)v25)) {
                                    v26 = v = item.getAttribute("name");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v26, (String)"v");
                                    v27 = old;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v27, (String)"old");
                                    if (!StringsKt.endsWith$default((String)v26, (String)v27, (boolean)false, (int)2, null)) continue;
                                    return;
                                }
                            } else if (parent.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                                return;
                            }
                        }
                        location = context.getLocation((Node)attribute);
                        message = '`' + value + "` requires API level " + api + " (current min is " + minSdk + ')';
                        context.report(ApiDetector.UNSUPPORTED, (Node)attribute, location, message, com.android.tools.lint.checks.ApiDetector$Companion.access$apiLevelFix(ApiDetector.Companion, api));
                    }
                }
            }
        }
    }

    private final boolean isAttributeOfGradientOrGradientItem(Attr attribute) {
        Element element;
        Element element2 = element = attribute.getOwnerElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
        if (Intrinsics.areEqual((Object)element2.getNodeName(), (Object)"gradient")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"item")) {
            Node node = element.getParentNode();
            return Intrinsics.areEqual((Object)(node != null ? node.getLocalName() : null), (Object)"gradient");
        }
        return false;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        String string = element.getTagName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.tagName");
        String tag = string;
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, "vector", 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "animated-vector", 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if (Intrinsics.areEqual((Object)"layer-list", (Object)tag)) {
                    this.checkLevelList(context, element);
                } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            Node node = element.getParentNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"element.parentNode");
            if (node.getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            NodeList nodeList = childNodes;
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String typeString;
                String text;
                Node textNode;
                Node node2 = textNode = childNodes.item(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"textNode");
                if (node2.getNodeType() != 3) continue;
                String string2 = text = textNode.getNodeValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"@android:", (boolean)false, (int)2, null)) continue;
                String string3 = text;
                boolean bl = false;
                text = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                int index = StringsKt.indexOf$default((CharSequence)text, (char)'/', (int)"@android:".length(), (boolean)false, (int)4, null);
                if (index == -1) continue;
                String string4 = text;
                int n2 = "@android:".length();
                boolean bl2 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n2, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (ResourceType.fromXmlValue((String)typeString) == null) continue;
                String owner = "android/R$" + typeString;
                String string6 = text;
                int n3 = index + 1;
                boolean bl3 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                String name = SdkUtils.getResourceFieldName((String)string8);
                int api = apiDatabase.getFieldVersion(owner, name);
                int minSdk = this.getMinSdk((Context)context);
                if (api <= minSdk || api <= context.getFolderVersion() || api <= ApiDetector.Companion.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message2 = '`' + text + "` requires API level " + api + " (current min is " + minSdk + ')';
                context.report(UNSUPPORTED, (Node)element, location, message2, ApiDetector.Companion.apiLevelFix(api));
            }
        } else {
            int minSdk;
            int api;
            if (Intrinsics.areEqual((Object)"view", (Object)tag)) {
                String string9 = element.getAttribute("class");
                if (string9 == null) {
                    return;
                }
                tag = string9;
                CharSequence childNodes = tag;
                boolean i = false;
                if (childNodes.length() == 0) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (Intrinsics.areEqual((Object)tag, (Object)"TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = apiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.Companion.getLocalMinSdk(element)) {
                Location location = context.getNameLocation((Node)element);
                String message3 = "View requires API level " + api + " (current min is " + minSdk + "): `<" + tag + ">`";
                context.report(UNSUPPORTED, (Node)element, location, message3, ApiDetector.Companion.apiLevelFix(api));
            }
        }
    }

    private final void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Element e;
            if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)"item", (Object)curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height") || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.Companion.getLocalMinSdk(element)) continue;
            for (String attributeName : new String[]{"width", "height"}) {
                Attr attribute;
                if (e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName) == null) {
                    continue;
                }
                Location location = context.getLocation((Node)attribute);
                String message2 = "Attribute `" + attribute.getLocalName() + "` is only used in API level " + attributeApiLevel + " and higher (current min is " + minSdk + ')';
                context.report(UNUSED, (Node)attribute, location, message2, ApiDetector.Companion.apiLevelFix(attributeApiLevel));
            }
        }
    }

    private final void checkElement(XmlContext context, Element element, String tag, int api, String gradleVersion, Issue issue) {
        int minSdk;
        String realTag = tag;
        if (Intrinsics.areEqual((Object)realTag, (Object)element.getTagName()) && api > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.Companion.getLocalMinSdk(element) && !ApiDetector.Companion.featureProvidedByGradle(context, gradleVersion)) {
            Location location = context.getNameLocation((Node)element);
            if (Intrinsics.areEqual((Object)"drawable", (Object)realTag)) {
                Attr attr = element.getAttributeNode("class");
                if (attr == null) {
                    return;
                }
                Attr attribute = attr;
                location = context.getLocation((Node)attribute);
                realTag = "class";
            }
            String message2 = null;
            if (issue == UNSUPPORTED) {
                message2 = "`<" + realTag + ">` requires API level " + api + " (current min is " + minSdk + ')';
                if (gradleVersion != null) {
                    message2 = message2 + " or building with Android Gradle plugin " + gradleVersion + " or higher";
                } else if (StringsKt.contains$default((CharSequence)realTag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    message2 = "Custom drawables requires API level " + api + " (current min is " + minSdk + ')';
                }
            } else {
                boolean bl = issue == UNUSED;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    Issue issue2 = issue;
                    throw (Throwable)((Object)new AssertionError(issue2));
                }
                message2 = "`<" + realTag + ">` is only used in API level " + api + " and higher (current min is " + minSdk + ')';
            }
            context.report(issue, (Node)element, location, message2, ApiDetector.Companion.apiLevelFix(api));
        }
    }

    private final int getMinSdk(Context context) {
        if (this.cachedMinApi == -1) {
            AndroidVersion minSdkVersion;
            AndroidVersion androidVersion = minSdkVersion = context.getMainProject().getMinSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"minSdkVersion");
            this.cachedMinApi = androidVersion.getFeatureLevel();
            if (this.cachedMinApi == 1 && !context.getMainProject().isAndroidProject()) {
                this.cachedMinApi = Integer.MAX_VALUE;
            }
        }
        return this.cachedMinApi;
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.apiDatabase == null || context.isTestSource()) {
            return null;
        }
        return !context.getMainProject().isAndroidProject() ? null : (UElementHandler)new ApiVisitor(context);
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{USimpleNameReferenceExpression.class, ULocalVariable.class, UTryExpression.class, UBinaryExpressionWithType.class, UBinaryExpression.class, UCallExpression.class, UClass.class, UMethod.class, UForEachExpression.class, UClassLiteralExpression.class, USwitchExpression.class, UCallableReferenceExpression.class});
    }

    private final String getApiErrorMessage(int minSdk, UElement node, int requires, String type, String sig) {
        String string;
        int min = Math.max(minSdk, com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null));
        if (requires <= 29) {
            string = String.valueOf(requires);
        } else {
            string = SdkVersionInfo.getCodeName((int)requires);
            if (string == null) {
                string = String.valueOf(requires);
            }
        }
        String apiLevel = string;
        String message2 = StringHelper.usLocaleCapitalize((String)type) + " requires API level " + apiLevel + " (current min is " + min + "): `" + sig + '`';
        return message2;
    }

    private final void checkObsoleteSdkVersion(JavaContext context, UElement node) {
        int minSdk;
        Boolean isConditional;
        UBinaryExpression binary = (UBinaryExpression)UastUtils.getParentOfType((UElement)node, UBinaryExpression.class, (boolean)true);
        if (binary != null && (isConditional = VersionChecks.isVersionCheckConditional(minSdk = this.getMinSdk((Context)context), binary)) != null) {
            String message2 = (isConditional != false ? "Unnecessary; SDK_INT is always >= " : "Unnecessary; SDK_INT is never < ") + minSdk;
            context.report(OBSOLETE_SDK, (UElement)binary, context.getLocation((UElement)binary), message2, this.fix().data(new Object[]{isConditional}));
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)folderName, (String)"folderName");
        int folderVersion = context.getFolderVersion();
        AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
        if (folderVersion > 1) {
            AndroidVersion androidVersion = minSdkVersion;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"minSdkVersion");
            if (folderVersion <= androidVersion.getFeatureLevel()) {
                FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
                if (folderConfiguration == null) {
                    File file = context.file;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(((Object)file).toString());
                }
                FolderConfiguration folderConfig = folderConfiguration;
                folderConfig.setVersionQualifier((VersionQualifier)null);
                ResourceFolderType resourceFolderType = context.getResourceFolderType();
                if (resourceFolderType == null) {
                    File file = context.file;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(((Object)file).toString());
                }
                ResourceFolderType resourceFolderType2 = resourceFolderType;
                String newFolderName = folderConfig.getFolderName(resourceFolderType2);
                context.report(OBSOLETE_SDK, Location.Companion.create(context.file), "This folder configuration (`v" + folderVersion + "`) is unnecessary; " + "`minSdkVersion` is " + minSdkVersion.getApiString() + ". " + "Merge all the resources in this folder " + "into `" + newFolderName + "`.", this.fix().data(new Object[]{context.file, newFolderName, minSdkVersion}));
            }
        }
    }

    static {
        Companion = new Companion(null);
        REQUIRES_API_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresApi");
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.MANIFEST), new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE});
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        UNSUPPORTED = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NewApi", (String)"Calling new methods on older versions", (String)"\n                This check scans through all the Android API calls in the application and \\\n                warns about any calls that are not available on **all** versions targeted by \\\n                this application (according to its minimum SDK attribute in the manifest).\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n\n                If you are deliberately setting `android:` attributes in style definitions, \\\n                make sure you place this in a `values-v`*NN* folder in order to avoid running \\\n                into runtime conflicts on certain devices where manufacturers have added \\\n                custom attributes whose ids conflict with the new ones on later platforms.\n\n                Similarly, you can use tools:targetApi=\"11\" in an XML file to indicate that \\\n                the element will only be inflated in an adequate context.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.CORRECTNESS;
        INLINED = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"InlinedApi", (String)"Using inlined constants on older versions", (String)"\n                This check scans through all the Android API field references in the \\\n                application and flags certain constants, such as static final integers and \\\n                Strings, which were introduced in later versions. These will actually be \\\n                copied into the class files rather than being referenced, which means that \\\n                the value is available even when running on older devices. In some cases \\\n                that's fine, and in other cases it can result in a runtime crash or \\\n                incorrect behavior. It depends on the context, so consider the code carefully \\\n                and decide whether it's safe and can be suppressed or whether the code needs \\\n                to be guarded.\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 6;
        string = null;
        category = Category.CORRECTNESS;
        OVERRIDE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Override", (String)"Method conflicts with new inherited method", (String)"\n                Suppose you are building against Android API 8, and you've subclassed \\\n                Activity. In your subclass you add a new method called `isDestroyed`(). \\\n                At some later point, a method of the same name and signature is added to \\\n                Android. Your method will now override the Android method, and possibly break \\\n                its contract. Your method is not calling `super.isDestroyed()`, since your \\\n                compilation target doesn't know about the method.\n\n                The above scenario is what this lint detector looks for. The above example is \\\n                real, since `isDestroyed()` was added in API 17, but it will be true for \\\n                **any** method you have added to a subclass of an Android class where your \\\n                build target is lower than the version the method was introduced in.\n\n                To fix this, either rename your method, or if you are really trying to augment \\\n                the builtin method if available, switch to a higher build target where you can \\\n                deliberately add `@Override` on your overriding method, and call `super` if \\\n                appropriate etc.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.RESOURCE_FOLDER_SCOPE});
        bl = false;
        bl2 = true;
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.CORRECTNESS;
        UNUSED = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UnusedAttribute", (String)"Attribute unused on older versions", (String)"\n                This check finds attributes set in XML files that were introduced in a version \\\n                newer than the oldest version targeted by your application (with the \\\n                `minSdkVersion` attribute).\n\n                This is not an error; the application will simply ignore the attribute. \\\n                However, if the attribute is important to the appearance or functionality of \\\n                your application, you should consider finding an alternative way to achieve the \\\n                same result with only available attributes, and then you can optionally create \\\n                a copy of the layout in a layout-vNN folder which will be used on API NN or \\\n                higher where you can take advantage of the newer attribute.\n\n                Note: This check does not only apply to attributes. For example, some tags can \\\n                be unused too, such as the new `<tag>` element in layouts introduced in API 21.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.PERFORMANCE;
        OBSOLETE_SDK = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ObsoleteSdkInt", (String)"Obsolete SDK_INT Version Check", (String)"\n                This check flags version checks that are not necessary, because the \\\n                `minSdkVersion` (or surrounding known API level) is already at least as high \\\n                as the version checked for.\n\n                Similarly, it also looks for resources in `-vNN` folders, such as `values-v14` \\\n                where the version qualifier is less than or equal to the `minSdkVersion`, \\\n                where the contents should be merged into the best folder.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    public static final /* synthetic */ void access$setApiDatabase$p(ApiDetector $this, ApiLookup apiLookup) {
        $this.apiDatabase = apiLookup;
    }

    @JvmStatic
    @JvmOverloads
    public static final int getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @JvmOverloads
    public static final int getTargetApi(@Nullable UElement scope) {
        return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, scope, null, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\"\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010,\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\nH\u0002JX\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001e2\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u001eH\u0002Jp\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u0002052\u0006\u0010\u0018\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u0002002\u0006\u0010=\u001a\u0002002\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020AH\u0016J\"\u0010B\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020\u000fH\u0002J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020DH\u0016J\u0010\u0010G\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\u0010\u0010X\u001a\u00020\u00062\u0006\u0010(\u001a\u00020AH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$ApiVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/checks/ApiDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkAnnotationTarget", "", "element", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "modifierListOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "checkCast", "node", "Lorg/jetbrains/uast/UElement;", "classType", "Lcom/intellij/psi/PsiClassType;", "interfaceType", "checkCatchTypeElement", "statement", "Lorg/jetbrains/uast/UTryExpression;", "typeReference", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "type", "Lcom/intellij/psi/PsiType;", "checkClass", "cls", "Lcom/intellij/psi/PsiClass;", "descriptor", "", "owner", "fqcn", "checkClassReference", "", "checkClassType", "checkField", "field", "Lcom/intellij/psi/PsiField;", "checkMethodReference", "expression", "Lorg/jetbrains/uast/UReferenceExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkRequiresApi", "member", "Lcom/intellij/psi/PsiMember;", "getRequiresApiFromAnnotations", "", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "name", "desc", "sig", "requires", "minSdk", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "visitCallExpression", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitForEachExpression", "Lorg/jetbrains/uast/UForEachExpression;", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "visitTryExpression", "visitTypeCastExpression", "lint-checks"})
    private final class ApiVisitor
    extends UElementHandler {
        private final JavaContext context;

        private final void report(Issue issue, UElement node, Location location, String type, String sig, int requires, int minSdk, LintFix fix, String owner, String name, String desc) {
            String message2 = ApiDetector.this.getApiErrorMessage(minSdk, node, requires, type, sig);
            this.report(issue, node, location, message2, fix, owner, name, desc);
        }

        static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, String string2, int n, int n2, LintFix lintFix, String string3, String string4, String string5, int n3, Object object) {
            if ((n3 & 0x80) != 0) {
                lintFix = null;
            }
            if ((n3 & 0x100) != 0) {
                string3 = null;
            }
            if ((n3 & 0x200) != 0) {
                string4 = null;
            }
            if ((n3 & 0x400) != 0) {
                string5 = null;
            }
            apiVisitor.report(issue, uElement, location, string, string2, n, n2, lintFix, string3, string4, string5);
        }

        private final void report(Issue issue, UElement node, Location location, String message2, LintFix fix, String owner, String name, String desc) {
            if (owner != null && (StringsKt.startsWith$default((String)owner, (String)"java/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null)) && this.context.getMainProject().isDesugaring(Desugaring.JAVA_8_LIBRARY) && LibraryDesugaringKt.isApiDesugared(this.context, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), name)) {
                return;
            }
            this.context.report(issue, node, location, message2, fix);
        }

        static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, LintFix lintFix, String string2, String string3, String string4, int n, Object object) {
            if ((n & 0x10) != 0) {
                lintFix = null;
            }
            if ((n & 0x20) != 0) {
                string2 = null;
            }
            if ((n & 0x40) != 0) {
                string3 = null;
            }
            if ((n & 0x80) != 0) {
                string4 = null;
            }
            apiVisitor.report(issue, uElement, location, string, lintFix, string2, string3, string4);
        }

        public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            } else if (resolved instanceof PsiMethod && node instanceof UCallExpression) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiMethod) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        private final void checkMethodReference(UReferenceExpression expression, PsiMethod method) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return");
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName((PsiMethod)method);
            String string2 = evaluator.getMethodDescription(method, false, false);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            int api = apiDatabase.getMethodVersion(owner, name, desc);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, (UElement)expression, minSdk)) {
                return;
            }
            String signature = expression.asSourceString();
            Location location = this.context.getLocation((UElement)expression);
            this.report(UNSUPPORTED, (UElement)expression, location, "Method reference", signature, api, minSdk, Companion.apiLevelFix(api), owner, name, desc);
        }

        public void visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            PsiType type;
            UTypeReferenceExpression typeReference;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (UastExpressionUtils.isTypeCast((UElement)((UElement)node))) {
                this.visitTypeCastExpression(node);
            } else if (UastExpressionUtils.isInstanceCheck((UElement)((UElement)node)) && (typeReference = node.getTypeReference()) != null && (type = typeReference.getType()) instanceof PsiClassType) {
                this.checkClassReference((UElement)typeReference, (PsiClassType)type);
            }
        }

        private final void visitTypeCastExpression(UBinaryExpressionWithType expression) {
            UExpression operand = expression.getOperand();
            PsiType operandType = operand.getExpressionType();
            PsiType castType = expression.getType();
            if (Intrinsics.areEqual((Object)castType, (Object)operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            UTypeReferenceExpression typeReference = expression.getTypeReference();
            if (typeReference != null && !this.checkClassReference((UElement)typeReference, (PsiClassType)castType)) {
                return;
            }
            this.checkCast((UElement)expression, (PsiClassType)operandType, (PsiClassType)castType);
        }

        private final boolean checkClassReference(UElement node, PsiClassType classType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return true;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(classType);
            if (string == null) {
                return true;
            }
            String expressionOwner = string;
            int api = apiDatabase.getClassVersion(expressionOwner);
            if (api == -1) {
                return true;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return true;
            }
            Location location = this.context.getLocation(node);
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, "Class", expressionOwner, api, minSdk, Companion.apiLevelFix(api), expressionOwner, null, null, 1536, null);
            return false;
        }

        private final void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            if (Intrinsics.areEqual((Object)classType, (Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String classTypeInternal = evaluator.getQualifiedName(classType);
            String interfaceTypeInternal = evaluator.getQualifiedName(interfaceType);
            if (interfaceTypeInternal == null || classTypeInternal == null) {
                return;
            }
            if (ApiLookup.equivalentName(interfaceTypeInternal, "java/lang/Object")) {
                return;
            }
            int api = apiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (api <= minSdk) {
                return;
            }
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return;
            }
            Location location = this.context.getLocation(node);
            String message2 = null;
            String to = interfaceType.getClassName();
            String from = classType.getClassName();
            int min = Math.max(minSdk, com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null));
            message2 = Intrinsics.areEqual((Object)interfaceTypeInternal, (Object)classTypeInternal) ? "Cast to `" + to + "` requires API level " + api + " (current min is " + min + ')' : "Cast from `" + from + "` to `" + to + "` requires API level " + api + " (current min is " + min + ')';
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, message2, Companion.apiLevelFix(api), classTypeInternal, null, null, 192, null);
        }

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass containingClass = node.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !this.context.getMainProject().isDesugaring(Desugaring.INTERFACE_METHODS)) {
                int minSdk;
                int api;
                PsiModifierList psiModifierList = node.getModifierList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"node.modifierList");
                PsiModifierList methodModifierList = psiModifierList;
                if ((methodModifierList.hasExplicitModifier("default") || methodModifierList.hasExplicitModifier("static")) && !Companion.isSuppressed(this.context, api = 24, (UElement)node, minSdk = ApiDetector.this.getMinSdk((Context)this.context))) {
                    Location location = this.context.getLocation(node);
                    String desc = methodModifierList.hasExplicitModifier("default") ? "Default method" : "Static interface method";
                    ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, desc, containingClass.getName() + "#" + node.getName(), api, minSdk, Companion.apiLevelFix(api), containingClass.getQualifiedName(), null, null, 1536, null);
                }
            }
            int buildSdk = this.context.getMainProject().getBuildSdk();
            String name = node.getName();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiMethod superMethod = evaluator.getSuperMethod((PsiMethod)node);
            while (superMethod != null) {
                String fqcn;
                PsiClass cls;
                if (superMethod.getContainingClass() == null) {
                    break;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)cls, (String)"superMethod.containingClass ?: break");
                if (cls.getQualifiedName() == null) {
                    break;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fqcn, (String)"cls.qualifiedName ?: break");
                if (!StringsKt.startsWith$default((String)fqcn, (String)"android.", (boolean)false, (int)2, null) && (!StringsKt.startsWith$default((String)fqcn, (String)"java.", (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)fqcn, (Object)"java.lang.Object") ^ true)) && !StringsKt.startsWith$default((String)fqcn, (String)"javax.", (boolean)false, (int)2, null)) break;
                String desc = evaluator.getMethodDescription(superMethod, false, false);
                if (desc != null) {
                    String owner;
                    if (evaluator.getQualifiedName(cls) == null) {
                        return;
                    }
                    int api = apiDatabase.getMethodVersion(owner, name, desc);
                    if (api > buildSdk && buildSdk != -1) {
                        if (this.context.getDriver().isSuppressed(this.context, OVERRIDE, (UElement)node)) {
                            return;
                        }
                        if (containingClass != null) {
                            String className = containingClass.getName();
                            String fullClassName = containingClass.getQualifiedName();
                            if (fullClassName != null) {
                                className = fullClassName;
                            }
                            fqcn = className + '#' + name;
                        } else {
                            fqcn = name;
                        }
                        String message2 = "This method is not overriding anything with the current " + "build target, but will in API level " + api + " (current " + "target is " + buildSdk + "): `" + fqcn + '`';
                        PsiElement locationNode = (PsiElement)node.getNameIdentifier();
                        if (locationNode == null) {
                            locationNode = (PsiElement)node;
                        }
                        Location location = this.context.getLocation(locationNode);
                        ApiVisitor.report$default(this, OVERRIDE, (UElement)node, location, message2, null, null, null, null, 240, null);
                    }
                }
                superMethod = evaluator.getSuperMethod(superMethod);
            }
        }

        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (node.isAnnotationType() && !this.context.getMainProject().isDesugaring(Desugaring.TYPE_ANNOTATIONS)) {
                JavaEvaluator evaluator = this.context.getEvaluator();
                for (PsiAnnotation annotation : evaluator.getAllAnnotations((PsiModifierListOwner)node, false)) {
                    PsiNameValuePair[] attributes;
                    String name = annotation.getQualifiedName();
                    if (Intrinsics.areEqual((Object)"java.lang.annotation.Repeatable", (Object)name)) {
                        int api = 24;
                        int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                        if (Companion.isSuppressed(this.context, api, (UElement)node, minSdk)) continue;
                        Location location = this.context.getLocation((PsiElement)annotation);
                        int min = Math.max(minSdk, com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null));
                        String message2 = "Repeatable annotation requires API level " + api + " (current min is " + min + ')';
                        this.context.report(UNSUPPORTED, (PsiElement)annotation, location, message2, Companion.apiLevelFix(api));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)"java.lang.annotation.Target", (Object)name)) continue;
                    PsiAnnotationParameterList psiAnnotationParameterList = annotation.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"annotation.parameterList");
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList.getAttributes(), (String)"annotation.parameterList.attributes");
                    PsiNameValuePair[] psiNameValuePairArray = attributes;
                    int n = psiNameValuePairArray.length;
                    for (int i = 0; i < n; ++i) {
                        PsiNameValuePair pair;
                        PsiNameValuePair psiNameValuePair = pair = psiNameValuePairArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiNameValuePair, (String)"pair");
                        PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                        if (value instanceof PsiArrayInitializerMemberValue) {
                            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)value).getInitializers();
                            int n2 = psiAnnotationMemberValueArray.length;
                            for (int j = 0; j < n2; ++j) {
                                PsiAnnotationMemberValue t;
                                PsiAnnotationMemberValue psiAnnotationMemberValue = t = psiAnnotationMemberValueArray[j];
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationMemberValue, (String)"t");
                                this.checkAnnotationTarget(psiAnnotationMemberValue, (PsiModifierListOwner)node, evaluator);
                            }
                            continue;
                        }
                        if (value == null) continue;
                        this.checkAnnotationTarget(value, (PsiModifierListOwner)node, evaluator);
                    }
                }
            }
            for (UTypeReferenceExpression typeReferenceExpression : node.getUastSuperTypes()) {
                PsiClass cls;
                PsiType type = typeReferenceExpression.getType();
                if (!(type instanceof PsiClassType) || (cls = ((PsiClassType)type).resolve()) == null) continue;
                this.checkClass((UElement)typeReferenceExpression, cls);
            }
        }

        public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiType type = node.getType();
            if (type instanceof PsiClassType) {
                UExpression lhs = node.getExpression();
                UExpression uExpression = lhs;
                if (uExpression == null) {
                    uExpression = (UExpression)node;
                }
                UExpression locationElement = uExpression;
                this.checkClassType((UElement)locationElement, (PsiClassType)type, null);
            }
        }

        private final void checkClassType(UElement element, PsiClassType classType, String descriptor) {
            String owner = this.context.getEvaluator().getQualifiedName(classType);
            String string = classType.getCanonicalText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classType.canonicalText");
            String fqcn = string;
            if (owner != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, PsiClass cls) {
            String string = this.context.getEvaluator().getQualifiedName(cls);
            if (string == null) {
                return;
            }
            String owner = string;
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, null, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, String descriptor, String owner, String fqcn) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            int api = apiDatabase.getClassVersion(owner);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, element, minSdk)) {
                return;
            }
            if (UastUtils.getParentOfType$default((UElement)element, UAnnotation.class, (boolean)false, (int)2, null) != null) {
                return;
            }
            Location location = this.context.getNameLocation(element);
            String string = descriptor;
            if (string == null) {
                string = "Class";
            }
            String desc = string;
            ApiVisitor.report$default(this, UNSUPPORTED, element, location, desc, fqcn, api, minSdk, Companion.apiLevelFix(api), owner, null, null, 1536, null);
        }

        private final void checkAnnotationTarget(PsiAnnotationMemberValue element, PsiModifierListOwner modifierListOwner, JavaEvaluator evaluator) {
            block2: {
                String referenceName;
                block3: {
                    if (!(element instanceof UReferenceExpression) || !Intrinsics.areEqual((Object)"TYPE_PARAMETER", (Object)(referenceName = UastLintUtils.Companion.getReferenceName((UReferenceExpression)element))) && !Intrinsics.areEqual((Object)"TYPE_USE", (Object)referenceName)) break block2;
                    PsiAnnotation retention = evaluator.findAnnotation(modifierListOwner, new String[]{"java.lang.annotation.Retention"});
                    if (retention == null) break block3;
                    String string = retention.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"retention.text");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"RUNTIME", (boolean)false, (int)2, null)) break block2;
                }
                Location location = this.context.getLocation((UElement)element);
                String message2 = "Type annotations are not supported in Android: `" + referenceName + '`';
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)element, location, message2, null, null, null, null, 240, null);
            }
        }

        public void visitForEachExpression(@NotNull UForEachExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            UExpression value = node.getIteratedValue();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiType type = value.getExpressionType();
            if (type instanceof PsiClassType) {
                PsiClass containingClass;
                PsiElement keySet;
                String string = evaluator.getQualifiedName((PsiClassType)type);
                if (string == null) {
                    return;
                }
                String expressionOwner = string;
                int api = apiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (Companion.isSuppressed(this.context, api, (UElement)node, minSdk)) {
                    return;
                }
                Location location = this.context.getLocation((UElement)value);
                int min = Math.max(minSdk, com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null));
                String message2 = "The type of the for loop iterated value is " + ((PsiClassType)type).getCanonicalText() + ", which requires API level " + api + " (current min is " + min + ')';
                if (value instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)"keySet", (Object)((UQualifiedReferenceExpression)value).getResolvedName()) && (keySet = ((UQualifiedReferenceExpression)value).resolve()) instanceof PsiMethod && (containingClass = ((PsiMethod)keySet).getContainingClass()) != null && Intrinsics.areEqual((Object)"java.util.concurrent.ConcurrentHashMap", (Object)containingClass.getQualifiedName())) {
                    message2 = message2 + "; to work around this, add an explicit cast to `(Map)` before the `keySet` call.";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, message2, Companion.apiLevelFix(api), expressionOwner, null, null, 192, null);
            }
        }

        public void visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiMethod method = node.resolve();
            if (method == null) {
                PsiElement resolved;
                UReferenceExpression reference = node.getClassReference();
                if (reference != null && (resolved = reference.resolve()) instanceof PsiClass) {
                    this.checkRequiresApi((UElement)node, (PsiMember)resolved, (PsiModifierListOwner)resolved);
                }
                return;
            }
            this.visitCall(method, node, (UElement)node);
        }

        /*
         * WARNING - void declaration
         */
        private final void visitCall(PsiMethod method, UCallExpression call, UElement reference) {
            Location location;
            UElement nameIdentifier;
            int api;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return");
            PsiClass containingClass = psiClass;
            if (!this.checkRequiresApi(reference, (PsiMember)method, (PsiModifierListOwner)method)) {
                this.checkRequiresApi(reference, (PsiMember)method, (PsiModifierListOwner)containingClass);
            }
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList parameterList = psiParameterList;
            if (parameterList.getParametersCount() > 0 && call != null) {
                PsiParameter[] psiParameterArray = parameterList.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"parameterList.parameters");
                PsiParameter[] parameters = psiParameterArray;
                List arguments = call.getValueArguments();
                int n = 0;
                int n2 = parameters.length;
                while (n < n2) {
                    PsiType parameterType;
                    void i;
                    PsiParameter psiParameter = parameters[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[i]");
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter.getType(), (String)"parameters[i].type");
                    if (parameterType instanceof PsiClassType) {
                        if (i >= arguments.size()) break;
                        UExpression argument = (UExpression)arguments.get((int)i);
                        PsiType argumentType = argument.getExpressionType();
                        if (argumentType != null && !Intrinsics.areEqual((Object)parameterType, (Object)argumentType) && argumentType instanceof PsiClassType) {
                            this.checkCast((UElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                        }
                    }
                    ++i;
                }
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            if (ApiLookup.startsWithEquivalentPrefix(owner, "android/support/")) {
                return;
            }
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName((PsiMethod)method);
            String string2 = evaluator.getMethodDescription(method, false, false);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            if (call != null && ApiLookup.startsWithEquivalentPrefix(owner, "java/text/SimpleDateFormat") && Intrinsics.areEqual((Object)name, (Object)"<init>") && Intrinsics.areEqual((Object)desc, (Object)"()V") ^ true) {
                Companion.checkSimpleDateFormat(this.context, call, ApiDetector.this.getMinSdk((Context)this.context));
            }
            if ((api = apiDatabase.getMethodVersion(owner, name, desc)) == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (api <= minSdk) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            if (call != null && UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                UExpression qualifier = call.getReceiver();
                if (qualifier != null && !(qualifier instanceof UThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    PsiClassType containingType;
                    List inheritanceChain;
                    PsiType receiverType = qualifier.getExpressionType();
                    if (receiverType instanceof PsiClassType && (inheritanceChain = Companion.getInheritanceChain((PsiClassType)receiverType, containingType = this.context.getEvaluator().getClassType(containingClass))) != null) {
                        for (PsiClassType type : inheritanceChain) {
                            String expressionOwner = evaluator.getQualifiedName(type);
                            if (expressionOwner == null || !(Intrinsics.areEqual((Object)expressionOwner, (Object)owner) ^ true)) continue;
                            int specificApi = apiDatabase.getMethodVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (!apiDatabase.isRelevantOwner(expressionOwner)) continue;
                                return;
                            }
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = type.getCanonicalText();
                            }
                            api = Math.min(specificApi, api);
                        }
                    }
                } else {
                    UInstanceExpression pte;
                    PsiElement resolved;
                    PsiClass cls = null;
                    String string3 = this.context.file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.file.path");
                    if (StringsKt.endsWith$default((String)string3, (String)".java", (boolean)false, (int)2, null)) {
                        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)call));
                        cls = uClass != null ? uClass.getJavaPsi() : null;
                    } else {
                        PsiType receiverType = call.getReceiverType();
                        if (receiverType instanceof PsiClassType) {
                            cls = ((PsiClassType)receiverType).resolve();
                        }
                    }
                    if ((qualifier instanceof UThisExpression || qualifier instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)qualifier).resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            PsiClassType anonymousBaseType;
                            boolean found = false;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((PsiAnonymousClass)cls).getBaseClassType(), (String)"cls.baseClassType");
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)cls), PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getQualifiedName(cls)) == null || ApiLookup.equivalentName(expressionOwner, "java/lang/Object")) break;
                        int specificApi = apiDatabase.getMethodVersion(expressionOwner, name, desc);
                        if (specificApi == -1) {
                            if (apiDatabase.isRelevantOwner(expressionOwner)) {
                                break;
                            }
                        } else {
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = cls.getQualifiedName();
                            }
                            api = Math.min(specificApi, api);
                            break;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            if (Companion.isSuppressed(this.context, api, reference, minSdk)) {
                return;
            }
            if (call != null && UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                UExpression receiver = call.getReceiver();
                PsiClass target2 = null;
                if (!method.isConstructor()) {
                    if (receiver != null) {
                        PsiType type = receiver.getExpressionType();
                        if (type instanceof PsiClassType) {
                            target2 = ((PsiClassType)type).resolve();
                        }
                    } else {
                        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)call));
                        Object object = target2 = uClass != null ? uClass.getJavaPsi() : null;
                    }
                }
                if (target2 != null) {
                    PsiMethod[] psiMethodArray = target2.findMethodsBySignature(method, true);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"target.findMethodsBySignature(method, true)");
                    PsiMethod[] methods = psiMethodArray;
                    if (methods.length > 1) {
                        for (PsiMethod m : methods) {
                            int methodApi;
                            String methodOwner;
                            if (!(Intrinsics.areEqual((Object)method, (Object)m) ^ true)) continue;
                            PsiMethod psiMethod = m;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"m");
                            PsiClass provider = psiMethod.getContainingClass();
                            if (provider == null || (methodOwner = evaluator.getQualifiedName(provider)) == null || (methodApi = apiDatabase.getMethodVersion(methodOwner, name, desc)) != -1 && methodApi > minSdk) continue;
                            return;
                        }
                    }
                }
                if (receiver instanceof USuperExpression) {
                    PsiMethod containingMethod;
                    UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)call));
                    Object object = containingMethod = uMethod != null ? uMethod.getJavaPsi() : null;
                    if (containingMethod != null && Intrinsics.areEqual((Object)name, (Object)containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                        return;
                    }
                }
                if (!(method instanceof PsiCompiledElement)) {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)name, (Object)"compare") && api == 19 && ApiLookup.startsWithEquivalentPrefix(owner, "java/lang/") && desc.length() == 4 && this.context.getMainProject().isDesugaring(Desugaring.LONG_COMPARE) && (Intrinsics.areEqual((Object)desc, (Object)"(JJ)") || Intrinsics.areEqual((Object)desc, (Object)"(ZZ)") || Intrinsics.areEqual((Object)desc, (Object)"(BB)") || Intrinsics.areEqual((Object)desc, (Object)"(CC)") || Intrinsics.areEqual((Object)desc, (Object)"(II)") || Intrinsics.areEqual((Object)desc, (Object)"(SS)"))) {
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"requireNonNull") && api == 19 && Intrinsics.areEqual((Object)owner, (Object)"java.util.Objects") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.Object;)") && this.context.getMainProject().isDesugaring(Desugaring.OBJECTS_REQUIRE_NON_NULL)) {
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"addSuppressed") && api == 19 && Intrinsics.areEqual((Object)owner, (Object)"java.lang.Throwable") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.Throwable;)") && this.context.getMainProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                return;
            }
            String signature = null;
            signature = fqcn == null ? name : (Intrinsics.areEqual((Object)"<init>", (Object)name) ? (Lint.isKotlin((PsiElement)reference.getSourcePsi()) ? fqcn + "()" : "new " + fqcn) : fqcn + '#' + name);
            UElement uElement = nameIdentifier = call != null ? (UElement)call.getMethodIdentifier() : reference;
            if (call != null && UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && call.getClassReference() != null) {
                UElement uElement2 = (UElement)call;
                UReferenceExpression uReferenceExpression = call.getClassReference();
                if (uReferenceExpression == null) {
                    Intrinsics.throwNpe();
                }
                location = this.context.getRangeLocation(uElement2, 0, (UElement)uReferenceExpression, 0);
            } else {
                location = nameIdentifier != null ? this.context.getLocation(nameIdentifier) : this.context.getLocation(reference);
            }
            Location location2 = location;
            this.report(UNSUPPORTED, reference, location2, "Call", signature, api, minSdk, Companion.apiLevelFix(api), owner, name, desc);
        }

        private final int getRequiresApiFromAnnotations(PsiModifierListOwner modifierListOwner) {
            for (PsiAnnotation annotation : this.context.getEvaluator().getAllAnnotations(modifierListOwner, false)) {
                boolean bl;
                String name;
                int start;
                int end;
                String text;
                String qualifiedName = annotation.getQualifiedName();
                if (REQUIRES_API_ANNOTATION.isEquals(qualifiedName)) {
                    UAnnotation wrapped = JavaUAnnotation.Companion.wrap(annotation);
                    int api = (int)UastLintUtils.Companion.getLongAttribute(this.context, wrapped, "value", -1L);
                    if (api <= 1) {
                        api = (int)UastLintUtils.Companion.getLongAttribute(this.context, wrapped, "api", -1L);
                    }
                    return api;
                }
                if (qualifiedName != null || annotation instanceof PsiCompiledElement) continue;
                String string = text = annotation.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"RequiresApi(", (boolean)false, (int)2, null) || (end = StringsKt.indexOf$default((CharSequence)text, (char)')', (int)((start = StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null)) + 1), (boolean)false, (int)4, null)) == -1) continue;
                String string2 = text;
                int n = start + 1;
                int n2 = 0;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int index = StringsKt.indexOf$default((CharSequence)name, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index != -1) {
                    String string3 = name;
                    n2 = index + 1;
                    bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    string3 = string5;
                    n2 = 0;
                    String string6 = string3;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    name = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                }
                if ((index = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                    String string7 = name;
                    n2 = index + 1;
                    bl = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                    name = string9;
                }
                CharSequence charSequence = name;
                n2 = 0;
                if (charSequence.length() == 0) continue;
                char c = name.charAt(0);
                n2 = 0;
                if (Character.isDigit(c)) {
                    int api = Integer.parseInt(name);
                    if (api <= 0) continue;
                    return api;
                }
                return VersionChecks.codeNameToApi(name);
            }
            return -1;
        }

        private final boolean checkRequiresApi(UElement expression, PsiMember member, PsiModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                return false;
            }
            int api = this.getRequiresApiFromAnnotations(modifierListOwner);
            if (api != -1) {
                int target2;
                int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (api > minSdk && ((target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, expression, null, 2, null)) == -1 || api > target2)) {
                    if (VersionChecks.isWithinVersionCheckConditional(this.context.getEvaluator(), expression, api, true)) {
                        return true;
                    }
                    if (VersionChecks.isPrecededByVersionCheckExit(expression, api, true)) {
                        return true;
                    }
                    Location location = null;
                    String fqcn = null;
                    if (expression instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)expression).getKind(), (Object)UastCallKind.METHOD_CALL) ^ true && ((UCallExpression)expression).getClassReference() != null) {
                        String string;
                        UReferenceExpression uReferenceExpression = ((UCallExpression)expression).getClassReference();
                        if (uReferenceExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        UReferenceExpression classReference = uReferenceExpression;
                        location = this.context.getRangeLocation(expression, 0, (UElement)classReference, 0);
                        String string2 = classReference.getResolvedName();
                        if (string2 == null) {
                            string2 = string = member.getName();
                        }
                        if (string2 == null) {
                            string = "";
                        }
                        fqcn = string;
                    } else {
                        location = this.context.getNameLocation(expression);
                        String string = member.getName();
                        if (string == null) {
                            string = "";
                        }
                        fqcn = string;
                    }
                    ApiVisitor.report$default(this, UNSUPPORTED, expression, location, "Call", fqcn, api, minSdk, Companion.apiLevelFix(api), null, null, null, 1792, null);
                }
                return true;
            }
            return false;
        }

        public void visitLocalVariable(@NotNull ULocalVariable node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UExpression uExpression = node.getUastInitializer();
            if (uExpression == null) {
                return;
            }
            UExpression initializer = uExpression;
            PsiType psiType = initializer.getExpressionType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return;
            }
            PsiClassType initializerType = psiClassType;
            PsiType interfaceType = node.getType();
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            if (Intrinsics.areEqual((Object)initializerType, (Object)interfaceType)) {
                return;
            }
            this.checkCast((UElement)initializer, initializerType, (PsiClassType)interfaceType);
        }

        public void visitBinaryExpression(@NotNull UBinaryExpression node) {
            PsiMethod method;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UastBinaryOperator operator = node.getOperator();
            if (operator instanceof UastBinaryOperator.AssignOperator) {
                UExpression rExpression = node.getRightOperand();
                PsiType psiType = rExpression.getExpressionType();
                if (!(psiType instanceof PsiClassType)) {
                    psiType = null;
                }
                PsiClassType psiClassType = (PsiClassType)psiType;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType rhsType = psiClassType;
                PsiType interfaceType = node.getLeftOperand().getExpressionType();
                if (!(interfaceType instanceof PsiClassType)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)rhsType, (Object)interfaceType)) {
                    return;
                }
                this.checkCast((UElement)rExpression, rhsType, (PsiClassType)interfaceType);
            } else if (operator == UastBinaryOperator.OTHER && (method = node.resolveOperator()) != null) {
                this.visitCall(method, null, (UElement)node);
            }
        }

        public void visitTryExpression(@NotNull UTryExpression node) {
            int minSdk;
            int api;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            List resourceList = node.getResourceVariables();
            if (!resourceList.isEmpty() && !this.context.getMainProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES) && (api = 19) > (minSdk = ApiDetector.this.getMinSdk((Context)this.context)) && api > com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null)) {
                if (Companion.isSuppressed(this.context, api, (UElement)node, minSdk)) {
                    return;
                }
                UVariable first = (UVariable)resourceList.get(0);
                UVariable last = (UVariable)resourceList.get(resourceList.size() - 1);
                Location location = this.context.getRangeLocation((UDeclaration)first, 0, (UDeclaration)last, 0);
                int min = Math.max(minSdk, com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null));
                String message2 = "Try-with-resources requires API level " + api + " (current min is " + min + ')';
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, message2, Companion.apiLevelFix(api), null, null, null, 224, null);
            }
            for (UCatchClause catchClause : node.getCatchClauses()) {
                int minSdk2 = ApiDetector.this.getMinSdk((Context)this.context);
                if (minSdk2 < 19 && Companion.isMultiCatchReflectiveOperationException(catchClause)) {
                    if (Companion.isSuppressed(this.context, 19, (UElement)node, minSdk2)) {
                        return;
                    }
                    String message3 = "Multi-catch with these reflection exceptions requires API level 19 (current min is " + minSdk2 + ") " + "because they get compiled to the common but new super type `ReflectiveOperationException`. " + "As a workaround either create individual catch statements, or catch `Exception`.";
                    ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, Companion.getCatchParametersLocation(this.context, catchClause), message3, Companion.apiLevelFix(19), null, null, null, 224, null);
                    continue;
                }
                for (UTypeReferenceExpression typeReference : catchClause.getTypeReferences()) {
                    this.checkCatchTypeElement(node, typeReference, typeReference.getType());
                }
            }
        }

        private final void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference, PsiType type) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass resolved = null;
            if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                String string = this.context.getEvaluator().getQualifiedName(resolved);
                if (string == null) {
                    return;
                }
                String signature = string;
                int api = apiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (api <= minSdk) {
                    return;
                }
                UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)statement));
                if (containingClass != null) {
                    int target2;
                    int n = target2 = minSdk < 19 ? Companion.getTargetApi((UElement)containingClass, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(Companion){

                        public final boolean invoke(@NotNull String p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            return com.android.tools.lint.checks.ApiDetector$Companion.access$isRequiresApiAnnotation((Companion)this.receiver, p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Companion.class);
                        }

                        public final String getName() {
                            return "isRequiresApiAnnotation";
                        }

                        public final String getSignature() {
                            return "isRequiresApiAnnotation(Ljava/lang/String;)Z";
                        }
                    })) : com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)statement, null, 2, null);
                    if (target2 != -1 && api <= target2) {
                        return;
                    }
                }
                if (Companion.isSuppressed(this.context, api, (UElement)statement, minSdk)) {
                    if (minSdk < 19) {
                        UCatchClause clause;
                        Location location = this.context.getLocation((UElement)typeReference);
                        String fqcn = resolved.getQualifiedName();
                        UElement uElement = (UElement)typeReference;
                        String string2 = fqcn;
                        if (string2 == null) {
                            string2 = "";
                        }
                        String apiMessage = ApiDetector.this.getApiErrorMessage(minSdk, uElement, api, "Exception", string2);
                        String message2 = apiMessage + ", and having a surrounding/preceding version " + "check **does not** help since prior to API level 19, just " + "**loading** the class will cause a crash. Consider marking the " + "surrounding class with `RequiresApi(19)` to ensure that the " + "class is never loaded except when on API 19 or higher.";
                        LintFix fix = LintFix.create().data(new Object[]{api, PsiClass.class});
                        UElement uElement2 = typeReference.getUastParent();
                        if (!(uElement2 instanceof UCatchClause)) {
                            uElement2 = null;
                        }
                        if ((clause = (UCatchClause)uElement2) != null && this.context.getDriver().isSuppressed(this.context, UNSUPPORTED, clause)) {
                            return;
                        }
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)typeReference, location, message2, fix, signature, null, null, 192, null);
                        return;
                    }
                    return;
                }
                Location location = this.context.getLocation((UElement)typeReference);
                String fqcn = resolved.getQualifiedName();
                LintFix fix = minSdk < 19 ? LintFix.create().data(new Object[]{api, PsiClass.class}) : LintFix.create().data(new Object[]{api});
                UElement uElement = (UElement)typeReference;
                String string3 = fqcn;
                if (string3 == null) {
                    string3 = "";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, uElement, location, "Exception", string3, api, minSdk, fix, signature, null, null, 1536, null);
            }
        }

        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            PsiType type;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UExpression expression = node.getExpression();
            if (expression != null && (type = expression.getExpressionType()) instanceof PsiClassType) {
                this.checkClassType((UElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkField(UElement node, PsiField field) {
            UElement parent;
            Issue issue;
            int minSdk;
            int api;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiType psiType = field.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"field.type");
            PsiType type = psiType;
            String string = field.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name");
            String name = string;
            if (Intrinsics.areEqual((Object)"SDK_INT", (Object)name)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.context, node);
            }
            PsiClass psiClass = field.getContainingClass();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return");
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(containingClass);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            if (!this.checkRequiresApi(node, (PsiMember)field, (PsiModifierListOwner)field)) {
                this.checkRequiresApi(node, (PsiMember)field, (PsiModifierListOwner)containingClass);
            }
            if ((api = apiDatabase.getFieldVersion(owner, name)) == -1 || api <= (minSdk = ApiDetector.this.getMinSdk((Context)this.context)) || api <= com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null)) return;
            Issue issue2 = issue = evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field) ? INLINED : UNSUPPORTED;
            if (!(type instanceof PsiPrimitiveType) && !Lint.isString((PsiType)type)) {
                List conditions;
                issue = UNSUPPORTED;
                parent = Lint.skipParentheses((UElement)node.getUastParent());
                if (parent instanceof USwitchClauseExpression && CollectionsKt.contains((Iterable)(conditions = ((USwitchClauseExpression)parent).getCaseValues()), (Object)node)) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)issue, (Object)INLINED) && Companion.isBenignConstantUsage(node, name, owner)) {
                return;
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.annotation.ElementType") && (parent = (UDeclaration)UastUtils.getParentOfType((UElement)node, UDeclaration.class, (boolean)true)) instanceof UClass && ((UClass)parent).isAnnotationType()) {
                return;
            }
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return;
            }
            if ((api == 28 || api == 29) && Intrinsics.areEqual((Object)owner, (Object)"android.app.TaskInfo") && (parent = node.getUastParent()) instanceof UQualifiedReferenceExpression) {
                UExpression receiver = ((UQualifiedReferenceExpression)parent).getReceiver();
                Object object = receiver.getExpressionType();
                if (object == null || (object = object.getCanonicalText()) == null) {
                    return;
                }
                owner = object;
                api = apiDatabase.getFieldVersion(owner, name);
                if (api == -1) return;
                minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (api <= minSdk || api <= com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null)) return;
                if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                    return;
                }
            }
            UElement locationNode = node;
            while (locationNode.getUastParent() instanceof UQualifiedReferenceExpression) {
                UElement uElement = locationNode.getUastParent();
                if (uElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
                }
                if (((UQualifiedReferenceExpression)uElement).getSelector() != locationNode) break;
                UElement uElement2 = locationNode.getUastParent();
                if (uElement2 == null) {
                    uElement2 = node;
                }
                locationNode = uElement2;
            }
            Location location = this.context.getLocation(locationNode);
            String fqcn = ClassContext.Companion.getFqcn(owner) + "#" + name;
            ApiVisitor.report$default(this, issue, node, location, "Field", fqcn, api, minSdk, Companion.apiLevelFix(api), owner, name, null, 1024, null);
        }

        public ApiVisitor(JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\"\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(2\u0006\u0010*\u001a\u00020)2\b\u0010+\u001a\u0004\u0018\u00010)H\u0002JB\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010,2\u0006\u0010*\u001a\u00020)2\b\u0010+\u001a\u0004\u0018\u00010)2\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020/0.j\b\u0012\u0004\u0012\u00020/`02\u0006\u00101\u001a\u00020\u0014H\u0002J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0002J(\u00105\u001a\u00020\u00142\b\u00106\u001a\u0004\u0018\u0001072\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d09H\u0007J\u0012\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J&\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010<2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d09H\u0002J \u0010=\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0014H\u0002J \u0010A\u001a\u00020\u001d2\b\u0010B\u001a\u0004\u0018\u0001072\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bJ\u000e\u0010E\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\bJ \u0010F\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020\u001dH\u0002J\u000e\u0010I\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&J\u0010\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\bH\u0002J\u0010\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020/H\u0002J(\u0010N\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00103\u001a\u0002072\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010O\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\bH\u0002J\u0010\u0010P\u001a\u00020\u001d2\u0006\u00103\u001a\u000204H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$Companion;", "", "()V", "INLINED", "Lcom/android/tools/lint/detector/api/Issue;", "OBSOLETE_SDK", "OVERRIDE", "REFLECTIVE_OPERATION_EXCEPTION", "", "REQUIRES_API_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "SDK_SUPPRESS_ANNOTATION", "TAG_ANIMATED_SELECTOR", "TAG_RIPPLE", "UNSUPPORTED", "UNUSED", "apiLevelFix", "Lcom/android/tools/lint/detector/api/LintFix;", "api", "", "checkSimpleDateFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "minSdk", "dependsOnAppCompat", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "featureProvidedByGradle", "Lcom/android/tools/lint/detector/api/XmlContext;", "minGradleVersionString", "getCatchParametersLocation", "Lcom/android/tools/lint/detector/api/Location;", "catchClause", "Lorg/jetbrains/uast/UCatchClause;", "getInheritanceChain", "", "Lcom/intellij/psi/PsiClassType;", "derivedClass", "baseClass", "", "visited", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiType;", "Lkotlin/collections/HashSet;", "depth", "getLocalMinSdk", "element", "Lorg/w3c/dom/Element;", "getTargetApi", "scope", "Lorg/jetbrains/uast/UElement;", "isApiLevelAnnotation", "Lkotlin/Function1;", "getTargetApiForAnnotated", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "isAlreadyWarnedDrawableFile", "attribute", "Lorg/w3c/dom/Attr;", "attributeApiLevel", "isBenignConstantUsage", "node", "name", "owner", "isBenignUnusedAttribute", "isFrameLayout", "tagName", "defaultValue", "isMultiCatchReflectiveOperationException", "isRequiresApiAnnotation", "fqcn", "isSubclassOfReflectiveOperationException", "type", "isSuppressed", "isTargetAnnotation", "viewMayExtendTextView", "lint-checks"})
    public static final class Companion {
        private final boolean isFrameLayout(XmlContext context, String tagName, boolean defaultValue) {
            if (StringsKt.indexOf$default((CharSequence)tagName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                SdkInfo sdkInfo = context.getClient().getSdkInfo(context.getProject());
                return sdkInfo.isSubViewOf("FrameLayout", tagName);
            }
            UastParser parser = context.getClient().getUastParser(context.getProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass psiClass = evaluator.findClass(tagName);
            if (psiClass == null) {
                return defaultValue;
            }
            PsiClass psiClass2 = psiClass;
            return evaluator.extendsClass(psiClass2, "android.widget.FrameLayout", false);
        }

        private final boolean dependsOnAppCompat(Project project) {
            return Intrinsics.areEqual((Object)Boolean.TRUE, (Object)project.dependsOn("com.android.support:appcompat-v7"));
        }

        private final LintFix apiLevelFix(int api) {
            LintFix lintFix = LintFix.create().data(new Object[]{api});
            Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"LintFix.create().data(api)");
            return lintFix;
        }

        private final boolean isTargetAnnotation(String fqcn) {
            return Intrinsics.areEqual((Object)fqcn, (Object)"android.annotation.TargetApi") || this.isRequiresApiAnnotation(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)ApiDetector.SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)"TargetApi");
        }

        private final boolean isRequiresApiAnnotation(String fqcn) {
            return REQUIRES_API_ANNOTATION.isEquals(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)"RequiresApi");
        }

        private final boolean viewMayExtendTextView(Element element) {
            String string = element.getTagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.tagName");
            String tag = string;
            if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
                String string2 = element.getAttribute("class");
                if (string2 == null) {
                    return false;
                }
                tag = string2;
                CharSequence charSequence = tag;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return false;
                }
            }
            return StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1 ? true : StringsKt.contains$default((CharSequence)tag, (CharSequence)"Text", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)tag, (CharSequence)"Button", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)tag, (Object)"DigitalClock") || Intrinsics.areEqual((Object)tag, (Object)"Chronometer") || Intrinsics.areEqual((Object)tag, (Object)"CheckBox") || Intrinsics.areEqual((Object)tag, (Object)"Switch");
        }

        private final boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, int attributeApiLevel) {
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21) {
                Element element = attribute.getOwnerElement();
                while (element != null) {
                    String root = element.getTagName();
                    if (Intrinsics.areEqual((Object)ApiDetector.TAG_RIPPLE, (Object)root) || Intrinsics.areEqual((Object)"vector", (Object)root) || Intrinsics.areEqual((Object)"animated-vector", (Object)root) || Intrinsics.areEqual((Object)ApiDetector.TAG_ANIMATED_SELECTOR, (Object)root)) {
                        return true;
                    }
                    Node parentNode = element.getParentNode();
                    if (!(parentNode instanceof Element)) break;
                    element = (Element)parentNode;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBenignUnusedAttribute(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            String string = name;
            switch (string.hashCode()) {
                case -1959280331: {
                    if (!string.equals("labelFor")) return false;
                    return true;
                }
                case 1192948249: {
                    if (!string.equals("importantForAutofill")) return false;
                    return true;
                }
                case 1193032953: {
                    if (!string.equals("layout_marginVertical")) return false;
                    return true;
                }
                case 1450157576: {
                    if (!string.equals("fullBackupContent")) return false;
                    return true;
                }
                case -980998419: {
                    if (!string.equals("textIsSelectable")) return false;
                    return true;
                }
                case -5379289: {
                    if (!string.equals("roundIcon")) return false;
                    return true;
                }
                case 495144524: {
                    if (!string.equals("foregroundServiceType")) return false;
                    return true;
                }
                case -388883485: {
                    if (!string.equals("autofilledHighlight")) return false;
                    return true;
                }
                case 1343645351: {
                    if (!string.equals("paddingVertical")) return false;
                    return true;
                }
                case 930483431: {
                    if (!string.equals("layout_marginHorizontal")) return false;
                    return true;
                }
                case 2042756918: {
                    if (!string.equals("textAlignment")) return false;
                    return true;
                }
                case 58924602: {
                    if (!string.equals("autofillHints")) return false;
                    return true;
                }
                case -359890155: {
                    if (!string.equals("paddingHorizontal")) return false;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final void checkSimpleDateFormat(JavaContext context, UCallExpression call, int minSdk) {
            if (minSdk >= 9) {
                return;
            }
            List expressions = call.getValueArguments();
            if (expressions.isEmpty()) {
                return;
            }
            UExpression argument = (UExpression)expressions.get(0);
            Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)argument));
            if (constant instanceof String) {
                boolean isEscaped = false;
                int n = 0;
                int n2 = ((String)constant).length();
                while (n < n2) {
                    void i;
                    char c = ((String)constant).charAt((int)i);
                    if (c == '\'') {
                        isEscaped = !isEscaped;
                    } else if (!(isEscaped || c != 'L' && c != 'c')) {
                        String message2 = "The pattern character '" + c + "' requires API level 9 (current min is " + minSdk + ") : \"`" + constant + "`\"";
                        context.report(UNSUPPORTED, (UElement)call, context.getRangeLocation((UElement)argument, (int)(i + true), 1), message2, this.apiLevelFix(9));
                        return;
                    }
                    ++i;
                }
            }
        }

        private final int getLocalMinSdk(Element element) {
            Element current = element;
            while (true) {
                Node parent;
                String targetApi;
                if ((targetApi = current.getAttributeNS("http://schemas.android.com/tools", "targetApi")) != null) {
                    CharSequence charSequence = targetApi;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) {
                        int n;
                        int n2 = targetApi.charAt(0);
                        bl = false;
                        if (Character.isDigit((char)n2)) {
                            try {
                                n2 = Integer.parseInt(targetApi);
                            }
                            catch (NumberFormatException e) {
                                break;
                            }
                            n = n2;
                        } else {
                            n = SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
                        }
                        return n;
                    }
                }
                if ((parent = current.getParentNode()) == null || parent.getNodeType() != 1) break;
                current = (Element)parent;
            }
            return -1;
        }

        private final boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
            GradleVersion minVersion;
            if (minGradleVersionString == null) {
                return false;
            }
            GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
            return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
        }

        public final boolean isBenignConstantUsage(@Nullable UElement node, @NotNull String name, @NotNull String owner) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            if (ApiLookup.equivalentName(owner, "android/os/Build$VERSION_CODES")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/view/ViewGroup$LayoutParams") && Intrinsics.areEqual((Object)name, (Object)"MATCH_PARENT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/widget/AbsListView") && (Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_NONE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_MULTIPLE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_SINGLE"))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/view/Gravity") && (Intrinsics.areEqual((Object)"START", (Object)name) || Intrinsics.areEqual((Object)"END", (Object)name))) {
                return true;
            }
            if (node == null) {
                return false;
            }
            for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
                if (curr instanceof USwitchClauseExpression) {
                    List caseValues = ((USwitchClauseExpression)curr).getCaseValues();
                    for (UExpression condition : caseValues) {
                        if (!UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false)) continue;
                        return true;
                    }
                    return false;
                }
                if (curr instanceof UIfExpression) {
                    UExpression condition = ((UIfExpression)curr).getCondition();
                    return UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false);
                }
                if (curr instanceof UMethod || curr instanceof UClass) break;
            }
            return false;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass) {
            List<PsiClassType> chain;
            block1: {
                if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                    return CollectionsKt.emptyList();
                }
                List<PsiClassType> list = chain = this.getInheritanceChain(derivedClass, baseClass, new HashSet<PsiType>(), 0);
                if (list == null) break block1;
                CollectionsKt.reverse(list);
            }
            return chain;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass, HashSet<PsiType> visited, int depth) {
            if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                return new ArrayList(depth);
            }
            for (PsiType type : derivedClass.getSuperTypes()) {
                List<PsiClassType> chain;
                if (!visited.add(type) || !(type instanceof PsiClassType) || (chain = this.getInheritanceChain((PsiClassType)type, baseClass, visited, depth + 1)) == null) continue;
                chain.add(derivedClass);
                return chain;
            }
            return null;
        }

        private final boolean isSuppressed(JavaContext context, int api, UElement element, int minSdk) {
            if (api <= minSdk) {
                return true;
            }
            int target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, element, null, 2, null);
            if (target2 != -1 && api <= target2) {
                return true;
            }
            LintDriver driver = context.getDriver();
            return driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element) || VersionChecks.isWithinVersionCheckConditional(context.getEvaluator(), element, api, true) || VersionChecks.isPrecededByVersionCheckExit(element, api, true);
        }

        @JvmStatic
        @JvmOverloads
        public final int getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkParameterIsNotNull(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                int targetApi;
                if (current instanceof UAnnotated && (targetApi = this.getTargetApiForAnnotated((UAnnotated)current, isApiLevelAnnotation)) != -1) {
                    return targetApi;
                }
                if (current instanceof UFile) break;
            }
            return -1;
        }

        public static /* synthetic */ int getTargetApi$default(Companion companion, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>(companion){

                    public final boolean invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return com.android.tools.lint.checks.ApiDetector$Companion.access$isTargetAnnotation((Companion)this.receiver, p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Companion.class);
                    }

                    public final String getName() {
                        return "isTargetAnnotation";
                    }

                    public final String getSignature() {
                        return "isTargetAnnotation(Ljava/lang/String;)Z";
                    }
                };
            }
            return companion.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final int getTargetApi(@Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, scope, null, 2, null);
        }

        private final int getTargetApiForAnnotated(UAnnotated annotated) {
            return this.getTargetApiForAnnotated(annotated, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){

                public final boolean invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return com.android.tools.lint.checks.ApiDetector$Companion.access$isTargetAnnotation((Companion)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Companion.class);
                }

                public final String getName() {
                    return "isTargetAnnotation";
                }

                public final String getSignature() {
                    return "isTargetAnnotation(Ljava/lang/String;)Z";
                }
            }));
        }

        private final int getTargetApiForAnnotated(UAnnotated annotated, Function1<? super String, Boolean> isApiLevelAnnotation) {
            if (annotated == null) {
                return -1;
            }
            for (UAnnotation annotation : annotated.getUAnnotations()) {
                boolean bl;
                String name;
                int end;
                String annotationString;
                String text;
                PsiElement psi;
                String fqcn = annotation.getQualifiedName();
                if (fqcn != null && ((Boolean)isApiLevelAnnotation.invoke((Object)fqcn)).booleanValue()) {
                    List attributeList = annotation.getAttributeValues();
                    for (UNamedExpression attribute : attributeList) {
                        Integer apiLevel;
                        UExpression expression = attribute.getExpression();
                        if (expression instanceof ULiteralExpression) {
                            Object value = ((ULiteralExpression)expression).getValue();
                            if (value instanceof Integer) {
                                return ((Number)value).intValue();
                            }
                            if (!(value instanceof String)) continue;
                            return VersionChecks.codeNameToApi((String)value);
                        }
                        if (expression instanceof UCallExpression) {
                            for (UExpression argument : ((UCallExpression)expression).getValueArguments()) {
                                if (!(argument instanceof ULiteralExpression)) continue;
                                Object value = ((ULiteralExpression)argument).getValue();
                                if (value instanceof Integer) {
                                    return ((Number)value).intValue();
                                }
                                if (!(value instanceof String)) continue;
                                return VersionChecks.codeNameToApi((String)value);
                            }
                            continue;
                        }
                        Object object = ConstantEvaluator.evaluate(null, (UElement)((UElement)expression));
                        if (!(object instanceof Integer)) {
                            object = null;
                        }
                        if ((apiLevel = (Integer)object) != null) {
                            return apiLevel;
                        }
                        if (expression instanceof UReferenceExpression) {
                            String name2 = ((UReferenceExpression)expression).getResolvedName();
                            if (name2 == null) continue;
                            return VersionChecks.codeNameToApi(name2);
                        }
                        return VersionChecks.codeNameToApi(expression.asSourceString());
                    }
                    continue;
                }
                if (fqcn != null) continue;
                if (annotation.getSourcePsi() == null) {
                    continue;
                }
                if (psi instanceof PsiCompiledElement) continue;
                String string = text = psi.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                int start = StringsKt.indexOf$default((CharSequence)string, (char)'(', (int)0, (boolean)false, (int)6, null);
                if (start == -1) continue;
                int colon = StringsKt.indexOf$default((CharSequence)text, (char)':', (int)0, (boolean)false, (int)6, null);
                String name2 = text;
                int value = colon < start ? colon + 1 : 0;
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)name2.substring(value, start), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (start == -1 || !((Boolean)isApiLevelAnnotation.invoke((Object)annotationString)).booleanValue() || (end = StringsKt.indexOf$default((CharSequence)text, (char)')', (int)(start + 1), (boolean)false, (int)4, null)) == -1) continue;
                String string2 = text;
                int n = start + 1;
                int n2 = 0;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int index = StringsKt.indexOf$default((CharSequence)name, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index != -1) {
                    String string3 = name;
                    n2 = index + 1;
                    bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    string3 = string5;
                    n2 = 0;
                    String string6 = string3;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    name = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                }
                if ((index = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                    String string7 = name;
                    n2 = index + 1;
                    bl = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                    name = string9;
                }
                CharSequence charSequence = name;
                n2 = 0;
                if (charSequence.length() == 0) continue;
                char c = name.charAt(0);
                n2 = 0;
                if (Character.isDigit(c)) {
                    int api = Integer.parseInt(name);
                    if (api <= 0) continue;
                    return api;
                }
                return VersionChecks.codeNameToApi(name);
            }
            return -1;
        }

        @NotNull
        public final Location getCatchParametersLocation(@NotNull JavaContext context, @NotNull UCatchClause catchClause) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypeReferences();
            if (types.isEmpty()) {
                return Location.NONE;
            }
            Location first = context.getLocation((UElement)types.get(0));
            if (types.size() < 2) {
                return first;
            }
            Location last = context.getLocation((UElement)types.get(types.size() - 1));
            File file = first.getFile();
            Position start = first.getStart();
            Position end = last.getEnd();
            return start == null ? Location.Companion.create(file) : Location.Companion.create(file, start, end);
        }

        public final boolean isMultiCatchReflectiveOperationException(@NotNull UCatchClause catchClause) {
            Intrinsics.checkParameterIsNotNull((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypes();
            if (types.size() < 2) {
                return false;
            }
            for (PsiType t : types) {
                if (this.isSubclassOfReflectiveOperationException(t)) continue;
                return false;
            }
            return true;
        }

        private final boolean isSubclassOfReflectiveOperationException(PsiType type) {
            PsiType[] psiTypeArray = type.getSuperTypes();
            int n = psiTypeArray.length;
            for (int i = 0; i < n; ++i) {
                PsiType t;
                PsiType psiType = t = psiTypeArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"t");
                if (!Intrinsics.areEqual((Object)ApiDetector.REFLECTIVE_OPERATION_EXCEPTION, (Object)psiType.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isRequiresApiAnnotation(Companion $this, String fqcn) {
            return $this.isRequiresApiAnnotation(fqcn);
        }

        public static final /* synthetic */ boolean access$dependsOnAppCompat(Companion $this, Project project) {
            return $this.dependsOnAppCompat(project);
        }

        public static final /* synthetic */ boolean access$isAlreadyWarnedDrawableFile(Companion $this, XmlContext context, Attr attribute, int attributeApiLevel) {
            return $this.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel);
        }

        public static final /* synthetic */ boolean access$viewMayExtendTextView(Companion $this, Element element) {
            return $this.viewMayExtendTextView(element);
        }

        public static final /* synthetic */ boolean access$isFrameLayout(Companion $this, XmlContext context, String tagName, boolean defaultValue) {
            return $this.isFrameLayout(context, tagName, defaultValue);
        }

        public static final /* synthetic */ boolean access$isTargetAnnotation(Companion $this, String fqcn) {
            return $this.isTargetAnnotation(fqcn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

