/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourcePrefixDetector
extends Detector
implements BinaryResourceScanner,
XmlScanner {
    public static final Issue ISSUE = Issue.create((String)"ResourceName", (String)"Resource with Wrong Prefix", (String)"In Gradle projects you can specify a resource prefix that all resources in the project must conform to. This makes it easier to ensure that you don't accidentally combine resources from different libraries, since they all end up in the same shared app namespace.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(ResourcePrefixDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.BINARY_RESOURCE_FILE), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.BINARY_RESOURCE_FILE_SCOPE}));
    private String mPrefix;
    private String mUnderlinePrefix;
    private String mCamelPrefix;

    public Collection<String> getApplicableElements() {
        return Arrays.asList("resources", "declare-styleable");
    }

    private static String computeResourcePrefix(Project project) {
        if (project.isGradleProject()) {
            return Lint.computeResourcePrefix((IdeAndroidProject)project.getGradleProjectModel());
        }
        return null;
    }

    private void updatePrefix(Context context) {
        if (context == null) {
            this.mCamelPrefix = null;
            this.mUnderlinePrefix = null;
            this.mPrefix = null;
        } else {
            this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context.getProject());
            if (this.mPrefix == null) {
                this.mCamelPrefix = null;
                this.mUnderlinePrefix = null;
            } else if (this.mPrefix.indexOf(95) != -1) {
                this.mUnderlinePrefix = this.mPrefix;
                this.mCamelPrefix = SdkVersionInfo.underlinesToCamelCase((String)this.mPrefix);
            } else {
                this.mCamelPrefix = this.mPrefix;
                this.mUnderlinePrefix = SdkVersionInfo.camelCaseToUnderlines((String)this.mPrefix);
            }
        }
    }

    public void beforeCheckEachProject(Context context) {
        this.updatePrefix(context);
    }

    public void afterCheckEachProject(Context context) {
        this.updatePrefix(null);
    }

    public void beforeCheckFile(Context context) {
        String name;
        XmlContext xmlContext;
        ResourceFolderType folderType;
        if (this.mPrefix != null && context instanceof XmlContext && (folderType = (xmlContext = (XmlContext)context).getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !ResourcePrefixDetector.libraryPrefixMatches(this.mUnderlinePrefix, name = Lint.getBaseName((String)context.file.getName()))) {
            Element root;
            if (xmlContext.document != null && (root = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(ISSUE, (Node)root, xmlContext.getElementLocation(root), this.getErrorMessage(name, folderType));
                return;
            }
            context.report(ISSUE, Location.create((File)context.file), this.getErrorMessage(name, folderType));
        }
    }

    private String getErrorMessage(String name, ResourceFolderType folderType) {
        assert (this.mPrefix != null && !name.startsWith(this.mPrefix));
        return String.format("Resource named '`%1$s`' does not start with the project's resource prefix '`%2$s`'; rename to '`%3$s`' ?", name, this.mPrefix, Lint.computeResourceName((String)this.mPrefix, (String)name, (ResourceFolderType)folderType));
    }

    public void visitElement(XmlContext context, Element element) {
        if (this.mPrefix == null || context.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        for (Element item : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr nameAttribute = item.getAttributeNode("name");
            if (nameAttribute == null || (name = nameAttribute.getValue()).indexOf(58) != -1 || ResourcePrefixDetector.libraryPrefixMatches(this.mUnderlinePrefix, name) || ResourcePrefixDetector.libraryPrefixMatches(this.mCamelPrefix, name)) continue;
            String message2 = this.getErrorMessage(name, ResourceFolderType.VALUES);
            context.report(ISSUE, (Node)nameAttribute, context.getLocation((Node)nameAttribute), message2);
        }
    }

    @VisibleForTesting
    static boolean libraryPrefixMatches(String prefix, String name) {
        if (name.startsWith(prefix)) {
            return true;
        }
        if (SdkUtils.startsWithIgnoreCase((String)name, (String)prefix)) {
            return true;
        }
        return prefix.endsWith("_") && name.regionMatches(true, 0, prefix, 0, prefix.length() - 1);
    }

    public void checkBinaryResource(ResourceContext context) {
        String name;
        ResourceFolderType folderType;
        if (this.mUnderlinePrefix != null && (folderType = context.getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = Lint.getBaseName((String)context.file.getName())).startsWith(this.mUnderlinePrefix)) {
            String path = context.file.getPath();
            if (path.endsWith(".bc") && folderType == ResourceFolderType.RAW) {
                return;
            }
            Location location = Location.create((File)context.file);
            context.report(ISSUE, location, this.getErrorMessage(name, folderType));
        }
    }
}

