/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "exportedActivities", "Ljava/util/HashMap;", "", "Lcom/android/tools/lint/detector/api/Location$Handle;", "applicableSuperClasses", "", "getApplicableElements", "", "isExported", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "className", "overridesIsValidFragment", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "resolvedClass", "Lcom/intellij/psi/PsiClass;", "visitClass", "", "declaration", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class PreferenceActivityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    private final HashMap<String, Location.Handle> exportedActivities = new HashMap();
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    public static final Companion Companion;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (SecurityDetector.getExported(element)) {
            String fqcn = Lint.resolveManifestName((Element)element);
            if (Intrinsics.areEqual((Object)fqcn, (Object)PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, (Node)element)) {
                String message2 = "`PreferenceActivity` should not be exported";
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getLocation((Node)element), (String)message2, null, (int)16, null);
            }
            ((Map)this.exportedActivities).put(fqcn, context.createLocationHandle((Node)element));
        }
    }

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)PREFERENCE_ACTIVITY);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (!context.getProject().getReportIssues()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        String className = declaration.getQualifiedName();
        if (evaluator.extendsClass((PsiClass)declaration, PREFERENCE_ACTIVITY, false) && this.isExported(context, className)) {
            if (context.getMainProject().getTargetSdk() >= 19 && this.overridesIsValidFragment(evaluator, (PsiClass)declaration)) {
                return;
            }
            String message2 = "`PreferenceActivity` subclass " + className + " should not be exported";
            Location location = null;
            if (context.getScope().contains(Scope.MANIFEST)) {
                Map map = this.exportedActivities;
                boolean bl = false;
                Location.Handle handle = (Location.Handle)map.get(className);
                if (handle == null || (handle = handle.resolve()) == null) {
                    return;
                }
                location = handle;
            } else {
                location = context.getNameLocation(declaration);
                message2 = message2 + " in the manifest";
            }
            context.report(ISSUE, declaration, location, message2);
        }
    }

    private final boolean isExported(JavaContext context, String className) {
        if (className == null) {
            return false;
        }
        if (context.getScope().contains(Scope.MANIFEST)) {
            return this.exportedActivities.containsKey(className);
        }
        Project mainProject = context.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        if (mergedManifest == null || mergedManifest.getDocumentElement() == null) {
            return false;
        }
        Element application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
        if (application != null) {
            Iterator iterator = XmlUtils.getSubTags((Node)application).iterator();
            while (iterator.hasNext()) {
                String fqn;
                String name;
                Element element;
                Element element2 = element = (Element)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                if (!Intrinsics.areEqual((Object)"activity", (Object)element2.getTagName())) continue;
                String string = name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                if (!StringsKt.endsWith$default((String)className, (String)string, (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)(fqn = Lint.resolveManifestName((Element)element)), (Object)className)) continue;
                return SecurityDetector.getExported(element);
            }
        }
        return false;
    }

    private final boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        PsiMethod[] psiMethodArray = resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false);
        int n = psiMethodArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMethod method;
            PsiMethod psiMethod = method = psiMethodArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
            if (!evaluator.parametersMatch(psiMethod, new String[]{"java.lang.String"})) continue;
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(PreferenceActivityDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE});
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        Severity severity = Severity.WARNING;
        int n = 8;
        Category category = Category.SECURITY;
        String string = "http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ExportedPreferenceActivity", (String)"PreferenceActivity should not be exported", (String)"\n                Fragment injection gives anyone who can send your PreferenceActivity an intent \\\n                the ability to load any fragment, with any arguments, in your process.", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3840, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "IS_VALID_FRAGMENT", "", "PREFERENCE_ACTIVITY", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

