/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkJavaToUpperLowerCase", "node", "checkLocaleGetDefault", "checkStringsKt", "getApplicableMethodNames", "", "", "isLoggingParameter", "", "visitMethodCall", "Companion", "lint-checks"})
public final class LocaleDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @NotNull
    public static final String TO_UPPER_CASE = "toUpperCase";
    @NotNull
    public static final String TO_LOWER_CASE = "toLowerCase";
    @NotNull
    public static final String GET_DEFAULT = "getDefault";
    @NotNull
    public static final String KOTLIN_STRINGS_JVM_KT = "kotlin.text.StringsKt__StringsJVMKt";
    @NotNull
    public static final String CAPITALIZE = "capitalize";
    @NotNull
    public static final String DECAPITALIZE = "decapitalize";
    @JvmField
    @NotNull
    public static final Issue STRING_LOCALE;
    @JvmField
    @NotNull
    public static final Issue FINAL_LOCALE;
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(TO_LOWER_CASE, TO_UPPER_CASE, "format", GET_DEFAULT, CAPITALIZE, DECAPITALIZE);
    }

    /*
     * Unable to fully structure code
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block18: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            if (Intrinsics.areEqual((Object)method.getName(), (Object)"getDefault")) {
                if (context.getEvaluator().isMemberInClass((PsiMember)method, "java.util.Locale")) {
                    this.checkLocaleGetDefault(context, method, node);
                }
                return;
            }
            if (context.getEvaluator().isMemberInClass((PsiMember)method, "java.lang.String")) {
                var4_4 = method.getName();
                tmp = -1;
                switch (var4_4.hashCode()) {
                    case -1137582698: {
                        if (!var4_4.equals("toLowerCase")) break;
                        tmp = 1;
                        break;
                    }
                    case -1268779017: {
                        if (!var4_4.equals("format")) break;
                        tmp = 2;
                        break;
                    }
                    case -399551817: {
                        if (!var4_4.equals("toUpperCase")) break;
                        tmp = 1;
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        this.checkFormat(context, method, node);
                        break;
                    }
                    case 1: {
                        this.checkJavaToUpperLowerCase(context, method, node);
                        break;
                    }
                }
            }
            if (!context.getEvaluator().isMemberInClass((PsiMember)method, "kotlin.text.StringsKt__StringsJVMKt")) break block18;
            var4_4 = method.getName();
            switch (var4_4.hashCode()) {
                case -1137582698: {
                    if (!var4_4.equals("toLowerCase")) ** break;
                    break;
                }
                case -399551817: {
                    if (!var4_4.equals("toUpperCase")) ** break;
                    break;
                }
                case 1449238061: {
                    if (!var4_4.equals("decapitalize")) ** break;
                    ** GOTO lbl46
                }
                case -1765638420: {
                    if (!var4_4.equals("capitalize")) ** break;
lbl46:
                    // 2 sources

                    this.checkStringsKt(context, method, node);
                    ** break;
                }
            }
            this.checkStringsKt(context, method, node);
            ** break;
        }
    }

    private final void checkJavaToUpperLowerCase(JavaContext context, PsiMethod method, UCallExpression node) {
        if (LintClient.Companion.isStudio()) {
            return;
        }
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() != 0) {
            return;
        }
        Location location = context.getNameLocation((UElement)node);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        Object[] objectArray = new Object[]{method.getName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        JavaContext.report$default((JavaContext)context, (Issue)STRING_LOCALE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
    }

    private final void checkStringsKt(JavaContext context, PsiMethod method, UCallExpression node) {
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() > 1) {
            return;
        }
        Location location = context.getNameLocation((UElement)node);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        LintFix.GroupBuilder groupBuilder = new LintFix.GroupBuilder[]{method.getName()};
        boolean bl = false;
        LintFix.GroupBuilder groupBuilder2 = groupBuilder;
        String string2 = String.format(string, Arrays.copyOf(groupBuilder2, ((Object[])groupBuilder2).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        Location range = context.getCallLocation(node, false, true);
        groupBuilder = LintFix.create().group();
        bl = false;
        boolean bl2 = false;
        LintFix.GroupBuilder groupBuilder3 = groupBuilder;
        boolean bl3 = false;
        for (String localeName : CollectionsKt.listOf((Object[])new String[]{"ROOT", "getDefault()"})) {
            groupBuilder3.add(LintFix.create().name("Replace with `" + method.getName() + "(Locale." + localeName + ")`").sharedName("Use explicit locale").replace().range(range).with(method.getName() + "(java.util.Locale." + localeName + ')').shortenNames().build());
        }
        LintFix quickfixData = groupBuilder.build();
        context.report(STRING_LOCALE, (UElement)node, location, message2, quickfixData);
    }

    private final void checkFormat(JavaContext context, PsiMethod method, UCallExpression call) {
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() == 0 || !context.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions.get(0);
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)first));
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String value = string;
        if (StringFormatDetector.isLocaleSpecific(value)) {
            if (this.isLoggingParameter(context, call)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)((UElement)call), UThrowExpression.class, (boolean)true) != null) {
                return;
            }
            Location location = Intrinsics.areEqual((Object)"format", (Object)Lint.getMethodName((UCallExpression)call)) ? context.getCallLocation(call, true, true) : context.getCallLocation(call, false, true);
            String message2 = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            JavaContext.report$default((JavaContext)context, (Issue)STRING_LOCALE, (UElement)((UElement)call), (Location)location, (String)message2, null, (int)16, null);
        }
    }

    private final void checkLocaleGetDefault(JavaContext context, PsiMethod method, UCallExpression node) {
        UField uField = (UField)UastUtils.getParentOfType((UElement)((UElement)node), UField.class, (boolean)true);
        if (uField == null) {
            return;
        }
        UField field = uField;
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field)) {
            JavaContext.report$default((JavaContext)context, (Issue)FINAL_LOCALE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)"Assigning `Locale.getDefault()` to a final static field is suspicious; this code will not work correctly if the user changes locale while the app is running", null, (int)16, null);
        }
    }

    private final boolean isLoggingParameter(JavaContext context, UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)node), UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = Lint.getMethodName((UCallExpression)parentCall)) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return context.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = null;
        boolean bl = false;
        Object object = IMPLEMENTATION;
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/reference/java/util/Locale.html#default_locale";
        STRING_LOCALE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DefaultLocale", (String)"Implied default locale in case conversion", (String)"\n                Calling `String#toLowerCase()` or `#toUpperCase()` **without specifying an \\\n                explicit locale** is a common source of bugs. The reason for that is that \\\n                those methods will use the current locale on the user's device, and even \\\n                though the code appears to work correctly when you are developing the app, \\\n                it will fail in some locales. For example, in the Turkish locale, the \\\n                uppercase replacement for `i` is **not** `I`.\n\n                If you want the methods to just perform ASCII replacement, for example to \\\n                convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you \\\n                really want to use the current locale, call \\\n                `String#toUpperCase(Locale.getDefault())` instead.\n                ", (Implementation)object, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, implementation, enumSet, collection, (int)3840, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        severity = Severity.WARNING;
        n = 6;
        category = null;
        string = Category.I18N;
        FINAL_LOCALE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ConstantLocale", (String)"Constant Locale", (String)"\n                Assigning `Locale.getDefault()` to a constant is suspicious, because \\\n                the locale can change while the app is running.", (Implementation)implementation, (String)category, (Category)string, (int)n, (Severity)severity, (boolean)bl, (Boolean)object, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector$Companion;", "", "()V", "CAPITALIZE", "", "DECAPITALIZE", "FINAL_LOCALE", "Lcom/android/tools/lint/detector/api/Issue;", "GET_DEFAULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KOTLIN_STRINGS_JVM_KT", "STRING_LOCALE", "TO_LOWER_CASE", "TO_UPPER_CASE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

