/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/BatteryDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableElements", "", "", "getApplicableReferenceNames", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "lint-checks"})
public final class BatteryDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"action");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        boolean bl = Intrinsics.areEqual((Object)element.getTagName(), (Object)"action");
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr attr2 = attr;
        String name = attr2.getValue();
        if (Intrinsics.areEqual((Object)"android.net.conn.CONNECTIVITY_CHANGE", (Object)name) && element.getParentNode() != null) {
            Node node = element.getParentNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"element.parentNode");
            if (node.getParentNode() != null) {
                Node node2 = element.getParentNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"element.parentNode");
                Node node3 = node2.getParentNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"element.parentNode.parentNode");
                if (Intrinsics.areEqual((Object)"receiver", (Object)node3.getNodeName())) {
                    AndroidVersion androidVersion = context.getMainProject().getTargetSdkVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.targetSdkVersion");
                    if (androidVersion.getFeatureLevel() >= 24) {
                        String message2 = "Declaring a broadcastreceiver for `android.net.conn.CONNECTIVITY_CHANGE` is deprecated for apps targeting N and higher. In general, apps should not rely on this broadcast and instead use `JobScheduler` or `GCMNetworkManager`.";
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(attr2), (String)message2, null, (int)16, null);
                    }
                }
            }
        }
        if (Intrinsics.areEqual((Object)"android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", (Object)name)) {
            AndroidVersion androidVersion = context.getMainProject().getTargetSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.targetSdkVersion");
            if (androidVersion.getFeatureLevel() >= 23) {
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(attr2), (String)"Use of `REQUEST_IGNORE_BATTERY_OPTIMIZATIONS` violates the Play Store Content Policy regarding acceptable use cases, as described in http://developer.android.com/training/monitoring-device-state/doze-standby.html", null, (int)16, null);
            }
        }
        if (Intrinsics.areEqual((Object)"android.hardware.action.NEW_PICTURE", (Object)name) || Intrinsics.areEqual((Object)"android.hardware.action.NEW_VIDEO", (Object)name) || Intrinsics.areEqual((Object)"com.android.camera.NEW_PICTURE", (Object)name)) {
            String message3 = "Use of `" + name + "` is deprecated for all apps starting " + "with the N release independent of the target SDK. Apps should not " + "rely on these broadcasts and instead use `JobScheduler`";
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(attr2), (String)message3, null, (int)16, null);
        }
    }

    @Nullable
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)referenced, (String)"referenced");
        if (referenced instanceof PsiField && context.getEvaluator().isMemberInSubClassOf((PsiMember)referenced, "android.provider.Settings", false)) {
            AndroidVersion androidVersion = context.getMainProject().getTargetSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.targetSdkVersion");
            if (androidVersion.getFeatureLevel() >= 23) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)reference), (Location)context.getNameLocation((UElement)reference), (String)"Use of `REQUEST_IGNORE_BATTERY_OPTIMIZATIONS` violates the Play Store Content Policy regarding acceptable use cases, as described in http://developer.android.com/training/monitoring-device-state/doze-standby.html", null, (int)16, null);
            }
        }
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(BatteryDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE});
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        Severity severity = Severity.WARNING;
        int n = 5;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/preview/features/background-optimization.html";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"BatteryLife", (String)"Battery Life Issues", (String)"\n            This issue flags code that either\n            * negatively affects battery life, or\n            * uses APIs that have recently changed behavior to prevent background tasks from \\\n            consuming memory and battery excessively.\n\n            Generally, you should be using `JobScheduler` or `GcmNetworkManager` instead.\n\n            For more details on how to update your code, please see \\\n            http://developer.android.com/preview/features/background-optimization.html\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3840, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/BatteryDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

