/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J&\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J&\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/TypoLookup;", "", "data", "", "indices", "", "wordCount", "", "([B[II)V", "computeSuggestions", "", "", "begin", "initialOffset", "glob", "getTypos", "utf8Text", "end", "text", "", "Companion", "lint-checks"})
public final class TypoLookup {
    private byte[] data;
    private int[] indices;
    private int wordCount;
    private static final TypoLookup NONE;
    private static final String WORD_SEPARATOR = "->";
    private static final String FILE_HEADER = "Typo database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 2;
    private static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final int BYTES_PER_ENTRY = 28;
    private static final WeakHashMap<String, TypoLookup> instanceMap;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getTypos(@NotNull CharSequence text, int begin, int end) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int n = end <= text.length() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Lint.assertionsEnabled()) {
            n = begin;
            n2 = end;
            while (n < n2) {
                void i;
                char c = text.charAt((int)i);
                if (c >= '\u0080') {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-TypoLookup$getTypos$22 = false;
                        String $i$a$-assert-TypoLookup$getTypos$22 = "Call the UTF-8 version of this method instead";
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypoLookup$getTypos$22));
                    }
                    return null;
                }
                ++i;
            }
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != (byte)text.charAt(begin) && Character.isLowerCase(text.charAt(begin))) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.data[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == (byte)42) {
                        int globEnd;
                        for (globEnd = i; globEnd < text.length() && Character.isLetter(text.charAt(globEnd)); ++globEnd) {
                        }
                        glob = ((Object)text.subSequence(i, globEnd)).toString();
                        break;
                    }
                    char c = text.charAt(i);
                    byte cb = (byte)c;
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    @Nullable
    public final List<String> getTypos(@NotNull byte[] utf8Text, int begin, int end) {
        Intrinsics.checkParameterIsNotNull((Object)utf8Text, (String)"utf8Text");
        boolean bl = end <= utf8Text.length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, utf8Text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != utf8Text[begin] && TypoLookup.Companion.isUpperCase(this.data[offset])) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.data[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == (byte)42) {
                        int globEnd;
                        for (globEnd = i; globEnd < utf8Text.length && Companion.isLetter(utf8Text[globEnd]); ++globEnd) {
                        }
                        int n = globEnd - i;
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.UTF_8");
                        Charset charset2 = charset;
                        boolean bl5 = false;
                        glob = new String(utf8Text, i, n, charset2);
                        break;
                    }
                    byte cb = utf8Text[i];
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    private final List<String> computeSuggestions(int begin, int initialOffset, String glob) {
        int offset = initialOffset;
        Object object = this.data;
        int n = offset - begin;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.UTF_8");
        Charset charset2 = charset;
        int n2 = 0;
        String typo = new String((byte[])object, begin, n, charset2);
        if (glob != null) {
            object = typo;
            String string = "\\*";
            boolean bl = false;
            string = new Regex(string);
            bl = false;
            typo = string.replace((CharSequence)object, glob);
        }
        boolean bl = this.data[offset] == 0;
        n = 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            n2 = 0;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int replacementEnd = ++offset;
        while (this.data[replacementEnd] != 0) {
            ++replacementEnd;
        }
        byte[] byArray = this.data;
        n2 = replacementEnd - offset;
        Charset charset3 = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"Charsets.UTF_8");
        Charset charset4 = charset3;
        boolean bl3 = false;
        String replacements = new String(byArray, offset, n2, charset4);
        ArrayList<String> words = new ArrayList<String>();
        words.add(typo);
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)replacements)) {
            if (glob != null) {
                String string = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
                CharSequence charSequence = string;
                String string2 = "\\*";
                ArrayList<String> arrayList = words;
                boolean bl4 = false;
                Object object2 = new Regex(string2);
                string2 = object2;
                bl4 = false;
                object2 = string2.replace(charSequence, glob);
                arrayList.add((String)object2);
                continue;
            }
            words.add(s);
        }
        return words;
    }

    private TypoLookup(byte[] data, int[] indices, int wordCount) {
        this.data = data;
        this.indices = indices;
        this.wordCount = wordCount;
    }

    /* synthetic */ TypoLookup(byte[] byArray, int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(byArray, nArray, n);
    }

    static {
        Companion = new Companion(null);
        NONE = new TypoLookup(new byte[0], new int[0], 0);
        instanceMap = new WeakHashMap();
    }

    public /* synthetic */ TypoLookup(byte[] data, int[] indices, int wordCount, DefaultConstructorMarker $constructor_marker) {
        this(data, indices, wordCount);
    }

    @JvmStatic
    @Nullable
    public static final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
        return Companion.get(client, locale, region);
    }

    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @JvmStatic
    public static final boolean isLetter(byte b) {
        return Companion.isLetter(b);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J#\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\tH\u0082\u0002J%\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0087\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0014H\u0007J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0014H\u0002J$\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J#\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0.H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/lint/checks/TypoLookup$Companion;", "", "()V", "BINARY_FORMAT_VERSION", "", "BYTES_PER_ENTRY", "DEBUG_FORCE_REGENERATE_BINARY", "", "FILE_HEADER", "", "NONE", "Lcom/android/tools/lint/checks/TypoLookup;", "WORD_SEPARATOR", "instanceMap", "Ljava/util/WeakHashMap;", "compare", "data", "", "offset", "terminator", "", "s", "begin", "initialEnd", "", "createCache", "client", "Lcom/android/tools/lint/client/api/LintClient;", "xmlStream", "Ljava/io/InputStream;", "binaryData", "Ljava/io/File;", "get", "name", "locale", "region", "isLetter", "b", "isUpperCase", "readData", "binaryFile", "toLowerCase", "writeDatabase", "", "file", "lines", "", "(Ljava/io/File;[Ljava/lang/String;)V", "lint-checks"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
            Class<TypoLookup> clazz = TypoLookup.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                TypoLookup db;
                boolean bl3 = false;
                String key = locale;
                if (region != null && region.length() == 2) {
                    boolean bl4 = Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1));
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean $i$a$-assert-TypoLookup$Companion$get$1$32 = false;
                        String $i$a$-assert-TypoLookup$Companion$get$1$32 = region;
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypoLookup$Companion$get$1$32));
                    }
                    key = locale + "r" + region;
                }
                if ((db = (TypoLookup)instanceMap.get(key)) == null) {
                    File file;
                    String build;
                    String name = "typos-" + key + ".txt";
                    String path = "/typos/" + name;
                    InputStream stream = TypoLookup.class.getResourceAsStream(path);
                    if (stream == null && (build = System.getenv("ANDROID_BUILD_TOP")) != null && (file = new File(build, StringsKt.replace$default((String)("sdk/files" + path), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null))).exists()) {
                        try {
                            stream = new BufferedInputStream(new FileInputStream(file));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (stream == null) {
                        if (region != null) {
                            return Companion.get(client, locale, null);
                        }
                        db = NONE;
                    } else {
                        db = Companion.get(client, stream, name);
                        boolean bl6 = db != null;
                        boolean bl7 = false;
                        if (_Assertions.ENABLED && !bl6) {
                            boolean bl8 = false;
                            String string = name;
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                    }
                    ((Map)instanceMap).put(key, db);
                }
                if (db == NONE) {
                    return null;
                }
                TypoLookup typoLookup = db;
                return typoLookup;
            }
        }

        private final TypoLookup get(LintClient client, InputStream xmlStream, String name) {
            File file = client.getCacheDir(null, true);
            if (file == null) {
                return null;
            }
            File cacheDir = file;
            File binaryData = new File(cacheDir, name + "-" + 2 + ".bin");
            if (!binaryData.exists() && !this.createCache(client, xmlStream, binaryData)) {
                return null;
            }
            if (!binaryData.exists()) {
                client.log(null, "The typo database file %1$s does not exist", new Object[]{binaryData});
                return null;
            }
            return this.readData(client, xmlStream, binaryData);
        }

        /*
         * WARNING - void declaration
         */
        private final TypoLookup readData(LintClient client, InputStream xmlStream, File binaryFile) {
            if (binaryFile == null) {
                return null;
            }
            if (!binaryFile.exists()) {
                client.log(null, "%1$s does not exist", new Object[]{binaryFile});
                return null;
            }
            try {
                MappedByteBuffer buffer = Files.map((File)binaryFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
                boolean bl = Intrinsics.areEqual((Object)buffer.order(), (Object)ByteOrder.BIG_ENDIAN);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String string = TypoLookup.FILE_HEADER;
                Charset charset = Charsets.US_ASCII;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.US_ASCII");
                Charset charset2 = charset;
                boolean bl5 = false;
                byte[] byArray = string.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] expectedHeader = byArray;
                buffer.rewind();
                for (byte anExpectedHeader : expectedHeader) {
                    if (anExpectedHeader == buffer.get()) continue;
                    client.log(null, "Incorrect file header: not an typo database cache file, or a corrupt cache file", new Object[0]);
                    return null;
                }
                if (buffer.get() != 2) {
                    if (this.createCache(client, xmlStream, binaryFile)) {
                        return this.readData(client, xmlStream, binaryFile);
                    }
                    return null;
                }
                MappedByteBuffer mappedByteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)mappedByteBuffer, (String)"buffer");
                int wordCount = mappedByteBuffer.getInt();
                int[] offsets = new int[wordCount];
                int n = 0;
                int n2 = wordCount;
                while (n < n2) {
                    void i;
                    offsets[i] = buffer.getInt();
                    ++i;
                }
                int size = buffer.limit();
                byte[] b = new byte[size];
                buffer.rewind();
                buffer.get(b);
                return new TypoLookup(b, offsets, wordCount, null);
            }
            catch (IOException e) {
                client.log((Throwable)e, null, new Object[0]);
                return null;
            }
        }

        private final boolean createCache(LintClient client, InputStream xmlStream, File binaryData) {
            String[] lines = null;
            try {
                List list;
                byte[] byArray = ByteStreams.toByteArray((InputStream)xmlStream);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteStreams.toByteArray(xmlStream)");
                Object object = byArray;
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.UTF_8");
                Object object2 = charset;
                int n = 0;
                object = new String((byte[])object, (Charset)object2);
                object2 = "\n";
                n = 0;
                object2 = new Regex((String)object2);
                n = 0;
                boolean bl = false;
                List $this$dropLastWhile$iv = object2.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        CharSequence charSequence = it;
                        boolean bl3 = false;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection collection = $this$toTypedArray$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                lines = stringArray;
            }
            catch (IOException e) {
                client.log((Throwable)e, "Can't read typo database file", new Object[0]);
                return false;
            }
            try {
                this.writeDatabase(binaryData, lines);
                return true;
            }
            catch (IOException ioe) {
                client.log((Throwable)ioe, "Can't write typo cache file", new Object[0]);
                return false;
            }
        }

        private final void writeDatabase(File file, String[] lines) throws IOException {
            int n;
            CharSequence $this$trim$iv$iv3;
            ArrayList<String> words = new ArrayList<String>(lines.length);
            for (String line : lines) {
                String $this$trim$iv;
                boolean $i$f$trim;
                CharSequence charSequence = line;
                boolean bl = false;
                if (charSequence.length() == 0 || !Character.isLetter(line.charAt(0))) continue;
                int end = StringsKt.indexOf$default((CharSequence)line, (String)TypoLookup.WORD_SEPARATOR, (int)0, (boolean)false, (int)6, null);
                if (end == -1) {
                    String $this$trim$iv2 = line;
                    boolean $i$f$trim2 = false;
                    CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                    $i$f$trim = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                        boolean bl2 = false;
                        boolean bl3 = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    end = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().length();
                }
                String $i$f$trim2 = line;
                int $this$trim$iv$iv2 = 0;
                $i$f$trim = false;
                String string = $i$f$trim2;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string.substring($this$trim$iv$iv2, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                boolean $i$f$trim222 = false;
                CharSequence $this$trim$iv$iv222 = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv222.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv222.charAt(index$iv$iv);
                    boolean bl4 = false;
                    boolean bl5 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String typo = ((Object)$this$trim$iv$iv222.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                String $i$f$trim222 = line;
                int $this$trim$iv$iv222 = end + TypoLookup.WORD_SEPARATOR.length();
                $i$f$trim3 = false;
                String string2 = $i$f$trim222;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring($this$trim$iv$iv222);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                CharSequence $this$trim$iv3 = string3;
                $i$f$trim = false;
                $this$trim$iv$iv3 = $this$trim$iv3;
                boolean $i$f$trim4 = false;
                int startIndex$iv$iv2 = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv3.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                    boolean bl6 = false;
                    boolean bl7 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv2;
                }
                String replacements = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                $this$trim$iv3 = replacements;
                $i$f$trim = false;
                if ($this$trim$iv3.length() == 0) continue;
                String combined = typo + '\u0000' + replacements;
                words.add(combined);
            }
            byte[][] wordArrays = new byte[words.size()][];
            Companion companion = this;
            boolean bl = false;
            int n2 = 0;
            Companion $this$run22 = companion;
            boolean bl8 = false;
            int i = 0;
            int n3 = words.size();
            while (i < n3) {
                byte[] byArray;
                Charset $i$f$trim4;
                Object e = words.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"words[i]");
                String word = (String)e;
                $this$trim$iv$iv3 = word;
                Intrinsics.checkExpressionValueIsNotNull((Object)Charsets.UTF_8, (String)"Charsets.UTF_8");
                n = i++;
                byte[][] byArrayArray = wordArrays;
                boolean bl9 = false;
                String string = $this$trim$iv$iv3;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string.getBytes($i$f$trim4), (String)"(this as java.lang.String).getBytes(charset)");
                byArrayArray[n] = byArray;
            }
            Arrays.sort((Object[])wordArrays, writeDatabase.3.INSTANCE);
            String string = TypoLookup.FILE_HEADER;
            Charset charset = Charsets.US_ASCII;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.US_ASCII");
            Charset charset2 = charset;
            boolean $this$run22 = false;
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] headerBytes = byArray;
            int entryCount = ((Object[])wordArrays).length;
            int capacity = entryCount * 28 + headerBytes.length + 5;
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.put(headerBytes);
            buffer.put((byte)2);
            buffer.putInt(entryCount);
            int wordOffsetTable = buffer.position();
            n3 = entryCount;
            for (i = 0; i < n3; ++i) {
                buffer.putInt(0);
            }
            int nextEntry = buffer.position();
            int nextOffset = wordOffsetTable;
            for (byte[] word : wordArrays) {
                buffer.position(nextOffset);
                buffer.putInt(nextEntry);
                nextOffset = buffer.position();
                buffer.position(nextEntry);
                buffer.put(word);
                buffer.put((byte)0);
                nextEntry = buffer.position();
            }
            int size = buffer.position();
            int $this$trim$iv$iv3 = size <= buffer.limit() ? 1 : 0;
            boolean $i$f$trim4 = false;
            n = 0;
            if (_Assertions.ENABLED && $this$trim$iv$iv3 == 0) {
                boolean bl10 = false;
                String string4 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string4));
            }
            buffer.mark();
            byte[] b = new byte[size];
            buffer.rewind();
            buffer.get(b);
            ByteSink sink = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
            sink.write(b);
        }

        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int max;
                byte b;
                if ((b = data[i]) == (byte)32 && j == end && end < (max = s.length()) && s.charAt(end) == ' ') {
                    while (end < max) {
                        char c = s.charAt(end);
                        if (!Character.isLetter(c)) {
                            if (c != ' ' || end != j) break;
                            ++end;
                            continue;
                        }
                        ++end;
                    }
                }
                if (j == end) break;
                if (b == (byte)42) {
                    return 0;
                }
                char c = s.charAt(j);
                byte cb = (byte)c;
                int delta = b - cb;
                if (delta != 0 && b != (cb = (byte)Character.toLowerCase(c)) && (delta = (b = (byte)Character.toLowerCase(b)) - cb) != 0) {
                    return delta;
                }
                ++i;
                ++j;
            }
            return data[i] - terminator;
        }

        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int max;
                byte b;
                if ((b = data[i]) == (byte)32 && j == end && end < (max = s.length) && s[end] == (byte)32) {
                    while (end < max) {
                        byte cb = s[end];
                        if (!this.isLetter(cb)) {
                            if (cb != (byte)32 || end != j) break;
                            ++end;
                            continue;
                        }
                        ++end;
                    }
                }
                if (j == end) break;
                if (b == (byte)42) {
                    return 0;
                }
                byte cb = s[j];
                int delta = b - cb;
                if (delta != 0) {
                    cb = this.toLowerCase(cb);
                    delta = (b = this.toLowerCase(b)) - cb;
                    if (delta != 0) {
                        return delta;
                    }
                }
                if (b == terminator || cb == terminator) {
                    return delta;
                }
                ++i;
                ++j;
            }
            return data[i] - terminator;
        }

        private final boolean isUpperCase(byte b) {
            return Character.isUpperCase((char)b);
        }

        private final byte toLowerCase(byte b) {
            return (byte)Character.toLowerCase((char)b);
        }

        @JvmStatic
        public final boolean isLetter(byte b) {
            return Character.isLetter((char)b) || (b & 0x80) != 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

