/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiMember;
import com.android.utils.Pair;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiClass
implements Comparable<ApiClass> {
    private final String mName;
    private final int mSince;
    private final int mDeprecatedIn;
    private final int mRemovedIn;
    private final List<Pair<String, Integer>> mSuperClasses = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> mInterfaces = new ArrayList<Pair<String, Integer>>();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();
    private Map<String, Integer> mMembersDeprecatedIn;
    private Map<String, Integer> mElementsRemovedIn;
    List<String> members;
    int index;
    int indexOffset;
    int memberOffsetBegin;
    int memberOffsetEnd;
    int memberIndexStart;
    int memberIndexLength;

    ApiClass(String name, int since, int deprecatedIn, int removedIn) {
        this.mName = name;
        this.mSince = since;
        this.mDeprecatedIn = deprecatedIn;
        this.mRemovedIn = removedIn;
    }

    String getName() {
        return this.mName;
    }

    int getSince() {
        return this.mSince;
    }

    int getDeprecatedIn() {
        return this.mDeprecatedIn;
    }

    int getRemovedIn() {
        return this.mRemovedIn;
    }

    int getField(String name, Api info) {
        int apiLevel = this.getValueWithDefault(this.mFields, name, 0);
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int i;
            ApiClass superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null || (i = superClass.getField(name, info)) == 0) continue;
            int tmp = Math.max((Integer)superClassPair.getSecond(), i);
            if (apiLevel != 0 && tmp >= apiLevel) continue;
            apiLevel = tmp;
        }
        return apiLevel;
    }

    int getMemberDeprecatedIn(String name, Api info) {
        int apiLevel = this.getValueWithDefault(this.mMembersDeprecatedIn, name, 0);
        return apiLevel == 0 ? this.mDeprecatedIn : (this.mDeprecatedIn == 0 ? apiLevel : Math.min(apiLevel, this.mDeprecatedIn));
    }

    int getMemberRemovedIn(String name, Api info) {
        int removedIn = this.getMemberRemovedInInternal(name, info);
        return removedIn == Integer.MAX_VALUE ? this.mRemovedIn : (removedIn > 0 ? removedIn : 0);
    }

    private int getMemberRemovedInInternal(String name, Api info) {
        int apiLevel = this.getValueWithDefault(this.mElementsRemovedIn, name, Integer.MAX_VALUE);
        if (apiLevel == Integer.MAX_VALUE) {
            if (this.mMethods.containsKey(name) || this.mFields.containsKey(name)) {
                return this.mRemovedIn == 0 ? Integer.MAX_VALUE : this.mRemovedIn;
            }
            apiLevel = -1;
        }
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int tmp;
            int i;
            ApiClass superClass;
            String superClassName = (String)superClassPair.getFirst();
            int superClassRemovedIn = this.getValueWithDefault(this.mElementsRemovedIn, superClassName, Integer.MAX_VALUE);
            if (superClassRemovedIn <= apiLevel || (superClass = info.getClass(superClassName)) == null || (i = superClass.getMemberRemovedInInternal(name, info)) == -1 || (tmp = Math.min(superClassRemovedIn, i)) <= apiLevel) continue;
            apiLevel = tmp;
        }
        return apiLevel;
    }

    private int getValueWithDefault(Map<String, Integer> map, String key, int defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Integer value = map.get(key);
        return value == null ? defaultValue : value;
    }

    int getMethod(String methodSignature, Api info) {
        int apiLevel = this.getValueWithDefault(this.mMethods, methodSignature, 0);
        if (!methodSignature.startsWith("<init>")) {
            for (Pair pair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
                int i;
                ApiClass superClass = info.getClass((String)pair.getFirst());
                if (superClass == null || (i = superClass.getMethod(methodSignature, info)) == 0) continue;
                int tmp = Math.max((Integer)pair.getSecond(), i);
                if (apiLevel != 0 && tmp >= apiLevel) continue;
                apiLevel = tmp;
            }
        }
        return apiLevel;
    }

    void addField(String name, int since, int deprecatedIn, int removedIn) {
        this.mFields.put(name, since);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addMethod(String name, int since, int deprecatedIn, int removedIn) {
        int index = name.indexOf(41);
        if (index != -1) {
            name = name.substring(0, index + 1);
        }
        this.mMethods.put(name, since);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addSuperClass(String superClass, int since, int removedIn) {
        ApiClass.addToArray(this.mSuperClasses, superClass, since);
        this.addToRemoved(superClass, removedIn);
    }

    void addInterface(String interfaceClass, int since, int removedIn) {
        ApiClass.addToArray(this.mInterfaces, interfaceClass, since);
        this.addToRemoved(interfaceClass, removedIn);
    }

    static void addToArray(List<Pair<String, Integer>> list, String name, int value) {
        for (Pair<String, Integer> pair : list) {
            if (!name.equals(pair.getFirst())) continue;
            assert (false);
            return;
        }
        list.add((Pair<String, Integer>)Pair.of((Object)name, (Object)value));
    }

    private void addToDeprecated(String name, int deprecatedIn) {
        if (deprecatedIn > 0) {
            if (this.mMembersDeprecatedIn == null) {
                this.mMembersDeprecatedIn = new HashMap<String, Integer>();
            }
            this.mMembersDeprecatedIn.put(name, deprecatedIn);
        }
    }

    private void addToRemoved(String name, int removedIn) {
        if (removedIn > 0) {
            if (this.mElementsRemovedIn == null) {
                this.mElementsRemovedIn = new HashMap<String, Integer>();
            }
            this.mElementsRemovedIn.put(name, removedIn);
        }
    }

    public String getContainerName() {
        int index = ApiClass.lastIndexOfSlashOrDollar(this.mName);
        if (index >= 0) {
            return this.mName.substring(0, index);
        }
        return "";
    }

    private static int lastIndexOfSlashOrDollar(String className) {
        int i = className.length();
        while (--i >= 0) {
            char c = className.charAt(i);
            if (c != '/' && c != '$') continue;
            return i;
        }
        return -1;
    }

    public String getSimpleName() {
        int index = this.mName.lastIndexOf(47);
        if (index != -1) {
            return this.mName.substring(index + 1);
        }
        return this.mName;
    }

    public String toString() {
        return this.mName;
    }

    Set<String> getAllMethods(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllMethods(info, members, true);
        return members;
    }

    List<Pair<String, Integer>> getInterfaces() {
        return this.mInterfaces;
    }

    List<Pair<String, Integer>> getSuperClasses() {
        return this.mSuperClasses;
    }

    private void addAllMethods(Api info, Set<String> set, boolean includeConstructors) {
        if (includeConstructors) {
            set.addAll(this.mMethods.keySet());
        } else {
            for (String method : this.mMethods.keySet()) {
                if (method.startsWith("<init>")) continue;
                set.add(method);
            }
        }
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            if (cls == null) continue;
            cls.addAllMethods(info, set, false);
        }
    }

    Set<String> getAllFields(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllFields(info, members);
        return members;
    }

    private void addAllFields(Api info, Set<String> set) {
        set.addAll(this.mFields.keySet());
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            assert (cls != null) : (Integer)superClass.getSecond();
            cls.addAllFields(info, set);
        }
    }

    private void addRemovedFields(Api info, Set<String> set) {
        set.addAll(this.mFields.keySet());
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            assert (cls != null) : (Integer)superClass.getSecond();
            cls.addAllFields(info, set);
        }
    }

    Collection<ApiMember> getAllRemovedFields(Api info) {
        Set<String> fields = this.getAllFields(info);
        if (fields.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedFields = new ArrayList<ApiMember>();
        for (String fieldName : fields) {
            int removedIn = this.getMemberRemovedIn(fieldName, info);
            if (removedIn <= 0) continue;
            int since = this.getField(fieldName, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(fieldName, info);
            removedFields.add(new ApiMember(fieldName, since, deprecatedIn, removedIn));
        }
        return removedFields;
    }

    Collection<ApiMember> getAllRemovedMethods(Api info) {
        Set<String> methods = this.getAllMethods(info);
        if (methods.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedMethods = new ArrayList<ApiMember>();
        for (String methodSignature : methods) {
            int removedIn = this.getMemberRemovedIn(methodSignature, info);
            if (removedIn <= 0) continue;
            int since = this.getMethod(methodSignature, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(methodSignature, info);
            removedMethods.add(new ApiMember(methodSignature, since, deprecatedIn, removedIn));
        }
        return removedMethods;
    }

    @Override
    public int compareTo(ApiClass other) {
        return this.mName.compareTo(other.mName);
    }
}

