/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/DetectMissingPrefix;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "", "isCustomView", "element", "Lorg/w3c/dom/Element;", "isFragment", "isNoPrefixAttribute", "attribute", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class DetectMissingPrefix
extends LayoutDetector {
    @JvmField
    @NotNull
    public static final Issue MISSING_NAMESPACE;
    public static final Issues Issues;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.INTERPOLATOR;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return LayoutDetector.ALL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoPrefixAttribute(String attribute) {
        String string = attribute;
        switch (string.hashCode()) {
            case -1109722326: {
                if (!string.equals("layout")) return false;
                return true;
            }
            case -807062458: {
                if (!string.equals("package")) return false;
                return true;
            }
            case 109648666: {
                if (!string.equals("split")) return false;
                return true;
            }
            case 109780401: {
                if (!string.equals("style")) return false;
                return true;
            }
            case 954743298: {
                if (!string.equals("coreApp")) return false;
                return true;
            }
            case 94742904: {
                if (!string.equals("class")) return false;
                return true;
            }
        }
        return false;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String uri = attribute.getNamespaceURI();
        if (uri == null || (charSequence = (CharSequence)uri).length() == 0) {
            CharSequence charSequence2;
            Element element;
            String string = attribute.getName();
            if (string == null) {
                return;
            }
            String name = string;
            if (this.isNoPrefixAttribute(name)) {
                return;
            }
            Element element2 = element = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            if (this.isCustomView(element2) && context.getResourceFolderType() != null) {
                return;
            }
            if (context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
                Element root;
                Document document = element.getOwnerDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"element.ownerDocument");
                Element element3 = root = document.getDocumentElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"root");
                if (Intrinsics.areEqual((Object)"layout", (Object)element3.getTagName())) {
                    return;
                }
            }
            if (StringsKt.indexOf$default((CharSequence)name, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            String elementNamespace = element.getNamespaceURI();
            if (elementNamespace != null && !((charSequence2 = (CharSequence)elementNamespace).length() == 0)) {
                return;
            }
            XmlContext.report$default((XmlContext)context, (Issue)MISSING_NAMESPACE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)"Attribute is missing the Android namespace prefix", null, (int)16, null);
        } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)uri) ^ true && Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)uri) ^ true && context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            Element element = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"attribute.ownerElement");
            if (!this.isCustomView(element)) {
                Element element4 = attribute.getOwnerElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element4, (String)"attribute.ownerElement");
                if (!this.isFragment(element4)) {
                    String string = attribute.getLocalName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute.localName");
                    if (!StringsKt.startsWith$default((String)string, (String)"layout_", (boolean)false, (int)2, null)) {
                        Element element5 = attribute.getOwnerElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)element5, (String)"attribute.ownerElement");
                        Node node = element5.getParentNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"attribute.ownerElement.parentNode");
                        if (node.getNodeType() == 1) {
                            String prefix = attribute.getPrefix();
                            if (Intrinsics.areEqual((Object)"xmlns", (Object)prefix)) {
                                Element root;
                                String name = attribute.getNodeName();
                                Document document = attribute.getOwnerDocument();
                                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"attribute.ownerDocument");
                                Element element6 = root = document.getDocumentElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)element6, (String)"root");
                                NamedNodeMap attributes = element6.getAttributes();
                                NamedNodeMap namedNodeMap = attributes;
                                Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
                                int n = namedNodeMap.getLength();
                                for (int i = 0; i < n; ++i) {
                                    String string2;
                                    Issue issue;
                                    Node item;
                                    Node node2 = item = attributes.item(i);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"item");
                                    if (!Intrinsics.areEqual((Object)name, (Object)node2.getNodeName()) || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)item.getNodeValue())) continue;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)NamespaceDetector.UNUSED, (String)"NamespaceDetector.UNUSED");
                                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                    String string3 = "Unused namespace declaration %1$s; already declared on the root element";
                                    Object[] objectArray = new Object[]{name};
                                    Location location = context.getLocation((Node)attribute);
                                    Node node3 = attribute;
                                    XmlContext xmlContext = context;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                                    XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node3, (Location)location, (String)string2, null, (int)16, null);
                                }
                                return;
                            }
                            if (context.getResourceFolderType() == ResourceFolderType.LAYOUT && Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)uri)) {
                                Element root;
                                Document document = attribute.getOwnerDocument();
                                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"attribute.ownerDocument");
                                Element element7 = root = document.getDocumentElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)element7, (String)"root");
                                if (Intrinsics.areEqual((Object)"layout", (Object)element7.getTagName())) {
                                    return;
                                }
                                if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"srcCompat") || Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"fontFamily")) {
                                    return;
                                }
                                Project project = context.getMainProject();
                                LintClient client = context.getClient();
                                ResourceRepository repository = client.getResourceRepository(project, true, true);
                                if (repository != null) {
                                    List items = repository.getResources(ResourceNamespace.TODO(), ResourceType.ATTR, attribute.getLocalName());
                                    if (!items.isEmpty()) {
                                        Iterator iterator = items.iterator();
                                        while (iterator.hasNext()) {
                                            String libraryName;
                                            ResourceItem item;
                                            ResourceItem resourceItem = item = (ResourceItem)iterator.next();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)resourceItem, (String)"item");
                                            if (resourceItem.getLibraryName() == null) {
                                                continue;
                                            }
                                            if (!StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"appcompat", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"material", (boolean)false, (int)2, null)) continue;
                                            return;
                                        }
                                    }
                                    Node node4 = attribute;
                                    Location location = context.getLocation((Node)attribute);
                                    StringBuilder stringBuilder = new StringBuilder().append("Unexpected namespace prefix \"").append(prefix).append("\" found for tag `");
                                    Element element8 = attribute.getOwnerElement();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)element8, (String)"attribute.ownerElement");
                                    XmlContext.report$default((XmlContext)context, (Issue)MISSING_NAMESPACE, (Node)node4, (Location)location, (String)stringBuilder.append(element8.getTagName()).append('`').toString(), null, (int)16, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final boolean isFragment(Element element) {
        return Intrinsics.areEqual((Object)"fragment", (Object)element.getTagName());
    }

    private final boolean isCustomView(Element element) {
        String tag = element.getTagName();
        if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
            return true;
        }
        if (SdkConstants.CONSTRAINT_LAYOUT.isEquals(tag) || SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEquals(tag)) {
            return false;
        }
        String string = tag;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag");
        return StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null) != -1 && (!StringsKt.startsWith$default((String)tag, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"android.support.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"androidx.", (boolean)false, (int)2, null));
    }

    static {
        Issues = new Issues(null);
        MISSING_NAMESPACE = Issue.Companion.create("MissingPrefix", "Missing Android XML namespace", "\n            Most Android views have attributes in the Android namespace. When referencing these attributes \\\n            you **must** include the namespace prefix, or your attribute will be interpreted by `aapt` as \\\n            just a custom attribute.\n\n            Similarly, in manifest files, nearly all attributes should be in the `android:` namespace.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(DetectMissingPrefix.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE}));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/DetectMissingPrefix$Issues;", "", "()V", "MISSING_NAMESPACE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

