/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotatedCallPath;
import com.android.tools.lint.checks.WrongThreadInterproceduralDetector;
import com.android.tools.lint.checks.WrongThreadInterproceduralDetectorKt;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.interprocedural.CallGraphResult;
import com.android.tools.lint.detector.api.interprocedural.ContextualEdge;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/WrongThreadInterproceduralDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "analyzeCallGraph", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "callGraph", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraphResult;", "isCallGraphRequired", "", "Companion", "lint-checks"})
public final class WrongThreadInterproceduralDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    public boolean isCallGraphRequired() {
        return true;
    }

    public void analyzeCallGraph(@NotNull Context context, @NotNull CallGraphResult callGraph) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callGraph, (String)"callGraph");
        Collection<AnnotatedCallPath> badPaths = WrongThreadInterproceduralDetectorKt.searchForInterproceduralThreadAnnotationViolations(callGraph.getCallGraph(), callGraph.getReceiverEval());
        for (AnnotatedCallPath annotatedCallPath : badPaths) {
            List<ContextualEdge> list;
            List<ContextualEdge> searchNodes = annotatedCallPath.component1();
            String sourceAnnotation = annotatedCallPath.component2();
            String sinkAnnotation = annotatedCallPath.component3();
            if (searchNodes.size() == 1) continue;
            List<ContextualEdge> list2 = list = searchNodes;
            ContextualEdge second = list2.get(1);
            UElement pathBeginning = second.getCause();
            UastParser parser = context.getClient().getUastParser(context.getProject());
            Location location = parser.createLocation(pathBeginning);
            String pathStr2 = CollectionsKt.joinToString$default((Iterable)searchNodes, (CharSequence)" -> ", null, null, (int)0, null, (Function1)analyzeCallGraph.pathStr.1.INSTANCE, (int)30, null);
            String sourceStr = StringsKt.substringAfterLast$default((String)sourceAnnotation, (char)'.', null, (int)2, null);
            String sinkStr = StringsKt.substringAfterLast$default((String)sinkAnnotation, (char)'.', null, (int)2, null);
            String message2 = "Interprocedural thread annotation violation " + '(' + sourceStr + " to " + sinkStr + "):\n" + pathStr2;
            context.report(ISSUE, location, message2, null);
        }
    }

    static {
        Companion = new Companion(null);
        Implementation implementation = new Implementation(WrongThreadInterproceduralDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
        boolean bl = false;
        Severity severity = Severity.ERROR;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/guide/components/processes-and-threads.html#Threads";
        ISSUE = Issue.Companion.create("WrongThreadInterprocedural", "Wrong Thread (Interprocedural)", "\n                Searches for interprocedural call paths that violate thread annotations \\\n                in the program. Tracks the flow of instantiated types and lambda \\\n                expressions to increase accuracy across method boundaries.\n                ", implementation, string, category, n, severity, bl);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/WrongThreadInterproceduralDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

