/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.VectorDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VectorPathDetector
extends ResourceXmlDetector {
    public static final Issue PATH_LENGTH = Issue.create((String)"VectorPath", (String)"Long vector paths", (String)"Using long vector paths is bad for performance. There are several ways to make the `pathData` shorter:\n* Using less precision\n* Removing some minor details\n* Using the Android Studio vector conversion tool\n* Rasterizing the image (converting to PNG)", (Category)Category.PERFORMANCE, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(VectorPathDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue PATH_VALID = Issue.create((String)"InvalidVectorPath", (String)"Invalid vector paths", (String)"This check ensures that vector paths are valid. For example, it makes sure that the numbers are not using scientific notation (such as 1.0e3) which can lead to runtime crashes on older devices. As another example, it flags numbers like `.5` which should be written as `0.5` instead to avoid crashes on some pre-Marshmallow devices.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(VectorPathDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://code.google.com/p/android/issues/detail?id=78162");
    private static final int MAX_PATH_DATA_LENGTH = 800;

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("pathData");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Element root;
        String value = attribute.getValue();
        if (value.startsWith("@")) {
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null || url.isFramework()) {
                return;
            }
            AbstractResourceRepository repository = context.getClient().getResourceRepository(context.getProject(), true, true);
            if (repository == null) {
                return;
            }
            List item = repository.getResourceItem(url.type, url.name);
            if (item == null || item.isEmpty()) {
                return;
            }
            ResourceValue resourceValue = ((ResourceItem)item.get(0)).getResourceValue();
            if (resourceValue == null) {
                return;
            }
            value = resourceValue.getValue();
            if (value == null) {
                return;
            }
        }
        if ((root = attribute.getOwnerDocument().getDocumentElement()) == null || !root.getTagName().equals("vector")) {
            return;
        }
        this.validatePath(context, attribute, value);
        if (value.length() < 800) {
            return;
        }
        if (VectorPathDetector.isRasterizingVector(context)) {
            return;
        }
        String message2 = String.format("Very long vector path (%1$d characters), which is bad for performance. Considering reducing precision, removing minor details or rasterizing vector.", value.length());
        context.report(PATH_LENGTH, (Node)attribute, context.getValueLocation(attribute), message2);
    }

    private static boolean isRasterizingVector(XmlContext context) {
        Project project = context.getMainProject();
        if (project.getMinSdkVersion().getFeatureLevel() >= 21) {
            return false;
        }
        if (context.getFolderVersion() >= 21) {
            return false;
        }
        if (!VectorDetector.isVectorGenerationSupported(context.getMainProject())) {
            return false;
        }
        if (VectorDetector.usingSupportLibVectors(project)) {
            return false;
        }
        return project.isGradleProject();
    }

    public void validatePath(XmlContext context, Attr attribute, String path) {
        if (context.getMainProject().getMinSdkVersion().getFeatureLevel() >= 23) {
            return;
        }
        int start = 0;
        int end = 1;
        while (end < path.length()) {
            int trimEnd;
            int trimStart;
            end = VectorPathDetector.findNextStart(path, end);
            for (trimStart = start; trimStart < end && Character.isWhitespace(path.charAt(trimStart)); ++trimStart) {
            }
            for (trimEnd = end; trimEnd > trimStart + 1 && Character.isWhitespace(path.charAt(trimEnd - 1)); --trimEnd) {
            }
            if (trimEnd > trimStart) {
                this.checkFloats(context, attribute, path, trimStart, trimEnd);
            }
            start = end++;
        }
    }

    private void checkFloats(XmlContext context, Attr attribute, String s, int start, int end) {
        if (s.charAt(start) == 'z' || s.charAt(start) == 'Z') {
            return;
        }
        int startPosition = start + 1;
        while (startPosition < end) {
            String message2;
            int currentIndex;
            boolean foundSeparator = false;
            boolean endWithNegOrDot = false;
            boolean hasExponential = false;
            boolean secondDot = false;
            boolean isExponential = false;
            for (currentIndex = startPosition; currentIndex < end; ++currentIndex) {
                boolean isPrevExponential = isExponential;
                isExponential = false;
                char currentChar = s.charAt(currentIndex);
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case ' ': 
                    case ',': {
                        foundSeparator = true;
                        break;
                    }
                    case '-': {
                        if (currentIndex == startPosition || isPrevExponential) break;
                        foundSeparator = true;
                        endWithNegOrDot = true;
                        break;
                    }
                    case '.': {
                        if (!secondDot) {
                            secondDot = true;
                            break;
                        }
                        foundSeparator = true;
                        endWithNegOrDot = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        isExponential = true;
                        hasExponential = true;
                    }
                }
                if (foundSeparator) break;
            }
            if (hasExponential && startPosition < currentIndex && context.getMainProject().getMinSdkVersion().getFeatureLevel() < 21) {
                String number = s.substring(startPosition, currentIndex);
                String converted = null;
                try {
                    DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                    df.setMaximumFractionDigits(340);
                    converted = df.format(Double.parseDouble(number));
                }
                catch (NumberFormatException df) {
                    // empty catch block
                }
                message2 = String.format("Avoid scientific notation (`%1$s`) in vector paths because it can lead to crashes on some devices.", number);
                if (converted != null) {
                    message2 = message2 + " Use `" + converted + "` instead.";
                }
                this.reportInvalidPathData(context, attribute, s, startPosition, currentIndex, number, converted, message2, "Replace scientific notation");
            }
            if (s.startsWith(".", startPosition) || s.startsWith("-.", startPosition) && context.getMainProject().getMinSdkVersion().getFeatureLevel() < 23) {
                String number = s.substring(startPosition, currentIndex);
                String replace = number.startsWith(".") ? "0" + number : "-0." + number.substring(2);
                message2 = String.format("Use %1$s instead of %2$s to avoid crashes on some devices", replace, number);
                if (number.startsWith(".") && startPosition > 0 && Character.isDigit(s.charAt(startPosition - 1))) {
                    replace = " " + replace;
                }
                this.reportInvalidPathData(context, attribute, s, startPosition, currentIndex, number, replace, message2, "Add leading 0");
            }
            int endPosition = currentIndex;
            if (endWithNegOrDot) {
                startPosition = endPosition;
                continue;
            }
            startPosition = endPosition + 1;
        }
    }

    private void reportInvalidPathData(XmlContext context, Attr attribute, String s, int startPosition, int currentIndex, String number, String replace, String message2, String sharedName) {
        Location location = context.getValueLocation(attribute);
        Position startPos = location.getStart();
        assert (startPos != null);
        LintFix lintFix = null;
        if (s.equals(attribute.getValue())) {
            location = Location.create((File)context.file, (CharSequence)context.getContents(), (int)(startPos.getOffset() + startPosition), (int)(startPos.getOffset() + currentIndex));
            if (replace != null) {
                lintFix = this.fix().name("Replace with " + replace.trim()).sharedName(sharedName).replace().text(number).with(replace).range(location).autoFix().build();
            }
        }
        context.report(PATH_VALID, (Node)attribute, location, message2, lintFix);
    }

    private static int findNextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }
}

