/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/StartDestinationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "navigation", "Lorg/w3c/dom/Element;", "Issues", "lint-checks"})
public final class StartDestinationDetector
extends ResourceXmlDetector {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.NAVIGATION);
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"navigation");
    }

    /*
     * WARNING - void declaration
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element navigation) {
        String destinationAttrValue;
        Attr destinationAttr;
        int it;
        boolean bl;
        NodeList children;
        block14: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)navigation, (String)"navigation");
            NodeList nodeList = children = navigation.getChildNodes();
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"children");
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)nodeList.getLength());
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv = ((IntIterator)iterator).nextInt();
                    it = element$iv;
                    if (!(children.item(it) instanceof Element)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Attr attr = destinationAttr = navigation.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "startDestination");
        String string = destinationAttrValue = attr != null ? attr.getValue() : null;
        if (destinationAttrValue == null || StringsKt.isBlank((CharSequence)destinationAttrValue)) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)navigation, (Location)context.getNameLocation((Node)navigation), (String)"No start destination specified", null, (int)16, null);
        } else {
            ResourceUrl url = ResourceUrl.parse((String)destinationAttrValue);
            if (url == null || Intrinsics.areEqual((Object)url.type, (Object)ResourceType.ID) ^ true) {
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)navigation, (Location)context.getNameLocation((Node)navigation), (String)"startDestination must be an id", null, (int)16, null);
                return;
            }
            it = 0;
            int n = children.getLength();
            while (it < n) {
                void i;
                Node node = children.item((int)i);
                if (!(node instanceof Element)) {
                    node = null;
                }
                if ((Element)node == null) {
                } else {
                    ResourceUrl childUrl;
                    Element child;
                    String childId = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                    if (ResourceUrl.parse((String)childId) == null) {
                    } else if (Intrinsics.areEqual((Object)url.name, (Object)childUrl.name)) {
                        return;
                    }
                }
                ++i;
            }
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)navigation, (Location)context.getValueLocation(destinationAttr), (String)("Invalid start destination " + destinationAttrValue), null, (int)16, null);
        }
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.Companion.create("InvalidNavigation", "No start destination specified", "\n            All `<navigation>` elements must have a start destination specified, and it must \\\n            be a direct child of that `<navigation>`.\n            ", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(StartDestinationDetector.class, Scope.RESOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/StartDestinationDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

