/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;

public class AppCompatCustomViewDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"AppCompatCustomView", (String)"Appcompat Custom Widgets", (String)"In order to support features such as tinting, the appcompat library will automatically load special appcompat replacements for the builtin widgets. However, this does not work for your own custom views.\n\nInstead of extending the `android.widget` classes directly, you should instead extend one of the delegate classes in `android.support.v7.widget.AppCompat`.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)new Implementation(AppCompatCustomViewDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        PsiJavaCodeReferenceElement[] elements;
        Project project = context.getMainProject();
        if (project.dependsOn("com.android.support:appcompat-v7") != Boolean.TRUE) {
            return;
        }
        UClass superClass = declaration.getSuperClass();
        if (!AppCompatCustomViewDetector.hasAppCompatDelegate(context, (PsiClass)superClass)) {
            return;
        }
        UClass locationNode = declaration;
        PsiReferenceList extendsList = declaration.getExtendsList();
        if (extendsList != null && (elements = extendsList.getReferenceElements()).length > 0) {
            locationNode = elements[0];
        }
        Location location = context.getNameLocation((PsiElement)locationNode);
        String suggested = AppCompatCustomViewDetector.getAppCompatDelegate((PsiClass)superClass);
        String message2 = String.format("This custom view should extend `%1$s` instead", suggested);
        String actionLabel = "Extend AppCompat widget instead";
        LintFix fix = this.fix().name(actionLabel).sharedName(actionLabel).replace().all().with(suggested).autoFix().build();
        context.report(ISSUE, declaration, location, message2, fix);
    }

    private static String getAppCompatDelegate(PsiClass superClass) {
        return "android.support.v7.widget.AppCompat" + superClass.getName();
    }

    private static boolean hasAppCompatDelegate(JavaContext context, PsiClass superClass) {
        if (superClass == null) {
            return false;
        }
        String qualifiedName = superClass.getQualifiedName();
        if (qualifiedName == null || !qualifiedName.startsWith("android.widget.")) {
            return false;
        }
        switch (qualifiedName) {
            case "android.widget.AutoCompleteTextView": 
            case "android.widget.Button": 
            case "android.widget.CheckBox": 
            case "android.widget.CheckedTextView": 
            case "android.widget.EditText": 
            case "android.widget.ImageButton": 
            case "android.widget.ImageView": 
            case "android.widget.MultiAutoCompleteTextView": 
            case "android.widget.RadioButton": 
            case "android.widget.RatingBar": 
            case "android.widget.SeekBar": 
            case "android.widget.Spinner": 
            case "android.widget.TextView": {
                return true;
            }
        }
        return context.getEvaluator().findClass(AppCompatCustomViewDetector.getAppCompatDelegate(superClass)) != null;
    }
}

