/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016JL\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J \u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0011H\u0002J\"\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J\u001e\u0010#\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0015H\u0002Jr\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0016\u00a8\u00060"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "addThreadAnnotations", "", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "result", "applicableAnnotations", "", "checkThreading", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "signature", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "containsThreadingAnnotation", "", "array", "describeThread", "describeThreads", "annotations", "any", "getThreadContext", "methodCall", "getThreads", "originalMethod", "isCompatibleThread", "caller", "callee", "callers", "isThreadingAnnotation", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "allMemberAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class ThreadDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue THREAD;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.UI_THREAD_ANNOTATION.oldName(), AnnotationDetector.UI_THREAD_ANNOTATION.newName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.newName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.newName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.newName(), AnnotationDetector.ANY_THREAD_ANNOTATION.oldName(), AnnotationDetector.ANY_THREAD_ANNOTATION.newName()});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method != null) {
            this.checkThreading(context, usage, method, qualifiedName, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkThreading(JavaContext context, UElement node, PsiMethod method, String signature, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        List<String> threadContext = this.getThreadContext(context, node);
        if (threadContext != null && !this.isCompatibleThread(threadContext, signature)) {
            void var10_15;
            String name;
            String s;
            if (UastLintUtils.containsAnnotation(allClassAnnotations, (UAnnotation)annotation)) {
                if (this.containsThreadingAnnotation(allMethodAnnotations)) {
                    return;
                }
            } else {
                boolean bl = UastLintUtils.containsAnnotation(allMethodAnnotations, (UAnnotation)annotation);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Boolean isFirst = null;
                for (UAnnotation uAnnotation : allMethodAnnotations) {
                    if (uAnnotation == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!this.isThreadingAnnotation(uAnnotation)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    s = uAnnotation.getQualifiedName();
                    if (s == null || !this.isCompatibleThread(threadContext, s)) continue;
                    return;
                }
            }
            String string = name = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (StringsKt.startsWith$default((String)string, (String)"post", (boolean)false, (int)2, null) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
                return;
            }
            List<String> list = this.getThreads(context, method);
            if (list == null) {
                List list2 = CollectionsKt.listOf((Object)signature);
            }
            if (var10_15.containsAll((Collection)threadContext)) {
                return;
            }
            if (var10_15.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || var10_15.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.newName())) {
                return;
            }
            s = StringCompanionObject.INSTANCE;
            String string2 = "%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread";
            Object[] objectArray = new Object[]{method.isConstructor() ? "Constructor" : "Method", method.getName(), this.describeThreads((List<String>)var10_15, true), this.describeThreads(threadContext, false)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String message2 = string3;
            Location location = context.getLocation(node);
            this.report(context, THREAD, node, location, message2);
        }
    }

    private final boolean containsThreadingAnnotation(List<? extends UAnnotation> array) {
        for (UAnnotation uAnnotation : array) {
            if (!this.isThreadingAnnotation(uAnnotation)) continue;
            return true;
        }
        return false;
    }

    private final boolean isThreadingAnnotation(UAnnotation annotation) {
        String signature = annotation.getQualifiedName();
        return signature != null && StringsKt.endsWith$default((String)signature, (String)"Thread", (boolean)false, (int)2, null) && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(signature);
    }

    /*
     * WARNING - void declaration
     */
    private final String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = ((Collection)annotations).size();
        while (n < n2) {
            void i;
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.describeThread(annotations.get((int)i)));
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String describeThread(String annotation) {
        String string = annotation;
        return Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.newName()) ? "UI" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.newName()) ? "main" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.newName()) ? "binder" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.newName()) ? "worker" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.newName()) ? "any" : "other"))));
    }

    private final boolean isCompatibleThread(List<String> callers, String callee) {
        boolean bl;
        boolean bl2 = bl = !callers.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (String caller : callers) {
            if (this.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCompatibleThread(String caller, String callee) {
        if (Intrinsics.areEqual((Object)callee, (Object)caller)) {
            return true;
        }
        if (AnnotationDetector.ANY_THREAD_ANNOTATION.isEquals(callee)) {
            return true;
        }
        return AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(callee) ? AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(caller) : AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(callee) && AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(caller);
    }

    private final List<String> getThreadContext(JavaContext context, UElement methodCall) {
        UElement uElement = UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class, ULambdaExpression.class});
        if (!(uElement instanceof PsiMethod)) {
            uElement = null;
        }
        PsiMethod method = (PsiMethod)uElement;
        return this.getThreads(context, method);
    }

    private final List<String> getThreads(JavaContext context, PsiMethod originalMethod) {
        PsiMethod method = originalMethod;
        if (method != null) {
            List<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                PsiModifierList psiModifierList = method.getModifierList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"method.modifierList");
                PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
                for (int i = 0; i < psiAnnotationArray.length; ++i) {
                    PsiAnnotation annotation;
                    PsiAnnotation psiAnnotation = annotation = psiAnnotationArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"annotation");
                    result = this.addThreadAnnotations(psiAnnotation, result);
                }
                if (result != null) {
                    return result;
                }
                method = context.getEvaluator().getSuperMethod(method);
            }
            while (cls != null) {
                PsiModifierList modifierList = cls.getModifierList();
                if (modifierList != null) {
                    PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                    for (int i = 0; i < psiAnnotationArray.length; ++i) {
                        PsiAnnotation annotation;
                        PsiAnnotation psiAnnotation = annotation = psiAnnotationArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"annotation");
                        result = this.addThreadAnnotations(psiAnnotation, result);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private final List<String> addThreadAnnotations(PsiAnnotation annotation, List<String> result) {
        List resultList = result;
        String name = annotation.getQualifiedName();
        if (name != null && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(name) && StringsKt.endsWith$default((String)name, (String)"Thread", (boolean)false, (int)2, null)) {
            if (resultList == null) {
                resultList = new ArrayList(4);
            }
            String string = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SUPPORT_ANNOTATIONS_PREFIX.newName()");
            if (StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                String string2 = name;
                int n = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length();
                StringBuilder stringBuilder = new StringBuilder().append(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName());
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                String oldName = stringBuilder.append(string4).toString();
                resultList.add(oldName);
            } else {
                resultList.add(name);
            }
        }
        return resultList;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ThreadDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Implementation implementation = ThreadDetector.Companion.getIMPLEMENTATION();
        Severity severity = Severity.ERROR;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/guide/components/processes-and-threads.html#Threads";
        THREAD = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"WrongThread", (String)"Wrong Thread", (String)"\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread.\n                ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (int)256, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

